/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.asm.aop;

import cn.myperf4j.asm.ASMRecorderMaintainer;
import cn.myperf4j.base.config.ProfilingParams;
import cn.myperf4j.base.util.Logger;
import cn.myperf4j.core.MethodTagMaintainer;
import cn.myperf4j.core.recorder.Recorder;
import java.lang.reflect.Method;

public final class ProfilingAspect {
    private static final MethodTagMaintainer methodTagMaintainer = MethodTagMaintainer.getInstance();
    private static ASMRecorderMaintainer recorderMaintainer;
    private static boolean running;

    private ProfilingAspect() {
    }

    public static void profiling(long startNanos, int methodTagId) {
        try {
            Recorder recorder;
            if (running && (recorder = recorderMaintainer.getRecorder(methodTagId)) != null) {
                recorder.recordTime(startNanos, System.nanoTime());
            }
        }
        catch (Throwable t) {
            Logger.error("ProfilingAspect.profiling(" + startNanos + ", " + methodTagId + ", " + MethodTagMaintainer.getInstance().getMethodTag(methodTagId) + ")", t);
        }
    }

    public static void profiling(long startNanos, Method method) {
        try {
            int methodTagId;
            if (running && (methodTagId = methodTagMaintainer.addMethodTag(method)) >= 0) {
                Recorder recorder = ProfilingAspect.getRecorder(methodTagId);
                recorder.recordTime(startNanos, System.nanoTime());
            }
        }
        catch (Throwable t) {
            Logger.error("ProfilingAspect.profiling(" + startNanos + ", " + method + ")", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Recorder getRecorder(int methodTagId) {
        Recorder recorder = recorderMaintainer.getRecorder(methodTagId);
        if (recorder != null) {
            return recorder;
        }
        Class<ProfilingAspect> clazz = ProfilingAspect.class;
        synchronized (ProfilingAspect.class) {
            Recorder newRec = recorderMaintainer.getRecorder(methodTagId);
            if (newRec != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return newRec;
            }
            recorderMaintainer.addRecorder(methodTagId, ProfilingParams.of(3000, 10));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return recorderMaintainer.getRecorder(methodTagId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setRecorderMaintainer(ASMRecorderMaintainer maintainer) {
        Class<ProfilingAspect> clazz = ProfilingAspect.class;
        synchronized (ProfilingAspect.class) {
            recorderMaintainer = maintainer;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setRunning(boolean run) {
        Class<ProfilingAspect> clazz = ProfilingAspect.class;
        synchronized (ProfilingAspect.class) {
            running = run;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

