/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.asm.aop;

import cn.myperf4j.asm.aop.ProfilingDynamicMethodVisitor;
import cn.myperf4j.asm.aop.ProfilingMethodVisitor;
import cn.myperf4j.base.config.LevelMappingFilter;
import cn.myperf4j.base.config.ProfilingConfig;
import cn.myperf4j.base.config.ProfilingFilter;
import cn.myperf4j.base.util.Logger;
import cn.myperf4j.base.util.TypeDescUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.shaded.objectweb.asm.ClassVisitor;
import org.shaded.objectweb.asm.FieldVisitor;
import org.shaded.objectweb.asm.MethodVisitor;

public class ProfilingClassAdapter
extends ClassVisitor {
    private static final String JAVA_INVOCATION_HANDLER = "java/lang/reflect/InvocationHandler";
    private final String innerClassName;
    private final String fullClassName;
    private final String simpleClassName;
    private final String classLevel;
    private boolean isInterface;
    private boolean isInvocationHandler;
    private final Set<String> fieldMethods = new HashSet<String>();

    public ProfilingClassAdapter(ClassVisitor cv, String innerClassName) {
        super(589824, cv);
        this.innerClassName = innerClassName;
        this.fullClassName = innerClassName.replace('/', '.');
        this.simpleClassName = TypeDescUtils.getSimpleClassName(innerClassName);
        this.classLevel = LevelMappingFilter.getClassLevel(this.simpleClassName);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        Logger.debug("ProfilingClassAdapter.visit(" + version + ", " + access + ", " + name + ", " + signature + ", " + superName + ", " + Arrays.toString(interfaces) + ")");
        super.visit(version, access, name, signature, superName, interfaces);
        this.isInterface = (access & 0x200) != 0;
        this.isInvocationHandler = this.isInvocationHandler(interfaces);
    }

    private boolean isInvocationHandler(String[] interfaces) {
        if (interfaces == null) {
            return false;
        }
        for (String inf : interfaces) {
            if (!JAVA_INVOCATION_HANDLER.equals(inf)) continue;
            return true;
        }
        return false;
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        String upFieldName = name.substring(0, 1).toUpperCase() + name.substring(1);
        this.fieldMethods.add("get" + upFieldName);
        this.fieldMethods.add("set" + upFieldName);
        this.fieldMethods.add("is" + upFieldName);
        return super.visitField(access, name, desc, signature, value);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (this.isInterface || !this.isNeedVisit(access, name)) {
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        String classMethodName = this.simpleClassName + "." + name;
        if (ProfilingFilter.isNotNeedInjectMethod(classMethodName)) {
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        String desc4Human = TypeDescUtils.getMethodParamsDesc(desc);
        if (ProfilingFilter.isNotNeedInjectMethod(classMethodName + desc4Human)) {
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        MethodVisitor mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
        if (mv == null) {
            return null;
        }
        Logger.debug("ProfilingClassAdapter.visitMethod(" + access + ", " + name + ", " + desc + ", " + signature + ", " + Arrays.toString(exceptions) + "), innerClassName=" + this.innerClassName);
        if (this.isInvocationHandler && this.isInvokeMethod(name, desc)) {
            return new ProfilingDynamicMethodVisitor(access, name, desc, mv);
        }
        return new ProfilingMethodVisitor(access, name, desc, mv, this.innerClassName, this.fullClassName, this.simpleClassName, this.classLevel, desc4Human);
    }

    private boolean isNeedVisit(int access, String name) {
        if ((access & 2) != 0 && ProfilingConfig.filterConfig().excludePrivateMethod()) {
            return false;
        }
        if ((access & 0x400) != 0 || (access & 0x100) != 0 || (access & 0x40) != 0 || (access & 0x1000) != 0) {
            return false;
        }
        if ("<init>".equals(name) || "<clinit>".equals(name)) {
            return false;
        }
        return !this.fieldMethods.contains(name) && !ProfilingFilter.isNotNeedInjectMethod(name);
    }

    private boolean isInvokeMethod(String methodName, String methodDesc) {
        return methodName.equals("invoke") && methodDesc.equals("(Ljava/lang/Object;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;");
    }
}

