/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.asm.aop;

import cn.myperf4j.asm.ASMRecorderMaintainer;
import cn.myperf4j.asm.aop.ProfilingAspect;
import cn.myperf4j.base.MethodTag;
import cn.myperf4j.base.config.MetricsConfig;
import cn.myperf4j.base.config.ProfilingConfig;
import cn.myperf4j.base.config.RecorderConfig;
import cn.myperf4j.core.MethodTagMaintainer;
import cn.myperf4j.core.recorder.AbstractRecorderMaintainer;
import org.shaded.objectweb.asm.MethodVisitor;
import org.shaded.objectweb.asm.Type;
import org.shaded.objectweb.asm.commons.AdviceAdapter;

public class ProfilingMethodVisitor
extends AdviceAdapter {
    private static final String PROFILING_ASPECT_INNER_NAME = Type.getInternalName(ProfilingAspect.class);
    private static final MethodTagMaintainer methodTagMaintainer = MethodTagMaintainer.getInstance();
    private static final AbstractRecorderMaintainer maintainer = ASMRecorderMaintainer.getInstance();
    private static final MetricsConfig metricsConf = ProfilingConfig.metricsConfig();
    private static final RecorderConfig recorderConf = ProfilingConfig.recorderConfig();
    private final String innerClassName;
    private final String methodName;
    private final int methodTagId;
    private int startTimeIdentifier;

    public ProfilingMethodVisitor(int access, String name, String desc, MethodVisitor mv, String innerClassName, String fullClassName, String simpleClassName, String classLevel, String humanMethodDesc) {
        super(589824, mv, access, name, desc);
        this.methodName = name;
        this.methodTagId = methodTagMaintainer.addMethodTag(this.getMethodTag(fullClassName, simpleClassName, classLevel, name, humanMethodDesc));
        this.innerClassName = innerClassName;
    }

    private MethodTag getMethodTag(String fullClassName, String simpleClassName, String classLevel, String methodName, String humanMethodDesc) {
        String methodParamDesc = metricsConf.showMethodParams() ? humanMethodDesc : "";
        return MethodTag.getGeneralInstance(fullClassName, simpleClassName, classLevel, methodName, methodParamDesc);
    }

    @Override
    protected void onMethodEnter() {
        if (this.profiling()) {
            maintainer.addRecorder(this.methodTagId, recorderConf.getProfilingParam(this.innerClassName + "/" + this.methodName));
            this.mv.visitMethodInsn(184, "java/lang/System", "nanoTime", "()J", false);
            this.startTimeIdentifier = this.newLocal(Type.LONG_TYPE);
            this.mv.visitVarInsn(55, this.startTimeIdentifier);
        }
    }

    @Override
    protected void onMethodExit(int opcode) {
        if (this.profiling() && (172 <= opcode && opcode <= 177 || opcode == 191)) {
            this.mv.visitVarInsn(22, this.startTimeIdentifier);
            this.mv.visitLdcInsn(this.methodTagId);
            this.mv.visitMethodInsn(184, PROFILING_ASPECT_INNER_NAME, "profiling", "(JI)V", false);
        }
    }

    private boolean profiling() {
        return this.methodTagId >= 0;
    }
}

