/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.buffer;

import cn.myperf4j.base.buffer.LongBuf;
import cn.myperf4j.base.util.Logger;
import java.util.ArrayDeque;
import java.util.Queue;

public final class LongBufPool {
    private static final int FOUR_K = 4096;
    private static final int TEN_K = 10240;
    private static final int ONE_HUNDRED_K = 102400;
    private static final int MAX_CAPACITY = 102400;
    private static final int FOUR_K_COUNT = 10;
    private static final int TEN_K_COUNT = 2;
    private static final int ONE_HUNDRED_K_COUNT = 1;
    private final Queue<LongBuf> fourKQueue = new ArrayDeque<LongBuf>();
    private final Queue<LongBuf> tenKQueue = new ArrayDeque<LongBuf>();
    private final Queue<LongBuf> oneHundredKQueue = new ArrayDeque<LongBuf>();

    public static LongBufPool getInstance() {
        return LongBufPoolHolder.instance;
    }

    private LongBufPool() {
        this.initBufQueue(this.fourKQueue, 4096, 10);
        this.initBufQueue(this.tenKQueue, 10240, 2);
        this.initBufQueue(this.oneHundredKQueue, 102400, 1);
    }

    private void initBufQueue(Queue<LongBuf> queue, int capacity, int num) {
        for (int i = 0; i < num; ++i) {
            queue.add(new LongBuf(capacity, this));
        }
    }

    public synchronized LongBuf acquire(int capacity) {
        if (capacity > 102400) {
            return new LongBuf(capacity);
        }
        LongBuf buf = capacity <= 4096 ? this.fourKQueue.poll() : (capacity <= 10240 ? this.tenKQueue.poll() : this.oneHundredKQueue.poll());
        return buf != null ? buf : new LongBuf(capacity);
    }

    public synchronized void release(LongBuf buf) {
        int capacity = buf.capacity();
        if (capacity > 102400 || buf.pool() != this) {
            return;
        }
        if (capacity == 4096) {
            this.fourKQueue.offer(buf);
        } else if (capacity == 10240) {
            this.tenKQueue.offer(buf);
        } else if (capacity == 102400) {
            this.oneHundredKQueue.offer(buf);
        } else {
            Logger.warn("LongBufPool.release(" + capacity + ") buf.capacity() is invalid!!!");
        }
    }

    private static final class LongBufPoolHolder {
        private static final LongBufPool instance = new LongBufPool();

        private LongBufPoolHolder() {
        }
    }
}

