/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.config;

import cn.myperf4j.base.config.MyProperties;
import cn.myperf4j.base.constant.PropertyKeys;
import cn.myperf4j.base.util.StrUtils;

public class BasicConfig {
    private String appName;
    private String configFileDir;
    private boolean debug;

    public String appName() {
        return this.appName;
    }

    public void appName(String appName) {
        if (StrUtils.isBlank(appName)) {
            throw new IllegalArgumentException("AppName is required!!!");
        }
        this.appName = appName;
    }

    public String configFileDir() {
        return this.configFileDir;
    }

    public void configFileDir(String configFileDir) {
        this.configFileDir = configFileDir;
    }

    public boolean debug() {
        return this.debug;
    }

    public void debug(boolean debug) {
        this.debug = debug;
    }

    public String sysProfilingParamsFile() {
        return this.configFileDir + "." + this.appName + "_SysGenProfilingFile";
    }

    public String toString() {
        return "BasicConfig{appName='" + this.appName + '\'' + ", configFileDir='" + this.configFileDir + '\'' + ", debug=" + this.debug + '}';
    }

    public static BasicConfig loadBasicConfig() {
        String appName = MyProperties.getStr(PropertyKeys.Basic.APP_NAME);
        if (StrUtils.isBlank(appName)) {
            throw new IllegalArgumentException(PropertyKeys.Basic.APP_NAME.key() + "|" + PropertyKeys.Basic.APP_NAME.legacyKey() + " is required!!!");
        }
        BasicConfig config = new BasicConfig();
        config.appName(appName);
        config.debug(MyProperties.getBoolean(PropertyKeys.Basic.DEBUG, false));
        config.configFileDir(MyProperties.getStr(PropertyKeys.Basic.PROPERTIES_FILE_DIR));
        return config;
    }
}

