/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.config;

import cn.myperf4j.base.config.MyProperties;
import cn.myperf4j.base.constant.PropertyKeys;
import cn.myperf4j.base.util.Logger;
import cn.myperf4j.base.util.NumUtils;
import cn.myperf4j.base.util.StrUtils;
import java.util.List;

public class HttpServerConfig {
    private int preferencePort;
    private int minPort;
    private int maxPort;
    private int minWorkers;
    private int maxWorkers;
    private int acceptCount;

    public int getPreferencePort() {
        return this.preferencePort;
    }

    public void setPreferencePort(int preferencePort) {
        this.preferencePort = preferencePort;
    }

    public int getMinPort() {
        return this.minPort;
    }

    public void setMinPort(int minPort) {
        this.minPort = minPort;
    }

    public int getMaxPort() {
        return this.maxPort;
    }

    public void setMaxPort(int maxPort) {
        this.maxPort = maxPort;
    }

    public int getMinWorkers() {
        return this.minWorkers;
    }

    public void setMinWorkers(int minWorkers) {
        this.minWorkers = minWorkers;
    }

    public int getMaxWorkers() {
        return this.maxWorkers;
    }

    public void setMaxWorkers(int maxWorkers) {
        this.maxWorkers = maxWorkers;
    }

    public int getAcceptCount() {
        return this.acceptCount;
    }

    public void setAcceptCount(int acceptCount) {
        this.acceptCount = acceptCount;
    }

    public String toString() {
        return "HttpServerConfig{preferencePort=" + this.preferencePort + ", minPort=" + this.minPort + ", maxPort=" + this.maxPort + ", minWorkers=" + this.minWorkers + ", maxWorkers=" + this.maxWorkers + ", acceptCount=" + this.acceptCount + '}';
    }

    public static HttpServerConfig loadHttpServerConfig() {
        String portStr = MyProperties.getStr(PropertyKeys.HttpServer.PORT);
        if (StrUtils.isBlank(portStr)) {
            portStr = "2048,2000,2040";
            Logger.info(PropertyKeys.HttpServer.PORT.key() + " is not configured, so use '" + portStr + "' as default.");
        }
        HttpServerConfig config = new HttpServerConfig();
        HttpServerConfig.completePorts(config, portStr);
        config.setMinWorkers(MyProperties.getInt(PropertyKeys.HttpServer.MIN_WORKERS, 1));
        config.setMaxWorkers(MyProperties.getInt(PropertyKeys.HttpServer.MAX_WORKERS, 2));
        config.setAcceptCount(MyProperties.getInt(PropertyKeys.HttpServer.ACCEPT_COUNT, 1024));
        return config;
    }

    private static void completePorts(HttpServerConfig config, String portStr) {
        List<String> ports = StrUtils.splitAsList(portStr, ',');
        if (ports.size() != 3) {
            config.setPreferencePort(NumUtils.parseInt(ports.get(0), 2048));
            config.setMinPort(2000);
            config.setMaxPort(2040);
            return;
        }
        config.setPreferencePort(NumUtils.parseInt(ports.get(0), 2048));
        config.setMinPort(NumUtils.parseInt(ports.get(1), 2000));
        config.setMaxPort(NumUtils.parseInt(ports.get(2), 2040));
    }
}

