/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.config;

import cn.myperf4j.base.config.ConfigKey;
import cn.myperf4j.base.config.MyProperties;
import cn.myperf4j.base.constant.PropertyKeys;
import cn.myperf4j.base.util.StrUtils;

public class MetricsConfig {
    private String metricsExporter;
    private String methodMetricsLog;
    private String classMetricsLog;
    private String gcMetricsLog;
    private String memoryMetricsLog;
    private String bufferPoolMetricsLog;
    private String threadMetricsLog;
    private String compilationMetricsLog;
    private String fileDescMetricsLog;
    private String logRollingTimeUnit;
    private int logReserveCount;
    private long methodMilliTimeSlice;
    private long jvmMilliTimeSlice;
    private boolean showMethodParams;
    private String classLevelMapping;

    public String metricsExporter() {
        return this.metricsExporter;
    }

    public void metricsExporter(String metricsExporter) {
        this.metricsExporter = metricsExporter;
    }

    public String methodMetricsFile() {
        return this.methodMetricsLog;
    }

    public void methodMetricsFile(String methodMetricsFile) {
        this.methodMetricsLog = methodMetricsFile;
    }

    public String classMetricsFile() {
        return this.classMetricsLog;
    }

    public void classMetricsFile(String classMetricsFile) {
        this.classMetricsLog = classMetricsFile;
    }

    public String gcMetricsFile() {
        return this.gcMetricsLog;
    }

    public void gcMetricsFile(String gcMetricsFile) {
        this.gcMetricsLog = gcMetricsFile;
    }

    public String memoryMetricsFile() {
        return this.memoryMetricsLog;
    }

    public void memoryMetricsFile(String memoryMetricsFile) {
        this.memoryMetricsLog = memoryMetricsFile;
    }

    public String bufferPoolMetricsFile() {
        return this.bufferPoolMetricsLog;
    }

    public void bufferPoolMetricsFile(String bufferPoolMetricsFile) {
        this.bufferPoolMetricsLog = bufferPoolMetricsFile;
    }

    public String threadMetricsFile() {
        return this.threadMetricsLog;
    }

    public void threadMetricsFile(String threadMetricsFile) {
        this.threadMetricsLog = threadMetricsFile;
    }

    public String compilationMetricsFile() {
        return this.compilationMetricsLog;
    }

    public void compilationMetricsFile(String compilationMetricsFile) {
        this.compilationMetricsLog = compilationMetricsFile;
    }

    public String fileDescMetricsFile() {
        return this.fileDescMetricsLog;
    }

    public void fileDescMetricsFile(String fileDescMetricsFile) {
        this.fileDescMetricsLog = fileDescMetricsFile;
    }

    public String logRollingTimeUnit() {
        return this.logRollingTimeUnit;
    }

    public void logRollingTimeUnit(String logRollingTimeUnit) {
        this.logRollingTimeUnit = logRollingTimeUnit;
    }

    public int logReserveCount() {
        return this.logReserveCount;
    }

    public void logReserveCount(int logReserveCount) {
        this.logReserveCount = logReserveCount;
    }

    public long methodMilliTimeSlice() {
        return this.methodMilliTimeSlice;
    }

    public void methodMilliTimeSlice(long methodMilliTimeSlice) {
        this.methodMilliTimeSlice = methodMilliTimeSlice;
    }

    public long jvmMilliTimeSlice() {
        return this.jvmMilliTimeSlice;
    }

    public void jvmMilliTimeSlice(long jvmMilliTimeSlice) {
        this.jvmMilliTimeSlice = jvmMilliTimeSlice;
    }

    public boolean showMethodParams() {
        return this.showMethodParams;
    }

    public void showMethodParams(boolean showMethodParams) {
        this.showMethodParams = showMethodParams;
    }

    public String classLevelMapping() {
        return this.classLevelMapping;
    }

    public void classLevelMapping(String classLevelMapping) {
        this.classLevelMapping = classLevelMapping;
    }

    public String toString() {
        return "MetricsConfig{metricsExporter='" + this.metricsExporter + '\'' + ", methodMetricsLog='" + this.methodMetricsLog + '\'' + ", classMetricsLog='" + this.classMetricsLog + '\'' + ", gcMetricsLog='" + this.gcMetricsLog + '\'' + ", memoryMetricsLog='" + this.memoryMetricsLog + '\'' + ", bufferPoolMetricsLog='" + this.bufferPoolMetricsLog + '\'' + ", threadMetricsLog='" + this.threadMetricsLog + '\'' + ", compilationMetricsLog='" + this.compilationMetricsLog + '\'' + ", fileDescMetricsLog='" + this.fileDescMetricsLog + '\'' + ", logRollingTimeUnit='" + this.logRollingTimeUnit + '\'' + ", logReserveCount='" + this.logReserveCount + '\'' + ", methodMilliTimeSlice=" + this.methodMilliTimeSlice + ", jvmMilliTimeSlice=" + this.jvmMilliTimeSlice + ", showMethodParams=" + this.showMethodParams + ", classLevelMapping='" + this.classLevelMapping + '\'' + '}';
    }

    public static MetricsConfig loadMetricsConfig() {
        MetricsConfig config = new MetricsConfig();
        String exporter = MetricsConfig.getExporter();
        config.metricsExporter(exporter);
        config.methodMetricsFile(MetricsConfig.getMetricsFile(PropertyKeys.Metrics.LOG_METHOD, exporter));
        config.classMetricsFile(MetricsConfig.getMetricsFile(PropertyKeys.Metrics.LOG_CLASS_LOADING, exporter));
        config.gcMetricsFile(MetricsConfig.getMetricsFile(PropertyKeys.Metrics.LOG_GC, exporter));
        config.memoryMetricsFile(MetricsConfig.getMetricsFile(PropertyKeys.Metrics.LOG_MEMORY, exporter));
        config.bufferPoolMetricsFile(MetricsConfig.getMetricsFile(PropertyKeys.Metrics.LOG_BUFF_POOL, exporter));
        config.threadMetricsFile(MetricsConfig.getMetricsFile(PropertyKeys.Metrics.LOG_THREAD, exporter));
        config.compilationMetricsFile(MetricsConfig.getMetricsFile(PropertyKeys.Metrics.LOG_COMPILATION, exporter));
        config.fileDescMetricsFile(MetricsConfig.getMetricsFile(PropertyKeys.Metrics.LOG_FILE_DESC, exporter));
        config.logRollingTimeUnit(MyProperties.getStr(PropertyKeys.Metrics.LOG_ROLLING_TIME_UNIT, "DAILY"));
        config.logReserveCount(MyProperties.getInt(PropertyKeys.Metrics.LOG_RESERVE_COUNT, 7));
        config.methodMilliTimeSlice(MyProperties.getLong(PropertyKeys.Metrics.TIME_SLICE_METHOD, 60000L));
        config.jvmMilliTimeSlice(MyProperties.getLong(PropertyKeys.Metrics.TIME_SLICE_JVM, 60000L));
        config.showMethodParams(MyProperties.getBoolean(PropertyKeys.Metrics.METHOD_SHOW_PARAMS, true));
        config.classLevelMapping(MyProperties.getStr(PropertyKeys.Metrics.CLASS_LEVEL_MAPPINGS));
        return config;
    }

    private static String getExporter() {
        String exporter = MyProperties.getStr(PropertyKeys.Metrics.EXPORTER.key());
        if (StrUtils.isNotBlank(exporter)) {
            return exporter;
        }
        Integer processorType = MyProperties.getInt(PropertyKeys.Metrics.EXPORTER.legacyKey());
        if (processorType == null) {
            return "log.stdout";
        }
        switch (processorType) {
            case 1: {
                return "log.standard";
            }
            case 2: {
                return "log.influxdb";
            }
        }
        return "log.stdout";
    }

    private static String getMetricsFile(ConfigKey configKey, String exporter) {
        if ("log.stdout".equals(exporter)) {
            return "STDOUT";
        }
        return MyProperties.getStr(configKey, "/data/logs/MyPerf4J/metrics.log");
    }
}

