/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.config;

import cn.myperf4j.base.config.ConfigKey;
import cn.myperf4j.base.util.Logger;
import cn.myperf4j.base.util.StrUtils;
import java.util.Properties;

public final class MyProperties {
    private static Properties properties;

    private MyProperties() {
    }

    public static synchronized boolean initial(Properties prop) {
        if (properties != null || prop == null) {
            return false;
        }
        properties = prop;
        return true;
    }

    public static String getStr(ConfigKey confKey) {
        String str = MyProperties.getStr0(confKey.key());
        if (str != null) {
            return StrUtils.trimToEmpty(str);
        }
        return StrUtils.trimToEmpty(MyProperties.getStr0(confKey.legacyKey()));
    }

    public static String getStr(String key) {
        return StrUtils.trimToEmpty(MyProperties.getStr0(key));
    }

    private static String getStr0(String key) {
        MyProperties.checkState();
        String value = System.getProperty(key);
        if (value != null) {
            return value;
        }
        return properties.getProperty(key);
    }

    private static void checkState() {
        if (properties == null) {
            throw new IllegalStateException("MyProperties is not initial yet!!!");
        }
    }

    public static void setStr(String key, String value) {
        MyProperties.checkState();
        System.setProperty(key, value);
        properties.setProperty(key, value);
    }

    public static String getStr(ConfigKey confKey, String defaultValue) {
        String result = MyProperties.getStr0(confKey.key());
        if (result != null) {
            return StrUtils.trimToEmpty(result);
        }
        return defaultValue;
    }

    public static String getStr(String key, String defaultValue) {
        String result = MyProperties.getStr0(key);
        if (result != null) {
            return StrUtils.trimToEmpty(result);
        }
        return defaultValue;
    }

    public static int getInt(ConfigKey confKey, int defaultValue) {
        Integer result = MyProperties.getInt(confKey.key());
        if (result != null) {
            return result;
        }
        return MyProperties.getInt(confKey.legacyKey(), defaultValue);
    }

    public static Integer getInt(ConfigKey confKey) {
        Integer result = MyProperties.getInt(confKey.key());
        if (result != null) {
            return result;
        }
        return MyProperties.getInt(confKey.legacyKey());
    }

    public static Integer getInt(String key) {
        String result = MyProperties.getStr0(key);
        if (result == null) {
            return null;
        }
        try {
            return Integer.valueOf(result);
        }
        catch (Exception e) {
            Logger.error("MyProperties.getInt(" + key + ")", e);
            return null;
        }
    }

    public static int getInt(String key, int defaultValue) {
        String result = MyProperties.getStr0(key);
        if (result == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(result);
        }
        catch (Exception e) {
            Logger.error("MyProperties.getInt(" + key + ", " + defaultValue + ")", e);
            return defaultValue;
        }
    }

    public static long getLong(ConfigKey confKey, long defaultValue) {
        Long l = MyProperties.getLong(confKey.key());
        if (l != null) {
            return l;
        }
        return MyProperties.getLong(confKey.legacyKey(), defaultValue);
    }

    public static Long getLong(String key) {
        String result = MyProperties.getStr0(key);
        if (result == null) {
            return null;
        }
        try {
            return Long.valueOf(result);
        }
        catch (Exception e) {
            Logger.error("MyProperties.getLong(" + key + ")", e);
            return null;
        }
    }

    public static long getLong(String key, long defaultValue) {
        String result = MyProperties.getStr0(key);
        if (result == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(result);
        }
        catch (Exception e) {
            Logger.error("MyProperties.getLong(" + key + ", " + defaultValue + ")", e);
            return defaultValue;
        }
    }

    public static long getLong(String key, long defaultValue, long minValue) {
        long result = MyProperties.getLong(key, defaultValue);
        if (result <= minValue) {
            return minValue;
        }
        return result;
    }

    public static boolean isSame(String key, String expectValue) {
        if (expectValue == null) {
            throw new IllegalArgumentException("isSame(" + key + ", null): expectValue must not null!!!");
        }
        return expectValue.equals(MyProperties.getStr0(key));
    }

    public static boolean getBoolean(ConfigKey confKey, boolean defaultValue) {
        Boolean result = MyProperties.getBoolean(confKey.key());
        if (result != null) {
            return result;
        }
        return MyProperties.getBoolean(confKey.legacyKey(), defaultValue);
    }

    public static Boolean getBoolean(String key) {
        String result = MyProperties.getStr0(key);
        if (result != null) {
            return result.equalsIgnoreCase("true");
        }
        return null;
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        String result = MyProperties.getStr0(key);
        if (result != null) {
            return result.equalsIgnoreCase("true");
        }
        return defaultValue;
    }
}

