/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.config;

import cn.myperf4j.base.config.MyProperties;
import cn.myperf4j.base.config.ProfilingParams;
import cn.myperf4j.base.constant.PropertyKeys;
import cn.myperf4j.base.util.collections.MapUtils;
import java.util.Map;

public class RecorderConfig {
    private String mode;
    private int backupCount;
    private int timingArrSize;
    private int timingMapSize;
    private ProfilingParams commonProfilingParams;
    private final Map<String, ProfilingParams> profilingParamsMap = MapUtils.createHashMap(1024);

    public String mode() {
        return this.mode;
    }

    public void mode(String mode) {
        this.mode = mode;
    }

    public boolean accurateMode() {
        return "ACCURATE".equalsIgnoreCase(this.mode);
    }

    public int backupCount() {
        return this.backupCount;
    }

    public void backupCount(int backupCount) {
        this.backupCount = backupCount;
    }

    public int timingArrSize() {
        return this.timingArrSize;
    }

    public void timingArrSize(int timingArrSize) {
        this.timingArrSize = timingArrSize;
    }

    public int timingMapSize() {
        return this.timingMapSize;
    }

    public void timingMapSize(int timingMapSize) {
        this.timingMapSize = timingMapSize;
    }

    public void commonProfilingParams(ProfilingParams commonProfilingParams) {
        this.commonProfilingParams = commonProfilingParams;
    }

    public void addProfilingParam(String methodName, int timeThreshold, int outThresholdCount) {
        this.profilingParamsMap.put(methodName, ProfilingParams.of(timeThreshold, outThresholdCount));
    }

    public ProfilingParams getProfilingParam(String methodName) {
        ProfilingParams params = this.profilingParamsMap.get(methodName);
        if (params != null) {
            return params;
        }
        return this.commonProfilingParams;
    }

    public String toString() {
        return "RecorderConfig{mode='" + this.mode + '\'' + ", backupCount=" + this.backupCount + ", timingArrSize=" + this.timingArrSize + ", timingMapSize=" + this.timingMapSize + ", commonProfilingParams=" + this.commonProfilingParams + '}';
    }

    public static RecorderConfig loadRecorderConfig() {
        RecorderConfig config = new RecorderConfig();
        config.mode(MyProperties.getStr(PropertyKeys.Recorder.MODE, "ACCURATE"));
        config.backupCount(MyProperties.getInt(PropertyKeys.Recorder.BACKUP_COUNT, 1));
        config.timingArrSize(MyProperties.getInt(PropertyKeys.Recorder.SIZE_TIMING_ARR, 1024));
        config.timingMapSize(MyProperties.getInt(PropertyKeys.Recorder.SIZE_TIMING_MAP, 32));
        config.commonProfilingParams(ProfilingParams.of(config.timingArrSize(), config.timingMapSize()));
        return config;
    }
}

