/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.file;

import cn.myperf4j.base.util.Logger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;

public abstract class AutoRollingFileWriter {
    private static final int MAX_INACTIVITY_EPOCHS = 30;
    private final String fileName;
    private final int reserveFileCount;
    private volatile String rollingFileName;
    private volatile BufferedWriter bufferedWriter;
    private volatile boolean closed;
    private volatile long nextRollingTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AutoRollingFileWriter(String fileName, int reserveFileCount) {
        Date now = new Date();
        this.fileName = fileName;
        this.reserveFileCount = Math.max(reserveFileCount, 0);
        this.closed = false;
        this.nextRollingTime = this.getNextRollingTime(now);
        this.rollingFileName = this.formatDateFileName(fileName, now);
        try {
            File targetFile = new File(fileName);
            if (!targetFile.exists()) {
                this.createWriter(targetFile, false);
                return;
            }
            Date lastModifiedDate = new Date(targetFile.lastModified());
            if (this.isSameEpoch(now, lastModifiedDate)) {
                this.createWriter(targetFile, true);
                return;
            }
            this.rollingFileName = this.formatDateFileName(fileName, lastModifiedDate);
            this.rollingFile(now);
        }
        finally {
            this.clean(now, 30);
        }
    }

    private void clean(Date now, int epochs) {
        for (int i = 0; i < epochs; ++i) {
            int epochOffset = -this.reserveFileCount - 1 - i;
            Date date = this.computeEpochCal(now, epochOffset).getTime();
            File file2Del = new File(this.formatDateFileName(this.fileName, date));
            if (!file2Del.exists() || !file2Del.isFile()) continue;
            boolean delete = file2Del.delete();
            Logger.info("AutoRollingFileWriter.clean(" + now + ", " + epochs + "): delete " + file2Del.getName() + " " + (delete ? "success" : "fail"));
        }
    }

    private long getNextRollingTime(Date now) {
        Calendar calendar = this.computeEpochCal(now, 1);
        return calendar.getTime().getTime();
    }

    abstract Calendar computeEpochCal(Date var1, int var2);

    abstract String formatDateFileName(String var1, Date var2);

    abstract boolean isSameEpoch(Date var1, Date var2);

    private void createWriter(File file, boolean append) {
        try {
            File parent = file.getParentFile();
            if (parent != null && !parent.exists()) {
                boolean mkdirs = parent.mkdirs();
                Logger.info("AutoRollingFileWriter.createWriter(" + file.getName() + ", " + append + "): mkdirs=" + mkdirs);
            }
            this.bufferedWriter = new BufferedWriter(new FileWriter(file, append), 65536);
        }
        catch (IOException e) {
            Logger.error("AutoRollingFileWriter.createWriter(" + file.getName() + ", " + append + ")", e);
        }
    }

    private void rollingFile(Date now) {
        try {
            String datedFilename = this.formatDateFileName(this.fileName, now);
            if (this.rollingFileName.equals(datedFilename)) {
                Logger.info("AutoRollingFileWriter.rollingFile(" + now + "): rollingFile=" + this.rollingFileName + ", datedFilename=" + datedFilename + " return!!!");
                return;
            }
            this.closeFile(false);
            File targetFile = new File(this.rollingFileName);
            if (targetFile.exists()) {
                boolean delete = targetFile.delete();
                Logger.info("AutoRollingFileWriter.rollingFile(" + now + "): rollingFile=" + this.rollingFileName + ", delete=" + delete);
            }
            File file = new File(this.fileName);
            boolean rename = file.renameTo(targetFile);
            Logger.info("AutoRollingFileWriter.rollingFile(" + now + "): rename " + this.fileName + " to " + targetFile.getName() + " " + (rename ? "success" : "fail"));
            this.createWriter(new File(this.fileName), false);
            this.rollingFileName = datedFilename;
            this.clean(now, 1);
        }
        catch (Exception e) {
            Logger.error("AutoRollingFileWriter.rollingFile(" + now + "): rollingFile=" + this.rollingFileName, e);
        }
    }

    public void write(String msg) {
        this.write0(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write0(String msg) {
        long time = System.currentTimeMillis();
        if (time < this.nextRollingTime) {
            this.doWrite(msg);
            return;
        }
        AutoRollingFileWriter autoRollingFileWriter = this;
        synchronized (autoRollingFileWriter) {
            if (time > this.nextRollingTime) {
                Date now = new Date();
                this.nextRollingTime = this.getNextRollingTime(now);
                this.rollingFile(now);
            }
        }
        this.doWrite(msg);
    }

    private void doWrite(String msg) {
        try {
            if (this.bufferedWriter != null && !this.closed) {
                this.bufferedWriter.write(msg);
            }
        }
        catch (Exception e) {
            Logger.error("AutoRollingFileWriter.doWrite(msg)", e);
        }
    }

    public void writeAndFlush(String msg) {
        this.write0(msg);
        this.flush();
    }

    public void flush() {
        try {
            if (this.bufferedWriter != null && !this.closed) {
                this.bufferedWriter.flush();
            }
        }
        catch (Exception e) {
            Logger.error("AutoRollingFileWriter.flush()", e);
        }
    }

    public void closeFile(boolean setCloseFlag) {
        try {
            this.closed = setCloseFlag;
            if (this.bufferedWriter != null) {
                this.bufferedWriter.close();
            }
        }
        catch (IOException e) {
            Logger.error("AutoRollingFileWriter.closeFile()", e);
        }
    }

    public void preCloseFile() {
        this.closed = true;
    }

    public String toString() {
        return "AutoRollingFileWriter{fileName='" + this.fileName + '\'' + ", rollingFileName='" + this.rollingFileName + '\'' + ", bufferedWriter=" + this.bufferedWriter + ", closed=" + this.closed + ", nextRollingTime=" + this.nextRollingTime + '}';
    }
}

