/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.file;

import cn.myperf4j.base.file.AutoRollingFileWriter;
import cn.myperf4j.base.util.DateUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class HourlyRollingFileWriter
extends AutoRollingFileWriter {
    private static final ThreadLocal<SimpleDateFormat> FILE_DATE_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("'.'yyyy-MM-dd-HH");
        }
    };

    public HourlyRollingFileWriter(String fileName, int reserveFileCount) {
        super(fileName, reserveFileCount);
    }

    @Override
    Calendar computeEpochCal(Date now, int epochOffset) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(now);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(11, epochOffset);
        return cal;
    }

    @Override
    String formatDateFileName(String fileName, Date date) {
        return fileName + FILE_DATE_FORMAT.get().format(date);
    }

    @Override
    boolean isSameEpoch(Date date1, Date date2) {
        return DateUtils.isSameHour(date1, date2);
    }
}

