/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.http;

import cn.myperf4j.base.http.HttpHeaders;
import cn.myperf4j.base.http.HttpRespStatus;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public final class HttpResponse {
    private final HttpRespStatus status;
    private final HttpHeaders headers;
    private final byte[] body;
    private String bodyString;

    public HttpResponse(HttpRespStatus status, HttpHeaders headers, String bodyString) {
        this.status = status;
        this.headers = headers;
        this.body = bodyString.getBytes(StandardCharsets.UTF_8);
        this.bodyString = bodyString;
    }

    public HttpResponse(HttpRespStatus status, HttpHeaders headers, byte[] body) {
        this.status = status;
        this.headers = headers;
        this.body = body;
    }

    public HttpRespStatus getStatus() {
        return this.status;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public byte[] getBody() {
        return this.body;
    }

    public String getBodyString() {
        if (this.bodyString == null) {
            this.bodyString = new String(this.body, 0, this.body.length, StandardCharsets.UTF_8);
        }
        return this.bodyString;
    }

    public String toString() {
        return "HttpResponse{status=" + this.status + ", headers=" + this.headers + ", body=" + Arrays.toString(this.body) + '}';
    }
}

