/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.http.client;

import cn.myperf4j.base.http.HttpHeaders;
import cn.myperf4j.base.http.HttpMethod;
import cn.myperf4j.base.http.HttpRequest;
import cn.myperf4j.base.http.HttpRespStatus;
import cn.myperf4j.base.http.HttpResponse;
import cn.myperf4j.base.http.HttpStatusClass;
import cn.myperf4j.base.util.collections.ArrayUtils;
import cn.myperf4j.base.util.collections.ListUtils;
import cn.myperf4j.base.util.io.InputStreamUtils;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;

public final class HttpClient {
    private final int connectTimeout;
    private final int readTimeout;

    public HttpClient(Builder builder) {
        this.connectTimeout = builder.connectTimeout;
        this.readTimeout = builder.readTimeout;
    }

    public HttpResponse execute(HttpRequest request) throws IOException {
        HttpURLConnection urlConn = this.createConnection(request);
        urlConn.connect();
        HttpHeaders headers = new HttpHeaders(urlConn.getHeaderFields());
        HttpRespStatus status = HttpRespStatus.valueOf(urlConn.getResponseCode());
        if (HttpStatusClass.SUCCESS.contains(status.code())) {
            return new HttpResponse(status, headers, InputStreamUtils.toBytes(urlConn.getInputStream()));
        }
        return new HttpResponse(status, headers, InputStreamUtils.toBytes(urlConn.getErrorStream()));
    }

    private HttpURLConnection createConnection(HttpRequest request) throws IOException {
        URL url = new URL(request.getFullUrl());
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(this.connectTimeout);
        conn.setReadTimeout(this.readTimeout);
        HttpMethod method = request.getMethod();
        conn.setRequestMethod(method.getName());
        conn.setDoOutput(method == HttpMethod.POST);
        conn.setDoInput(true);
        conn.setUseCaches(false);
        this.configureHeaders(request, conn);
        this.writeBody(request, conn);
        return conn;
    }

    private void configureHeaders(HttpRequest request, HttpURLConnection conn) {
        HttpHeaders headers = request.getHeaders();
        List<String> names = headers.names();
        for (int i = 0; i < names.size(); ++i) {
            String name = names.get(i);
            List<String> values = headers.getValues(name);
            if (ListUtils.isEmpty(values)) continue;
            for (int k = 0; k < values.size(); ++k) {
                conn.addRequestProperty(name, values.get(k));
            }
        }
    }

    private void writeBody(HttpRequest request, HttpURLConnection conn) throws IOException {
        HttpMethod method = request.getMethod();
        byte[] body = request.getBody();
        if (method.isPermitsBody() && ArrayUtils.isNotEmpty(body)) {
            try (BufferedOutputStream bufferedOs = new BufferedOutputStream(conn.getOutputStream());){
                bufferedOs.write(body);
            }
        }
    }

    public static class Builder {
        private static final int DEFAULT_CONNECT_TIMEOUT = 1000;
        private static final int DEFAULT_READ_TIMEOUT = 3000;
        private int connectTimeout = 1000;
        private int readTimeout = 3000;

        public Builder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder readTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public HttpClient build() {
            return new HttpClient(this);
        }
    }
}

