/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.influxdb;

import cn.myperf4j.base.http.HttpRequest;
import cn.myperf4j.base.http.HttpRespStatus;
import cn.myperf4j.base.http.HttpResponse;
import cn.myperf4j.base.http.HttpStatusClass;
import cn.myperf4j.base.http.client.HttpClient;
import cn.myperf4j.base.influxdb.InfluxDbClient;
import cn.myperf4j.base.util.Base64;
import cn.myperf4j.base.util.Logger;
import cn.myperf4j.base.util.StrUtils;
import cn.myperf4j.base.util.concurrent.ExecutorManager;
import cn.myperf4j.base.util.concurrent.ThreadUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class InfluxDbV1Client
implements InfluxDbClient {
    private static final Base64.Encoder BASE64_ENCODER = Base64.getEncoder();
    private static final ThreadPoolExecutor ASYNC_EXECUTOR = new ThreadPoolExecutor(1, 2, 3L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(1024), ThreadUtils.newThreadFactory("MyPerf4J-InfluxDbV1Client_"), new ThreadPoolExecutor.DiscardOldestPolicy());
    private final String writeReqUrl;
    private final String authorization;
    private final HttpClient httpClient;

    public InfluxDbV1Client(Builder builder) {
        this.writeReqUrl = "http://" + builder.host + ":" + builder.port + "/write?db=" + builder.database;
        this.authorization = this.buildAuthorization(builder);
        this.httpClient = new HttpClient.Builder().connectTimeout(builder.connectTimeout).readTimeout(builder.readTimeout).build();
    }

    private String buildAuthorization(Builder builder) {
        if (StrUtils.isNotBlank(builder.username) && StrUtils.isNotBlank(builder.password)) {
            String auth = builder.username + ':' + builder.password;
            return "Basic " + BASE64_ENCODER.encodeToString(auth.getBytes(StandardCharsets.UTF_8));
        }
        return "";
    }

    @Override
    public boolean writeMetricsSync(String content) {
        HttpRequest req = new HttpRequest.Builder().url(this.writeReqUrl).header("Authorization", this.authorization).post(content).build();
        try {
            HttpResponse response = this.httpClient.execute(req);
            HttpRespStatus status = response.getStatus();
            if (status.statusClass() == HttpStatusClass.SUCCESS) {
                if (Logger.isDebugEnable()) {
                    Logger.debug("InfluxDbV1Client.writeMetricsSync(): respStatus=" + status.simpleString() + ", reqBody=" + content);
                }
                return true;
            }
            if (status.statusClass() != HttpStatusClass.INFORMATIONAL && status.statusClass() != HttpStatusClass.SUCCESS) {
                Logger.warn("InfluxDbV1Client.writeMetricsSync(): respStatus=" + status.simpleString() + ", reqBody=" + content);
            }
        }
        catch (IOException e) {
            Logger.warn("InfluxDbV1Client.writeMetricsSync() catch IOException!", e);
        }
        catch (Throwable t) {
            Logger.error("InfluxDbV1Client.writeMetricsSync() catch Exception!", t);
        }
        return false;
    }

    @Override
    public boolean writeMetricsAsync(final String content) {
        if (StrUtils.isBlank(content)) {
            return false;
        }
        try {
            ASYNC_EXECUTOR.execute(new Runnable(){

                @Override
                public void run() {
                    InfluxDbV1Client.this.writeMetricsSync(content);
                }
            });
            return true;
        }
        catch (Throwable t) {
            Logger.error("InfluxDbV1Client.writeMetricsAsync(): t=" + t.getMessage(), t);
            return false;
        }
    }

    @Override
    public boolean close() {
        return true;
    }

    static {
        ExecutorManager.addExecutorService(ASYNC_EXECUTOR);
    }

    public static class Builder {
        private static final int DEFAULT_CONNECT_TIMEOUT = 3000;
        private static final int DEFAULT_READ_TIMEOUT = 5000;
        private String host;
        private int port;
        private String database;
        private String username;
        private String password;
        private int connectTimeout = 3000;
        private int readTimeout = 5000;

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder database(String database) {
            this.database = database;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder readTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public InfluxDbV1Client build() {
            return new InfluxDbV1Client(this);
        }
    }
}

