/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.log;

import cn.myperf4j.base.config.MetricsConfig;
import cn.myperf4j.base.config.ProfilingConfig;
import cn.myperf4j.base.log.AutoRollingLogger;
import cn.myperf4j.base.log.ILogger;
import cn.myperf4j.base.log.NullLogger;
import cn.myperf4j.base.log.StdoutLogger;
import java.util.HashMap;
import java.util.Map;

public final class LoggerFactory {
    private static final MetricsConfig METRICS_CONFIG = ProfilingConfig.metricsConfig();
    private static final Map<String, ILogger> LOGGER_MAP = new HashMap<String, ILogger>();

    private LoggerFactory() {
    }

    public static synchronized ILogger getLogger(String logFile) {
        if ((logFile = logFile.trim()).equalsIgnoreCase("NULL")) {
            return new NullLogger();
        }
        if (logFile.equalsIgnoreCase("STDOUT")) {
            return new StdoutLogger();
        }
        ILogger logger = LOGGER_MAP.get(logFile);
        if (logger != null) {
            return logger;
        }
        logger = new AutoRollingLogger(logFile, METRICS_CONFIG.logRollingTimeUnit(), METRICS_CONFIG.logReserveCount());
        LOGGER_MAP.put(logFile, logger);
        return logger;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                for (ILogger writer : LOGGER_MAP.values()) {
                    writer.preCloseLog();
                }
                for (ILogger writer : LOGGER_MAP.values()) {
                    writer.closeLog();
                }
            }
        }));
    }
}

