/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.metric;

import cn.myperf4j.base.metric.Metrics;

public class JvmGcMetrics
extends Metrics {
    private static final long serialVersionUID = -233095689152915892L;
    private final long youngGcCount;
    private final long youngGcTime;
    private final double avgYoungGcTime;
    private final long fullGcCount;
    private final long fullGcTime;
    private final long zGcCount;
    private final long zGcTime;
    private final double avgZGcTime;
    private final long zGcCyclesCount;
    private final long zGcCyclesTime;
    private final double avgZGcCyclesTime;
    private final long zGcPausesCount;
    private final long zGcPausesTime;
    private final double avgZGcPausesTime;

    public JvmGcMetrics(long youngGcCount, long youngGcTime, long fullGcCount, long fullGcTime, long zGcCount, long zGcTime, long zGcCyclesCount, long zGcCyclesTime, long zGcPausesCount, long zGcPausesTime) {
        this.youngGcCount = youngGcCount;
        this.youngGcTime = youngGcTime;
        this.avgYoungGcTime = this.getAvgTime(youngGcCount, youngGcTime);
        this.fullGcCount = fullGcCount;
        this.fullGcTime = fullGcTime;
        this.zGcCount = zGcCount;
        this.zGcTime = zGcTime;
        this.avgZGcTime = this.getAvgTime(zGcCount, zGcTime);
        this.zGcCyclesCount = zGcCyclesCount;
        this.zGcCyclesTime = zGcCyclesTime;
        this.avgZGcCyclesTime = this.getAvgTime(zGcCyclesCount, zGcCyclesTime);
        this.zGcPausesCount = zGcPausesCount;
        this.zGcPausesTime = zGcPausesTime;
        this.avgZGcPausesTime = this.getAvgTime(zGcPausesCount, zGcPausesTime);
    }

    private double getAvgTime(long count, long time) {
        return count > 0L ? (double)time / (double)count : 0.0;
    }

    public double getAvgYoungGcTime() {
        return this.avgYoungGcTime;
    }

    public long getFullGcCount() {
        return this.fullGcCount;
    }

    public long getFullGcTime() {
        return this.fullGcTime;
    }

    public long getYoungGcCount() {
        return this.youngGcCount;
    }

    public long getYoungGcTime() {
        return this.youngGcTime;
    }

    public long getZGcTime() {
        return this.zGcTime;
    }

    public long getZGcCount() {
        return this.zGcCount;
    }

    public double getAvgZGcTime() {
        return this.avgZGcTime;
    }

    public long getZGcCyclesCount() {
        return this.zGcCyclesCount;
    }

    public long getZGcCyclesTime() {
        return this.zGcCyclesTime;
    }

    public double getAvgZGcCyclesTime() {
        return this.avgZGcCyclesTime;
    }

    public long getZGcPausesCount() {
        return this.zGcPausesCount;
    }

    public long getZGcPausesTime() {
        return this.zGcPausesTime;
    }

    public double getAvgZGcPausesTime() {
        return this.avgZGcPausesTime;
    }

    public String toString() {
        return "JvmGcMetrics{youngGcCount=" + this.youngGcCount + ", youngGcTime=" + this.youngGcTime + ", avgYoungGcTime=" + this.avgYoungGcTime + ", fullGcCount=" + this.fullGcCount + ", fullGcTime=" + this.fullGcTime + ", zGcCount=" + this.zGcCount + ", zGcTime=" + this.zGcTime + ", avgZGcTime=" + this.avgZGcTime + ", zGcCyclesCount=" + this.zGcCyclesCount + ", zGcCyclesTime=" + this.zGcCyclesTime + ", avgZGcCyclesTime=" + this.avgZGcCyclesTime + ", zGcPausesCount=" + this.zGcPausesCount + ", zGcPausesTime=" + this.zGcPausesTime + ", avgZGcPausesTime=" + this.avgZGcPausesTime + '}';
    }
}

