/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.metric.collector;

import cn.myperf4j.base.metric.JvmMemoryMetrics;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.List;

public final class JvmMemoryCollector {
    private JvmMemoryCollector() {
    }

    public static JvmMemoryMetrics collectMemoryMetrics() {
        long oldGenUsed = 0L;
        long oldGenMax = 0L;
        long permGenUsed = 0L;
        long permGenMax = 0L;
        long edenUsed = 0L;
        long edenMax = 0L;
        long survivorUsed = 0L;
        long survivorMax = 0L;
        long metaspaceUsed = 0L;
        long metaSpaceMax = 0L;
        long codeCacheUsed = 0L;
        long codeCacheMax = 0L;
        List<MemoryPoolMXBean> mxBeanList = ManagementFactory.getMemoryPoolMXBeans();
        int size = mxBeanList.size();
        for (int i = 0; i < size; ++i) {
            MemoryPoolMXBean memoryPool = mxBeanList.get(i);
            MemoryUsage usage = memoryPool.getUsage();
            String poolName = memoryPool.getName();
            if (poolName.endsWith("Perm Gen")) {
                permGenUsed = usage.getUsed() >> 10;
                permGenMax = usage.getMax() >> 10;
                continue;
            }
            if (poolName.endsWith("Metaspace")) {
                metaspaceUsed = usage.getUsed() >> 10;
                metaSpaceMax = usage.getMax() >> 10;
                continue;
            }
            if (poolName.endsWith("Code Cache")) {
                codeCacheUsed = usage.getUsed() >> 10;
                codeCacheMax = usage.getMax() >> 10;
                continue;
            }
            if (poolName.endsWith("Old Gen")) {
                oldGenUsed = usage.getUsed() >> 10;
                oldGenMax = usage.getMax() >> 10;
                continue;
            }
            if (poolName.endsWith("Eden Space")) {
                edenUsed = usage.getUsed() >> 10;
                edenMax = usage.getMax() >> 10;
                continue;
            }
            if (!poolName.endsWith("Survivor Space")) continue;
            survivorUsed = usage.getUsed() >> 10;
            survivorMax = usage.getMax() >> 10;
        }
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage nonHeapMem = memoryMXBean.getNonHeapMemoryUsage();
        long nonHeapUsed = nonHeapMem.getUsed() >> 10;
        long nonHeapMax = nonHeapMem.getMax() >> 10;
        MemoryUsage heapMem = memoryMXBean.getHeapMemoryUsage();
        long heapUsed = heapMem.getUsed() >> 10;
        long heapMax = heapMem.getMax() >> 10;
        return new JvmMemoryMetrics(heapUsed, heapMax, nonHeapUsed, nonHeapMax, permGenUsed, permGenMax, metaspaceUsed, metaSpaceMax, codeCacheUsed, codeCacheMax, oldGenUsed, oldGenMax, edenUsed, edenMax, survivorUsed, survivorMax);
    }
}

