/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.metric.exporter.log.standard;

import cn.myperf4j.base.metric.JvmGcMetrics;
import cn.myperf4j.base.metric.exporter.log.AbstractLogJvmGcMetricsExporter;
import cn.myperf4j.base.metric.formatter.JvmGcMetricsFormatter;
import cn.myperf4j.base.metric.formatter.standard.StdJvmGcMetricsFormatter;
import cn.myperf4j.base.util.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class StdLogJvmGcMetricsExporter
extends AbstractLogJvmGcMetricsExporter {
    private static final JvmGcMetricsFormatter METRICS_FORMATTER = new StdJvmGcMetricsFormatter();
    private final ConcurrentMap<Long, List<JvmGcMetrics>> metricsMap = new ConcurrentHashMap<Long, List<JvmGcMetrics>>(8);

    @Override
    public void beforeProcess(long processId, long startMillis, long stopMillis) {
        this.metricsMap.put(processId, new ArrayList(1));
    }

    @Override
    public void process(JvmGcMetrics metrics, long processId, long startMillis, long stopMillis) {
        List metricsList = (List)this.metricsMap.get(processId);
        if (metricsList != null) {
            metricsList.add(metrics);
        } else {
            Logger.error("StdLogJvmGcMetricsExporter.process(" + processId + ", " + startMillis + ", " + stopMillis + "): metricsList is null!!!");
        }
    }

    @Override
    public void afterProcess(long processId, long startMillis, long stopMillis) {
        List metricsList = (List)this.metricsMap.remove(processId);
        if (metricsList != null) {
            this.logger.logAndFlush(METRICS_FORMATTER.format(metricsList, startMillis, stopMillis));
        } else {
            Logger.error("StdLogJvmGcMetricsExporter.afterProcess(" + processId + ", " + startMillis + ", " + stopMillis + "): metricsList is null!!!");
        }
    }
}

