/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.metric.formatter.influxdb;

import cn.myperf4j.base.config.ProfilingConfig;
import cn.myperf4j.base.metric.JvmBufferPoolMetrics;
import cn.myperf4j.base.metric.formatter.JvmBufferPoolMetricsFormatter;
import cn.myperf4j.base.util.LineProtocolUtils;
import cn.myperf4j.base.util.net.IpUtils;
import java.util.List;

public class InfluxJvmBufferPoolMetricsFormatter
implements JvmBufferPoolMetricsFormatter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String format(List<JvmBufferPoolMetrics> metricsList, long startMillis, long stopMillis) {
        StringBuilder sb = (StringBuilder)SB_TL.get();
        try {
            long startNanos = startMillis * 1000L * 1000L;
            int size = metricsList.size();
            for (int i = 0; i < size; ++i) {
                this.appendLineProtocol(metricsList.get(i), startNanos, sb);
            }
            String string = sb.substring(0, Math.max(0, sb.length() - 1));
            return string;
        }
        finally {
            sb.setLength(0);
        }
    }

    private void appendLineProtocol(JvmBufferPoolMetrics metrics, long startNanos, StringBuilder sb) {
        sb.append("jvm_buffer_pool_metrics_v2").append(",AppName=").append(ProfilingConfig.basicConfig().appName()).append(",PoolName=").append(LineProtocolUtils.processTagOrField(metrics.getName())).append(",host=").append(LineProtocolUtils.processTagOrField(IpUtils.getLocalhostName())).append(" Count=").append(metrics.getCount()).append('i').append(",MemoryUsed=").append(metrics.getMemoryUsed()).append('i').append(",MemoryCapacity=").append(metrics.getMemoryCapacity()).append('i').append(' ').append(startNanos).append('\n');
    }
}

