/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.metric.formatter.influxdb;

import cn.myperf4j.base.config.ProfilingConfig;
import cn.myperf4j.base.metric.JvmClassMetrics;
import cn.myperf4j.base.metric.formatter.JvmClassMetricsFormatter;
import cn.myperf4j.base.util.LineProtocolUtils;
import cn.myperf4j.base.util.net.IpUtils;
import java.util.List;

public final class InfluxJvmClassMetricsFormatter
implements JvmClassMetricsFormatter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String format(List<JvmClassMetrics> metricsList, long startMillis, long stopMillis) {
        StringBuilder sb = (StringBuilder)SB_TL.get();
        try {
            long startNanos = startMillis * 1000L * 1000L;
            int size = metricsList.size();
            for (int i = 0; i < size; ++i) {
                this.appendLineProtocol(metricsList.get(i), startNanos, sb);
            }
            String string = sb.substring(0, Math.max(0, sb.length() - 1));
            return string;
        }
        finally {
            sb.setLength(0);
        }
    }

    private void appendLineProtocol(JvmClassMetrics metrics, long startNanos, StringBuilder sb) {
        sb.append("jvm_class_metrics").append(",AppName=").append(ProfilingConfig.basicConfig().appName()).append(",host=").append(LineProtocolUtils.processTagOrField(IpUtils.getLocalhostName())).append(" Total=").append(metrics.getTotal()).append('i').append(",Loaded=").append(metrics.getLoaded()).append('i').append(",Unloaded=").append(metrics.getUnloaded()).append('i').append(' ').append(startNanos).append('\n');
    }
}

