/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.metric.formatter.influxdb;

import cn.myperf4j.base.config.ProfilingConfig;
import cn.myperf4j.base.metric.JvmGcMetrics;
import cn.myperf4j.base.metric.formatter.JvmGcMetricsFormatter;
import cn.myperf4j.base.util.LineProtocolUtils;
import cn.myperf4j.base.util.net.IpUtils;
import cn.myperf4j.base.util.text.NumFormatUtils;
import java.util.List;

public class InfluxJvmGcMetricsFormatter
implements JvmGcMetricsFormatter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String format(List<JvmGcMetrics> metricsList, long startMillis, long stopMillis) {
        StringBuilder sb = (StringBuilder)SB_TL.get();
        try {
            long startNanos = startMillis * 1000L * 1000L;
            int size = metricsList.size();
            for (int i = 0; i < size; ++i) {
                this.appendLineProtocol(metricsList.get(i), startNanos, sb);
            }
            String string = sb.substring(0, Math.max(0, sb.length() - 1));
            return string;
        }
        finally {
            sb.setLength(0);
        }
    }

    private void appendLineProtocol(JvmGcMetrics metrics, long startNanos, StringBuilder sb) {
        sb.append("jvm_gc_metrics_v2").append(",AppName=").append(ProfilingConfig.basicConfig().appName()).append(",host=").append(LineProtocolUtils.processTagOrField(IpUtils.getLocalhostName())).append(" YoungGcCount=").append(metrics.getYoungGcCount()).append('i').append(",YoungGcTime=").append(metrics.getYoungGcTime()).append('i').append(",AvgYoungGcTime=").append(NumFormatUtils.doubleFormat(metrics.getAvgYoungGcTime())).append(",FullGcCount=").append(metrics.getFullGcCount()).append('i').append(",FullGcTime=").append(metrics.getFullGcTime()).append('i').append(",ZGcTime=").append(metrics.getZGcTime()).append('i').append(",ZGcCount=").append(metrics.getZGcCount()).append('i').append(",AvgZGcTime=").append(NumFormatUtils.doubleFormat(metrics.getAvgZGcTime())).append(",ZGcCyclesTime=").append(metrics.getZGcCyclesTime()).append('i').append(",ZGcCyclesCount=").append(metrics.getZGcCyclesCount()).append('i').append(",AvgZGcCyclesTime=").append(NumFormatUtils.doubleFormat(metrics.getAvgZGcCyclesTime())).append(",ZGcPausesTime=").append(metrics.getZGcPausesTime()).append('i').append(",ZGcPausesCount=").append(metrics.getZGcPausesCount()).append('i').append(",AvgZGcPausesTime=").append(NumFormatUtils.doubleFormat(metrics.getAvgZGcPausesTime())).append(' ').append(startNanos).append('\n');
    }
}

