/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.metric.formatter.influxdb;

import cn.myperf4j.base.config.ProfilingConfig;
import cn.myperf4j.base.metric.JvmGcMetricsV3;
import cn.myperf4j.base.metric.formatter.JvmGcMetricsV3Formatter;
import cn.myperf4j.base.util.LineProtocolUtils;
import cn.myperf4j.base.util.net.IpUtils;
import cn.myperf4j.base.util.text.NumFormatUtils;
import java.util.List;

public class InfluxJvmGcMetricsV3Formatter
implements JvmGcMetricsV3Formatter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String format(List<JvmGcMetricsV3> metricsList, long startMillis, long stopMillis) {
        StringBuilder sb = (StringBuilder)SB_TL.get();
        try {
            long startNanos = startMillis * 1000L * 1000L;
            int size = metricsList.size();
            for (int i = 0; i < size; ++i) {
                this.appendLineProtocol(metricsList.get(i), startNanos, sb);
            }
            String string = sb.substring(0, Math.max(0, sb.length() - 1));
            return string;
        }
        finally {
            sb.setLength(0);
        }
    }

    private void appendLineProtocol(JvmGcMetricsV3 metrics, long startNanos, StringBuilder sb) {
        sb.append("jvm_gc_metrics_v3").append(",AppName=").append(ProfilingConfig.basicConfig().appName()).append(",host=").append(LineProtocolUtils.processTagOrField(IpUtils.getLocalhostName())).append(",GcName=").append(LineProtocolUtils.processTagOrField(metrics.getGcName())).append(" GcCount=").append(metrics.getGcCount()).append('i').append(",GcTime=").append(metrics.getGcTime()).append('i').append(",AvgGcTime=").append(NumFormatUtils.doubleFormat(metrics.getAvgGcTime())).append(' ').append(startNanos).append('\n');
    }
}

