/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.metric.formatter.influxdb;

import cn.myperf4j.base.config.ProfilingConfig;
import cn.myperf4j.base.metric.JvmMemoryMetrics;
import cn.myperf4j.base.metric.formatter.JvmMemoryMetricsFormatter;
import cn.myperf4j.base.util.LineProtocolUtils;
import cn.myperf4j.base.util.net.IpUtils;
import cn.myperf4j.base.util.text.NumFormatUtils;
import java.util.List;

public class InfluxJvmMemoryMetricsFormatter
implements JvmMemoryMetricsFormatter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String format(List<JvmMemoryMetrics> metricsList, long startMillis, long stopMillis) {
        StringBuilder sb = (StringBuilder)SB_TL.get();
        try {
            long startNanos = startMillis * 1000L * 1000L;
            int size = metricsList.size();
            for (int i = 0; i < size; ++i) {
                this.appendLineProtocol(metricsList.get(i), startNanos, sb);
            }
            String string = sb.substring(0, Math.max(0, sb.length() - 1));
            return string;
        }
        finally {
            sb.setLength(0);
        }
    }

    private void appendLineProtocol(JvmMemoryMetrics metrics, long startNanos, StringBuilder sb) {
        sb.append("jvm_memory_metrics_v2").append(",AppName=").append(ProfilingConfig.basicConfig().appName()).append(",host=").append(LineProtocolUtils.processTagOrField(IpUtils.getLocalhostName())).append(" HeapUsed=").append(metrics.getHeapUsed()).append('i').append(",HeapUsedPercent=").append(NumFormatUtils.doubleFormat(metrics.getHeapUsedPercent())).append(",NonHeapUsed=").append(metrics.getNonHeapUsed()).append('i').append(",NonHeapUsedPercent=").append(NumFormatUtils.doubleFormat(metrics.getNonHeapUsedPercent())).append(",PermGenUsed=").append(metrics.getPermGenUsed()).append('i').append(",PermGenUsedPercent=").append(NumFormatUtils.doubleFormat(metrics.getPermGenUsedPercent())).append(",MetaspaceUsed=").append(metrics.getMetaspaceUsed()).append('i').append(",MetaspaceUsedPercent=").append(NumFormatUtils.doubleFormat(metrics.getMetaspaceUsedPercent())).append(",CodeCacheUsed=").append(metrics.getCodeCacheUsed()).append('i').append(",CodeCacheUsedPercent=").append(NumFormatUtils.doubleFormat(metrics.getCodeCacheUsedPercent())).append(",OldGenUsed=").append(metrics.getOldGenUsed()).append('i').append(",OldGenUsedPercent=").append(NumFormatUtils.doubleFormat(metrics.getOldGenUsedPercent())).append(",EdenUsed=").append(metrics.getEdenUsed()).append('i').append(",EdenUsedPercent=").append(NumFormatUtils.doubleFormat(metrics.getEdenUsedPercent())).append(",SurvivorUsed=").append(metrics.getSurvivorUsed()).append('i').append(",SurvivorUsedPercent=").append(metrics.getSurvivorUsedPercent()).append(' ').append(startNanos).append('\n');
    }
}

