/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.metric.formatter.standard;

import cn.myperf4j.base.metric.JvmCompilationMetrics;
import cn.myperf4j.base.metric.formatter.JvmCompilationMetricsFormatter;
import cn.myperf4j.base.util.SysProperties;
import cn.myperf4j.base.util.text.DateFormatUtils;
import java.util.List;

public final class StdJvmCompilationMetricsFormatter
implements JvmCompilationMetricsFormatter {
    private static final String TITLE_FORMAT = "%-16s%16s%n";
    private static final String DATA_FORMAT = "%-16d%16d%n";

    @Override
    public String format(List<JvmCompilationMetrics> metricsList, long startMillis, long stopMillis) {
        StringBuilder sb = new StringBuilder((metricsList.size() + 2) * 40);
        sb.append("MyPerf4J JVM Compilation Metrics [").append(DateFormatUtils.format(startMillis)).append(", ").append(DateFormatUtils.format(stopMillis)).append(']').append(SysProperties.LINE_SEPARATOR);
        sb.append(String.format(TITLE_FORMAT, "Time(ms)", "TotalTime(ms)"));
        if (metricsList.isEmpty()) {
            return sb.toString();
        }
        for (int i = 0; i < metricsList.size(); ++i) {
            JvmCompilationMetrics metrics = metricsList.get(i);
            sb.append(String.format(DATA_FORMAT, metrics.getTime(), metrics.getTotalTime()));
        }
        return sb.toString();
    }
}

