/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.metric.formatter.standard;

import cn.myperf4j.base.metric.JvmFileDescriptorMetrics;
import cn.myperf4j.base.metric.formatter.JvmFileDescMetricsFormatter;
import cn.myperf4j.base.util.SysProperties;
import cn.myperf4j.base.util.text.DateFormatUtils;
import java.util.List;

public final class StdJvmFileDescMetricsFormatter
implements JvmFileDescMetricsFormatter {
    private static final String TITLE_FORMAT = "%-14s%14s%14s%n";
    private static final String DATA_FORMAT = "%-14d%14.2f%14s%n";

    @Override
    public String format(List<JvmFileDescriptorMetrics> metricsList, long startMillis, long stopMillis) {
        StringBuilder sb = new StringBuilder((metricsList.size() + 2) * 48);
        sb.append("MyPerf4J JVM FileDescriptor Metrics [").append(DateFormatUtils.format(startMillis)).append(", ").append(DateFormatUtils.format(stopMillis)).append(']').append(SysProperties.LINE_SEPARATOR);
        sb.append(String.format(TITLE_FORMAT, "OpenCount", "OpenPercent", "MaxPercent"));
        if (metricsList.isEmpty()) {
            return sb.toString();
        }
        for (int i = 0; i < metricsList.size(); ++i) {
            JvmFileDescriptorMetrics metrics = metricsList.get(i);
            sb.append(String.format(DATA_FORMAT, metrics.getOpenCount(), metrics.getOpenPercent(), metrics.getMaxCount()));
        }
        return sb.toString();
    }
}

