/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.util;

import java.util.Arrays;

public final class Base64 {
    private Base64() {
    }

    public static Encoder getEncoder() {
        return Encoder.RFC4648;
    }

    public static final class Encoder {
        private final byte[] newline;
        private final int lineMax;
        private final boolean isURL;
        private final boolean doPadding;
        private static final char[] toBase64 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        private static final char[] toBase64URL = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '_'};
        static final Encoder RFC4648 = new Encoder(false, null, -1, true);

        private Encoder(boolean isURL, byte[] newline, int lineMax, boolean doPadding) {
            this.isURL = isURL;
            this.newline = newline;
            this.lineMax = lineMax;
            this.doPadding = doPadding;
        }

        private int outLength(int srclen) {
            int len;
            if (this.doPadding) {
                len = 4 * ((srclen + 2) / 3);
            } else {
                int n = srclen % 3;
                len = 4 * (srclen / 3) + (n == 0 ? 0 : n + 1);
            }
            if (this.lineMax > 0) {
                len += (len - 1) / this.lineMax * this.newline.length;
            }
            return len;
        }

        public byte[] encode(byte[] src) {
            int len = this.outLength(src.length);
            byte[] dst = new byte[len];
            int ret = this.encode0(src, 0, src.length, dst);
            if (ret != dst.length) {
                return Arrays.copyOf(dst, ret);
            }
            return dst;
        }

        public String encodeToString(byte[] src) {
            byte[] encoded = this.encode(src);
            return new String(encoded, 0, 0, encoded.length);
        }

        private int encode0(byte[] src, int off, int end, byte[] dst) {
            char[] base64 = this.isURL ? toBase64URL : toBase64;
            int sp = off;
            int slen = (end - off) / 3 * 3;
            int sl = off + slen;
            if (this.lineMax > 0 && slen > this.lineMax / 4 * 3) {
                slen = this.lineMax / 4 * 3;
            }
            int dp = 0;
            while (sp < sl) {
                int sl0 = Math.min(sp + slen, sl);
                int sp0 = sp;
                int dp0 = dp;
                while (sp0 < sl0) {
                    int bits = (src[sp0++] & 0xFF) << 16 | (src[sp0++] & 0xFF) << 8 | src[sp0++] & 0xFF;
                    dst[dp0++] = (byte)base64[bits >>> 18 & 0x3F];
                    dst[dp0++] = (byte)base64[bits >>> 12 & 0x3F];
                    dst[dp0++] = (byte)base64[bits >>> 6 & 0x3F];
                    dst[dp0++] = (byte)base64[bits & 0x3F];
                }
                int dlen = (sl0 - sp) / 3 * 4;
                dp += dlen;
                sp = sl0;
                if (dlen != this.lineMax || sp >= end) continue;
                for (byte b : this.newline) {
                    dst[dp++] = b;
                }
            }
            if (sp < end) {
                int b0 = src[sp++] & 0xFF;
                dst[dp++] = (byte)base64[b0 >> 2];
                if (sp == end) {
                    dst[dp++] = (byte)base64[b0 << 4 & 0x3F];
                    if (this.doPadding) {
                        dst[dp++] = 61;
                        dst[dp++] = 61;
                    }
                } else {
                    int b1 = src[sp++] & 0xFF;
                    dst[dp++] = (byte)base64[b0 << 4 & 0x3F | b1 >> 4];
                    dst[dp++] = (byte)base64[b1 << 2 & 0x3F];
                    if (this.doPadding) {
                        dst[dp++] = 61;
                    }
                }
            }
            return dp;
        }
    }
}

