/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public final class LineProtocolUtils {
    private static final Pattern SPACE_PATTERN = Pattern.compile(" ");
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");
    private static final Pattern EQUAL_SIGN_PATTERN = Pattern.compile("=");
    private static final Map<String, String> methodNameMap = new ConcurrentHashMap<String, String>(1024);

    private LineProtocolUtils() {
    }

    public static String processTagOrField(String tagOrField) {
        String lineProtocol = methodNameMap.get(tagOrField);
        if (lineProtocol != null) {
            return lineProtocol;
        }
        lineProtocol = SPACE_PATTERN.matcher(tagOrField).replaceAll("\\\\ ");
        lineProtocol = COMMA_PATTERN.matcher(lineProtocol).replaceAll("\\\\,");
        lineProtocol = EQUAL_SIGN_PATTERN.matcher(lineProtocol).replaceAll("\\\\=");
        methodNameMap.put(tagOrField, lineProtocol);
        return lineProtocol;
    }
}

