/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.util;

import cn.myperf4j.base.util.Logger;

public final class NumUtils {
    private NumUtils() {
    }

    public static double getPercent(double curNum, double maxNum) {
        if (curNum > 0.0 && maxNum > 0.0) {
            return 100.0 * curNum / maxNum;
        }
        return 0.0;
    }

    public static int parseInt(String str, int defaultValue) {
        try {
            return Integer.parseInt(str);
        }
        catch (Exception e) {
            Logger.error("NumUtils.parseInt(" + str + ", " + defaultValue + ")", e);
            return defaultValue;
        }
    }

    public static long composeKv(int key, int value) {
        return (long)value << 32 | (long)key;
    }

    public static int parseKey(long kv) {
        return (int)kv;
    }

    public static int parseValue(long kv) {
        return (int)(kv >> 32);
    }
}

