/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class StrUtils {
    private static final byte[] HEX2B = new byte[65536];

    private StrUtils() {
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static boolean isNotEmpty(String str) {
        return !StrUtils.isEmpty(str);
    }

    public static boolean isBlank(String str) {
        if (str == null || str.isEmpty()) {
            return true;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String str) {
        return !StrUtils.isBlank(str);
    }

    public static boolean isContains(String str, char ch) {
        return StrUtils.isNotEmpty(str) && str.indexOf(ch) >= 0;
    }

    public static boolean isEndWith(String str, char ch) {
        return StrUtils.isNotEmpty(str) && str.charAt(str.length() - 1) == ch;
    }

    public static String trimToEmpty(String str) {
        return StrUtils.isEmpty(str) ? "" : str.trim();
    }

    public static List<String> splitAsList(String str, char separatorChar) {
        if (str == null || str.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        StrUtils.splitWorker(str, separatorChar, false, result);
        return result;
    }

    private static void splitWorker(String str, char separatorChar, boolean preserveAllTokens, List<String> list) {
        int i = 0;
        int start = 0;
        boolean match = false;
        boolean lastMatch = false;
        while (i < str.length()) {
            if (str.charAt(i) == separatorChar) {
                if (match || preserveAllTokens) {
                    list.add(str.substring(start, i));
                    match = false;
                    lastMatch = true;
                }
                start = ++i;
                continue;
            }
            lastMatch = false;
            match = true;
            ++i;
        }
        if (match || preserveAllTokens && lastMatch) {
            list.add(str.substring(start, i));
        }
    }

    public static byte decodeHexByte(CharSequence s, int pos) {
        int hi = StrUtils.decodeHexNibble(s.charAt(pos));
        int lo = StrUtils.decodeHexNibble(s.charAt(pos + 1));
        if (hi == -1 || lo == -1) {
            throw new IllegalArgumentException(String.format("invalid hex byte '%s' at index %d of '%s'", s.subSequence(pos, pos + 2), pos, s));
        }
        return (byte)((hi << 4) + lo);
    }

    public static int decodeHexNibble(char c) {
        assert (HEX2B.length == 65536);
        return HEX2B[c];
    }

    static {
        Arrays.fill(HEX2B, (byte)-1);
        StrUtils.HEX2B[48] = 0;
        StrUtils.HEX2B[49] = 1;
        StrUtils.HEX2B[50] = 2;
        StrUtils.HEX2B[51] = 3;
        StrUtils.HEX2B[52] = 4;
        StrUtils.HEX2B[53] = 5;
        StrUtils.HEX2B[54] = 6;
        StrUtils.HEX2B[55] = 7;
        StrUtils.HEX2B[56] = 8;
        StrUtils.HEX2B[57] = 9;
        StrUtils.HEX2B[65] = 10;
        StrUtils.HEX2B[66] = 11;
        StrUtils.HEX2B[67] = 12;
        StrUtils.HEX2B[68] = 13;
        StrUtils.HEX2B[69] = 14;
        StrUtils.HEX2B[70] = 15;
        StrUtils.HEX2B[97] = 10;
        StrUtils.HEX2B[98] = 11;
        StrUtils.HEX2B[99] = 12;
        StrUtils.HEX2B[100] = 13;
        StrUtils.HEX2B[101] = 14;
        StrUtils.HEX2B[102] = 15;
    }
}

