/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.util;

import cn.myperf4j.base.util.Logger;
import java.lang.reflect.Method;

public final class TypeDescUtils {
    private static final ThreadLocal<StringBuilder> SB_TL = new ThreadLocal<StringBuilder>(){

        @Override
        protected StringBuilder initialValue() {
            return new StringBuilder(128);
        }
    };
    private static final char[] TYPE_DESCRIPTOR = new char[]{'Z', 'C', 'B', 'S', 'I', 'F', 'J', 'D', '[', 'L'};
    private static final String[] JAVA_TYPE_DESC = new String[]{"boolean", "char", "byte", "short", "int", "float", "long", "double", "[]", "Object"};
    private static final byte[] TYPE_DESCRIPTOR_BIT_MAP = new byte[128];
    private static final String[] JAVA_TYPE_DESC_MAP = new String[128];

    private TypeDescUtils() {
    }

    public static String getMethodParamsDesc(String descriptor) {
        descriptor = descriptor.trim();
        int roundTimes = 0;
        StringBuilder sb = new StringBuilder("(");
        int i = 0;
        while (i < descriptor.length() && roundTimes++ <= descriptor.length()) {
            char ch = descriptor.charAt(i);
            if (ch == '(') {
                ++i;
                continue;
            }
            if (ch == ')') break;
            if (TypeDescUtils.isTypeDescriptor(ch)) {
                if ((i = TypeDescUtils.processDescriptor(descriptor, i, sb)) >= 0) continue;
                return descriptor;
            }
            Logger.error("TypeDescUtils.processDescriptor(" + descriptor + ") Should never arrive here!!! 0");
            return descriptor;
        }
        if (sb.length() < 2) {
            sb.append(')');
            return sb.toString();
        }
        sb.replace(sb.length() - 2, sb.length() - 1, ")");
        return sb.substring(0, sb.length() - 1);
    }

    private static boolean isTypeDescriptor(char ch) {
        return TYPE_DESCRIPTOR_BIT_MAP[ch] == 1;
    }

    private static int processDescriptor(String descriptor, int idx, StringBuilder sb) {
        int startIdx = idx;
        boolean isObjectDesc = false;
        int arrayLevel = 0;
        int roundTimes = 0;
        while (idx < descriptor.length() && roundTimes++ <= descriptor.length()) {
            char ch = descriptor.charAt(idx);
            if (ch == '[') {
                ++arrayLevel;
            } else if (ch == 'L') {
                isObjectDesc = true;
            } else {
                if (ch == ';') {
                    sb.append(TypeDescUtils.getSimpleClassName(descriptor, startIdx, idx));
                    TypeDescUtils.appendArrDesc(sb, arrayLevel);
                    sb.append(", ");
                    return idx + 1;
                }
                if (TypeDescUtils.isTypeDescriptor(ch) && !isObjectDesc) {
                    sb.append(JAVA_TYPE_DESC_MAP[ch]);
                    TypeDescUtils.appendArrDesc(sb, arrayLevel);
                    sb.append(", ");
                    return idx + 1;
                }
                if (ch == ')') {
                    Logger.error("TypeDescUtils.processDescriptor(" + descriptor + ", " + idx + ", " + sb + ") Should never arrive here!!! 1");
                    return -1;
                }
            }
            ++idx;
        }
        Logger.error("TypeDescUtils.processDescriptor(" + descriptor + ", " + idx + ", " + sb + ") Should never arrive here!!! 2");
        return -1;
    }

    private static String getSimpleClassName(String descriptor, int startIdx, int endIdx) {
        int lastIdx = startIdx;
        for (int i = endIdx; i >= startIdx; --i) {
            if (descriptor.charAt(i) != '/') continue;
            lastIdx = i;
            break;
        }
        return descriptor.substring(lastIdx + 1, endIdx);
    }

    private static void appendArrDesc(StringBuilder sb, int arrayLevel) {
        for (int k = 0; k < arrayLevel; ++k) {
            sb.append("[]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMethodParamsDesc(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length == 0) {
            return "()";
        }
        StringBuilder sb = SB_TL.get();
        try {
            int i;
            sb.append('(');
            for (i = 0; i < parameterTypes.length - 1; ++i) {
                sb.append(parameterTypes[i].getSimpleName()).append(", ");
            }
            sb.append(parameterTypes[i].getSimpleName()).append(')');
            String string = sb.toString();
            return string;
        }
        finally {
            sb.setLength(0);
        }
    }

    public static String getSimpleClassName(String innerClassName) {
        int idx = innerClassName.lastIndexOf(47);
        return innerClassName.substring(idx + 1);
    }

    static {
        for (int i = 0; i < TYPE_DESCRIPTOR.length; ++i) {
            char ch = TYPE_DESCRIPTOR[i];
            TypeDescUtils.TYPE_DESCRIPTOR_BIT_MAP[ch] = 1;
            TypeDescUtils.JAVA_TYPE_DESC_MAP[ch] = JAVA_TYPE_DESC[i];
        }
    }
}

