/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.util;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import sun.misc.Unsafe;

public final class UnsafeUtils {
    private static final Unsafe UNSAFE = UnsafeUtils.generateUnsafe();

    private static Unsafe generateUnsafe() {
        Unsafe unsafe = null;
        try {
            unsafe = AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                @Override
                public Unsafe run() throws Exception {
                    Class<Unsafe> k = Unsafe.class;
                    for (Field f : k.getDeclaredFields()) {
                        f.setAccessible(true);
                        Object x = f.get(null);
                        if (!k.isInstance(x)) continue;
                        return (Unsafe)k.cast(x);
                    }
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return unsafe;
    }

    public static Unsafe getUnsafe() {
        return UNSAFE;
    }

    public static long fieldOffset(Class<?> clz, String fieldName) throws RuntimeException {
        try {
            return UNSAFE.objectFieldOffset(clz.getDeclaredField(fieldName));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static int getAndAddInt(Object obj, long offset, int delta) {
        int oldVal;
        while (!UNSAFE.compareAndSwapInt(obj, offset, oldVal = UNSAFE.getIntVolatile(obj, offset), oldVal + delta)) {
        }
        return oldVal;
    }

    public static int getAndSetInt(Object obj, long offset, int newVal) {
        int oldVal;
        while (!UNSAFE.compareAndSwapInt(obj, offset, oldVal = UNSAFE.getIntVolatile(obj, offset), newVal)) {
        }
        return oldVal;
    }

    public static Object getAndSetObject(Object obj, long offset, Object newVal) {
        Object oldVal;
        while (!UNSAFE.compareAndSwapObject(obj, offset, oldVal = UNSAFE.getObjectVolatile(obj, offset), newVal)) {
        }
        return oldVal;
    }

    public static long getAndAddLong(Object obj, long offset, long delta) {
        long oldVal;
        while (!UNSAFE.compareAndSwapLong(obj, offset, oldVal = UNSAFE.getLongVolatile(obj, offset), oldVal + delta)) {
        }
        return oldVal;
    }

    private UnsafeUtils() {
    }
}

