/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.util.concurrent;

import cn.myperf4j.base.buffer.LongBuf;
import cn.myperf4j.base.util.UnsafeUtils;
import java.io.Serializable;
import sun.misc.Unsafe;

public final class AtomicIntArray
implements Serializable {
    private static final long serialVersionUID = 4512166855752664301L;
    private static final Unsafe unsafe = UnsafeUtils.getUnsafe();
    private static final int base = Unsafe.ARRAY_INT_BASE_OFFSET;
    private static final int scale = Unsafe.ARRAY_INT_INDEX_SCALE;
    private static final int shift = 31 - Integer.numberOfLeadingZeros(scale);
    private final int[] array;

    private long checkedByteOffset(int i) {
        if (i < 0 || i >= this.array.length) {
            throw new IndexOutOfBoundsException("index " + i);
        }
        return AtomicIntArray.byteOffset(i);
    }

    private static long byteOffset(int i) {
        return ((long)i << shift) + (long)base;
    }

    public AtomicIntArray(int length) {
        this.array = new int[length];
    }

    public int length() {
        return this.array.length;
    }

    public int get(int i) {
        return this.getRaw(this.checkedByteOffset(i));
    }

    private int getRaw(long offset) {
        return unsafe.getIntVolatile(this.array, offset);
    }

    public void set(int i, int newValue) {
        unsafe.putIntVolatile(this.array, this.checkedByteOffset(i), newValue);
    }

    public int getAndIncrement(int i) {
        return this.getAndAdd(i, 1);
    }

    public int getAndAdd(int i, int delta) {
        int current;
        long offset = this.checkedByteOffset(i);
        while (!this.compareAndSetRaw(offset, current = this.getRaw(offset), current + delta)) {
        }
        return current;
    }

    private boolean compareAndSetRaw(long offset, int expect, int update) {
        return unsafe.compareAndSwapInt(this.array, offset, expect, update);
    }

    public int incrementAndGet(int i) {
        return this.addAndGet(i, 1);
    }

    public int addAndGet(int i, int delta) {
        int next;
        int current;
        long offset = this.checkedByteOffset(i);
        while (!this.compareAndSetRaw(offset, current = this.getRaw(offset), next = current + delta)) {
        }
        return next;
    }

    public void reset() {
        int[] array = this.array;
        unsafe.setMemory(array, AtomicIntArray.byteOffset(0), (long)array.length * (long)scale, (byte)0);
    }

    public long fillSortedKvs(LongBuf longBuf) {
        long totalCount = 0L;
        int len = this.array.length;
        for (int i = 0; i < len; ++i) {
            int count = this.get(i);
            if (count <= 0) continue;
            longBuf.write(i, count);
            totalCount += (long)count;
        }
        return totalCount;
    }

    static {
        if ((scale & scale - 1) != 0) {
            throw new Error("data type scale not a power of two");
        }
    }
}

