/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.util.concurrent;

import cn.myperf4j.base.buffer.LongBuf;
import cn.myperf4j.base.util.UnsafeUtils;
import cn.myperf4j.base.util.concurrent.IntHashCounter;
import java.io.Serializable;
import java.util.Arrays;
import sun.misc.Unsafe;

public class AtomicIntHashCounter
implements IntHashCounter {
    private static final Unsafe UNSAFE = UnsafeUtils.getUnsafe();
    private static final int I_BASE = Unsafe.ARRAY_INT_BASE_OFFSET;
    private static final int I_SCALE = Unsafe.ARRAY_INT_INDEX_SCALE;
    private static final int I_SHIFT = 31 - Integer.numberOfLeadingZeros(I_SCALE);
    private static final long IHC_OFFSET = UnsafeUtils.fieldOffset(AtomicIntHashCounter.class, "ihc");
    private static final long SIZE_OFFSET = UnsafeUtils.fieldOffset(AtomicIntHashCounter.class, "size");
    private static final long VAL_0_OFFSET = UnsafeUtils.fieldOffset(AtomicIntHashCounter.class, "val0");
    private static final int MIN_LOG_SIZE = 4;
    private static final int MAX_LOG_SIZE = 29;
    private static final int MAX_CAPACITY = 0x20000000;
    private static final int MIN_SIZE = 16;
    private static final int RE_PROBE_LIMIT = 10;
    private static final int NO_KEY = 0;
    private static final int PRIME_MASK = Integer.MIN_VALUE;
    private static final int TOMB_PRIME = Integer.MIN_VALUE;
    private IHC ihc;
    private int size;
    private int val0;

    public AtomicIntHashCounter() {
        this(16);
    }

    public AtomicIntHashCounter(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initialCapacity: " + initialCapacity + " (expected: >= 0)");
        }
        if (initialCapacity >= 0x20000000) {
            throw new IllegalArgumentException("Max initialCapacity need low than 536870912");
        }
        this.ihc = new IHC(this, AtomicIntHashCounter.log2Size(initialCapacity));
        this.size = 0;
        this.val0 = 0;
    }

    private static int log2Size(int minSize) {
        int log2 = 4;
        while (1L << log2 < (long)minSize) {
            ++log2;
        }
        return log2;
    }

    private boolean CAS(long offset, Object oldObj, Object newObj) {
        return UNSAFE.compareAndSwapObject(this, offset, oldObj, newObj);
    }

    private void helpCopy() {
        IHC topIhc = this.ihc;
        if (topIhc.nextIhc == null) {
            return;
        }
        topIhc.helpCopy(false);
    }

    private void incrementSize() {
        UnsafeUtils.getAndAddInt(this, SIZE_OFFSET, 1);
    }

    @Override
    public int get(int key) {
        if (key == 0) {
            return this.val0;
        }
        int V = this.ihc.get(key);
        assert (!AtomicIntHashCounter.isPrime(V));
        return V;
    }

    @Override
    public int getAndIncrement(int key) {
        return this.getAndAdd(key, 1);
    }

    @Override
    public int getAndAdd(int key, int delta) {
        return this.addDelta(key, delta);
    }

    private int addDelta(int key, int delta) {
        if (key == 0) {
            return UnsafeUtils.getAndAddInt(this, VAL_0_OFFSET, delta);
        }
        int res = this.ihc.addDelta(key, delta, false);
        assert (!AtomicIntHashCounter.isPrime(res));
        return res;
    }

    @Override
    public int incrementAndGet(int key) {
        return this.addAndGet(key, 1);
    }

    @Override
    public int addAndGet(int key, int delta) {
        return this.addDelta(key, delta) + delta;
    }

    @Override
    public int size() {
        return (this.val0 == 0 ? 0 : 1) + this.size;
    }

    @Override
    public void reset() {
        this.size = 0;
        this.val0 = 0;
        this.finishCopy().reset();
    }

    @Override
    public long fillSortedKvs(LongBuf longBuf) {
        long totalCount = 0L;
        int offset = longBuf.writerIndex();
        if (this.val0 > 0) {
            longBuf.write(0, this.val0);
            totalCount += (long)this.val0;
        }
        IHC topIhc = this.finishCopy();
        int[] kvs = topIhc.kvs;
        int len = kvs.length;
        for (int k = 0; k < len; k += 2) {
            int value = kvs[k + 1];
            if (value <= 0) continue;
            longBuf.write(kvs[k], value);
            totalCount += (long)value;
        }
        if (offset == longBuf.writerIndex()) {
            return 0L;
        }
        int writerIndex = longBuf.writerIndex();
        Arrays.sort(longBuf._buf(), offset, writerIndex);
        return totalCount;
    }

    private IHC finishCopy() {
        IHC topIhc;
        while ((topIhc = this.ihc).nextIhc != null) {
            topIhc.helpCopy(true);
        }
        return topIhc;
    }

    private static long byteOffset(int idx) {
        return ((long)idx << I_SHIFT) + (long)I_BASE;
    }

    private static long composeKv(int key, int value) {
        return (long)value << 32 | (long)key;
    }

    private static int parseKey(long kv) {
        return (int)kv;
    }

    private static int parseValue(long kv) {
        return (int)(kv >> 32);
    }

    private static boolean isPrime(int v) {
        return (v & Integer.MIN_VALUE) != 0;
    }

    private static int boxPrime(int v) {
        return v | Integer.MIN_VALUE;
    }

    private static int reProbeLimit(int len) {
        return 10 + (len >> 4);
    }

    private static int len(int[] kvs) {
        return kvs.length >> 1;
    }

    static {
        if ((I_SCALE & I_SCALE - 1) != 0) {
            throw new Error("data type scale not a power of two");
        }
    }

    private static final class IHC
    implements Serializable {
        private static final long serialVersionUID = -156965978265678243L;
        private static final long SLOTS_OFFSET = UnsafeUtils.fieldOffset(IHC.class, "slots");
        private static final long NEXT_IHC_OFFSET = UnsafeUtils.fieldOffset(IHC.class, "nextIhc");
        private static final long RESIZE_THREADS_OFFSET = UnsafeUtils.fieldOffset(IHC.class, "resizeThreads");
        private static final long COPY_DONE_OFFSET = UnsafeUtils.fieldOffset(IHC.class, "copyDone");
        private static final long COPY_IDX_OFFSET = UnsafeUtils.fieldOffset(IHC.class, "copyIdx");
        private final AtomicIntHashCounter aihc;
        private volatile int slots;
        private volatile IHC nextIhc;
        private volatile long resizeThreads;
        private volatile long copyDone;
        private volatile long copyIdx;
        private final int[] kvs;
        private final int len;
        private final int reProbeLimit;

        IHC(AtomicIntHashCounter aihc, int logSize) {
            this.aihc = aihc;
            this.slots = 0;
            this.kvs = new int[1 << logSize << 1];
            this.len = AtomicIntHashCounter.len(this.kvs);
            this.reProbeLimit = AtomicIntHashCounter.reProbeLimit(this.len);
        }

        public void reset() {
            this.slots = 0;
            this.nextIhc = null;
            this.resizeThreads = 0L;
            this.copyDone = 0L;
            this.copyIdx = 0L;
            UNSAFE.setMemory(this.kvs, AtomicIntHashCounter.byteOffset(0), (long)this.kvs.length * (long)I_SCALE, (byte)0);
        }

        private boolean casNextIhc(IHC newIhc) {
            return UNSAFE.compareAndSwapObject(this, NEXT_IHC_OFFSET, null, newIhc);
        }

        private boolean casKv(int idx, long oldKv, long newKv) {
            return UNSAFE.compareAndSwapLong(this.kvs, AtomicIntHashCounter.byteOffset(idx << 1), oldKv, newKv);
        }

        private boolean casValue(int idx, int oldVal, int newVal) {
            return UNSAFE.compareAndSwapInt(this.kvs, AtomicIntHashCounter.byteOffset((idx << 1) + 1), oldVal, newVal);
        }

        private long getKv(int idx) {
            return UNSAFE.getLongVolatile(this.kvs, AtomicIntHashCounter.byteOffset(idx << 1));
        }

        private int getValue(int idx) {
            return UNSAFE.getIntVolatile(this.kvs, AtomicIntHashCounter.byteOffset((idx << 1) + 1));
        }

        private int get(int key) {
            int lenMask = this.len - 1;
            int idx = key & lenMask;
            int reProbeTimes = 0;
            long kv;
            while ((kv = this.getKv(idx)) != 0L) {
                int k = AtomicIntHashCounter.parseKey(kv);
                if (k == key) {
                    int v = AtomicIntHashCounter.parseValue(kv);
                    if (!AtomicIntHashCounter.isPrime(v)) {
                        return v;
                    }
                    this.aihc.helpCopy();
                    return this.nextIhc.get(key);
                }
                if (++reProbeTimes >= this.reProbeLimit || k == Integer.MIN_VALUE) {
                    if (this.nextIhc != null) {
                        this.aihc.helpCopy();
                        return this.nextIhc.get(key);
                    }
                    return 0;
                }
                idx = idx + 1 & lenMask;
            }
            return 0;
        }

        private int addDelta(int key, int delta, boolean fromTableCopy) {
            assert (key > 0 && delta > 0);
            int lenMask = this.len - 1;
            int idx = key & lenMask;
            int reProbeTimes = 0;
            while (true) {
                long kv = this.getKv(idx);
                int k = AtomicIntHashCounter.parseKey(kv);
                int v = AtomicIntHashCounter.parseValue(kv);
                if (k == 0) {
                    assert (v == 0);
                    if (this.casKv(idx, kv, AtomicIntHashCounter.composeKv(key, delta))) {
                        int slots;
                        if (!fromTableCopy) {
                            this.aihc.incrementSize();
                        }
                        if ((slots = UnsafeUtils.getAndAddInt(this, SLOTS_OFFSET, 1)) >= (this.len >> 1) + (this.len >> 2)) {
                            this.resize();
                            if (!fromTableCopy) {
                                this.aihc.helpCopy();
                            }
                        }
                        return v;
                    }
                    kv = this.getKv(idx);
                    k = AtomicIntHashCounter.parseKey(kv);
                    v = AtomicIntHashCounter.parseValue(kv);
                    assert (k != 0);
                }
                if (k == key) {
                    while (true) {
                        if (AtomicIntHashCounter.isPrime(v)) {
                            if (!fromTableCopy) {
                                this.aihc.helpCopy();
                            }
                            return this.nextIhc.addDelta(key, delta, v != Integer.MIN_VALUE);
                        }
                        if (this.casValue(idx, v, v + delta)) {
                            return v;
                        }
                        v = this.getValue(idx);
                    }
                }
                if (++reProbeTimes >= this.reProbeLimit || k == Integer.MIN_VALUE) {
                    IHC newIhc = this.resize();
                    if (!fromTableCopy) {
                        this.aihc.helpCopy();
                    }
                    return newIhc.addDelta(key, delta, fromTableCopy);
                }
                idx = idx + 1 & lenMask;
            }
        }

        private IHC resize() {
            IHC newIhc = this.nextIhc;
            if (newIhc != null) {
                return newIhc;
            }
            int newSize = this.len << 1;
            int log2 = AtomicIntHashCounter.log2Size(newSize);
            if (log2 > 29) {
                throw new RuntimeException("Table is full, size=" + this.aihc.size + ", newSize=" + newSize);
            }
            long r = UnsafeUtils.getAndAddLong(this, RESIZE_THREADS_OFFSET, 1L);
            long megs = (1L << log2 << 1) + 8L << 3 >> 20;
            if (r >= 2L && megs > 0L) {
                newIhc = this.nextIhc;
                if (newIhc != null) {
                    return newIhc;
                }
                try {
                    Thread.sleep(megs);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((newIhc = this.nextIhc) != null) {
                return newIhc;
            }
            newIhc = new IHC(this.aihc, log2);
            if (this.nextIhc != null) {
                return this.nextIhc;
            }
            if (this.casNextIhc(newIhc)) {
                return newIhc;
            }
            return this.nextIhc;
        }

        private void helpCopy(boolean copyAll) {
            IHC newIhc = this.nextIhc;
            assert (newIhc != null);
            int oldLen = this.len;
            int MIN_COPY_WORK = Math.min(oldLen, 1024);
            int panicStart = -1;
            int copyIdx = -9999;
            while (this.copyDone < (long)oldLen) {
                if (panicStart == -1 && (copyIdx = (int)UnsafeUtils.getAndAddLong(this, COPY_IDX_OFFSET, MIN_COPY_WORK)) >= oldLen << 1) {
                    panicStart = copyIdx;
                }
                int workDone = 0;
                for (int i = 0; i < MIN_COPY_WORK; ++i) {
                    if (!this.copySlot(copyIdx + i & oldLen - 1)) continue;
                    ++workDone;
                }
                if (workDone > 0) {
                    this.copyCheckAndPromote(workDone);
                }
                copyIdx += MIN_COPY_WORK;
                if (copyAll || panicStart != -1) continue;
                return;
            }
            this.copyCheckAndPromote(0);
        }

        private boolean copySlot(int idx) {
            long kv = this.getKv(idx);
            int oldKey = AtomicIntHashCounter.parseKey(kv);
            int oldVal = AtomicIntHashCounter.parseValue(kv);
            while (!AtomicIntHashCounter.isPrime(oldVal)) {
                int box;
                if (this.casKv(idx, kv, AtomicIntHashCounter.composeKv(oldKey == 0 ? Integer.MIN_VALUE : oldKey, box = oldVal == 0 ? Integer.MIN_VALUE : AtomicIntHashCounter.boxPrime(oldVal)))) {
                    if (oldVal != 0) {
                        this.nextIhc.addDelta(oldKey, oldVal, true);
                    }
                    return true;
                }
                kv = this.getKv(idx);
                oldKey = AtomicIntHashCounter.parseKey(kv);
                oldVal = AtomicIntHashCounter.parseValue(kv);
            }
            return false;
        }

        private void copyCheckAndPromote(int workDone) {
            int oldLen = this.len;
            long copyDone = this.copyDone;
            assert (copyDone + (long)workDone <= (long)oldLen);
            if (workDone > 0) {
                copyDone = UnsafeUtils.getAndAddLong(this, COPY_DONE_OFFSET, workDone);
                assert (copyDone + (long)workDone <= (long)oldLen);
            }
            if (copyDone + (long)workDone == (long)oldLen && this.aihc.ihc == this) {
                this.aihc.CAS(IHC_OFFSET, this, this.nextIhc);
            }
        }
    }
}

