/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.util.concurrent;

import cn.myperf4j.base.util.Logger;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public final class ExecutorManager {
    private static final Set<ExecutorService> executors = new HashSet<ExecutorService>();

    private ExecutorManager() {
    }

    public static void addExecutorService(ExecutorService executor) {
        executors.add(executor);
    }

    public static void stopAll(long timeout, TimeUnit unit) {
        for (ExecutorService executorService : executors) {
            try {
                executorService.shutdown();
                executorService.awaitTermination(timeout, unit);
            }
            catch (InterruptedException e) {
                Logger.error("ExecutorManager.stopAll()", e);
                Thread.currentThread().interrupt();
            }
        }
    }
}

