/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.util.concurrent;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class ThreadUtils {
    private ThreadUtils() {
    }

    public static ThreadFactory newThreadFactory(final String prefix) {
        return new ThreadFactory(){
            final AtomicInteger threadId = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, prefix + this.threadId.getAndIncrement());
            }
        };
    }

    public static void sleepQuietly(long time, TimeUnit timeUnit) {
        try {
            timeUnit.sleep(time);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static ThreadGroup getSystemThreadGroup() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        return threadGroup;
    }

    public static Thread[] findThreads(ThreadGroup group, boolean recurse) {
        Thread[] threads;
        if (group == null) {
            throw new IllegalArgumentException("The group must not be null");
        }
        int count = group.activeCount();
        while ((count = group.enumerate(threads = new Thread[count + count / 2 + 1], recurse)) >= threads.length) {
        }
        return threads;
    }
}

