/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.util.net;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.ServerSocket;

public final class NetUtils {
    public static final int MIN_PORT_NUMBER = 1;
    public static final int MAX_PORT_NUMBER = 65535;

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean isPortAvailable(int port) {
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("Invalid port: " + port);
        }
        try (ServerSocket ss = new ServerSocket(port);){
            DatagramSocket ds = new DatagramSocket(port);
            try {
                ss.setReuseAddress(true);
                ds.setReuseAddress(true);
                boolean bl = true;
                ds.close();
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    ds.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return false;
        }
    }

    private NetUtils() {
    }
}

