/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.core;

import cn.myperf4j.base.MethodTag;
import cn.myperf4j.base.buffer.LongBuf;
import cn.myperf4j.base.buffer.LongBufPool;
import cn.myperf4j.base.metric.MethodMetrics;
import cn.myperf4j.base.util.Logger;
import cn.myperf4j.base.util.NumUtils;
import cn.myperf4j.core.recorder.Recorder;

public final class MethodMetricsCalculator {
    private static final ThreadLocal<long[]> LONG_ARR_TL = new ThreadLocal<long[]>(){

        @Override
        protected long[] initialValue() {
            return new long[MethodMetrics.getPercentiles().length];
        }
    };
    private static final LongBufPool longBufPool = LongBufPool.getInstance();

    public static MethodMetrics calMetrics(Recorder recorder, MethodTag methodTag, long startTime, long stopTime) {
        int diffCount = recorder.getDiffCount();
        LongBuf longBuf = longBufPool.acquire(diffCount);
        try {
            long totalCount = recorder.fillSortedRecords(longBuf);
            MethodMetrics methodMetrics = MethodMetricsCalculator.calMetrics(recorder, methodTag, startTime, stopTime, longBuf, totalCount, diffCount);
            if (longBuf != null) {
                longBuf.close();
            }
            return methodMetrics;
        }
        catch (Throwable throwable) {
            try {
                if (longBuf != null) {
                    try {
                        longBuf.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                Logger.error("MethodMetricsCalculator.calMetrics(" + recorder + ", " + methodTag + ", " + startTime + ", " + stopTime + ")", e);
                return MethodMetrics.getInstance(methodTag, recorder.getMethodTagId(), startTime, stopTime);
            }
        }
    }

    private static MethodMetrics calMetrics(Recorder rec, MethodTag methodTag, long startTime, long stopTime, LongBuf sortedRecords, long totalCount, int diffCount) {
        MethodMetrics result = MethodMetrics.getInstance(methodTag, rec.getMethodTagId(), startTime, stopTime);
        if (diffCount <= 0) {
            return result;
        }
        long[] buf = sortedRecords._buf();
        result.setTotalCount(totalCount);
        result.setMinTime(NumUtils.parseKey(buf[0]));
        result.setMaxTime(NumUtils.parseKey(buf[sortedRecords.writerIndex() - 1]));
        long[] tpIndexArr = MethodMetricsCalculator.getTpIndexArr(totalCount);
        int tpIndexArrLen = tpIndexArr.length;
        int[] tpArr = result.getTpArr();
        int tpIndex = 0;
        double sigma = 0.0;
        long countMile = 0L;
        long totalTime = 0L;
        int i = 0;
        int writerIdx = sortedRecords.writerIndex();
        while (i < writerIdx) {
            long kvLong = buf[i++];
            int timeCost = NumUtils.parseKey(kvLong);
            int count = NumUtils.parseValue(kvLong);
            totalTime += (long)timeCost * (long)count;
            countMile += (long)count;
            while (tpIndex < tpIndexArrLen && countMile >= tpIndexArr[tpIndex]) {
                tpArr[tpIndex++] = timeCost;
            }
            sigma += (double)count * Math.pow(timeCost, 2.0);
        }
        double avgTime = (double)totalTime / (double)totalCount;
        result.setAvgTime(avgTime);
        result.setStdDev(Math.sqrt(sigma / (double)totalCount - Math.pow(avgTime, 2.0)));
        result.setTotalTime(totalTime);
        result.setTotalTimePercent((double)totalTime / (double)(stopTime - startTime));
        return MethodMetricsCalculator.reviseStatistic(result);
    }

    private static MethodMetrics reviseStatistic(MethodMetrics metrics) {
        int[] tpArr = metrics.getTpArr();
        int len = tpArr.length;
        for (int i = 1; i < len; ++i) {
            int last = tpArr[i - 1];
            int cur = tpArr[i];
            if (cur > -1) continue;
            tpArr[i] = last;
        }
        return metrics;
    }

    private static long[] getTpIndexArr(long totalCount) {
        long[] result = LONG_ARR_TL.get();
        double[] percentiles = MethodMetrics.getPercentiles();
        int len = percentiles.length;
        for (int i = 0; i < len; ++i) {
            result[i] = MethodMetricsCalculator.getIndex(totalCount, percentiles[i]);
        }
        return result;
    }

    private static long getIndex(long totalCount, double percentile) {
        return (long)Math.ceil((double)totalCount * percentile);
    }

    private MethodMetricsCalculator() {
    }
}

