/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.core;

import cn.myperf4j.base.MethodTag;
import cn.myperf4j.base.config.ProfilingConfig;
import cn.myperf4j.base.metric.MethodMetrics;
import cn.myperf4j.base.util.Logger;
import cn.myperf4j.core.MethodMetricsInfo;
import cn.myperf4j.core.MethodTagMaintainer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class MethodMetricsHistogram {
    private static final ConcurrentMap<Integer, MethodMetricsInfo> METHOD_MAP = new ConcurrentHashMap<Integer, MethodMetricsInfo>(8192);

    private MethodMetricsHistogram() {
    }

    public static void recordMetrics(MethodMetrics metrics) {
        MethodMetricsHistogram.recordMetrics0(metrics.getMethodTagId(), metrics.getTP95(), metrics.getTP99(), metrics.getTP999(), metrics.getTP9999());
    }

    public static void recordNoneMetrics(int methodTagId) {
        MethodMetricsHistogram.recordMetrics0(methodTagId, -1, -1, -1, -1);
    }

    private static void recordMetrics0(int methodTagId, int tp95, int tp99, int tp999, int tp9999) {
        MethodMetricsInfo methodMetricsInfo = (MethodMetricsInfo)METHOD_MAP.get(methodTagId);
        if (methodMetricsInfo != null) {
            methodMetricsInfo.add(tp95, tp99, tp999, tp9999);
            return;
        }
        METHOD_MAP.put(methodTagId, new MethodMetricsInfo(tp95, tp99, tp999, tp9999));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void buildSysGenProfilingFile() {
        long startMills = System.currentTimeMillis();
        String filePath = ProfilingConfig.basicConfig().sysProfilingParamsFile();
        String tempFilePath = filePath + "_tmp";
        File tempFile = new File(tempFilePath);
        try (BufferedWriter fileWriter = new BufferedWriter(new FileWriter(tempFile, false), 8192);){
            File destFile;
            fileWriter.write("#This is a file automatically generated by MyPerf4J, please do not edit!\n");
            ArrayList<Integer> neverInvokedMethods = new ArrayList<Integer>(128);
            MethodTagMaintainer tagMaintainer = MethodTagMaintainer.getInstance();
            for (Map.Entry entry : METHOD_MAP.entrySet()) {
                Integer methodId = (Integer)entry.getKey();
                MethodMetricsInfo info = (MethodMetricsInfo)entry.getValue();
                if (info.getCount() <= 0) {
                    neverInvokedMethods.add(methodId);
                    continue;
                }
                int mostTimeThreshold = MethodMetricsHistogram.calMostTimeThreshold(info);
                MethodMetricsHistogram.writeProfilingInfo(tagMaintainer, fileWriter, methodId, mostTimeThreshold);
            }
            fileWriter.flush();
            if (!neverInvokedMethods.isEmpty()) {
                fileWriter.write("#The following methods have never been invoked!\n");
                for (Integer methodId : neverInvokedMethods) {
                    MethodMetricsHistogram.writeProfilingInfo(tagMaintainer, fileWriter, methodId, 128);
                }
                fileWriter.flush();
            }
            boolean rename = tempFile.renameTo(destFile = new File(filePath)) && destFile.setReadOnly();
            Logger.debug("MethodMetricsHistogram.buildSysGenProfilingFile(): rename " + tempFile.getName() + " to " + destFile.getName() + " " + (rename ? "success" : "fail"));
        }
        catch (Exception e) {
            Logger.error("MethodMetricsHistogram.buildSysGenProfilingFile()", e);
        }
        finally {
            Logger.debug("MethodMetricsHistogram.buildSysGenProfilingFile() finished, cost=" + (System.currentTimeMillis() - startMills) + "ms");
        }
    }

    private static void writeProfilingInfo(MethodTagMaintainer tagMaintainer, BufferedWriter fileWriter, Integer methodId, int mostTimeThreshold) throws IOException {
        MethodTag methodTag = tagMaintainer.getMethodTag(methodId);
        if (methodTag == null) {
            Logger.warn("MethodMetricsHistogram.writeProfilingInfo(): methodId=" + methodId + ", methodTag is null");
            return;
        }
        fileWriter.write(methodTag.getFullDesc());
        fileWriter.write(61);
        fileWriter.write(mostTimeThreshold + ":" + MethodMetricsHistogram.calOutThresholdCount(mostTimeThreshold));
        fileWriter.newLine();
    }

    private static int calMostTimeThreshold(MethodMetricsInfo info) {
        int count = info.getCount();
        long tp9999Avg = info.getTp9999Sum() / (long)count;
        if (tp9999Avg <= 64L) {
            return 64;
        }
        if (tp9999Avg <= 128L) {
            return 128;
        }
        if (tp9999Avg <= 256L) {
            return 256;
        }
        long tp999Avg = info.getTp999Sum() / (long)count;
        if (tp999Avg <= 128L) {
            return 128;
        }
        if (tp999Avg <= 256L) {
            return 256;
        }
        if (tp999Avg <= 512L) {
            return 512;
        }
        long tp99Avg = info.getTp99Sum() / (long)count;
        if (tp99Avg <= 256L) {
            return 256;
        }
        if (tp99Avg <= 512L) {
            return 512;
        }
        if (tp99Avg <= 1024L) {
            return 1024;
        }
        long tp95Avg = info.getTp95Sum() / (long)count;
        if (tp95Avg <= 512L) {
            return 512;
        }
        if (tp95Avg <= 1024L) {
            return 1024;
        }
        if (tp95Avg <= 1536L) {
            return 1536;
        }
        return 2048;
    }

    private static int calOutThresholdCount(int mostTimeThreshold) {
        if (mostTimeThreshold <= 256) {
            return 64;
        }
        if (mostTimeThreshold <= 512) {
            return 128;
        }
        if (mostTimeThreshold <= 1024) {
            return 256;
        }
        if (mostTimeThreshold <= 1536) {
            return 512;
        }
        return 1024;
    }
}

