/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.core.recorder;

import cn.myperf4j.base.buffer.LongBuf;
import cn.myperf4j.base.util.concurrent.AtomicIntArray;
import cn.myperf4j.base.util.concurrent.AtomicIntHashCounter;
import cn.myperf4j.base.util.concurrent.IntHashCounter;
import cn.myperf4j.core.recorder.Recorder;
import java.util.concurrent.atomic.AtomicInteger;

public final class AccurateRecorder
extends Recorder {
    private final int mostTimeThreshold;
    private final AtomicIntArray timingArr;
    private final IntHashCounter timingHashCounter;
    private final AtomicInteger diffCount;

    private AccurateRecorder(int methodTagId, int mostTimeThreshold, int outThresholdCount) {
        super(methodTagId);
        this.mostTimeThreshold = mostTimeThreshold;
        this.timingArr = new AtomicIntArray(mostTimeThreshold);
        this.timingHashCounter = new AtomicIntHashCounter(outThresholdCount);
        this.diffCount = new AtomicInteger(0);
    }

    @Override
    public void recordTime(long startNanoTime, long endNanoTime) {
        if (startNanoTime > endNanoTime) {
            return;
        }
        int elapsedTime = (int)((endNanoTime - startNanoTime) / 1000000L);
        if (elapsedTime < this.mostTimeThreshold) {
            if (this.timingArr.getAndIncrement(elapsedTime) <= 0) {
                this.diffCount.incrementAndGet();
            }
        } else if (this.timingHashCounter.getAndIncrement(elapsedTime) <= 0) {
            this.diffCount.incrementAndGet();
        }
    }

    @Override
    public long fillSortedRecords(LongBuf longBuf) {
        return this.timingArr.fillSortedKvs(longBuf) + this.timingHashCounter.fillSortedKvs(longBuf);
    }

    @Override
    public int getDiffCount() {
        return this.diffCount.get();
    }

    @Override
    public void resetRecord() {
        if (this.hasRecord()) {
            this.timingArr.reset();
            this.timingHashCounter.reset();
            this.diffCount.set(0);
        }
    }

    @Override
    public boolean hasRecord() {
        return this.diffCount.get() > 0;
    }

    public static AccurateRecorder getInstance(int methodTagId, int mostTimeThreshold, int outThresholdCount) {
        return new AccurateRecorder(methodTagId, mostTimeThreshold, outThresholdCount);
    }
}

