/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.core.recorder;

import cn.myperf4j.base.buffer.LongBuf;
import cn.myperf4j.base.util.concurrent.AtomicIntArray;
import cn.myperf4j.core.recorder.Recorder;
import java.util.concurrent.atomic.AtomicInteger;

public final class RoughRecorder
extends Recorder {
    private final AtomicIntArray timingArr;
    private final AtomicInteger diffCount;

    public RoughRecorder(int methodTag, int mostTimeThreshold) {
        super(methodTag);
        this.timingArr = new AtomicIntArray(mostTimeThreshold + 2);
        this.diffCount = new AtomicInteger(0);
    }

    @Override
    public void recordTime(long startNanoTime, long endNanoTime) {
        if (startNanoTime > endNanoTime) {
            return;
        }
        int elapsedTime = (int)((endNanoTime - startNanoTime) / 1000000L);
        AtomicIntArray timingArr = this.timingArr;
        int oldValue = elapsedTime < timingArr.length() - 1 ? timingArr.getAndIncrement(elapsedTime) : timingArr.getAndIncrement(timingArr.length() - 1);
        if (oldValue <= 0) {
            this.diffCount.incrementAndGet();
        }
    }

    @Override
    public long fillSortedRecords(LongBuf longBuf) {
        return this.timingArr.fillSortedKvs(longBuf);
    }

    @Override
    public int getDiffCount() {
        return this.diffCount.get();
    }

    @Override
    public void resetRecord() {
        if (!this.hasRecord()) {
            return;
        }
        this.timingArr.reset();
        this.diffCount.set(0);
    }

    @Override
    public boolean hasRecord() {
        return this.diffCount.get() > 0;
    }

    public static RoughRecorder getInstance(int methodTagId, int mostTimeThreshold) {
        return new RoughRecorder(methodTagId, mostTimeThreshold);
    }
}

