# Super-admin / site-wide permissions

Models providing site-wide (or superuser) permissions for all resources of a specific type

---

## Schema

```zed
definition platform {
    relation administrator: user
    permission super_admin = administrator
}

definition organization {
    // The platform is generally a singleton pointing to the same
    // platform object, on which the superuser is in turn granted
    // access.
    relation platform: platform
    permission admin = platform->super_admin
}

definition resource {
    relation owner: user | organization
    permission admin = owner + owner->admin
}

definition user {}
```
