<?php

class AdminController extends AuthorizedController
{
    /**
     * Initializer.
     *
     * @return void
     */

    public function __construct()
    {
    	// These have been moved into the routes for more granular control
        // Apply the admin auth filter
        //$this->beforeFilter('admin-auth', array('except' => $this->whitelist));

        // CSRF Protection
        $this->beforeFilter('csrf', array('on' => 'post'));
    }



    /**
     * Encodes the permissions so that they are form friendly.
     *
     * @param  array  $permissions
     * @param  bool   $removeSuperUser
     * @return void
     */
    protected function encodeAllPermissions(array &$allPermissions, $removeSuperUser = false)
    {
        foreach ($allPermissions as $area => &$permissions) {
            foreach ($permissions as $index => &$permission) {
                if ($removeSuperUser == true and $permission['permission'] == 'superuser') {
                    unset($permissions[$index]);
                    continue;
                }

                $permission['can_inherit'] = ($permission['permission'] != 'superuser');
                $permission['permission']  = base64_encode($permission['permission']);
            }

            // If we removed a super user permission and there are
            // none left, let's remove the group
            if ($removeSuperUser == true and empty($permissions)) {
                unset($allPermissions[$area]);
            }
        }
    }

    /**
     * Encodes user permissions to match that of the encoded "all"
     * permissions above.
     *
     * @param  array  $permissions
     * @return void
     */
    protected function encodePermissions(array &$permissions)
    {
        $encodedPermissions = array();

        foreach ($permissions as $permission => $access) {
            $encodedPermissions[base64_encode($permission)] = $access;
        }

        $permissions = $encodedPermissions;
    }

    /**
     * Decodes user permissions to match that of the encoded "all"
     * permissions above.
     *
     * @param  array  $permissions
     * @return void
     */
    protected function decodePermissions(array &$permissions)
    {
        $decodedPermissions = array();

        foreach ($permissions as $permission => $access) {
            $decodedPermissions[base64_decode($permission)] = $access;
        }

        $permissions = $decodedPermissions;
    }

}
