<?php

    use Illuminate\Database\Migrations\Migration;
    use Illuminate\Database\Schema\Blueprint;
    use Illuminate\Support\Facades\Lang;

    class CreateAssetMaintenancesTable extends Migration
    {

        /**
         * Run the migrations.
         *
         * @return void
         */
        public function up()
        {

            Schema::create( 'asset_maintenances', function ( Blueprint $table ) {

                $table->increments( 'id' );
                $table->integer( 'asset_id' )
                      ->unsigned();
                $table->integer( 'supplier_id' )
                      ->unsigned();
                $table->enum( 'asset_maintenance_type', $this->getEnumFields() );
                $table->string( 'title', 100 );
                $table->boolean( 'is_warranty' );
                $table->date( 'start_date' );
                $table->date( 'completion_date' )
                      ->nullable();
                $table->integer( 'asset_maintenance_time' )
                      ->nullable();
                $table->longText( 'notes' )
                      ->nullable();
                $table->decimal( 'cost', 10, 2 )
                      ->nullable();
                $table->dateTime( 'deleted_at' )
                      ->nullable();
                $table->timestamps();
            } );
        }

        protected function getEnumFields()
        {

            return [
                Lang::get( 'admin/asset_maintenances/general.maintenance' ),
                Lang::get( 'admin/asset_maintenances/general.repair' ),
                Lang::get( 'admin/asset_maintenances/general.upgrade' )
            ];
        }

        /**
         * Reverse the migrations.
         *
         * @return void
         */
        public function down()
        {

            Schema::dropIfExists( 'asset_maintenances' );

        }

}
