--[[--------------------------------------------------------------------
    Copyright (C) 2014 Johnny C. Lam.
    See the file LICENSE.txt for copying permission.
--]]--------------------------------------------------------------------

local OVALE, Ovale = ...

local rawset = rawset
local setmetatable = setmetatable
local tostring = tostring

local L = nil
do
	-- Default value is the key itself.
	local MT = {
		__index = function(self, key)
			local value = tostring(key)
			rawset(self, key, value)
			return value
		end,
	}
	L = setmetatable({}, MT)
	Ovale.L = L
end

-- THE REST OF THIS FILE IS AUTOMATICALLY GENERATED.
-- ANY CHANGES MADE BELOW THIS POINT WILL BE LOST.
-- UPDATE TRANSLATIONS AT:
--     http://wow.curseforge.com/addons/ovale/localization

local locale = GetLocale()

if locale == "deDE" then
--@localization(locale="deDE", format="lua_additive_table", handle-subnamespaces="concat", handle-unlocalized="blank")@
elseif locale == "enUS" then
--@localization(locale="enUS", format="lua_additive_table", handle-subnamespaces="concat", handle-unlocalized="blank")@
elseif locale == "esES" then
--@localization(locale="esES", format="lua_additive_table", handle-subnamespaces="concat", handle-unlocalized="blank")@
elseif locale == "esMX" then
--@localization(locale="esMX", format="lua_additive_table", handle-subnamespaces="concat", handle-unlocalized="blank")@
elseif locale == "frFR" then
--@localization(locale="frFR", format="lua_additive_table", handle-subnamespaces="concat", handle-unlocalized="blank")@
elseif locale == "itIT" then
--@localization(locale="itIT", format="lua_additive_table", handle-subnamespaces="concat", handle-unlocalized="blank")@
elseif locale == "koKR" then
--@localization(locale="koKR", format="lua_additive_table", handle-subnamespaces="concat", handle-unlocalized="blank")@
elseif locale == "ptBR" then
--@localization(locale="ptBR", format="lua_additive_table", handle-subnamespaces="concat", handle-unlocalized="blank")@
elseif locale == "ruRU" then
--@localization(locale="ruRU", format="lua_additive_table", handle-subnamespaces="concat", handle-unlocalized="blank")@
elseif locale == "zhCN" then
--@localization(locale="zhCN", format="lua_additive_table", handle-subnamespaces="concat", handle-unlocalized="blank")@
elseif locale == "zhTW" then
--@localization(locale="zhTW", format="lua_additive_table", handle-subnamespaces="concat", handle-unlocalized="blank")@
end
