local OVALE, Ovale = ...
local OvaleScripts = Ovale.OvaleScripts

do
	local name = "icyveins_deathknight_blood"
	local desc = "[7.0] Icy-Veins: DeathKnight Blood"
	local code = [[

Include(ovale_common)
Include(ovale_trinkets_mop)
Include(ovale_trinkets_wod)
Include(ovale_deathknight_spells)

AddCheckBox(opt_interrupt L(interrupt) default specialization=blood)
AddCheckBox(opt_melee_range L(not_in_melee_range) specialization=blood)
AddCheckBox(opt_legendary_ring_tank ItemName(legendary_ring_bonus_armor) default specialization=blood)

AddFunction BloodDefaultShortCDActions
{
	if CheckBoxOn(opt_melee_range) and not target.InRange(death_strike) Texture(misc_arrowlup help=L(not_in_melee_range))
	if not BuffPresent(rune_tap_buff) Spell(rune_tap)
	if Rune() <= 2 Spell(blood_tap)
}

AddFunction BloodDefaultMainActions
{
	BloodHealMe()
	if InCombat() and BuffExpires(bone_shield_buff 3) Spell(marrowrend)
	if not Talent(soulgorge_talent) and target.DebuffRefreshable(blood_plague_debuff) Spell(blood_boil)
	if target.DebuffRefreshable(blood_plague_debuff) Spell(deaths_caress)
	if not BuffPresent(death_and_decay_buff) and BuffPresent(crimson_scourge_buff) and Talent(rapid_decomposition_talent) Spell(death_and_decay)
	if RunicPower() >= 100 and target.TimeToDie() >= 10 Spell(bonestorm)
	if RunicPowerDeficit() <= 20 Spell(death_strike)
	if BuffStacks(bone_shield_buff) <= 2+4*Talent(ossuary_talent) Spell(marrowrend)
	if not BuffPresent(death_and_decay_buff) and Rune() >= 3 and Talent(rapid_decomposition_talent) Spell(death_and_decay)
	if not target.DebuffPresent(mark_of_blood_debuff) Spell(mark_of_blood)
	if Rune() >= 3 or RunicPower() < 45 Spell(heart_strike)
	Spell(consumption)
	Spell(blood_boil)
}

AddFunction BloodDefaultAoEActions
{
	BloodHealMe()
	if RunicPower() >= 100 Spell(bonestorm)
	if InCombat() and BuffExpires(bone_shield_buff 3) Spell(marrowrend)
	if not Talent(soulgorge_talent) and DebuffCountOnAny(blood_plague_debuff) < Enemies(tagged=1) Spell(blood_boil)
	if not BuffPresent(death_and_decay_buff) and BuffPresent(crimson_scourge_buff) Spell(death_and_decay)
	if RunicPowerDeficit() <= 20 Spell(death_strike)
	if BuffStacks(bone_shield_buff) <= 2+4*Talent(ossuary_talent) Spell(marrowrend)
	if not BuffPresent(death_and_decay_buff) and Enemies() >= 3 Spell(death_and_decay)
	if not target.DebuffPresent(mark_of_blood_debuff) Spell(mark_of_blood)
	if Rune() >= 3 or RunicPower() < 45 Spell(heart_strike)
	Spell(consumption)
	Spell(blood_boil)
	if target.DebuffRefreshable(blood_plague_debuff) Spell(deaths_caress)
}

AddFunction BloodHealMe
{
	if HealthPercent() <= 70 Spell(death_strike)
	if (DamageTaken(5) * 0.2) > (Health() / 100 * 25) Spell(death_strike)
	if (BuffStacks(bone_shield_buff) * 3) > (100 - HealthPercent()) Spell(tombstone)
	if HealthPercent() <= 70 Spell(consumption)
}

AddFunction BloodDefaultCdActions
{
	BloodInterruptActions()
	if IncomingDamage(1.5 magic=1) > 0 spell(antimagic_shell)
	if CheckBoxOn(opt_legendary_ring_tank) Item(legendary_ring_bonus_armor usable=1)
	Spell(vampiric_blood)
	if target.InRange(blood_mirror) Spell(blood_mirror)
	Spell(dancing_rune_weapon)
	if BuffStacks(bone_shield_buff) >= 5 Spell(tombstone)
	Item(unbending_potion usable=1)
}

AddFunction BloodInterruptActions
{
	if CheckBoxOn(opt_interrupt) and not target.IsFriend() and target.IsInterruptible()
	{
		if target.InRange(mind_freeze) Spell(mind_freeze)
		if not target.Classification(worldboss)
		{
			if target.InRange(asphyxiate) Spell(asphyxiate)
			Spell(arcane_torrent_runicpower)
			if target.InRange(quaking_palm) Spell(quaking_palm)
			Spell(war_stomp)
		}
	}
}

AddCheckBox(opt_deathknight_blood_aoe L(AOE) default specialization=blood)

AddIcon help=shortcd specialization=blood
{
	BloodDefaultShortCDActions()
}

AddIcon enemies=1 help=main specialization=blood
{
	BloodDefaultMainActions()
}

AddIcon checkbox=opt_deathknight_blood_aoe help=aoe specialization=blood
{
	BloodDefaultAoEActions()
}

AddIcon help=cd specialization=blood
{
	#if not InCombat() ProtectionPrecombatCdActions()
	BloodDefaultCdActions()
}
]]
	OvaleScripts:RegisterScript("DEATHKNIGHT", "blood", name, desc, code, "script")
end

-- THE REST OF THIS FILE IS AUTOMATICALLY GENERATED.
-- ANY CHANGES MADE BELOW THIS POINT WILL BE LOST.

do
	local name = "simulationcraft_death_knight_frost_t19p"
	local desc = "[7.0] SimulationCraft: Death_Knight_Frost_T19P"
	local code = [[
# Based on SimulationCraft profile "Death_Knight_Frost_T19P".
#	class=deathknight
#	spec=frost
#	talents=2230021

Include(ovale_common)
Include(ovale_trinkets_mop)
Include(ovale_trinkets_wod)
Include(ovale_deathknight_spells)

AddCheckBox(opt_interrupt L(interrupt) default specialization=frost)
AddCheckBox(opt_melee_range L(not_in_melee_range) specialization=frost)
AddCheckBox(opt_legendary_ring_strength ItemName(legendary_ring_strength) default specialization=frost)

AddFunction FrostUseItemActions
{
	Item(Trinket0Slot usable=1)
	Item(Trinket1Slot usable=1)
}

AddFunction FrostGetInMeleeRange
{
	if CheckBoxOn(opt_melee_range) and not target.InRange(death_strike) Texture(misc_arrowlup help=L(not_in_melee_range))
}

AddFunction FrostInterruptActions
{
	if CheckBoxOn(opt_interrupt) and not target.IsFriend() and target.IsInterruptible()
	{
		if target.InRange(mind_freeze) Spell(mind_freeze)
		if not target.Classification(worldboss)
		{
			if target.InRange(asphyxiate) Spell(asphyxiate)
			if target.InRange(strangulate) Spell(strangulate)
			Spell(arcane_torrent_runicpower)
			if target.InRange(quaking_palm) Spell(quaking_palm)
			Spell(war_stomp)
		}
	}
}

### actions.default

AddFunction FrostDefaultMainActions
{
	#call_action_list,name=generic,if=!talent.breath_of_sindragosa.enabled&!(talent.gathering_storm.enabled&buff.remorseless_winter.remains)
	if not Talent(breath_of_sindragosa_talent) and not { Talent(gathering_storm_talent) and BuffPresent(remorseless_winter_buff) } FrostGenericMainActions()

	unless not Talent(breath_of_sindragosa_talent) and not { Talent(gathering_storm_talent) and BuffPresent(remorseless_winter_buff) } and FrostGenericMainPostConditions()
	{
		#call_action_list,name=bos,if=talent.breath_of_sindragosa.enabled&!dot.breath_of_sindragosa.ticking
		if Talent(breath_of_sindragosa_talent) and not BuffPresent(breath_of_sindragosa_buff) FrostBosMainActions()

		unless Talent(breath_of_sindragosa_talent) and not BuffPresent(breath_of_sindragosa_buff) and FrostBosMainPostConditions()
		{
			#call_action_list,name=bos_ticking,if=talent.breath_of_sindragosa.enabled&dot.breath_of_sindragosa.ticking
			if Talent(breath_of_sindragosa_talent) and BuffPresent(breath_of_sindragosa_buff) FrostBosTickingMainActions()

			unless Talent(breath_of_sindragosa_talent) and BuffPresent(breath_of_sindragosa_buff) and FrostBosTickingMainPostConditions()
			{
				#call_action_list,name=gs_ticking,if=talent.gathering_storm.enabled&buff.remorseless_winter.remains&!talent.breath_of_sindragosa.enabled
				if Talent(gathering_storm_talent) and BuffPresent(remorseless_winter_buff) and not Talent(breath_of_sindragosa_talent) FrostGsTickingMainActions()
			}
		}
	}
}

AddFunction FrostDefaultMainPostConditions
{
	not Talent(breath_of_sindragosa_talent) and not { Talent(gathering_storm_talent) and BuffPresent(remorseless_winter_buff) } and FrostGenericMainPostConditions() or Talent(breath_of_sindragosa_talent) and not BuffPresent(breath_of_sindragosa_buff) and FrostBosMainPostConditions() or Talent(breath_of_sindragosa_talent) and BuffPresent(breath_of_sindragosa_buff) and FrostBosTickingMainPostConditions() or Talent(gathering_storm_talent) and BuffPresent(remorseless_winter_buff) and not Talent(breath_of_sindragosa_talent) and FrostGsTickingMainPostConditions()
}

AddFunction FrostDefaultShortCdActions
{
	#auto_attack
	FrostGetInMeleeRange()
	#pillar_of_frost
	Spell(pillar_of_frost)
	#obliteration,if=(!talent.frozen_pulse.enabled|(rune<2&runic_power<28))&!talent.gathering_storm.enabled
	if { not Talent(frozen_pulse_talent) or Rune() < 2 and RunicPower() < 28 } and not Talent(gathering_storm_talent) Spell(obliteration)
	#call_action_list,name=generic,if=!talent.breath_of_sindragosa.enabled&!(talent.gathering_storm.enabled&buff.remorseless_winter.remains)
	if not Talent(breath_of_sindragosa_talent) and not { Talent(gathering_storm_talent) and BuffPresent(remorseless_winter_buff) } FrostGenericShortCdActions()

	unless not Talent(breath_of_sindragosa_talent) and not { Talent(gathering_storm_talent) and BuffPresent(remorseless_winter_buff) } and FrostGenericShortCdPostConditions()
	{
		#call_action_list,name=bos,if=talent.breath_of_sindragosa.enabled&!dot.breath_of_sindragosa.ticking
		if Talent(breath_of_sindragosa_talent) and not BuffPresent(breath_of_sindragosa_buff) FrostBosShortCdActions()

		unless Talent(breath_of_sindragosa_talent) and not BuffPresent(breath_of_sindragosa_buff) and FrostBosShortCdPostConditions()
		{
			#call_action_list,name=bos_ticking,if=talent.breath_of_sindragosa.enabled&dot.breath_of_sindragosa.ticking
			if Talent(breath_of_sindragosa_talent) and BuffPresent(breath_of_sindragosa_buff) FrostBosTickingShortCdActions()

			unless Talent(breath_of_sindragosa_talent) and BuffPresent(breath_of_sindragosa_buff) and FrostBosTickingShortCdPostConditions()
			{
				#call_action_list,name=gs_ticking,if=talent.gathering_storm.enabled&buff.remorseless_winter.remains&!talent.breath_of_sindragosa.enabled
				if Talent(gathering_storm_talent) and BuffPresent(remorseless_winter_buff) and not Talent(breath_of_sindragosa_talent) FrostGsTickingShortCdActions()
			}
		}
	}
}

AddFunction FrostDefaultShortCdPostConditions
{
	not Talent(breath_of_sindragosa_talent) and not { Talent(gathering_storm_talent) and BuffPresent(remorseless_winter_buff) } and FrostGenericShortCdPostConditions() or Talent(breath_of_sindragosa_talent) and not BuffPresent(breath_of_sindragosa_buff) and FrostBosShortCdPostConditions() or Talent(breath_of_sindragosa_talent) and BuffPresent(breath_of_sindragosa_buff) and FrostBosTickingShortCdPostConditions() or Talent(gathering_storm_talent) and BuffPresent(remorseless_winter_buff) and not Talent(breath_of_sindragosa_talent) and FrostGsTickingShortCdPostConditions()
}

AddFunction FrostDefaultCdActions
{
	#mind_freeze
	FrostInterruptActions()
	#arcane_torrent,if=runic_power.deficit>20
	if RunicPowerDeficit() > 20 Spell(arcane_torrent_runicpower)
	#blood_fury,if=buff.pillar_of_frost.up
	if BuffPresent(pillar_of_frost_buff) Spell(blood_fury_ap)
	#berserking,if=buff.pillar_of_frost.up
	if BuffPresent(pillar_of_frost_buff) Spell(berserking)
	#use_item,slot=finger2
	if CheckBoxOn(opt_legendary_ring_strength) Item(legendary_ring_strength usable=1)
	#use_item,slot=trinket1
	FrostUseItemActions()
	#potion,name=old_war,if=buff.pillar_of_frost.up
	#sindragosas_fury,if=buff.pillar_of_frost.up&(buff.unholy_strength.up|(buff.pillar_of_frost.remains<3&target.time_to_die<60))&debuff.razorice.stack==5&!buff.obliteration.up
	if BuffPresent(pillar_of_frost_buff) and { BuffPresent(unholy_strength_buff) or BuffRemaining(pillar_of_frost_buff) < 3 and target.TimeToDie() < 60 } and target.DebuffStacks(razorice_debuff) == 5 and not BuffPresent(obliteration_buff) Spell(sindragosas_fury)

	unless { not Talent(frozen_pulse_talent) or Rune() < 2 and RunicPower() < 28 } and not Talent(gathering_storm_talent) and Spell(obliteration)
	{
		#call_action_list,name=generic,if=!talent.breath_of_sindragosa.enabled&!(talent.gathering_storm.enabled&buff.remorseless_winter.remains)
		if not Talent(breath_of_sindragosa_talent) and not { Talent(gathering_storm_talent) and BuffPresent(remorseless_winter_buff) } FrostGenericCdActions()

		unless not Talent(breath_of_sindragosa_talent) and not { Talent(gathering_storm_talent) and BuffPresent(remorseless_winter_buff) } and FrostGenericCdPostConditions()
		{
			#call_action_list,name=bos,if=talent.breath_of_sindragosa.enabled&!dot.breath_of_sindragosa.ticking
			if Talent(breath_of_sindragosa_talent) and not BuffPresent(breath_of_sindragosa_buff) FrostBosCdActions()

			unless Talent(breath_of_sindragosa_talent) and not BuffPresent(breath_of_sindragosa_buff) and FrostBosCdPostConditions()
			{
				#call_action_list,name=bos_ticking,if=talent.breath_of_sindragosa.enabled&dot.breath_of_sindragosa.ticking
				if Talent(breath_of_sindragosa_talent) and BuffPresent(breath_of_sindragosa_buff) FrostBosTickingCdActions()

				unless Talent(breath_of_sindragosa_talent) and BuffPresent(breath_of_sindragosa_buff) and FrostBosTickingCdPostConditions()
				{
					#call_action_list,name=gs_ticking,if=talent.gathering_storm.enabled&buff.remorseless_winter.remains&!talent.breath_of_sindragosa.enabled
					if Talent(gathering_storm_talent) and BuffPresent(remorseless_winter_buff) and not Talent(breath_of_sindragosa_talent) FrostGsTickingCdActions()
				}
			}
		}
	}
}

AddFunction FrostDefaultCdPostConditions
{
	{ not Talent(frozen_pulse_talent) or Rune() < 2 and RunicPower() < 28 } and not Talent(gathering_storm_talent) and Spell(obliteration) or not Talent(breath_of_sindragosa_talent) and not { Talent(gathering_storm_talent) and BuffPresent(remorseless_winter_buff) } and FrostGenericCdPostConditions() or Talent(breath_of_sindragosa_talent) and not BuffPresent(breath_of_sindragosa_buff) and FrostBosCdPostConditions() or Talent(breath_of_sindragosa_talent) and BuffPresent(breath_of_sindragosa_buff) and FrostBosTickingCdPostConditions() or Talent(gathering_storm_talent) and BuffPresent(remorseless_winter_buff) and not Talent(breath_of_sindragosa_talent) and FrostGsTickingCdPostConditions()
}

### actions.bos

AddFunction FrostBosMainActions
{
	#frost_strike,if=talent.icy_talons.enabled&buff.icy_talons.remains<1.5&cooldown.breath_of_sindragosa.remains>6
	if Talent(icy_talons_talent) and BuffRemaining(icy_talons_buff) < 1.5 and SpellCooldown(breath_of_sindragosa) > 6 Spell(frost_strike)
	#remorseless_winter,if=talent.gathering_storm.enabled
	if Talent(gathering_storm_talent) Spell(remorseless_winter)
	#howling_blast,target_if=!dot.frost_fever.ticking
	if not target.DebuffPresent(frost_fever_debuff) Spell(howling_blast)
	#frost_strike,if=runic_power>=90&set_bonus.tier19_4pc
	if RunicPower() >= 90 and ArmorSetBonus(T19 4) Spell(frost_strike)
	#remorseless_winter,if=buff.rime.react&equipped.132459
	if BuffPresent(rime_buff) and HasEquippedItem(132459) Spell(remorseless_winter)
	#howling_blast,if=buff.rime.react&(dot.remorseless_winter.ticking|cooldown.remorseless_winter.remains>1.5|!equipped.132459)
	if BuffPresent(rime_buff) and { target.DebuffPresent(remorseless_winter_debuff) or SpellCooldown(remorseless_winter) > 1.5 or not HasEquippedItem(132459) } Spell(howling_blast)
	#frost_strike,if=runic_power>=70
	if RunicPower() >= 70 Spell(frost_strike)
	#obliterate,if=!buff.rime.react
	if not BuffPresent(rime_buff) Spell(obliterate)
	#frost_strike,if=cooldown.breath_of_sindragosa.remains>15
	if SpellCooldown(breath_of_sindragosa) > 15 Spell(frost_strike)
	#remorseless_winter,if=cooldown.breath_of_sindragosa.remains>10
	if SpellCooldown(breath_of_sindragosa) > 10 Spell(remorseless_winter)
}

AddFunction FrostBosMainPostConditions
{
}

AddFunction FrostBosShortCdActions
{
	unless Talent(icy_talons_talent) and BuffRemaining(icy_talons_buff) < 1.5 and SpellCooldown(breath_of_sindragosa) > 6 and Spell(frost_strike) or Talent(gathering_storm_talent) and Spell(remorseless_winter) or not target.DebuffPresent(frost_fever_debuff) and Spell(howling_blast) or RunicPower() >= 90 and ArmorSetBonus(T19 4) and Spell(frost_strike) or BuffPresent(rime_buff) and HasEquippedItem(132459) and Spell(remorseless_winter) or BuffPresent(rime_buff) and { target.DebuffPresent(remorseless_winter_debuff) or SpellCooldown(remorseless_winter) > 1.5 or not HasEquippedItem(132459) } and Spell(howling_blast) or RunicPower() >= 70 and Spell(frost_strike) or not BuffPresent(rime_buff) and Spell(obliterate)
	{
		#horn_of_winter,if=cooldown.breath_of_sindragosa.remains>15&runic_power<=70
		if SpellCooldown(breath_of_sindragosa) > 15 and RunicPower() <= 70 and BuffExpires(attack_power_multiplier_buff any=1) Spell(horn_of_winter)
	}
}

AddFunction FrostBosShortCdPostConditions
{
	Talent(icy_talons_talent) and BuffRemaining(icy_talons_buff) < 1.5 and SpellCooldown(breath_of_sindragosa) > 6 and Spell(frost_strike) or Talent(gathering_storm_talent) and Spell(remorseless_winter) or not target.DebuffPresent(frost_fever_debuff) and Spell(howling_blast) or RunicPower() >= 90 and ArmorSetBonus(T19 4) and Spell(frost_strike) or BuffPresent(rime_buff) and HasEquippedItem(132459) and Spell(remorseless_winter) or BuffPresent(rime_buff) and { target.DebuffPresent(remorseless_winter_debuff) or SpellCooldown(remorseless_winter) > 1.5 or not HasEquippedItem(132459) } and Spell(howling_blast) or RunicPower() >= 70 and Spell(frost_strike) or not BuffPresent(rime_buff) and Spell(obliterate) or SpellCooldown(breath_of_sindragosa) > 15 and Spell(frost_strike) or SpellCooldown(breath_of_sindragosa) > 10 and Spell(remorseless_winter)
}

AddFunction FrostBosCdActions
{
	unless Talent(icy_talons_talent) and BuffRemaining(icy_talons_buff) < 1.5 and SpellCooldown(breath_of_sindragosa) > 6 and Spell(frost_strike) or Talent(gathering_storm_talent) and Spell(remorseless_winter) or not target.DebuffPresent(frost_fever_debuff) and Spell(howling_blast)
	{
		#breath_of_sindragosa,if=runic_power>=50
		if RunicPower() >= 50 Spell(breath_of_sindragosa)
	}
}

AddFunction FrostBosCdPostConditions
{
	Talent(icy_talons_talent) and BuffRemaining(icy_talons_buff) < 1.5 and SpellCooldown(breath_of_sindragosa) > 6 and Spell(frost_strike) or Talent(gathering_storm_talent) and Spell(remorseless_winter) or not target.DebuffPresent(frost_fever_debuff) and Spell(howling_blast) or RunicPower() >= 90 and ArmorSetBonus(T19 4) and Spell(frost_strike) or BuffPresent(rime_buff) and HasEquippedItem(132459) and Spell(remorseless_winter) or BuffPresent(rime_buff) and { target.DebuffPresent(remorseless_winter_debuff) or SpellCooldown(remorseless_winter) > 1.5 or not HasEquippedItem(132459) } and Spell(howling_blast) or RunicPower() >= 70 and Spell(frost_strike) or not BuffPresent(rime_buff) and Spell(obliterate) or SpellCooldown(breath_of_sindragosa) > 15 and RunicPower() <= 70 and BuffExpires(attack_power_multiplier_buff any=1) and Spell(horn_of_winter) or SpellCooldown(breath_of_sindragosa) > 15 and Spell(frost_strike) or SpellCooldown(breath_of_sindragosa) > 10 and Spell(remorseless_winter)
}

### actions.bos_ticking

AddFunction FrostBosTickingMainActions
{
	#howling_blast,target_if=!dot.frost_fever.ticking
	if not target.DebuffPresent(frost_fever_debuff) Spell(howling_blast)
	#remorseless_winter,if=((runic_power>=20&set_bonus.tier19_4pc)|runic_power>=30)&buff.rime.react&(equipped.132459|talent.gathering_storm.enabled)
	if { RunicPower() >= 20 and ArmorSetBonus(T19 4) or RunicPower() >= 30 } and BuffPresent(rime_buff) and { HasEquippedItem(132459) or Talent(gathering_storm_talent) } Spell(remorseless_winter)
	#howling_blast,if=((runic_power>=20&set_bonus.tier19_4pc)|runic_power>=30)&buff.rime.react
	if { RunicPower() >= 20 and ArmorSetBonus(T19 4) or RunicPower() >= 30 } and BuffPresent(rime_buff) Spell(howling_blast)
	#obliterate,if=runic_power<=75|rune>3
	if RunicPower() <= 75 or Rune() >= 4 Spell(obliterate)
	#remorseless_winter,if=talent.gathering_storm.enabled|!set_bonus.tier19_4pc|runic_power<30
	if Talent(gathering_storm_talent) or not ArmorSetBonus(T19 4) or RunicPower() < 30 Spell(remorseless_winter)
}

AddFunction FrostBosTickingMainPostConditions
{
}

AddFunction FrostBosTickingShortCdActions
{
	unless not target.DebuffPresent(frost_fever_debuff) and Spell(howling_blast) or { RunicPower() >= 20 and ArmorSetBonus(T19 4) or RunicPower() >= 30 } and BuffPresent(rime_buff) and { HasEquippedItem(132459) or Talent(gathering_storm_talent) } and Spell(remorseless_winter) or { RunicPower() >= 20 and ArmorSetBonus(T19 4) or RunicPower() >= 30 } and BuffPresent(rime_buff) and Spell(howling_blast) or { RunicPower() <= 75 or Rune() >= 4 } and Spell(obliterate)
	{
		#horn_of_winter,if=runic_power<70&!dot.hungering_rune_weapon.ticking
		if RunicPower() < 70 and not BuffPresent(hungering_rune_weapon_buff) and BuffExpires(attack_power_multiplier_buff any=1) Spell(horn_of_winter)
	}
}

AddFunction FrostBosTickingShortCdPostConditions
{
	not target.DebuffPresent(frost_fever_debuff) and Spell(howling_blast) or { RunicPower() >= 20 and ArmorSetBonus(T19 4) or RunicPower() >= 30 } and BuffPresent(rime_buff) and { HasEquippedItem(132459) or Talent(gathering_storm_talent) } and Spell(remorseless_winter) or { RunicPower() >= 20 and ArmorSetBonus(T19 4) or RunicPower() >= 30 } and BuffPresent(rime_buff) and Spell(howling_blast) or { RunicPower() <= 75 or Rune() >= 4 } and Spell(obliterate) or { Talent(gathering_storm_talent) or not ArmorSetBonus(T19 4) or RunicPower() < 30 } and Spell(remorseless_winter)
}

AddFunction FrostBosTickingCdActions
{
	unless not target.DebuffPresent(frost_fever_debuff) and Spell(howling_blast) or { RunicPower() >= 20 and ArmorSetBonus(T19 4) or RunicPower() >= 30 } and BuffPresent(rime_buff) and { HasEquippedItem(132459) or Talent(gathering_storm_talent) } and Spell(remorseless_winter) or { RunicPower() >= 20 and ArmorSetBonus(T19 4) or RunicPower() >= 30 } and BuffPresent(rime_buff) and Spell(howling_blast) or { RunicPower() <= 75 or Rune() >= 4 } and Spell(obliterate) or RunicPower() < 70 and not BuffPresent(hungering_rune_weapon_buff) and BuffExpires(attack_power_multiplier_buff any=1) and Spell(horn_of_winter)
	{
		#hungering_rune_weapon,if=runic_power<30&!dot.hungering_rune_weapon.ticking
		if RunicPower() < 30 and not BuffPresent(hungering_rune_weapon_buff) Spell(hungering_rune_weapon)
		#empower_rune_weapon,if=runic_power<20
		if RunicPower() < 20 Spell(empower_rune_weapon)
	}
}

AddFunction FrostBosTickingCdPostConditions
{
	not target.DebuffPresent(frost_fever_debuff) and Spell(howling_blast) or { RunicPower() >= 20 and ArmorSetBonus(T19 4) or RunicPower() >= 30 } and BuffPresent(rime_buff) and { HasEquippedItem(132459) or Talent(gathering_storm_talent) } and Spell(remorseless_winter) or { RunicPower() >= 20 and ArmorSetBonus(T19 4) or RunicPower() >= 30 } and BuffPresent(rime_buff) and Spell(howling_blast) or { RunicPower() <= 75 or Rune() >= 4 } and Spell(obliterate) or RunicPower() < 70 and not BuffPresent(hungering_rune_weapon_buff) and BuffExpires(attack_power_multiplier_buff any=1) and Spell(horn_of_winter) or { Talent(gathering_storm_talent) or not ArmorSetBonus(T19 4) or RunicPower() < 30 } and Spell(remorseless_winter)
}

### actions.generic

AddFunction FrostGenericMainActions
{
	#frost_strike,if=!talent.shattering_strikes.enabled&(buff.icy_talons.remains<1.5&talent.icy_talons.enabled)
	if not Talent(shattering_strikes_talent) and BuffRemaining(icy_talons_buff) < 1.5 and Talent(icy_talons_talent) Spell(frost_strike)
	#frost_strike,if=talent.shattering_strikes.enabled&debuff.razorice.stack=5
	if Talent(shattering_strikes_talent) and target.DebuffStacks(razorice_debuff) == 5 Spell(frost_strike)
	#howling_blast,target_if=!dot.frost_fever.ticking
	if not target.DebuffPresent(frost_fever_debuff) Spell(howling_blast)
	#obliterate,if=equipped.132366&talent.runic_attenuation.enabled&set_bonus.tier19_2pc=1
	if HasEquippedItem(132366) and Talent(runic_attenuation_talent) and ArmorSetBonus(T19 2) == 1 Spell(obliterate)
	#remorseless_winter,if=(buff.rime.react&equipped.132459&!(buff.obliteration.up&spell_targets.howling_blast<2))|talent.gathering_storm.enabled
	if BuffPresent(rime_buff) and HasEquippedItem(132459) and not { BuffPresent(obliteration_buff) and Enemies() < 2 } or Talent(gathering_storm_talent) Spell(remorseless_winter)
	#howling_blast,if=buff.rime.react&!(buff.obliteration.up&spell_targets.howling_blast<2)
	if BuffPresent(rime_buff) and not { BuffPresent(obliteration_buff) and Enemies() < 2 } Spell(howling_blast)
	#frost_strike,if=runic_power.deficit<=10
	if RunicPowerDeficit() <= 10 Spell(frost_strike)
	#frost_strike,if=buff.obliteration.up&!buff.killing_machine.react
	if BuffPresent(obliteration_buff) and not BuffPresent(killing_machine_buff) Spell(frost_strike)
	#remorseless_winter,if=spell_targets.remorseless_winter>=2&!(talent.frostscythe.enabled&buff.killing_machine.react&spell_targets.frostscythe>=2)
	if Enemies() >= 2 and not { Talent(frostscythe_talent) and BuffPresent(killing_machine_buff) and Enemies() >= 2 } Spell(remorseless_winter)
	#frostscythe,if=(buff.killing_machine.react&spell_targets.frostscythe>=2)
	if BuffPresent(killing_machine_buff) and Enemies() >= 2 Spell(frostscythe)
	#glacial_advance,if=spell_targets.glacial_advance>=2
	if Enemies() >= 2 Spell(glacial_advance)
	#frostscythe,if=spell_targets.frostscythe>=3
	if Enemies() >= 3 Spell(frostscythe)
	#obliterate,if=buff.killing_machine.react
	if BuffPresent(killing_machine_buff) Spell(obliterate)
	#obliterate
	Spell(obliterate)
	#glacial_advance
	Spell(glacial_advance)
	#frost_strike
	Spell(frost_strike)
	#remorseless_winter,if=talent.frozen_pulse.enabled
	if Talent(frozen_pulse_talent) Spell(remorseless_winter)
}

AddFunction FrostGenericMainPostConditions
{
}

AddFunction FrostGenericShortCdActions
{
	unless not Talent(shattering_strikes_talent) and BuffRemaining(icy_talons_buff) < 1.5 and Talent(icy_talons_talent) and Spell(frost_strike) or Talent(shattering_strikes_talent) and target.DebuffStacks(razorice_debuff) == 5 and Spell(frost_strike) or not target.DebuffPresent(frost_fever_debuff) and Spell(howling_blast) or HasEquippedItem(132366) and Talent(runic_attenuation_talent) and ArmorSetBonus(T19 2) == 1 and Spell(obliterate) or { BuffPresent(rime_buff) and HasEquippedItem(132459) and not { BuffPresent(obliteration_buff) and Enemies() < 2 } or Talent(gathering_storm_talent) } and Spell(remorseless_winter) or BuffPresent(rime_buff) and not { BuffPresent(obliteration_buff) and Enemies() < 2 } and Spell(howling_blast) or RunicPowerDeficit() <= 10 and Spell(frost_strike) or BuffPresent(obliteration_buff) and not BuffPresent(killing_machine_buff) and Spell(frost_strike) or Enemies() >= 2 and not { Talent(frostscythe_talent) and BuffPresent(killing_machine_buff) and Enemies() >= 2 } and Spell(remorseless_winter) or BuffPresent(killing_machine_buff) and Enemies() >= 2 and Spell(frostscythe) or Enemies() >= 2 and Spell(glacial_advance) or Enemies() >= 3 and Spell(frostscythe) or BuffPresent(killing_machine_buff) and Spell(obliterate) or Spell(obliterate) or Spell(glacial_advance)
	{
		#horn_of_winter,if=!dot.hungering_rune_weapon.ticking
		if not BuffPresent(hungering_rune_weapon_buff) and BuffExpires(attack_power_multiplier_buff any=1) Spell(horn_of_winter)
	}
}

AddFunction FrostGenericShortCdPostConditions
{
	not Talent(shattering_strikes_talent) and BuffRemaining(icy_talons_buff) < 1.5 and Talent(icy_talons_talent) and Spell(frost_strike) or Talent(shattering_strikes_talent) and target.DebuffStacks(razorice_debuff) == 5 and Spell(frost_strike) or not target.DebuffPresent(frost_fever_debuff) and Spell(howling_blast) or HasEquippedItem(132366) and Talent(runic_attenuation_talent) and ArmorSetBonus(T19 2) == 1 and Spell(obliterate) or { BuffPresent(rime_buff) and HasEquippedItem(132459) and not { BuffPresent(obliteration_buff) and Enemies() < 2 } or Talent(gathering_storm_talent) } and Spell(remorseless_winter) or BuffPresent(rime_buff) and not { BuffPresent(obliteration_buff) and Enemies() < 2 } and Spell(howling_blast) or RunicPowerDeficit() <= 10 and Spell(frost_strike) or BuffPresent(obliteration_buff) and not BuffPresent(killing_machine_buff) and Spell(frost_strike) or Enemies() >= 2 and not { Talent(frostscythe_talent) and BuffPresent(killing_machine_buff) and Enemies() >= 2 } and Spell(remorseless_winter) or BuffPresent(killing_machine_buff) and Enemies() >= 2 and Spell(frostscythe) or Enemies() >= 2 and Spell(glacial_advance) or Enemies() >= 3 and Spell(frostscythe) or BuffPresent(killing_machine_buff) and Spell(obliterate) or Spell(obliterate) or Spell(glacial_advance) or Spell(frost_strike) or Talent(frozen_pulse_talent) and Spell(remorseless_winter)
}

AddFunction FrostGenericCdActions
{
	unless not Talent(shattering_strikes_talent) and BuffRemaining(icy_talons_buff) < 1.5 and Talent(icy_talons_talent) and Spell(frost_strike) or Talent(shattering_strikes_talent) and target.DebuffStacks(razorice_debuff) == 5 and Spell(frost_strike) or not target.DebuffPresent(frost_fever_debuff) and Spell(howling_blast) or HasEquippedItem(132366) and Talent(runic_attenuation_talent) and ArmorSetBonus(T19 2) == 1 and Spell(obliterate) or { BuffPresent(rime_buff) and HasEquippedItem(132459) and not { BuffPresent(obliteration_buff) and Enemies() < 2 } or Talent(gathering_storm_talent) } and Spell(remorseless_winter) or BuffPresent(rime_buff) and not { BuffPresent(obliteration_buff) and Enemies() < 2 } and Spell(howling_blast) or RunicPowerDeficit() <= 10 and Spell(frost_strike) or BuffPresent(obliteration_buff) and not BuffPresent(killing_machine_buff) and Spell(frost_strike) or Enemies() >= 2 and not { Talent(frostscythe_talent) and BuffPresent(killing_machine_buff) and Enemies() >= 2 } and Spell(remorseless_winter) or BuffPresent(killing_machine_buff) and Enemies() >= 2 and Spell(frostscythe) or Enemies() >= 2 and Spell(glacial_advance) or Enemies() >= 3 and Spell(frostscythe) or BuffPresent(killing_machine_buff) and Spell(obliterate) or Spell(obliterate) or Spell(glacial_advance) or not BuffPresent(hungering_rune_weapon_buff) and BuffExpires(attack_power_multiplier_buff any=1) and Spell(horn_of_winter) or Spell(frost_strike) or Talent(frozen_pulse_talent) and Spell(remorseless_winter)
	{
		#empower_rune_weapon
		Spell(empower_rune_weapon)
		#hungering_rune_weapon,if=!dot.hungering_rune_weapon.ticking
		if not BuffPresent(hungering_rune_weapon_buff) Spell(hungering_rune_weapon)
	}
}

AddFunction FrostGenericCdPostConditions
{
	not Talent(shattering_strikes_talent) and BuffRemaining(icy_talons_buff) < 1.5 and Talent(icy_talons_talent) and Spell(frost_strike) or Talent(shattering_strikes_talent) and target.DebuffStacks(razorice_debuff) == 5 and Spell(frost_strike) or not target.DebuffPresent(frost_fever_debuff) and Spell(howling_blast) or HasEquippedItem(132366) and Talent(runic_attenuation_talent) and ArmorSetBonus(T19 2) == 1 and Spell(obliterate) or { BuffPresent(rime_buff) and HasEquippedItem(132459) and not { BuffPresent(obliteration_buff) and Enemies() < 2 } or Talent(gathering_storm_talent) } and Spell(remorseless_winter) or BuffPresent(rime_buff) and not { BuffPresent(obliteration_buff) and Enemies() < 2 } and Spell(howling_blast) or RunicPowerDeficit() <= 10 and Spell(frost_strike) or BuffPresent(obliteration_buff) and not BuffPresent(killing_machine_buff) and Spell(frost_strike) or Enemies() >= 2 and not { Talent(frostscythe_talent) and BuffPresent(killing_machine_buff) and Enemies() >= 2 } and Spell(remorseless_winter) or BuffPresent(killing_machine_buff) and Enemies() >= 2 and Spell(frostscythe) or Enemies() >= 2 and Spell(glacial_advance) or Enemies() >= 3 and Spell(frostscythe) or BuffPresent(killing_machine_buff) and Spell(obliterate) or Spell(obliterate) or Spell(glacial_advance) or not BuffPresent(hungering_rune_weapon_buff) and BuffExpires(attack_power_multiplier_buff any=1) and Spell(horn_of_winter) or Spell(frost_strike) or Talent(frozen_pulse_talent) and Spell(remorseless_winter)
}

### actions.gs_ticking

AddFunction FrostGsTickingMainActions
{
	#frost_strike,if=buff.icy_talons.remains<1.5&talent.icy_talons.enabled
	if BuffRemaining(icy_talons_buff) < 1.5 and Talent(icy_talons_talent) Spell(frost_strike)
	#howling_blast,target_if=!dot.frost_fever.ticking
	if not target.DebuffPresent(frost_fever_debuff) Spell(howling_blast)
	#howling_blast,if=buff.rime.react&!(buff.obliteration.up&spell_targets.howling_blast<2)
	if BuffPresent(rime_buff) and not { BuffPresent(obliteration_buff) and Enemies() < 2 } Spell(howling_blast)
	#obliterate,if=rune>3|buff.killing_machine.react|buff.obliteration.up
	if Rune() >= 4 or BuffPresent(killing_machine_buff) or BuffPresent(obliteration_buff) Spell(obliterate)
	#frost_strike,if=runic_power>80|(buff.obliteration.up&!buff.killing_machine.react)
	if RunicPower() > 80 or BuffPresent(obliteration_buff) and not BuffPresent(killing_machine_buff) Spell(frost_strike)
	#obliterate
	Spell(obliterate)
	#glacial_advance
	Spell(glacial_advance)
	#frost_strike
	Spell(frost_strike)
}

AddFunction FrostGsTickingMainPostConditions
{
}

AddFunction FrostGsTickingShortCdActions
{
	unless BuffRemaining(icy_talons_buff) < 1.5 and Talent(icy_talons_talent) and Spell(frost_strike) or not target.DebuffPresent(frost_fever_debuff) and Spell(howling_blast) or BuffPresent(rime_buff) and not { BuffPresent(obliteration_buff) and Enemies() < 2 } and Spell(howling_blast)
	{
		#obliteration,if=(!talent.frozen_pulse.enabled|(rune<2&runic_power<28))
		if not Talent(frozen_pulse_talent) or Rune() < 2 and RunicPower() < 28 Spell(obliteration)

		unless { Rune() >= 4 or BuffPresent(killing_machine_buff) or BuffPresent(obliteration_buff) } and Spell(obliterate) or { RunicPower() > 80 or BuffPresent(obliteration_buff) and not BuffPresent(killing_machine_buff) } and Spell(frost_strike) or Spell(obliterate)
		{
			#horn_of_winter,if=runic_power<70&!dot.hungering_rune_weapon.ticking
			if RunicPower() < 70 and not BuffPresent(hungering_rune_weapon_buff) and BuffExpires(attack_power_multiplier_buff any=1) Spell(horn_of_winter)
		}
	}
}

AddFunction FrostGsTickingShortCdPostConditions
{
	BuffRemaining(icy_talons_buff) < 1.5 and Talent(icy_talons_talent) and Spell(frost_strike) or not target.DebuffPresent(frost_fever_debuff) and Spell(howling_blast) or BuffPresent(rime_buff) and not { BuffPresent(obliteration_buff) and Enemies() < 2 } and Spell(howling_blast) or { Rune() >= 4 or BuffPresent(killing_machine_buff) or BuffPresent(obliteration_buff) } and Spell(obliterate) or { RunicPower() > 80 or BuffPresent(obliteration_buff) and not BuffPresent(killing_machine_buff) } and Spell(frost_strike) or Spell(obliterate) or Spell(glacial_advance) or Spell(frost_strike)
}

AddFunction FrostGsTickingCdActions
{
	unless BuffRemaining(icy_talons_buff) < 1.5 and Talent(icy_talons_talent) and Spell(frost_strike) or not target.DebuffPresent(frost_fever_debuff) and Spell(howling_blast) or BuffPresent(rime_buff) and not { BuffPresent(obliteration_buff) and Enemies() < 2 } and Spell(howling_blast) or { not Talent(frozen_pulse_talent) or Rune() < 2 and RunicPower() < 28 } and Spell(obliteration) or { Rune() >= 4 or BuffPresent(killing_machine_buff) or BuffPresent(obliteration_buff) } and Spell(obliterate) or { RunicPower() > 80 or BuffPresent(obliteration_buff) and not BuffPresent(killing_machine_buff) } and Spell(frost_strike) or Spell(obliterate) or RunicPower() < 70 and not BuffPresent(hungering_rune_weapon_buff) and BuffExpires(attack_power_multiplier_buff any=1) and Spell(horn_of_winter) or Spell(glacial_advance) or Spell(frost_strike)
	{
		#hungering_rune_weapon,if=!dot.hungering_rune_weapon.ticking
		if not BuffPresent(hungering_rune_weapon_buff) Spell(hungering_rune_weapon)
		#empower_rune_weapon
		Spell(empower_rune_weapon)
	}
}

AddFunction FrostGsTickingCdPostConditions
{
	BuffRemaining(icy_talons_buff) < 1.5 and Talent(icy_talons_talent) and Spell(frost_strike) or not target.DebuffPresent(frost_fever_debuff) and Spell(howling_blast) or BuffPresent(rime_buff) and not { BuffPresent(obliteration_buff) and Enemies() < 2 } and Spell(howling_blast) or { not Talent(frozen_pulse_talent) or Rune() < 2 and RunicPower() < 28 } and Spell(obliteration) or { Rune() >= 4 or BuffPresent(killing_machine_buff) or BuffPresent(obliteration_buff) } and Spell(obliterate) or { RunicPower() > 80 or BuffPresent(obliteration_buff) and not BuffPresent(killing_machine_buff) } and Spell(frost_strike) or Spell(obliterate) or RunicPower() < 70 and not BuffPresent(hungering_rune_weapon_buff) and BuffExpires(attack_power_multiplier_buff any=1) and Spell(horn_of_winter) or Spell(glacial_advance) or Spell(frost_strike)
}

### actions.precombat

AddFunction FrostPrecombatMainActions
{
	#flask,name=countless_armies
	#food,name=fishbrul_special
	#augmentation,name=defiled
	Spell(augmentation)
}

AddFunction FrostPrecombatMainPostConditions
{
}

AddFunction FrostPrecombatShortCdActions
{
}

AddFunction FrostPrecombatShortCdPostConditions
{
	Spell(augmentation)
}

AddFunction FrostPrecombatCdActions
{
}

AddFunction FrostPrecombatCdPostConditions
{
	Spell(augmentation)
}

### Frost icons.

AddCheckBox(opt_deathknight_frost_aoe L(AOE) default specialization=frost)

AddIcon checkbox=!opt_deathknight_frost_aoe enemies=1 help=shortcd specialization=frost
{
	if not InCombat() FrostPrecombatShortCdActions()
	unless not InCombat() and FrostPrecombatShortCdPostConditions()
	{
		FrostDefaultShortCdActions()
	}
}

AddIcon checkbox=opt_deathknight_frost_aoe help=shortcd specialization=frost
{
	if not InCombat() FrostPrecombatShortCdActions()
	unless not InCombat() and FrostPrecombatShortCdPostConditions()
	{
		FrostDefaultShortCdActions()
	}
}

AddIcon enemies=1 help=main specialization=frost
{
	if not InCombat() FrostPrecombatMainActions()
	unless not InCombat() and FrostPrecombatMainPostConditions()
	{
		FrostDefaultMainActions()
	}
}

AddIcon checkbox=opt_deathknight_frost_aoe help=aoe specialization=frost
{
	if not InCombat() FrostPrecombatMainActions()
	unless not InCombat() and FrostPrecombatMainPostConditions()
	{
		FrostDefaultMainActions()
	}
}

AddIcon checkbox=!opt_deathknight_frost_aoe enemies=1 help=cd specialization=frost
{
	if not InCombat() FrostPrecombatCdActions()
	unless not InCombat() and FrostPrecombatCdPostConditions()
	{
		FrostDefaultCdActions()
	}
}

AddIcon checkbox=opt_deathknight_frost_aoe help=cd specialization=frost
{
	if not InCombat() FrostPrecombatCdActions()
	unless not InCombat() and FrostPrecombatCdPostConditions()
	{
		FrostDefaultCdActions()
	}
}

### Required symbols
# 132366
# 132459
# arcane_torrent_runicpower
# asphyxiate
# augmentation
# berserking
# blood_fury_ap
# breath_of_sindragosa
# breath_of_sindragosa_buff
# breath_of_sindragosa_talent
# death_strike
# empower_rune_weapon
# frost_fever_debuff
# frost_strike
# frostscythe
# frostscythe_talent
# frozen_pulse_talent
# gathering_storm_talent
# glacial_advance
# horn_of_winter
# howling_blast
# hungering_rune_weapon
# hungering_rune_weapon_buff
# icy_talons_buff
# icy_talons_talent
# killing_machine_buff
# legendary_ring_strength
# mind_freeze
# obliterate
# obliteration
# obliteration_buff
# pillar_of_frost
# pillar_of_frost_buff
# quaking_palm
# razorice_debuff
# remorseless_winter
# remorseless_winter_buff
# remorseless_winter_debuff
# rime_buff
# runic_attenuation_talent
# shattering_strikes_talent
# sindragosas_fury
# strangulate
# unholy_strength_buff
# war_stomp
]]
	OvaleScripts:RegisterScript("DEATHKNIGHT", "frost", name, desc, code, "script")
end

do
	local name = "simulationcraft_death_knight_unholy_t19p"
	local desc = "[7.0] SimulationCraft: Death_Knight_Unholy_T19P"
	local code = [[
# Based on SimulationCraft profile "Death_Knight_Unholy_T19P".
#	class=deathknight
#	spec=unholy
#	talents=1210023

Include(ovale_common)
Include(ovale_trinkets_mop)
Include(ovale_trinkets_wod)
Include(ovale_deathknight_spells)

AddCheckBox(opt_interrupt L(interrupt) default specialization=unholy)
AddCheckBox(opt_melee_range L(not_in_melee_range) specialization=unholy)

AddFunction UnholyUseItemActions
{
	Item(Trinket0Slot usable=1)
	Item(Trinket1Slot usable=1)
}

AddFunction UnholyGetInMeleeRange
{
	if CheckBoxOn(opt_melee_range) and not target.InRange(death_strike) Texture(misc_arrowlup help=L(not_in_melee_range))
}

AddFunction UnholyInterruptActions
{
	if CheckBoxOn(opt_interrupt) and not target.IsFriend() and target.IsInterruptible()
	{
		if target.InRange(mind_freeze) Spell(mind_freeze)
		if not target.Classification(worldboss)
		{
			if target.InRange(asphyxiate) Spell(asphyxiate)
			if target.InRange(strangulate) Spell(strangulate)
			Spell(arcane_torrent_runicpower)
			if target.InRange(quaking_palm) Spell(quaking_palm)
			Spell(war_stomp)
		}
	}
}

### actions.default

AddFunction UnholyDefaultMainActions
{
	#potion,name=old_war,if=buff.unholy_strength.react
	#outbreak,target_if=!dot.virulent_plague.ticking
	if not target.DebuffPresent(virulent_plague_debuff) Spell(outbreak)
	#run_action_list,name=valkyr,if=talent.dark_arbiter.enabled&pet.valkyr_battlemaiden.active
	if Talent(dark_arbiter_talent) and pet.Present() UnholyValkyrMainActions()

	unless Talent(dark_arbiter_talent) and pet.Present() and UnholyValkyrMainPostConditions()
	{
		#call_action_list,name=generic
		UnholyGenericMainActions()
	}
}

AddFunction UnholyDefaultMainPostConditions
{
	Talent(dark_arbiter_talent) and pet.Present() and UnholyValkyrMainPostConditions() or UnholyGenericMainPostConditions()
}

AddFunction UnholyDefaultShortCdActions
{
	#auto_attack
	UnholyGetInMeleeRange()

	unless not target.DebuffPresent(virulent_plague_debuff) and Spell(outbreak)
	{
		#dark_transformation,if=equipped.137075&cooldown.dark_arbiter.remains>165
		if HasEquippedItem(137075) and SpellCooldown(dark_arbiter) > 165 Spell(dark_transformation)
		#dark_transformation,if=equipped.137075&!talent.shadow_infusion.enabled&cooldown.dark_arbiter.remains>55
		if HasEquippedItem(137075) and not Talent(shadow_infusion_talent) and SpellCooldown(dark_arbiter) > 55 Spell(dark_transformation)
		#dark_transformation,if=equipped.137075&talent.shadow_infusion.enabled&cooldown.dark_arbiter.remains>35
		if HasEquippedItem(137075) and Talent(shadow_infusion_talent) and SpellCooldown(dark_arbiter) > 35 Spell(dark_transformation)
		#dark_transformation,if=equipped.137075&target.time_to_die<cooldown.dark_arbiter.remains-8
		if HasEquippedItem(137075) and target.TimeToDie() < SpellCooldown(dark_arbiter) - 8 Spell(dark_transformation)
		#dark_transformation,if=equipped.137075&cooldown.summon_gargoyle.remains>160
		if HasEquippedItem(137075) and SpellCooldown(summon_gargoyle) > 160 Spell(dark_transformation)
		#dark_transformation,if=equipped.137075&!talent.shadow_infusion.enabled&cooldown.summon_gargoyle.remains>55
		if HasEquippedItem(137075) and not Talent(shadow_infusion_talent) and SpellCooldown(summon_gargoyle) > 55 Spell(dark_transformation)
		#dark_transformation,if=equipped.137075&talent.shadow_infusion.enabled&cooldown.summon_gargoyle.remains>35
		if HasEquippedItem(137075) and Talent(shadow_infusion_talent) and SpellCooldown(summon_gargoyle) > 35 Spell(dark_transformation)
		#dark_transformation,if=equipped.137075&target.time_to_die<cooldown.summon_gargoyle.remains-8
		if HasEquippedItem(137075) and target.TimeToDie() < SpellCooldown(summon_gargoyle) - 8 Spell(dark_transformation)
		#dark_transformation,if=!equipped.137075&rune<=3
		if not HasEquippedItem(137075) and Rune() < 4 Spell(dark_transformation)
		#blighted_rune_weapon,if=rune<=3
		if Rune() < 4 Spell(blighted_rune_weapon)
		#run_action_list,name=valkyr,if=talent.dark_arbiter.enabled&pet.valkyr_battlemaiden.active
		if Talent(dark_arbiter_talent) and pet.Present() UnholyValkyrShortCdActions()

		unless Talent(dark_arbiter_talent) and pet.Present() and UnholyValkyrShortCdPostConditions()
		{
			#call_action_list,name=generic
			UnholyGenericShortCdActions()
		}
	}
}

AddFunction UnholyDefaultShortCdPostConditions
{
	not target.DebuffPresent(virulent_plague_debuff) and Spell(outbreak) or Talent(dark_arbiter_talent) and pet.Present() and UnholyValkyrShortCdPostConditions() or UnholyGenericShortCdPostConditions()
}

AddFunction UnholyDefaultCdActions
{
	#mind_freeze
	UnholyInterruptActions()
	#arcane_torrent,if=runic_power.deficit>20
	if RunicPowerDeficit() > 20 Spell(arcane_torrent_runicpower)
	#blood_fury
	Spell(blood_fury_ap)
	#berserking
	Spell(berserking)
	#use_item,slot=trinket1
	UnholyUseItemActions()

	unless not target.DebuffPresent(virulent_plague_debuff) and Spell(outbreak) or HasEquippedItem(137075) and SpellCooldown(dark_arbiter) > 165 and Spell(dark_transformation) or HasEquippedItem(137075) and not Talent(shadow_infusion_talent) and SpellCooldown(dark_arbiter) > 55 and Spell(dark_transformation) or HasEquippedItem(137075) and Talent(shadow_infusion_talent) and SpellCooldown(dark_arbiter) > 35 and Spell(dark_transformation) or HasEquippedItem(137075) and target.TimeToDie() < SpellCooldown(dark_arbiter) - 8 and Spell(dark_transformation) or HasEquippedItem(137075) and SpellCooldown(summon_gargoyle) > 160 and Spell(dark_transformation) or HasEquippedItem(137075) and not Talent(shadow_infusion_talent) and SpellCooldown(summon_gargoyle) > 55 and Spell(dark_transformation) or HasEquippedItem(137075) and Talent(shadow_infusion_talent) and SpellCooldown(summon_gargoyle) > 35 and Spell(dark_transformation) or HasEquippedItem(137075) and target.TimeToDie() < SpellCooldown(summon_gargoyle) - 8 and Spell(dark_transformation) or not HasEquippedItem(137075) and Rune() < 4 and Spell(dark_transformation) or Rune() < 4 and Spell(blighted_rune_weapon)
	{
		#run_action_list,name=valkyr,if=talent.dark_arbiter.enabled&pet.valkyr_battlemaiden.active
		if Talent(dark_arbiter_talent) and pet.Present() UnholyValkyrCdActions()

		unless Talent(dark_arbiter_talent) and pet.Present() and UnholyValkyrCdPostConditions()
		{
			#call_action_list,name=generic
			UnholyGenericCdActions()
		}
	}
}

AddFunction UnholyDefaultCdPostConditions
{
	not target.DebuffPresent(virulent_plague_debuff) and Spell(outbreak) or HasEquippedItem(137075) and SpellCooldown(dark_arbiter) > 165 and Spell(dark_transformation) or HasEquippedItem(137075) and not Talent(shadow_infusion_talent) and SpellCooldown(dark_arbiter) > 55 and Spell(dark_transformation) or HasEquippedItem(137075) and Talent(shadow_infusion_talent) and SpellCooldown(dark_arbiter) > 35 and Spell(dark_transformation) or HasEquippedItem(137075) and target.TimeToDie() < SpellCooldown(dark_arbiter) - 8 and Spell(dark_transformation) or HasEquippedItem(137075) and SpellCooldown(summon_gargoyle) > 160 and Spell(dark_transformation) or HasEquippedItem(137075) and not Talent(shadow_infusion_talent) and SpellCooldown(summon_gargoyle) > 55 and Spell(dark_transformation) or HasEquippedItem(137075) and Talent(shadow_infusion_talent) and SpellCooldown(summon_gargoyle) > 35 and Spell(dark_transformation) or HasEquippedItem(137075) and target.TimeToDie() < SpellCooldown(summon_gargoyle) - 8 and Spell(dark_transformation) or not HasEquippedItem(137075) and Rune() < 4 and Spell(dark_transformation) or Rune() < 4 and Spell(blighted_rune_weapon) or Talent(dark_arbiter_talent) and pet.Present() and UnholyValkyrCdPostConditions() or UnholyGenericCdPostConditions()
}

### actions.aoe

AddFunction UnholyAoeMainActions
{
	#death_and_decay,if=spell_targets.death_and_decay>=2
	if Enemies() >= 2 Spell(death_and_decay)
	#epidemic,if=spell_targets.epidemic>4
	if Enemies() > 4 Spell(epidemic)
	#scourge_strike,if=spell_targets.scourge_strike>=2&(dot.death_and_decay.ticking|dot.defile.ticking)
	if Enemies() >= 2 and { target.DebuffPresent(death_and_decay_debuff) or target.DebuffPresent(defile_debuff) } Spell(scourge_strike)
	#clawing_shadows,if=spell_targets.clawing_shadows>=2&(dot.death_and_decay.ticking|dot.defile.ticking)
	if Enemies() >= 2 and { target.DebuffPresent(death_and_decay_debuff) or target.DebuffPresent(defile_debuff) } Spell(clawing_shadows)
	#epidemic,if=spell_targets.epidemic>2
	if Enemies() > 2 Spell(epidemic)
}

AddFunction UnholyAoeMainPostConditions
{
}

AddFunction UnholyAoeShortCdActions
{
}

AddFunction UnholyAoeShortCdPostConditions
{
	Enemies() >= 2 and Spell(death_and_decay) or Enemies() > 4 and Spell(epidemic) or Enemies() >= 2 and { target.DebuffPresent(death_and_decay_debuff) or target.DebuffPresent(defile_debuff) } and Spell(scourge_strike) or Enemies() >= 2 and { target.DebuffPresent(death_and_decay_debuff) or target.DebuffPresent(defile_debuff) } and Spell(clawing_shadows) or Enemies() > 2 and Spell(epidemic)
}

AddFunction UnholyAoeCdActions
{
}

AddFunction UnholyAoeCdPostConditions
{
	Enemies() >= 2 and Spell(death_and_decay) or Enemies() > 4 and Spell(epidemic) or Enemies() >= 2 and { target.DebuffPresent(death_and_decay_debuff) or target.DebuffPresent(defile_debuff) } and Spell(scourge_strike) or Enemies() >= 2 and { target.DebuffPresent(death_and_decay_debuff) or target.DebuffPresent(defile_debuff) } and Spell(clawing_shadows) or Enemies() > 2 and Spell(epidemic)
}

### actions.castigator

AddFunction UnholyCastigatorMainActions
{
	#festering_strike,if=debuff.festering_wound.stack<=4&runic_power.deficit>23
	if target.DebuffStacks(festering_wound_debuff) <= 4 and RunicPowerDeficit() > 23 Spell(festering_strike)
	#death_coil,if=!buff.necrosis.up&talent.necrosis.enabled&rune<=3
	if not BuffPresent(necrosis_buff) and Talent(necrosis_talent) and Rune() < 4 Spell(death_coil)
	#scourge_strike,if=buff.necrosis.react&debuff.festering_wound.stack>=3&runic_power.deficit>23
	if BuffPresent(necrosis_buff) and target.DebuffStacks(festering_wound_debuff) >= 3 and RunicPowerDeficit() > 23 Spell(scourge_strike)
	#scourge_strike,if=buff.unholy_strength.react&debuff.festering_wound.stack>=3&runic_power.deficit>23
	if BuffPresent(unholy_strength_buff) and target.DebuffStacks(festering_wound_debuff) >= 3 and RunicPowerDeficit() > 23 Spell(scourge_strike)
	#scourge_strike,if=rune>=2&debuff.festering_wound.stack>=3&runic_power.deficit>23
	if Rune() >= 2 and target.DebuffStacks(festering_wound_debuff) >= 3 and RunicPowerDeficit() > 23 Spell(scourge_strike)
	#death_coil,if=talent.shadow_infusion.enabled&talent.dark_arbiter.enabled&!buff.dark_transformation.up&cooldown.dark_arbiter.remains>15
	if Talent(shadow_infusion_talent) and Talent(dark_arbiter_talent) and not pet.BuffPresent(dark_transformation_buff) and SpellCooldown(dark_arbiter) > 15 Spell(death_coil)
	#death_coil,if=talent.shadow_infusion.enabled&!talent.dark_arbiter.enabled&!buff.dark_transformation.up
	if Talent(shadow_infusion_talent) and not Talent(dark_arbiter_talent) and not pet.BuffPresent(dark_transformation_buff) Spell(death_coil)
	#death_coil,if=talent.dark_arbiter.enabled&cooldown.dark_arbiter.remains>15
	if Talent(dark_arbiter_talent) and SpellCooldown(dark_arbiter) > 15 Spell(death_coil)
	#death_coil,if=!talent.shadow_infusion.enabled&!talent.dark_arbiter.enabled
	if not Talent(shadow_infusion_talent) and not Talent(dark_arbiter_talent) Spell(death_coil)
}

AddFunction UnholyCastigatorMainPostConditions
{
}

AddFunction UnholyCastigatorShortCdActions
{
}

AddFunction UnholyCastigatorShortCdPostConditions
{
	target.DebuffStacks(festering_wound_debuff) <= 4 and RunicPowerDeficit() > 23 and Spell(festering_strike) or not BuffPresent(necrosis_buff) and Talent(necrosis_talent) and Rune() < 4 and Spell(death_coil) or BuffPresent(necrosis_buff) and target.DebuffStacks(festering_wound_debuff) >= 3 and RunicPowerDeficit() > 23 and Spell(scourge_strike) or BuffPresent(unholy_strength_buff) and target.DebuffStacks(festering_wound_debuff) >= 3 and RunicPowerDeficit() > 23 and Spell(scourge_strike) or Rune() >= 2 and target.DebuffStacks(festering_wound_debuff) >= 3 and RunicPowerDeficit() > 23 and Spell(scourge_strike) or Talent(shadow_infusion_talent) and Talent(dark_arbiter_talent) and not pet.BuffPresent(dark_transformation_buff) and SpellCooldown(dark_arbiter) > 15 and Spell(death_coil) or Talent(shadow_infusion_talent) and not Talent(dark_arbiter_talent) and not pet.BuffPresent(dark_transformation_buff) and Spell(death_coil) or Talent(dark_arbiter_talent) and SpellCooldown(dark_arbiter) > 15 and Spell(death_coil) or not Talent(shadow_infusion_talent) and not Talent(dark_arbiter_talent) and Spell(death_coil)
}

AddFunction UnholyCastigatorCdActions
{
}

AddFunction UnholyCastigatorCdPostConditions
{
	target.DebuffStacks(festering_wound_debuff) <= 4 and RunicPowerDeficit() > 23 and Spell(festering_strike) or not BuffPresent(necrosis_buff) and Talent(necrosis_talent) and Rune() < 4 and Spell(death_coil) or BuffPresent(necrosis_buff) and target.DebuffStacks(festering_wound_debuff) >= 3 and RunicPowerDeficit() > 23 and Spell(scourge_strike) or BuffPresent(unholy_strength_buff) and target.DebuffStacks(festering_wound_debuff) >= 3 and RunicPowerDeficit() > 23 and Spell(scourge_strike) or Rune() >= 2 and target.DebuffStacks(festering_wound_debuff) >= 3 and RunicPowerDeficit() > 23 and Spell(scourge_strike) or Talent(shadow_infusion_talent) and Talent(dark_arbiter_talent) and not pet.BuffPresent(dark_transformation_buff) and SpellCooldown(dark_arbiter) > 15 and Spell(death_coil) or Talent(shadow_infusion_talent) and not Talent(dark_arbiter_talent) and not pet.BuffPresent(dark_transformation_buff) and Spell(death_coil) or Talent(dark_arbiter_talent) and SpellCooldown(dark_arbiter) > 15 and Spell(death_coil) or not Talent(shadow_infusion_talent) and not Talent(dark_arbiter_talent) and Spell(death_coil)
}

### actions.generic

AddFunction UnholyGenericMainActions
{
	#death_coil,if=runic_power.deficit<10
	if RunicPowerDeficit() < 10 Spell(death_coil)
	#death_coil,if=!talent.dark_arbiter.enabled&buff.sudden_doom.up&!buff.necrosis.up&rune<=3
	if not Talent(dark_arbiter_talent) and BuffPresent(sudden_doom_buff) and not BuffPresent(necrosis_buff) and Rune() < 4 Spell(death_coil)
	#death_coil,if=talent.dark_arbiter.enabled&buff.sudden_doom.up&cooldown.dark_arbiter.remains>5&rune<=3
	if Talent(dark_arbiter_talent) and BuffPresent(sudden_doom_buff) and SpellCooldown(dark_arbiter) > 5 and Rune() < 4 Spell(death_coil)
	#festering_strike,if=debuff.festering_wound.stack<7&cooldown.apocalypse.remains<5
	if target.DebuffStacks(festering_wound_debuff) < 7 and SpellCooldown(apocalypse) < 5 Spell(festering_strike)
	#festering_strike,if=debuff.soul_reaper.up&!debuff.festering_wound.up
	if target.DebuffPresent(soul_reaper_unholy_debuff) and not target.DebuffPresent(festering_wound_debuff) Spell(festering_strike)
	#scourge_strike,if=debuff.soul_reaper.up&debuff.festering_wound.stack>=1
	if target.DebuffPresent(soul_reaper_unholy_debuff) and target.DebuffStacks(festering_wound_debuff) >= 1 Spell(scourge_strike)
	#clawing_shadows,if=debuff.soul_reaper.up&debuff.festering_wound.stack>=1
	if target.DebuffPresent(soul_reaper_unholy_debuff) and target.DebuffStacks(festering_wound_debuff) >= 1 Spell(clawing_shadows)
	#call_action_list,name=aoe,if=active_enemies>=2
	if Enemies() >= 2 UnholyAoeMainActions()

	unless Enemies() >= 2 and UnholyAoeMainPostConditions()
	{
		#call_action_list,name=instructors,if=equipped.132448
		if HasEquippedItem(132448) UnholyInstructorsMainActions()

		unless HasEquippedItem(132448) and UnholyInstructorsMainPostConditions()
		{
			#call_action_list,name=standard,if=!talent.castigator.enabled&!equipped.132448
			if not Talent(castigator_talent) and not HasEquippedItem(132448) UnholyStandardMainActions()

			unless not Talent(castigator_talent) and not HasEquippedItem(132448) and UnholyStandardMainPostConditions()
			{
				#call_action_list,name=castigator,if=talent.castigator.enabled&!equipped.132448
				if Talent(castigator_talent) and not HasEquippedItem(132448) UnholyCastigatorMainActions()
			}
		}
	}
}

AddFunction UnholyGenericMainPostConditions
{
	Enemies() >= 2 and UnholyAoeMainPostConditions() or HasEquippedItem(132448) and UnholyInstructorsMainPostConditions() or not Talent(castigator_talent) and not HasEquippedItem(132448) and UnholyStandardMainPostConditions() or Talent(castigator_talent) and not HasEquippedItem(132448) and UnholyCastigatorMainPostConditions()
}

AddFunction UnholyGenericShortCdActions
{
	#soul_reaper,if=debuff.festering_wound.stack>=7&cooldown.apocalypse.remains<2
	if target.DebuffStacks(festering_wound_debuff) >= 7 and SpellCooldown(apocalypse) < 2 Spell(soul_reaper_unholy)
	#apocalypse,if=debuff.festering_wound.stack>=7
	if target.DebuffStacks(festering_wound_debuff) >= 7 Spell(apocalypse)

	unless RunicPowerDeficit() < 10 and Spell(death_coil) or not Talent(dark_arbiter_talent) and BuffPresent(sudden_doom_buff) and not BuffPresent(necrosis_buff) and Rune() < 4 and Spell(death_coil) or Talent(dark_arbiter_talent) and BuffPresent(sudden_doom_buff) and SpellCooldown(dark_arbiter) > 5 and Rune() < 4 and Spell(death_coil) or target.DebuffStacks(festering_wound_debuff) < 7 and SpellCooldown(apocalypse) < 5 and Spell(festering_strike)
	{
		#soul_reaper,if=debuff.festering_wound.stack>=3
		if target.DebuffStacks(festering_wound_debuff) >= 3 Spell(soul_reaper_unholy)

		unless target.DebuffPresent(soul_reaper_unholy_debuff) and not target.DebuffPresent(festering_wound_debuff) and Spell(festering_strike) or target.DebuffPresent(soul_reaper_unholy_debuff) and target.DebuffStacks(festering_wound_debuff) >= 1 and Spell(scourge_strike) or target.DebuffPresent(soul_reaper_unholy_debuff) and target.DebuffStacks(festering_wound_debuff) >= 1 and Spell(clawing_shadows)
		{
			#defile
			Spell(defile)
			#call_action_list,name=aoe,if=active_enemies>=2
			if Enemies() >= 2 UnholyAoeShortCdActions()

			unless Enemies() >= 2 and UnholyAoeShortCdPostConditions()
			{
				#call_action_list,name=instructors,if=equipped.132448
				if HasEquippedItem(132448) UnholyInstructorsShortCdActions()

				unless HasEquippedItem(132448) and UnholyInstructorsShortCdPostConditions()
				{
					#call_action_list,name=standard,if=!talent.castigator.enabled&!equipped.132448
					if not Talent(castigator_talent) and not HasEquippedItem(132448) UnholyStandardShortCdActions()

					unless not Talent(castigator_talent) and not HasEquippedItem(132448) and UnholyStandardShortCdPostConditions()
					{
						#call_action_list,name=castigator,if=talent.castigator.enabled&!equipped.132448
						if Talent(castigator_talent) and not HasEquippedItem(132448) UnholyCastigatorShortCdActions()
					}
				}
			}
		}
	}
}

AddFunction UnholyGenericShortCdPostConditions
{
	RunicPowerDeficit() < 10 and Spell(death_coil) or not Talent(dark_arbiter_talent) and BuffPresent(sudden_doom_buff) and not BuffPresent(necrosis_buff) and Rune() < 4 and Spell(death_coil) or Talent(dark_arbiter_talent) and BuffPresent(sudden_doom_buff) and SpellCooldown(dark_arbiter) > 5 and Rune() < 4 and Spell(death_coil) or target.DebuffStacks(festering_wound_debuff) < 7 and SpellCooldown(apocalypse) < 5 and Spell(festering_strike) or target.DebuffPresent(soul_reaper_unholy_debuff) and not target.DebuffPresent(festering_wound_debuff) and Spell(festering_strike) or target.DebuffPresent(soul_reaper_unholy_debuff) and target.DebuffStacks(festering_wound_debuff) >= 1 and Spell(scourge_strike) or target.DebuffPresent(soul_reaper_unholy_debuff) and target.DebuffStacks(festering_wound_debuff) >= 1 and Spell(clawing_shadows) or Enemies() >= 2 and UnholyAoeShortCdPostConditions() or HasEquippedItem(132448) and UnholyInstructorsShortCdPostConditions() or not Talent(castigator_talent) and not HasEquippedItem(132448) and UnholyStandardShortCdPostConditions() or Talent(castigator_talent) and not HasEquippedItem(132448) and UnholyCastigatorShortCdPostConditions()
}

AddFunction UnholyGenericCdActions
{
	#dark_arbiter,if=!equipped.137075&runic_power.deficit<30
	if not HasEquippedItem(137075) and RunicPowerDeficit() < 30 Spell(dark_arbiter)
	#dark_arbiter,if=equipped.137075&runic_power.deficit<30&cooldown.dark_transformation.remains<2
	if HasEquippedItem(137075) and RunicPowerDeficit() < 30 and SpellCooldown(dark_transformation) < 2 Spell(dark_arbiter)
	#summon_gargoyle,if=!equipped.137075,if=rune<=3
	if Rune() < 4 Spell(summon_gargoyle)
	#summon_gargoyle,if=equipped.137075&cooldown.dark_transformation.remains<10&rune<=3
	if HasEquippedItem(137075) and SpellCooldown(dark_transformation) < 10 and Rune() < 4 Spell(summon_gargoyle)

	unless target.DebuffStacks(festering_wound_debuff) >= 7 and SpellCooldown(apocalypse) < 2 and Spell(soul_reaper_unholy) or target.DebuffStacks(festering_wound_debuff) >= 7 and Spell(apocalypse) or RunicPowerDeficit() < 10 and Spell(death_coil) or not Talent(dark_arbiter_talent) and BuffPresent(sudden_doom_buff) and not BuffPresent(necrosis_buff) and Rune() < 4 and Spell(death_coil) or Talent(dark_arbiter_talent) and BuffPresent(sudden_doom_buff) and SpellCooldown(dark_arbiter) > 5 and Rune() < 4 and Spell(death_coil) or target.DebuffStacks(festering_wound_debuff) < 7 and SpellCooldown(apocalypse) < 5 and Spell(festering_strike) or target.DebuffStacks(festering_wound_debuff) >= 3 and Spell(soul_reaper_unholy) or target.DebuffPresent(soul_reaper_unholy_debuff) and not target.DebuffPresent(festering_wound_debuff) and Spell(festering_strike) or target.DebuffPresent(soul_reaper_unholy_debuff) and target.DebuffStacks(festering_wound_debuff) >= 1 and Spell(scourge_strike) or target.DebuffPresent(soul_reaper_unholy_debuff) and target.DebuffStacks(festering_wound_debuff) >= 1 and Spell(clawing_shadows) or Spell(defile)
	{
		#call_action_list,name=aoe,if=active_enemies>=2
		if Enemies() >= 2 UnholyAoeCdActions()

		unless Enemies() >= 2 and UnholyAoeCdPostConditions()
		{
			#call_action_list,name=instructors,if=equipped.132448
			if HasEquippedItem(132448) UnholyInstructorsCdActions()

			unless HasEquippedItem(132448) and UnholyInstructorsCdPostConditions()
			{
				#call_action_list,name=standard,if=!talent.castigator.enabled&!equipped.132448
				if not Talent(castigator_talent) and not HasEquippedItem(132448) UnholyStandardCdActions()

				unless not Talent(castigator_talent) and not HasEquippedItem(132448) and UnholyStandardCdPostConditions()
				{
					#call_action_list,name=castigator,if=talent.castigator.enabled&!equipped.132448
					if Talent(castigator_talent) and not HasEquippedItem(132448) UnholyCastigatorCdActions()
				}
			}
		}
	}
}

AddFunction UnholyGenericCdPostConditions
{
	target.DebuffStacks(festering_wound_debuff) >= 7 and SpellCooldown(apocalypse) < 2 and Spell(soul_reaper_unholy) or target.DebuffStacks(festering_wound_debuff) >= 7 and Spell(apocalypse) or RunicPowerDeficit() < 10 and Spell(death_coil) or not Talent(dark_arbiter_talent) and BuffPresent(sudden_doom_buff) and not BuffPresent(necrosis_buff) and Rune() < 4 and Spell(death_coil) or Talent(dark_arbiter_talent) and BuffPresent(sudden_doom_buff) and SpellCooldown(dark_arbiter) > 5 and Rune() < 4 and Spell(death_coil) or target.DebuffStacks(festering_wound_debuff) < 7 and SpellCooldown(apocalypse) < 5 and Spell(festering_strike) or target.DebuffStacks(festering_wound_debuff) >= 3 and Spell(soul_reaper_unholy) or target.DebuffPresent(soul_reaper_unholy_debuff) and not target.DebuffPresent(festering_wound_debuff) and Spell(festering_strike) or target.DebuffPresent(soul_reaper_unholy_debuff) and target.DebuffStacks(festering_wound_debuff) >= 1 and Spell(scourge_strike) or target.DebuffPresent(soul_reaper_unholy_debuff) and target.DebuffStacks(festering_wound_debuff) >= 1 and Spell(clawing_shadows) or Spell(defile) or Enemies() >= 2 and UnholyAoeCdPostConditions() or HasEquippedItem(132448) and UnholyInstructorsCdPostConditions() or not Talent(castigator_talent) and not HasEquippedItem(132448) and UnholyStandardCdPostConditions() or Talent(castigator_talent) and not HasEquippedItem(132448) and UnholyCastigatorCdPostConditions()
}

### actions.instructors

AddFunction UnholyInstructorsMainActions
{
	#festering_strike,if=debuff.festering_wound.stack<=3&runic_power.deficit>13
	if target.DebuffStacks(festering_wound_debuff) <= 3 and RunicPowerDeficit() > 13 Spell(festering_strike)
	#death_coil,if=!buff.necrosis.up&talent.necrosis.enabled&rune<=3
	if not BuffPresent(necrosis_buff) and Talent(necrosis_talent) and Rune() < 4 Spell(death_coil)
	#scourge_strike,if=buff.necrosis.react&debuff.festering_wound.stack>=4&runic_power.deficit>29
	if BuffPresent(necrosis_buff) and target.DebuffStacks(festering_wound_debuff) >= 4 and RunicPowerDeficit() > 29 Spell(scourge_strike)
	#clawing_shadows,if=buff.necrosis.react&debuff.festering_wound.stack>=4&runic_power.deficit>11
	if BuffPresent(necrosis_buff) and target.DebuffStacks(festering_wound_debuff) >= 4 and RunicPowerDeficit() > 11 Spell(clawing_shadows)
	#scourge_strike,if=buff.unholy_strength.react&debuff.festering_wound.stack>=4&runic_power.deficit>29
	if BuffPresent(unholy_strength_buff) and target.DebuffStacks(festering_wound_debuff) >= 4 and RunicPowerDeficit() > 29 Spell(scourge_strike)
	#clawing_shadows,if=buff.unholy_strength.react&debuff.festering_wound.stack>=4&runic_power.deficit>11
	if BuffPresent(unholy_strength_buff) and target.DebuffStacks(festering_wound_debuff) >= 4 and RunicPowerDeficit() > 11 Spell(clawing_shadows)
	#scourge_strike,if=rune>=2&debuff.festering_wound.stack>=4&runic_power.deficit>29
	if Rune() >= 2 and target.DebuffStacks(festering_wound_debuff) >= 4 and RunicPowerDeficit() > 29 Spell(scourge_strike)
	#clawing_shadows,if=rune>=2&debuff.festering_wound.stack>=4&runic_power.deficit>11
	if Rune() >= 2 and target.DebuffStacks(festering_wound_debuff) >= 4 and RunicPowerDeficit() > 11 Spell(clawing_shadows)
	#death_coil,if=talent.shadow_infusion.enabled&talent.dark_arbiter.enabled&!buff.dark_transformation.up&cooldown.dark_arbiter.remains>15
	if Talent(shadow_infusion_talent) and Talent(dark_arbiter_talent) and not pet.BuffPresent(dark_transformation_buff) and SpellCooldown(dark_arbiter) > 15 Spell(death_coil)
	#death_coil,if=talent.shadow_infusion.enabled&!talent.dark_arbiter.enabled&!buff.dark_transformation.up
	if Talent(shadow_infusion_talent) and not Talent(dark_arbiter_talent) and not pet.BuffPresent(dark_transformation_buff) Spell(death_coil)
	#death_coil,if=talent.dark_arbiter.enabled&cooldown.dark_arbiter.remains>15
	if Talent(dark_arbiter_talent) and SpellCooldown(dark_arbiter) > 15 Spell(death_coil)
	#death_coil,if=!talent.shadow_infusion.enabled&!talent.dark_arbiter.enabled
	if not Talent(shadow_infusion_talent) and not Talent(dark_arbiter_talent) Spell(death_coil)
}

AddFunction UnholyInstructorsMainPostConditions
{
}

AddFunction UnholyInstructorsShortCdActions
{
}

AddFunction UnholyInstructorsShortCdPostConditions
{
	target.DebuffStacks(festering_wound_debuff) <= 3 and RunicPowerDeficit() > 13 and Spell(festering_strike) or not BuffPresent(necrosis_buff) and Talent(necrosis_talent) and Rune() < 4 and Spell(death_coil) or BuffPresent(necrosis_buff) and target.DebuffStacks(festering_wound_debuff) >= 4 and RunicPowerDeficit() > 29 and Spell(scourge_strike) or BuffPresent(necrosis_buff) and target.DebuffStacks(festering_wound_debuff) >= 4 and RunicPowerDeficit() > 11 and Spell(clawing_shadows) or BuffPresent(unholy_strength_buff) and target.DebuffStacks(festering_wound_debuff) >= 4 and RunicPowerDeficit() > 29 and Spell(scourge_strike) or BuffPresent(unholy_strength_buff) and target.DebuffStacks(festering_wound_debuff) >= 4 and RunicPowerDeficit() > 11 and Spell(clawing_shadows) or Rune() >= 2 and target.DebuffStacks(festering_wound_debuff) >= 4 and RunicPowerDeficit() > 29 and Spell(scourge_strike) or Rune() >= 2 and target.DebuffStacks(festering_wound_debuff) >= 4 and RunicPowerDeficit() > 11 and Spell(clawing_shadows) or Talent(shadow_infusion_talent) and Talent(dark_arbiter_talent) and not pet.BuffPresent(dark_transformation_buff) and SpellCooldown(dark_arbiter) > 15 and Spell(death_coil) or Talent(shadow_infusion_talent) and not Talent(dark_arbiter_talent) and not pet.BuffPresent(dark_transformation_buff) and Spell(death_coil) or Talent(dark_arbiter_talent) and SpellCooldown(dark_arbiter) > 15 and Spell(death_coil) or not Talent(shadow_infusion_talent) and not Talent(dark_arbiter_talent) and Spell(death_coil)
}

AddFunction UnholyInstructorsCdActions
{
}

AddFunction UnholyInstructorsCdPostConditions
{
	target.DebuffStacks(festering_wound_debuff) <= 3 and RunicPowerDeficit() > 13 and Spell(festering_strike) or not BuffPresent(necrosis_buff) and Talent(necrosis_talent) and Rune() < 4 and Spell(death_coil) or BuffPresent(necrosis_buff) and target.DebuffStacks(festering_wound_debuff) >= 4 and RunicPowerDeficit() > 29 and Spell(scourge_strike) or BuffPresent(necrosis_buff) and target.DebuffStacks(festering_wound_debuff) >= 4 and RunicPowerDeficit() > 11 and Spell(clawing_shadows) or BuffPresent(unholy_strength_buff) and target.DebuffStacks(festering_wound_debuff) >= 4 and RunicPowerDeficit() > 29 and Spell(scourge_strike) or BuffPresent(unholy_strength_buff) and target.DebuffStacks(festering_wound_debuff) >= 4 and RunicPowerDeficit() > 11 and Spell(clawing_shadows) or Rune() >= 2 and target.DebuffStacks(festering_wound_debuff) >= 4 and RunicPowerDeficit() > 29 and Spell(scourge_strike) or Rune() >= 2 and target.DebuffStacks(festering_wound_debuff) >= 4 and RunicPowerDeficit() > 11 and Spell(clawing_shadows) or Talent(shadow_infusion_talent) and Talent(dark_arbiter_talent) and not pet.BuffPresent(dark_transformation_buff) and SpellCooldown(dark_arbiter) > 15 and Spell(death_coil) or Talent(shadow_infusion_talent) and not Talent(dark_arbiter_talent) and not pet.BuffPresent(dark_transformation_buff) and Spell(death_coil) or Talent(dark_arbiter_talent) and SpellCooldown(dark_arbiter) > 15 and Spell(death_coil) or not Talent(shadow_infusion_talent) and not Talent(dark_arbiter_talent) and Spell(death_coil)
}

### actions.precombat

AddFunction UnholyPrecombatMainActions
{
	#flask,name=countless_armies
	#food,name=nightborne_delicacy_platter
	#augmentation,name=defiled
	Spell(augmentation)
}

AddFunction UnholyPrecombatMainPostConditions
{
}

AddFunction UnholyPrecombatShortCdActions
{
	unless Spell(augmentation)
	{
		#snapshot_stats
		#potion,name=old_war
		#raise_dead
		Spell(raise_dead)
	}
}

AddFunction UnholyPrecombatShortCdPostConditions
{
	Spell(augmentation)
}

AddFunction UnholyPrecombatCdActions
{
	unless Spell(augmentation) or Spell(raise_dead)
	{
		#army_of_the_dead
		Spell(army_of_the_dead)
	}
}

AddFunction UnholyPrecombatCdPostConditions
{
	Spell(augmentation) or Spell(raise_dead)
}

### actions.standard

AddFunction UnholyStandardMainActions
{
	#festering_strike,if=debuff.festering_wound.stack<=3&runic_power.deficit>13
	if target.DebuffStacks(festering_wound_debuff) <= 3 and RunicPowerDeficit() > 13 Spell(festering_strike)
	#death_coil,if=!buff.necrosis.up&talent.necrosis.enabled&rune<=3
	if not BuffPresent(necrosis_buff) and Talent(necrosis_talent) and Rune() < 4 Spell(death_coil)
	#scourge_strike,if=buff.necrosis.react&debuff.festering_wound.stack>=1&runic_power.deficit>15
	if BuffPresent(necrosis_buff) and target.DebuffStacks(festering_wound_debuff) >= 1 and RunicPowerDeficit() > 15 Spell(scourge_strike)
	#clawing_shadows,if=buff.necrosis.react&debuff.festering_wound.stack>=1&runic_power.deficit>11
	if BuffPresent(necrosis_buff) and target.DebuffStacks(festering_wound_debuff) >= 1 and RunicPowerDeficit() > 11 Spell(clawing_shadows)
	#scourge_strike,if=buff.unholy_strength.react&debuff.festering_wound.stack>=1&runic_power.deficit>15
	if BuffPresent(unholy_strength_buff) and target.DebuffStacks(festering_wound_debuff) >= 1 and RunicPowerDeficit() > 15 Spell(scourge_strike)
	#clawing_shadows,if=buff.unholy_strength.react&debuff.festering_wound.stack>=1&runic_power.deficit>11
	if BuffPresent(unholy_strength_buff) and target.DebuffStacks(festering_wound_debuff) >= 1 and RunicPowerDeficit() > 11 Spell(clawing_shadows)
	#scourge_strike,if=rune>=2&debuff.festering_wound.stack>=1&runic_power.deficit>15
	if Rune() >= 2 and target.DebuffStacks(festering_wound_debuff) >= 1 and RunicPowerDeficit() > 15 Spell(scourge_strike)
	#clawing_shadows,if=rune>=2&debuff.festering_wound.stack>=1&runic_power.deficit>11
	if Rune() >= 2 and target.DebuffStacks(festering_wound_debuff) >= 1 and RunicPowerDeficit() > 11 Spell(clawing_shadows)
	#death_coil,if=talent.shadow_infusion.enabled&talent.dark_arbiter.enabled&!buff.dark_transformation.up&cooldown.dark_arbiter.remains>15
	if Talent(shadow_infusion_talent) and Talent(dark_arbiter_talent) and not pet.BuffPresent(dark_transformation_buff) and SpellCooldown(dark_arbiter) > 15 Spell(death_coil)
	#death_coil,if=talent.shadow_infusion.enabled&!talent.dark_arbiter.enabled&!buff.dark_transformation.up
	if Talent(shadow_infusion_talent) and not Talent(dark_arbiter_talent) and not pet.BuffPresent(dark_transformation_buff) Spell(death_coil)
	#death_coil,if=talent.dark_arbiter.enabled&cooldown.dark_arbiter.remains>15
	if Talent(dark_arbiter_talent) and SpellCooldown(dark_arbiter) > 15 Spell(death_coil)
	#death_coil,if=!talent.shadow_infusion.enabled&!talent.dark_arbiter.enabled
	if not Talent(shadow_infusion_talent) and not Talent(dark_arbiter_talent) Spell(death_coil)
}

AddFunction UnholyStandardMainPostConditions
{
}

AddFunction UnholyStandardShortCdActions
{
}

AddFunction UnholyStandardShortCdPostConditions
{
	target.DebuffStacks(festering_wound_debuff) <= 3 and RunicPowerDeficit() > 13 and Spell(festering_strike) or not BuffPresent(necrosis_buff) and Talent(necrosis_talent) and Rune() < 4 and Spell(death_coil) or BuffPresent(necrosis_buff) and target.DebuffStacks(festering_wound_debuff) >= 1 and RunicPowerDeficit() > 15 and Spell(scourge_strike) or BuffPresent(necrosis_buff) and target.DebuffStacks(festering_wound_debuff) >= 1 and RunicPowerDeficit() > 11 and Spell(clawing_shadows) or BuffPresent(unholy_strength_buff) and target.DebuffStacks(festering_wound_debuff) >= 1 and RunicPowerDeficit() > 15 and Spell(scourge_strike) or BuffPresent(unholy_strength_buff) and target.DebuffStacks(festering_wound_debuff) >= 1 and RunicPowerDeficit() > 11 and Spell(clawing_shadows) or Rune() >= 2 and target.DebuffStacks(festering_wound_debuff) >= 1 and RunicPowerDeficit() > 15 and Spell(scourge_strike) or Rune() >= 2 and target.DebuffStacks(festering_wound_debuff) >= 1 and RunicPowerDeficit() > 11 and Spell(clawing_shadows) or Talent(shadow_infusion_talent) and Talent(dark_arbiter_talent) and not pet.BuffPresent(dark_transformation_buff) and SpellCooldown(dark_arbiter) > 15 and Spell(death_coil) or Talent(shadow_infusion_talent) and not Talent(dark_arbiter_talent) and not pet.BuffPresent(dark_transformation_buff) and Spell(death_coil) or Talent(dark_arbiter_talent) and SpellCooldown(dark_arbiter) > 15 and Spell(death_coil) or not Talent(shadow_infusion_talent) and not Talent(dark_arbiter_talent) and Spell(death_coil)
}

AddFunction UnholyStandardCdActions
{
}

AddFunction UnholyStandardCdPostConditions
{
	target.DebuffStacks(festering_wound_debuff) <= 3 and RunicPowerDeficit() > 13 and Spell(festering_strike) or not BuffPresent(necrosis_buff) and Talent(necrosis_talent) and Rune() < 4 and Spell(death_coil) or BuffPresent(necrosis_buff) and target.DebuffStacks(festering_wound_debuff) >= 1 and RunicPowerDeficit() > 15 and Spell(scourge_strike) or BuffPresent(necrosis_buff) and target.DebuffStacks(festering_wound_debuff) >= 1 and RunicPowerDeficit() > 11 and Spell(clawing_shadows) or BuffPresent(unholy_strength_buff) and target.DebuffStacks(festering_wound_debuff) >= 1 and RunicPowerDeficit() > 15 and Spell(scourge_strike) or BuffPresent(unholy_strength_buff) and target.DebuffStacks(festering_wound_debuff) >= 1 and RunicPowerDeficit() > 11 and Spell(clawing_shadows) or Rune() >= 2 and target.DebuffStacks(festering_wound_debuff) >= 1 and RunicPowerDeficit() > 15 and Spell(scourge_strike) or Rune() >= 2 and target.DebuffStacks(festering_wound_debuff) >= 1 and RunicPowerDeficit() > 11 and Spell(clawing_shadows) or Talent(shadow_infusion_talent) and Talent(dark_arbiter_talent) and not pet.BuffPresent(dark_transformation_buff) and SpellCooldown(dark_arbiter) > 15 and Spell(death_coil) or Talent(shadow_infusion_talent) and not Talent(dark_arbiter_talent) and not pet.BuffPresent(dark_transformation_buff) and Spell(death_coil) or Talent(dark_arbiter_talent) and SpellCooldown(dark_arbiter) > 15 and Spell(death_coil) or not Talent(shadow_infusion_talent) and not Talent(dark_arbiter_talent) and Spell(death_coil)
}

### actions.valkyr

AddFunction UnholyValkyrMainActions
{
	#death_coil
	Spell(death_coil)
	#festering_strike,if=debuff.festering_wound.stack<8&cooldown.apocalypse.remains<5
	if target.DebuffStacks(festering_wound_debuff) < 8 and SpellCooldown(apocalypse) < 5 Spell(festering_strike)
	#call_action_list,name=aoe,if=active_enemies>=2
	if Enemies() >= 2 UnholyAoeMainActions()

	unless Enemies() >= 2 and UnholyAoeMainPostConditions()
	{
		#festering_strike,if=debuff.festering_wound.stack<=3
		if target.DebuffStacks(festering_wound_debuff) <= 3 Spell(festering_strike)
		#scourge_strike,if=debuff.festering_wound.up
		if target.DebuffPresent(festering_wound_debuff) Spell(scourge_strike)
		#clawing_shadows,if=debuff.festering_wound.up
		if target.DebuffPresent(festering_wound_debuff) Spell(clawing_shadows)
	}
}

AddFunction UnholyValkyrMainPostConditions
{
	Enemies() >= 2 and UnholyAoeMainPostConditions()
}

AddFunction UnholyValkyrShortCdActions
{
	unless Spell(death_coil)
	{
		#apocalypse,if=debuff.festering_wound.stack=8
		if target.DebuffStacks(festering_wound_debuff) == 8 Spell(apocalypse)

		unless target.DebuffStacks(festering_wound_debuff) < 8 and SpellCooldown(apocalypse) < 5 and Spell(festering_strike)
		{
			#call_action_list,name=aoe,if=active_enemies>=2
			if Enemies() >= 2 UnholyAoeShortCdActions()
		}
	}
}

AddFunction UnholyValkyrShortCdPostConditions
{
	Spell(death_coil) or target.DebuffStacks(festering_wound_debuff) < 8 and SpellCooldown(apocalypse) < 5 and Spell(festering_strike) or Enemies() >= 2 and UnholyAoeShortCdPostConditions() or target.DebuffStacks(festering_wound_debuff) <= 3 and Spell(festering_strike) or target.DebuffPresent(festering_wound_debuff) and Spell(scourge_strike) or target.DebuffPresent(festering_wound_debuff) and Spell(clawing_shadows)
}

AddFunction UnholyValkyrCdActions
{
	unless Spell(death_coil) or target.DebuffStacks(festering_wound_debuff) == 8 and Spell(apocalypse) or target.DebuffStacks(festering_wound_debuff) < 8 and SpellCooldown(apocalypse) < 5 and Spell(festering_strike)
	{
		#call_action_list,name=aoe,if=active_enemies>=2
		if Enemies() >= 2 UnholyAoeCdActions()
	}
}

AddFunction UnholyValkyrCdPostConditions
{
	Spell(death_coil) or target.DebuffStacks(festering_wound_debuff) == 8 and Spell(apocalypse) or target.DebuffStacks(festering_wound_debuff) < 8 and SpellCooldown(apocalypse) < 5 and Spell(festering_strike) or Enemies() >= 2 and UnholyAoeCdPostConditions() or target.DebuffStacks(festering_wound_debuff) <= 3 and Spell(festering_strike) or target.DebuffPresent(festering_wound_debuff) and Spell(scourge_strike) or target.DebuffPresent(festering_wound_debuff) and Spell(clawing_shadows)
}

### Unholy icons.

AddCheckBox(opt_deathknight_unholy_aoe L(AOE) default specialization=unholy)

AddIcon checkbox=!opt_deathknight_unholy_aoe enemies=1 help=shortcd specialization=unholy
{
	if not InCombat() UnholyPrecombatShortCdActions()
	unless not InCombat() and UnholyPrecombatShortCdPostConditions()
	{
		UnholyDefaultShortCdActions()
	}
}

AddIcon checkbox=opt_deathknight_unholy_aoe help=shortcd specialization=unholy
{
	if not InCombat() UnholyPrecombatShortCdActions()
	unless not InCombat() and UnholyPrecombatShortCdPostConditions()
	{
		UnholyDefaultShortCdActions()
	}
}

AddIcon enemies=1 help=main specialization=unholy
{
	if not InCombat() UnholyPrecombatMainActions()
	unless not InCombat() and UnholyPrecombatMainPostConditions()
	{
		UnholyDefaultMainActions()
	}
}

AddIcon checkbox=opt_deathknight_unholy_aoe help=aoe specialization=unholy
{
	if not InCombat() UnholyPrecombatMainActions()
	unless not InCombat() and UnholyPrecombatMainPostConditions()
	{
		UnholyDefaultMainActions()
	}
}

AddIcon checkbox=!opt_deathknight_unholy_aoe enemies=1 help=cd specialization=unholy
{
	if not InCombat() UnholyPrecombatCdActions()
	unless not InCombat() and UnholyPrecombatCdPostConditions()
	{
		UnholyDefaultCdActions()
	}
}

AddIcon checkbox=opt_deathknight_unholy_aoe help=cd specialization=unholy
{
	if not InCombat() UnholyPrecombatCdActions()
	unless not InCombat() and UnholyPrecombatCdPostConditions()
	{
		UnholyDefaultCdActions()
	}
}

### Required symbols
# 132448
# 137075
# apocalypse
# arcane_torrent_runicpower
# army_of_the_dead
# asphyxiate
# augmentation
# berserking
# blighted_rune_weapon
# blood_fury_ap
# castigator_talent
# clawing_shadows
# dark_arbiter
# dark_arbiter_talent
# dark_transformation
# dark_transformation_buff
# death_and_decay
# death_and_decay_debuff
# death_coil
# death_strike
# defile
# defile_debuff
# epidemic
# festering_strike
# festering_wound_debuff
# mind_freeze
# necrosis_buff
# necrosis_talent
# outbreak
# quaking_palm
# raise_dead
# scourge_strike
# shadow_infusion_talent
# soul_reaper_unholy
# soul_reaper_unholy_debuff
# strangulate
# sudden_doom_buff
# summon_gargoyle
# unholy_strength_buff
# valkyr_battlemaiden
# virulent_plague_debuff
# war_stomp
]]
	OvaleScripts:RegisterScript("DEATHKNIGHT", "unholy", name, desc, code, "script")
end
