local OVALE, Ovale = ...
local OvaleScripts = Ovale.OvaleScripts

-- THE REST OF THIS FILE IS AUTOMATICALLY GENERATED.
-- ANY CHANGES MADE BELOW THIS POINT WILL BE LOST.

do
	local name = "simulationcraft_hunter_bm_t19p"
	local desc = "[7.0] SimulationCraft: Hunter_BM_T19P"
	local code = [[
# Based on SimulationCraft profile "Hunter_BM_T19P".
#	class=hunter
#	spec=beast_mastery
#	talents=2102012

Include(ovale_common)
Include(ovale_trinkets_mop)
Include(ovale_trinkets_wod)
Include(ovale_hunter_spells)

AddCheckBox(opt_interrupt L(interrupt) default specialization=beast_mastery)
AddCheckBox(opt_volley SpellName(volley) default specialization=beast_mastery)

AddFunction BeastMasteryInterruptActions
{
	if CheckBoxOn(opt_interrupt) and not target.IsFriend() and target.IsInterruptible()
	{
		Spell(counter_shot)
		if not target.Classification(worldboss)
		{
			Spell(arcane_torrent_focus)
			if target.InRange(quaking_palm) Spell(quaking_palm)
			Spell(war_stomp)
		}
	}
}

AddFunction BeastMasterySummonPet
{
	if pet.IsDead()
	{
		if not DebuffPresent(heart_of_the_phoenix_debuff) Spell(heart_of_the_phoenix)
		Spell(revive_pet)
	}
	if not pet.Present() and not pet.IsDead() and not PreviousSpell(revive_pet) Texture(ability_hunter_beastcall help=L(summon_pet))
}

### actions.default

AddFunction BeastMasteryDefaultMainActions
{
	#volley,toggle=on
	if CheckBoxOn(opt_volley) Spell(volley)
	#dire_beast,if=cooldown.bestial_wrath.remains>3
	if SpellCooldown(bestial_wrath) > 3 Spell(dire_beast)
	#dire_frenzy,if=cooldown.bestial_wrath.remains>6|target.time_to_die<9
	if SpellCooldown(bestial_wrath) > 6 or target.TimeToDie() < 9 Spell(dire_frenzy)
	#multi_shot,if=spell_targets>4&(pet.buff.beast_cleave.remains<gcd.max|pet.buff.beast_cleave.down)
	if Enemies() > 4 and { pet.BuffRemaining(pet_beast_cleave_buff) < GCD() or pet.BuffExpires(pet_beast_cleave_buff) } Spell(multi_shot)
	#kill_command
	if pet.Present() and not pet.IsIncapacitated() and not pet.IsFeared() and not pet.IsStunned() Spell(kill_command)
	#multi_shot,if=spell_targets>1&(pet.buff.beast_cleave.remains<gcd.max*2|pet.buff.beast_cleave.down)
	if Enemies() > 1 and { pet.BuffRemaining(pet_beast_cleave_buff) < GCD() * 2 or pet.BuffExpires(pet_beast_cleave_buff) } Spell(multi_shot)
	#chimaera_shot,if=focus<90
	if Focus() < 90 Spell(chimaera_shot)
	#cobra_shot,if=cooldown.kill_command.remains>focus.time_to_max&cooldown.bestial_wrath.remains>focus.time_to_max|(buff.bestial_wrath.up&focus.regen*cooldown.kill_command.remains>30)|target.time_to_die<cooldown.kill_command.remains
	if SpellCooldown(kill_command) > TimeToMaxFocus() and SpellCooldown(bestial_wrath) > TimeToMaxFocus() or BuffPresent(bestial_wrath_buff) and FocusRegenRate() * SpellCooldown(kill_command) > 30 or target.TimeToDie() < SpellCooldown(kill_command) Spell(cobra_shot)
}

AddFunction BeastMasteryDefaultMainPostConditions
{
}

AddFunction BeastMasteryDefaultShortCdActions
{
	unless CheckBoxOn(opt_volley) and Spell(volley)
	{
		#potion,name=prolonged_power,if=buff.bestial_wrath.remains|!cooldown.beastial_wrath.remains
		#a_murder_of_crows
		Spell(a_murder_of_crows)

		unless SpellCooldown(bestial_wrath) > 3 and Spell(dire_beast) or { SpellCooldown(bestial_wrath) > 6 or target.TimeToDie() < 9 } and Spell(dire_frenzy)
		{
			#barrage,if=spell_targets.barrage>1
			if Enemies() > 1 Spell(barrage)
			#titans_thunder,if=talent.dire_frenzy.enabled|cooldown.dire_beast.remains>=3|buff.bestial_wrath.up&pet.dire_beast.active
			if Talent(dire_frenzy_talent) or SpellCooldown(dire_beast) >= 3 or BuffPresent(bestial_wrath_buff) and pet.Present() Spell(titans_thunder)
			#bestial_wrath
			Spell(bestial_wrath)
		}
	}
}

AddFunction BeastMasteryDefaultShortCdPostConditions
{
	CheckBoxOn(opt_volley) and Spell(volley) or SpellCooldown(bestial_wrath) > 3 and Spell(dire_beast) or { SpellCooldown(bestial_wrath) > 6 or target.TimeToDie() < 9 } and Spell(dire_frenzy) or Enemies() > 4 and { pet.BuffRemaining(pet_beast_cleave_buff) < GCD() or pet.BuffExpires(pet_beast_cleave_buff) } and Spell(multi_shot) or pet.Present() and not pet.IsIncapacitated() and not pet.IsFeared() and not pet.IsStunned() and Spell(kill_command) or Enemies() > 1 and { pet.BuffRemaining(pet_beast_cleave_buff) < GCD() * 2 or pet.BuffExpires(pet_beast_cleave_buff) } and Spell(multi_shot) or Focus() < 90 and Spell(chimaera_shot) or { SpellCooldown(kill_command) > TimeToMaxFocus() and SpellCooldown(bestial_wrath) > TimeToMaxFocus() or BuffPresent(bestial_wrath_buff) and FocusRegenRate() * SpellCooldown(kill_command) > 30 or target.TimeToDie() < SpellCooldown(kill_command) } and Spell(cobra_shot)
}

AddFunction BeastMasteryDefaultCdActions
{
	#auto_shot
	#counter_shot
	BeastMasteryInterruptActions()
	#arcane_torrent,if=focus.deficit>=30
	if FocusDeficit() >= 30 Spell(arcane_torrent_focus)
	#berserking
	Spell(berserking)
	#blood_fury
	Spell(blood_fury_ap)

	unless CheckBoxOn(opt_volley) and Spell(volley) or Spell(a_murder_of_crows)
	{
		#stampede,if=buff.bloodlust.up|buff.bestial_wrath.up|cooldown.bestial_wrath.remains<=2|target.time_to_die<=14
		if BuffPresent(burst_haste_buff any=1) or BuffPresent(bestial_wrath_buff) or SpellCooldown(bestial_wrath) <= 2 or target.TimeToDie() <= 14 Spell(stampede)

		unless SpellCooldown(bestial_wrath) > 3 and Spell(dire_beast) or { SpellCooldown(bestial_wrath) > 6 or target.TimeToDie() < 9 } and Spell(dire_frenzy)
		{
			#aspect_of_the_wild,if=buff.bestial_wrath.up|target.time_to_die<12
			if BuffPresent(bestial_wrath_buff) or target.TimeToDie() < 12 Spell(aspect_of_the_wild)
		}
	}
}

AddFunction BeastMasteryDefaultCdPostConditions
{
	CheckBoxOn(opt_volley) and Spell(volley) or Spell(a_murder_of_crows) or SpellCooldown(bestial_wrath) > 3 and Spell(dire_beast) or { SpellCooldown(bestial_wrath) > 6 or target.TimeToDie() < 9 } and Spell(dire_frenzy) or Enemies() > 1 and Spell(barrage) or { Talent(dire_frenzy_talent) or SpellCooldown(dire_beast) >= 3 or BuffPresent(bestial_wrath_buff) and pet.Present() } and Spell(titans_thunder) or Enemies() > 4 and { pet.BuffRemaining(pet_beast_cleave_buff) < GCD() or pet.BuffExpires(pet_beast_cleave_buff) } and Spell(multi_shot) or pet.Present() and not pet.IsIncapacitated() and not pet.IsFeared() and not pet.IsStunned() and Spell(kill_command) or Enemies() > 1 and { pet.BuffRemaining(pet_beast_cleave_buff) < GCD() * 2 or pet.BuffExpires(pet_beast_cleave_buff) } and Spell(multi_shot) or Focus() < 90 and Spell(chimaera_shot) or { SpellCooldown(kill_command) > TimeToMaxFocus() and SpellCooldown(bestial_wrath) > TimeToMaxFocus() or BuffPresent(bestial_wrath_buff) and FocusRegenRate() * SpellCooldown(kill_command) > 30 or target.TimeToDie() < SpellCooldown(kill_command) } and Spell(cobra_shot)
}

### actions.precombat

AddFunction BeastMasteryPrecombatMainActions
{
	#snapshot_stats
	#potion,name=prolonged_power
	#augmentation,type=defiled
	Spell(augmentation)
}

AddFunction BeastMasteryPrecombatMainPostConditions
{
}

AddFunction BeastMasteryPrecombatShortCdActions
{
	#flask,type=flask_of_the_seventh_demon
	#food,type=nightborne_delicacy_platter
	#summon_pet
	BeastMasterySummonPet()
}

AddFunction BeastMasteryPrecombatShortCdPostConditions
{
	Spell(augmentation)
}

AddFunction BeastMasteryPrecombatCdActions
{
}

AddFunction BeastMasteryPrecombatCdPostConditions
{
	Spell(augmentation)
}

### BeastMastery icons.

AddCheckBox(opt_hunter_beast_mastery_aoe L(AOE) default specialization=beast_mastery)

AddIcon checkbox=!opt_hunter_beast_mastery_aoe enemies=1 help=shortcd specialization=beast_mastery
{
	if not InCombat() BeastMasteryPrecombatShortCdActions()
	unless not InCombat() and BeastMasteryPrecombatShortCdPostConditions()
	{
		BeastMasteryDefaultShortCdActions()
	}
}

AddIcon checkbox=opt_hunter_beast_mastery_aoe help=shortcd specialization=beast_mastery
{
	if not InCombat() BeastMasteryPrecombatShortCdActions()
	unless not InCombat() and BeastMasteryPrecombatShortCdPostConditions()
	{
		BeastMasteryDefaultShortCdActions()
	}
}

AddIcon enemies=1 help=main specialization=beast_mastery
{
	if not InCombat() BeastMasteryPrecombatMainActions()
	unless not InCombat() and BeastMasteryPrecombatMainPostConditions()
	{
		BeastMasteryDefaultMainActions()
	}
}

AddIcon checkbox=opt_hunter_beast_mastery_aoe help=aoe specialization=beast_mastery
{
	if not InCombat() BeastMasteryPrecombatMainActions()
	unless not InCombat() and BeastMasteryPrecombatMainPostConditions()
	{
		BeastMasteryDefaultMainActions()
	}
}

AddIcon checkbox=!opt_hunter_beast_mastery_aoe enemies=1 help=cd specialization=beast_mastery
{
	if not InCombat() BeastMasteryPrecombatCdActions()
	unless not InCombat() and BeastMasteryPrecombatCdPostConditions()
	{
		BeastMasteryDefaultCdActions()
	}
}

AddIcon checkbox=opt_hunter_beast_mastery_aoe help=cd specialization=beast_mastery
{
	if not InCombat() BeastMasteryPrecombatCdActions()
	unless not InCombat() and BeastMasteryPrecombatCdPostConditions()
	{
		BeastMasteryDefaultCdActions()
	}
}

### Required symbols
# a_murder_of_crows
# arcane_torrent_focus
# aspect_of_the_wild
# augmentation
# barrage
# berserking
# bestial_wrath
# bestial_wrath_buff
# blood_fury_ap
# chimaera_shot
# cobra_shot
# counter_shot
# dire_beast
# dire_frenzy
# dire_frenzy_talent
# kill_command
# multi_shot
# pet_beast_cleave_buff
# quaking_palm
# revive_pet
# stampede
# titans_thunder
# volley
# war_stomp
]]
	OvaleScripts:RegisterScript("HUNTER", "beast_mastery", name, desc, code, "script")
end

do
	local name = "simulationcraft_hunter_mm_t19p"
	local desc = "[7.0] SimulationCraft: Hunter_MM_T19P"
	local code = [[
# Based on SimulationCraft profile "Hunter_MM_T19P".
#	class=hunter
#	spec=marksmanship
#	talents=1303013

Include(ovale_common)
Include(ovale_trinkets_mop)
Include(ovale_trinkets_wod)
Include(ovale_hunter_spells)


AddFunction pooling_for_piercing
{
	Talent(piercing_shot_talent) and SpellCooldown(piercing_shot) < 5 and Focus() < 100 and not BuffPresent(lock_and_load_buff)
}

AddFunction safe_to_build
{
	target.DebuffExpires(hunters_mark_debuff) or BuffExpires(trueshot_buff) and BuffExpires(marking_targets_buff)
}

AddFunction vuln_aim_casts
{
	if target.DebuffRemaining(vulnerability_debuff) / { 2 * { 100 / { 100 + MeleeHaste() } } } > { FocusRegenRate() * { target.DebuffRemaining(vulnerability_debuff) - 2 * { 100 / { 100 + MeleeHaste() } } } + Focus() } / 50 { FocusRegenRate() * { target.DebuffRemaining(vulnerability_debuff) - 2 * { 100 / { 100 + MeleeHaste() } } } + Focus() } / 50
	target.DebuffRemaining(vulnerability_debuff) / { 2 * { 100 / { 100 + MeleeHaste() } } }
}

AddFunction use_multishot
{
	{ BuffPresent(marking_targets_buff) or BuffPresent(trueshot_buff) } and Enemies() > 1 or BuffExpires(marking_targets_buff) and BuffExpires(trueshot_buff) and Enemies() > 2
}

AddFunction trueshot_cooldown
{
	if TimeInCombat() > 15 and not SpellCooldown(trueshot) > 0 and 0 == 0 TimeInCombat() * 1.1
}

AddFunction sentinel_soon
{
	Talent(sentinel_talent) and not { not SpellCooldown(sentinel) > 0 } and { SpellCooldown(sentinel) > 50 and SpellCooldown(sentinel) < 50 + GCD() or SpellCooldown(sentinel) > 40 and SpellCooldown(sentinel) < 40 + GCD() }
}

AddFunction focus_after_vuln
{
	FocusRegenRate() * target.DebuffRemaining(vulnerability_debuff) - vuln_aim_casts() * 50
}

AddCheckBox(opt_interrupt L(interrupt) default specialization=marksmanship)
AddCheckBox(opt_volley SpellName(volley) default specialization=marksmanship)

AddFunction MarksmanshipInterruptActions
{
	if CheckBoxOn(opt_interrupt) and not target.IsFriend() and target.IsInterruptible()
	{
		Spell(counter_shot)
		if not target.Classification(worldboss)
		{
			Spell(arcane_torrent_focus)
			if target.InRange(quaking_palm) Spell(quaking_palm)
			Spell(war_stomp)
		}
	}
}

AddFunction MarksmanshipSummonPet
{
	if not Talent(lone_wolf_talent)
	{
		if pet.IsDead()
		{
			if not DebuffPresent(heart_of_the_phoenix_debuff) Spell(heart_of_the_phoenix)
			Spell(revive_pet)
		}
		if not pet.Present() and not pet.IsDead() and not PreviousSpell(revive_pet) Texture(ability_hunter_beastcall help=L(summon_pet))
	}
}

### actions.default

AddFunction MarksmanshipDefaultMainActions
{
	#volley,toggle=on
	if CheckBoxOn(opt_volley) Spell(volley)
	#call_action_list,name=cooldowns
	MarksmanshipCooldownsMainActions()

	unless MarksmanshipCooldownsMainPostConditions()
	{
		#call_action_list,name=targetdie,if=target.time_to_die<6&spell_targets.multishot=1
		if target.TimeToDie() < 6 and Enemies() == 1 MarksmanshipTargetdieMainActions()

		unless target.TimeToDie() < 6 and Enemies() == 1 and MarksmanshipTargetdieMainPostConditions()
		{
			#call_action_list,name=patient_sniper,if=talent.patient_sniper.enabled
			if Talent(patient_sniper_talent) MarksmanshipPatientSniperMainActions()

			unless Talent(patient_sniper_talent) and MarksmanshipPatientSniperMainPostConditions()
			{
				#call_action_list,name=non_patient_sniper,if=!talent.patient_sniper.enabled
				if not Talent(patient_sniper_talent) MarksmanshipNonPatientSniperMainActions()
			}
		}
	}
}

AddFunction MarksmanshipDefaultMainPostConditions
{
	MarksmanshipCooldownsMainPostConditions() or target.TimeToDie() < 6 and Enemies() == 1 and MarksmanshipTargetdieMainPostConditions() or Talent(patient_sniper_talent) and MarksmanshipPatientSniperMainPostConditions() or not Talent(patient_sniper_talent) and MarksmanshipNonPatientSniperMainPostConditions()
}

AddFunction MarksmanshipDefaultShortCdActions
{
	unless CheckBoxOn(opt_volley) and Spell(volley)
	{
		#variable,name=safe_to_build,value=debuff.hunters_mark.down|(buff.trueshot.down&buff.marking_targets.down)
		#variable,name=use_multishot,value=((buff.marking_targets.up|buff.trueshot.up)&spell_targets.multishot>1)|(buff.marking_targets.down&buff.trueshot.down&spell_targets.multishot>2)
		#variable,name=pooling_for_piercing,value=talent.piercing_shot.enabled&cooldown.piercing_shot.remains<5&focus<100&!buff.lock_and_load.up
		#variable,name=sentinel_soon,value=talent.sentinel.enabled&!cooldown.sentinel.up&((cooldown.sentinel.remains>50&cooldown.sentinel.remains<(50+gcd.max))|(cooldown.sentinel.remains>40&cooldown.sentinel.remains<(40+gcd.max)))
		#a_murder_of_crows,if=time=0
		if TimeInCombat() == 0 Spell(a_murder_of_crows)
		#call_action_list,name=cooldowns
		MarksmanshipCooldownsShortCdActions()

		unless MarksmanshipCooldownsShortCdPostConditions()
		{
			#call_action_list,name=targetdie,if=target.time_to_die<6&spell_targets.multishot=1
			if target.TimeToDie() < 6 and Enemies() == 1 MarksmanshipTargetdieShortCdActions()

			unless target.TimeToDie() < 6 and Enemies() == 1 and MarksmanshipTargetdieShortCdPostConditions()
			{
				#call_action_list,name=patient_sniper,if=talent.patient_sniper.enabled
				if Talent(patient_sniper_talent) MarksmanshipPatientSniperShortCdActions()

				unless Talent(patient_sniper_talent) and MarksmanshipPatientSniperShortCdPostConditions()
				{
					#call_action_list,name=non_patient_sniper,if=!talent.patient_sniper.enabled
					if not Talent(patient_sniper_talent) MarksmanshipNonPatientSniperShortCdActions()
				}
			}
		}
	}
}

AddFunction MarksmanshipDefaultShortCdPostConditions
{
	CheckBoxOn(opt_volley) and Spell(volley) or MarksmanshipCooldownsShortCdPostConditions() or target.TimeToDie() < 6 and Enemies() == 1 and MarksmanshipTargetdieShortCdPostConditions() or Talent(patient_sniper_talent) and MarksmanshipPatientSniperShortCdPostConditions() or not Talent(patient_sniper_talent) and MarksmanshipNonPatientSniperShortCdPostConditions()
}

AddFunction MarksmanshipDefaultCdActions
{
	#auto_shot
	#arcane_torrent,if=focus.deficit>=30&(!talent.sidewinders.enabled|cooldown.sidewinders.charges<2)
	if FocusDeficit() >= 30 and { not Talent(sidewinders_talent) or SpellChargeCooldown(sidewinders) < 2 } Spell(arcane_torrent_focus)
	#counter_shot
	MarksmanshipInterruptActions()
	#berserking,if=buff.trueshot.up
	if BuffPresent(trueshot_buff) Spell(berserking)
	#blood_fury,if=buff.trueshot.up
	if BuffPresent(trueshot_buff) Spell(blood_fury_ap)

	unless CheckBoxOn(opt_volley) and Spell(volley) or TimeInCombat() == 0 and Spell(a_murder_of_crows)
	{
		#call_action_list,name=cooldowns
		MarksmanshipCooldownsCdActions()

		unless MarksmanshipCooldownsCdPostConditions()
		{
			#call_action_list,name=targetdie,if=target.time_to_die<6&spell_targets.multishot=1
			if target.TimeToDie() < 6 and Enemies() == 1 MarksmanshipTargetdieCdActions()

			unless target.TimeToDie() < 6 and Enemies() == 1 and MarksmanshipTargetdieCdPostConditions()
			{
				#call_action_list,name=patient_sniper,if=talent.patient_sniper.enabled
				if Talent(patient_sniper_talent) MarksmanshipPatientSniperCdActions()

				unless Talent(patient_sniper_talent) and MarksmanshipPatientSniperCdPostConditions()
				{
					#call_action_list,name=non_patient_sniper,if=!talent.patient_sniper.enabled
					if not Talent(patient_sniper_talent) MarksmanshipNonPatientSniperCdActions()
				}
			}
		}
	}
}

AddFunction MarksmanshipDefaultCdPostConditions
{
	CheckBoxOn(opt_volley) and Spell(volley) or TimeInCombat() == 0 and Spell(a_murder_of_crows) or MarksmanshipCooldownsCdPostConditions() or target.TimeToDie() < 6 and Enemies() == 1 and MarksmanshipTargetdieCdPostConditions() or Talent(patient_sniper_talent) and MarksmanshipPatientSniperCdPostConditions() or not Talent(patient_sniper_talent) and MarksmanshipNonPatientSniperCdPostConditions()
}

### actions.cooldowns

AddFunction MarksmanshipCooldownsMainActions
{
}

AddFunction MarksmanshipCooldownsMainPostConditions
{
}

AddFunction MarksmanshipCooldownsShortCdActions
{
}

AddFunction MarksmanshipCooldownsShortCdPostConditions
{
}

AddFunction MarksmanshipCooldownsCdActions
{
	#potion,name=prolonged_power,if=spell_targets.multishot>2&((buff.trueshot.react&buff.bloodlust.react)|buff.bullseye.react>=23|target.time_to_die<62)
	#potion,name=deadly_grace,if=(buff.trueshot.react&buff.bloodlust.react)|buff.bullseye.react>=23|target.time_to_die<31
	#variable,name=trueshot_cooldown,op=set,value=time*1.1,if=time>15&cooldown.trueshot.up&variable.trueshot_cooldown=0
	#trueshot,if=time<=15|buff.bloodlust.react|(variable.trueshot_cooldown>0&target.time_to_die>(variable.trueshot_cooldown+duration))|buff.bullseye.react>25|target.time_to_die<16
	if TimeInCombat() <= 15 or BuffPresent(burst_haste_buff any=1) or trueshot_cooldown() > 0 and target.TimeToDie() > trueshot_cooldown() + BaseDuration(trueshot_buff) or BuffStacks(bullseye_buff) > 25 or target.TimeToDie() < 16 Spell(trueshot)
}

AddFunction MarksmanshipCooldownsCdPostConditions
{
}

### actions.non_patient_sniper

AddFunction MarksmanshipNonPatientSniperMainActions
{
	#windburst,if=debuff.vulnerability.remains<(2*attack_haste)
	if target.DebuffRemaining(vulnerability_debuff) < 2 * { 100 / { 100 + MeleeHaste() } } Spell(windburst)
	#black_arrow,if=debuff.vulnerability.remains<(2*attack_haste)
	if target.DebuffRemaining(vulnerability_debuff) < 2 * { 100 / { 100 + MeleeHaste() } } Spell(black_arrow)
	#sidewinders,if=variable.safe_to_build&focus.deficit>60&(((buff.marking_targets.up|buff.trueshot.up)&charges_fractional>1.2)|charges_fractional>1.8)&!variable.sentinel_soon
	if safe_to_build() and FocusDeficit() > 60 and { { BuffPresent(marking_targets_buff) or BuffPresent(trueshot_buff) } and Charges(sidewinders count=0) > 1.2 or Charges(sidewinders count=0) > 1.8 } and not sentinel_soon() Spell(sidewinders)
	#marked_shot,if=cooldown.sentinel.remains>40|spell_targets.multishot>1
	if SpellCooldown(sentinel) > 40 or Enemies() > 1 Spell(marked_shot)
	#marked_shot,if=talent.sidewinders.enabled&((debuff.vulnerability.remains<1&cooldown.sidewinders.charges_fractional<1.5&focus.deficit<80)|(cooldown.sidewinders.charges_fractional>1.7))
	if Talent(sidewinders_talent) and { target.DebuffRemaining(vulnerability_debuff) < 1 and SpellCharges(sidewinders count=0) < 1.5 and FocusDeficit() < 80 or SpellCharges(sidewinders count=0) > 1.7 } Spell(marked_shot)
	#marked_shot,if=!talent.sidewinders.enabled&debuff.vulnerability.remains<(2*attack_haste)
	if not Talent(sidewinders_talent) and target.DebuffRemaining(vulnerability_debuff) < 2 * { 100 / { 100 + MeleeHaste() } } Spell(marked_shot)
	#aimed_shot,if=(debuff.vulnerability.remains>execute_time|(focus>80&cooldown.windburst.remains>3))&!variable.pooling_for_piercing
	if { target.DebuffRemaining(vulnerability_debuff) > ExecuteTime(aimed_shot) or Focus() > 80 and SpellCooldown(windburst) > 3 } and not pooling_for_piercing() Spell(aimed_shot)
	#arcane_shot,if=spell_targets.multishot<2
	if Enemies() < 2 Spell(arcane_shot)
	#multishot,if=spell_targets.multishot>1
	if Enemies() > 1 Spell(multishot)
}

AddFunction MarksmanshipNonPatientSniperMainPostConditions
{
}

AddFunction MarksmanshipNonPatientSniperShortCdActions
{
	unless target.DebuffRemaining(vulnerability_debuff) < 2 * { 100 / { 100 + MeleeHaste() } } and Spell(windburst)
	{
		#piercing_shot,if=debuff.vulnerability.up&focus>90
		if target.DebuffPresent(vulnerability_debuff) and Focus() > 90 Spell(piercing_shot)

		unless target.DebuffRemaining(vulnerability_debuff) < 2 * { 100 / { 100 + MeleeHaste() } } and Spell(black_arrow)
		{
			#explosive_shot,if=debuff.vulnerability.remains<(2*attack_haste)|spell_targets.explosive_shot>1
			if target.DebuffRemaining(vulnerability_debuff) < 2 * { 100 / { 100 + MeleeHaste() } } or Enemies() > 1 Spell(explosive_shot)
			#a_murder_of_crows,if=debuff.vulnerability.remains<(2*attack_haste)
			if target.DebuffRemaining(vulnerability_debuff) < 2 * { 100 / { 100 + MeleeHaste() } } Spell(a_murder_of_crows)
			#barrage,if=spell_targets>1|(target.health.pct<20&buff.bullseye.stack<25)
			if Enemies() > 1 or target.HealthPercent() < 20 and BuffStacks(bullseye_buff) < 25 Spell(barrage)
			#sentinel,if=debuff.hunters_mark.down
			if target.DebuffExpires(hunters_mark_debuff) Spell(sentinel)
		}
	}
}

AddFunction MarksmanshipNonPatientSniperShortCdPostConditions
{
	target.DebuffRemaining(vulnerability_debuff) < 2 * { 100 / { 100 + MeleeHaste() } } and Spell(windburst) or target.DebuffRemaining(vulnerability_debuff) < 2 * { 100 / { 100 + MeleeHaste() } } and Spell(black_arrow) or safe_to_build() and FocusDeficit() > 60 and { { BuffPresent(marking_targets_buff) or BuffPresent(trueshot_buff) } and Charges(sidewinders count=0) > 1.2 or Charges(sidewinders count=0) > 1.8 } and not sentinel_soon() and Spell(sidewinders) or { SpellCooldown(sentinel) > 40 or Enemies() > 1 } and Spell(marked_shot) or Talent(sidewinders_talent) and { target.DebuffRemaining(vulnerability_debuff) < 1 and SpellCharges(sidewinders count=0) < 1.5 and FocusDeficit() < 80 or SpellCharges(sidewinders count=0) > 1.7 } and Spell(marked_shot) or not Talent(sidewinders_talent) and target.DebuffRemaining(vulnerability_debuff) < 2 * { 100 / { 100 + MeleeHaste() } } and Spell(marked_shot) or { target.DebuffRemaining(vulnerability_debuff) > ExecuteTime(aimed_shot) or Focus() > 80 and SpellCooldown(windburst) > 3 } and not pooling_for_piercing() and Spell(aimed_shot) or Enemies() < 2 and Spell(arcane_shot) or Enemies() > 1 and Spell(multishot)
}

AddFunction MarksmanshipNonPatientSniperCdActions
{
}

AddFunction MarksmanshipNonPatientSniperCdPostConditions
{
	target.DebuffRemaining(vulnerability_debuff) < 2 * { 100 / { 100 + MeleeHaste() } } and Spell(windburst) or target.DebuffPresent(vulnerability_debuff) and Focus() > 90 and Spell(piercing_shot) or target.DebuffRemaining(vulnerability_debuff) < 2 * { 100 / { 100 + MeleeHaste() } } and Spell(black_arrow) or { target.DebuffRemaining(vulnerability_debuff) < 2 * { 100 / { 100 + MeleeHaste() } } or Enemies() > 1 } and Spell(explosive_shot) or target.DebuffRemaining(vulnerability_debuff) < 2 * { 100 / { 100 + MeleeHaste() } } and Spell(a_murder_of_crows) or { Enemies() > 1 or target.HealthPercent() < 20 and BuffStacks(bullseye_buff) < 25 } and Spell(barrage) or target.DebuffExpires(hunters_mark_debuff) and Spell(sentinel) or safe_to_build() and FocusDeficit() > 60 and { { BuffPresent(marking_targets_buff) or BuffPresent(trueshot_buff) } and Charges(sidewinders count=0) > 1.2 or Charges(sidewinders count=0) > 1.8 } and not sentinel_soon() and Spell(sidewinders) or { SpellCooldown(sentinel) > 40 or Enemies() > 1 } and Spell(marked_shot) or Talent(sidewinders_talent) and { target.DebuffRemaining(vulnerability_debuff) < 1 and SpellCharges(sidewinders count=0) < 1.5 and FocusDeficit() < 80 or SpellCharges(sidewinders count=0) > 1.7 } and Spell(marked_shot) or not Talent(sidewinders_talent) and target.DebuffRemaining(vulnerability_debuff) < 2 * { 100 / { 100 + MeleeHaste() } } and Spell(marked_shot) or { target.DebuffRemaining(vulnerability_debuff) > ExecuteTime(aimed_shot) or Focus() > 80 and SpellCooldown(windburst) > 3 } and not pooling_for_piercing() and Spell(aimed_shot) or Enemies() < 2 and Spell(arcane_shot) or Enemies() > 1 and Spell(multishot)
}

### actions.patient_sniper

AddFunction MarksmanshipPatientSniperMainActions
{
	#variable,name=vuln_aim_casts,op=set,value=floor(debuff.vulnerability.remains%(2*attack_haste))
	#variable,name=vuln_aim_casts,op=set,value=floor((focus.regen*(debuff.vulnerability.remains-(2*attack_haste))+focus)%50),if=variable.vuln_aim_casts>floor((focus.regen*(debuff.vulnerability.remains-(2*attack_haste))+focus)%50)
	#variable,name=focus_after_vuln,op=set,value=(focus.regen*debuff.vulnerability.remains)-(variable.vuln_aim_casts*50)
	#sidewinders,if=buff.trueshot.up&(debuff.vulnerability.remains<(2*attack_haste)|focus<35)&(spell_targets.sidewinders<2|debuff.hunters_mark.down)
	if BuffPresent(trueshot_buff) and { target.DebuffRemaining(vulnerability_debuff) < 2 * { 100 / { 100 + MeleeHaste() } } or Focus() < 35 } and { Enemies() < 2 or target.DebuffExpires(hunters_mark_debuff) } Spell(sidewinders)
	#sidewinders,if=buff.trueshot.down&debuff.vulnerability.remains<(2*attack_haste)&focus<60&(debuff.hunters_mark.down|(charges_fractional>1.3&spell_targets.sidewinders<2))
	if BuffExpires(trueshot_buff) and target.DebuffRemaining(vulnerability_debuff) < 2 * { 100 / { 100 + MeleeHaste() } } and Focus() < 60 and { target.DebuffExpires(hunters_mark_debuff) or Charges(sidewinders count=0) > 1.3 and Enemies() < 2 } Spell(sidewinders)
	#windburst,if=debuff.vulnerability.remains<(2*attack_haste)&(talent.sidewinders.enabled|focus>60)&!variable.pooling_for_piercing
	if target.DebuffRemaining(vulnerability_debuff) < 2 * { 100 / { 100 + MeleeHaste() } } and { Talent(sidewinders_talent) or Focus() > 60 } and not pooling_for_piercing() Spell(windburst)
	#black_arrow
	Spell(black_arrow)
	#marked_shot,if=!talent.sidewinders.enabled&spell_targets.multishot>1&(!variable.pooling_for_piercing|debuff.vulnerability.up)
	if not Talent(sidewinders_talent) and Enemies() > 1 and { not pooling_for_piercing() or target.DebuffPresent(vulnerability_debuff) } Spell(marked_shot)
	#marked_shot,if=talent.sidewinders.enabled&((debuff.vulnerability.remains<(2*attack_haste)&focus>50)|spell_targets.sidewinders>1)
	if Talent(sidewinders_talent) and { target.DebuffRemaining(vulnerability_debuff) < 2 * { 100 / { 100 + MeleeHaste() } } and Focus() > 50 or Enemies() > 1 } Spell(marked_shot)
	#marked_shot,if=!talent.sidewinders.enabled&spell_targets.multishot<2&debuff.vulnerability.remains<(2*attack_haste)&(debuff.hunters_mark.remains<gcd|focus>90)
	if not Talent(sidewinders_talent) and Enemies() < 2 and target.DebuffRemaining(vulnerability_debuff) < 2 * { 100 / { 100 + MeleeHaste() } } and { target.DebuffRemaining(hunters_mark_debuff) < GCD() or Focus() > 90 } Spell(marked_shot)
	#aimed_shot,if=debuff.vulnerability.remains>execute_time&(buff.trueshot.up|buff.lock_and_load.up)&(spell_targets.multishot<2|talent.sidewinders.enabled)&!variable.pooling_for_piercing
	if target.DebuffRemaining(vulnerability_debuff) > ExecuteTime(aimed_shot) and { BuffPresent(trueshot_buff) or BuffPresent(lock_and_load_buff) } and { Enemies() < 2 or Talent(sidewinders_talent) } and not pooling_for_piercing() Spell(aimed_shot)
	#aimed_shot,if=talent.sidewinders.enabled&variable.focus_after_vuln>60&!debuff.hunters_mark.up
	if Talent(sidewinders_talent) and focus_after_vuln() > 60 and not target.DebuffPresent(hunters_mark_debuff) Spell(aimed_shot)
	#aimed_shot,if=debuff.vulnerability.remains>execute_time&debuff.vulnerability.remains-execute_time<1&!variable.pooling_for_piercing
	if target.DebuffRemaining(vulnerability_debuff) > ExecuteTime(aimed_shot) and target.DebuffRemaining(vulnerability_debuff) - ExecuteTime(aimed_shot) < 1 and not pooling_for_piercing() Spell(aimed_shot)
	#aimed_shot,if=debuff.vulnerability.remains>(execute_time*2)&(debuff.vulnerability.remains-(execute_time*2))<1&(focus+focus.regen*(debuff.vulnerability.remains-execute_time))>100&!variable.pooling_for_piercing
	if target.DebuffRemaining(vulnerability_debuff) > ExecuteTime(aimed_shot) * 2 and target.DebuffRemaining(vulnerability_debuff) - ExecuteTime(aimed_shot) * 2 < 1 and Focus() + FocusRegenRate() * { target.DebuffRemaining(vulnerability_debuff) - ExecuteTime(aimed_shot) } > 100 and not pooling_for_piercing() Spell(aimed_shot)
	#aimed_shot,if=cast_regen+focus>focus.max&(debuff.vulnerability.remains>execute_time|cooldown.windburst.remains>3)&!variable.pooling_for_piercing
	if FocusCastingRegen(aimed_shot) + Focus() > MaxFocus() and { target.DebuffRemaining(vulnerability_debuff) > ExecuteTime(aimed_shot) or SpellCooldown(windburst) > 3 } and not pooling_for_piercing() Spell(aimed_shot)
	#arcane_shot,if=buff.trueshot.up&spell_targets.multishot<2
	if BuffPresent(trueshot_buff) and Enemies() < 2 Spell(arcane_shot)
	#multishot,if=buff.trueshot.up&spell_targets.multishot>1
	if BuffPresent(trueshot_buff) and Enemies() > 1 Spell(multishot)
	#arcane_shot,if=spell_targets.multishot<2&(debuff.vulnerability.remains<(2*attack_haste)|(debuff.vulnerability.remains>(variable.vuln_aim_casts*2*attack_haste+gcd)&(debuff.vulnerability.remains-(variable.vuln_aim_casts*2*attack_haste+gcd))<1))
	if Enemies() < 2 and { target.DebuffRemaining(vulnerability_debuff) < 2 * { 100 / { 100 + MeleeHaste() } } or target.DebuffRemaining(vulnerability_debuff) > vuln_aim_casts() * 2 * { 100 / { 100 + MeleeHaste() } } + GCD() and target.DebuffRemaining(vulnerability_debuff) - { vuln_aim_casts() * 2 * { 100 / { 100 + MeleeHaste() } } + GCD() } < 1 } Spell(arcane_shot)
	#multishot,if=spell_targets.multishot>1&(debuff.vulnerability.remains<(2*attack_haste)|(debuff.vulnerability.remains>(variable.vuln_aim_casts*2*attack_haste+gcd)&(debuff.vulnerability.remains-(variable.vuln_aim_casts*2*attack_haste+gcd))<1))
	if Enemies() > 1 and { target.DebuffRemaining(vulnerability_debuff) < 2 * { 100 / { 100 + MeleeHaste() } } or target.DebuffRemaining(vulnerability_debuff) > vuln_aim_casts() * 2 * { 100 / { 100 + MeleeHaste() } } + GCD() and target.DebuffRemaining(vulnerability_debuff) - { vuln_aim_casts() * 2 * { 100 / { 100 + MeleeHaste() } } + GCD() } < 1 } Spell(multishot)
}

AddFunction MarksmanshipPatientSniperMainPostConditions
{
}

AddFunction MarksmanshipPatientSniperShortCdActions
{
	unless BuffPresent(trueshot_buff) and { target.DebuffRemaining(vulnerability_debuff) < 2 * { 100 / { 100 + MeleeHaste() } } or Focus() < 35 } and { Enemies() < 2 or target.DebuffExpires(hunters_mark_debuff) } and Spell(sidewinders) or BuffExpires(trueshot_buff) and target.DebuffRemaining(vulnerability_debuff) < 2 * { 100 / { 100 + MeleeHaste() } } and Focus() < 60 and { target.DebuffExpires(hunters_mark_debuff) or Charges(sidewinders count=0) > 1.3 and Enemies() < 2 } and Spell(sidewinders) or target.DebuffRemaining(vulnerability_debuff) < 2 * { 100 / { 100 + MeleeHaste() } } and { Talent(sidewinders_talent) or Focus() > 60 } and not pooling_for_piercing() and Spell(windburst) or Spell(black_arrow)
	{
		#a_murder_of_crows,if=(target.time_to_die>=cooldown+duration|target.health.pct<20|target.time_to_die<16)&(debuff.vulnerability.remains<1|debuff.vulnerability.remains>(4*attack_haste+gcd))
		if { target.TimeToDie() >= SpellCooldown(a_murder_of_crows) + BaseDuration(a_murder_of_crows_debuff) or target.HealthPercent() < 20 or target.TimeToDie() < 16 } and { target.DebuffRemaining(vulnerability_debuff) < 1 or target.DebuffRemaining(vulnerability_debuff) > 4 * { 100 / { 100 + MeleeHaste() } } + GCD() } Spell(a_murder_of_crows)
		#barrage,if=spell_targets>1|(target.health.pct<20&buff.bullseye.stack<25)
		if Enemies() > 1 or target.HealthPercent() < 20 and BuffStacks(bullseye_buff) < 25 Spell(barrage)
		#piercing_shot,if=debuff.vulnerability.up&debuff.vulnerability.remains<4&focus>80
		if target.DebuffPresent(vulnerability_debuff) and target.DebuffRemaining(vulnerability_debuff) < 4 and Focus() > 80 Spell(piercing_shot)
	}
}

AddFunction MarksmanshipPatientSniperShortCdPostConditions
{
	BuffPresent(trueshot_buff) and { target.DebuffRemaining(vulnerability_debuff) < 2 * { 100 / { 100 + MeleeHaste() } } or Focus() < 35 } and { Enemies() < 2 or target.DebuffExpires(hunters_mark_debuff) } and Spell(sidewinders) or BuffExpires(trueshot_buff) and target.DebuffRemaining(vulnerability_debuff) < 2 * { 100 / { 100 + MeleeHaste() } } and Focus() < 60 and { target.DebuffExpires(hunters_mark_debuff) or Charges(sidewinders count=0) > 1.3 and Enemies() < 2 } and Spell(sidewinders) or target.DebuffRemaining(vulnerability_debuff) < 2 * { 100 / { 100 + MeleeHaste() } } and { Talent(sidewinders_talent) or Focus() > 60 } and not pooling_for_piercing() and Spell(windburst) or Spell(black_arrow) or not Talent(sidewinders_talent) and Enemies() > 1 and { not pooling_for_piercing() or target.DebuffPresent(vulnerability_debuff) } and Spell(marked_shot) or Talent(sidewinders_talent) and { target.DebuffRemaining(vulnerability_debuff) < 2 * { 100 / { 100 + MeleeHaste() } } and Focus() > 50 or Enemies() > 1 } and Spell(marked_shot) or not Talent(sidewinders_talent) and Enemies() < 2 and target.DebuffRemaining(vulnerability_debuff) < 2 * { 100 / { 100 + MeleeHaste() } } and { target.DebuffRemaining(hunters_mark_debuff) < GCD() or Focus() > 90 } and Spell(marked_shot) or target.DebuffRemaining(vulnerability_debuff) > ExecuteTime(aimed_shot) and { BuffPresent(trueshot_buff) or BuffPresent(lock_and_load_buff) } and { Enemies() < 2 or Talent(sidewinders_talent) } and not pooling_for_piercing() and Spell(aimed_shot) or Talent(sidewinders_talent) and focus_after_vuln() > 60 and not target.DebuffPresent(hunters_mark_debuff) and Spell(aimed_shot) or target.DebuffRemaining(vulnerability_debuff) > ExecuteTime(aimed_shot) and target.DebuffRemaining(vulnerability_debuff) - ExecuteTime(aimed_shot) < 1 and not pooling_for_piercing() and Spell(aimed_shot) or target.DebuffRemaining(vulnerability_debuff) > ExecuteTime(aimed_shot) * 2 and target.DebuffRemaining(vulnerability_debuff) - ExecuteTime(aimed_shot) * 2 < 1 and Focus() + FocusRegenRate() * { target.DebuffRemaining(vulnerability_debuff) - ExecuteTime(aimed_shot) } > 100 and not pooling_for_piercing() and Spell(aimed_shot) or FocusCastingRegen(aimed_shot) + Focus() > MaxFocus() and { target.DebuffRemaining(vulnerability_debuff) > ExecuteTime(aimed_shot) or SpellCooldown(windburst) > 3 } and not pooling_for_piercing() and Spell(aimed_shot) or BuffPresent(trueshot_buff) and Enemies() < 2 and Spell(arcane_shot) or BuffPresent(trueshot_buff) and Enemies() > 1 and Spell(multishot) or Enemies() < 2 and { target.DebuffRemaining(vulnerability_debuff) < 2 * { 100 / { 100 + MeleeHaste() } } or target.DebuffRemaining(vulnerability_debuff) > vuln_aim_casts() * 2 * { 100 / { 100 + MeleeHaste() } } + GCD() and target.DebuffRemaining(vulnerability_debuff) - { vuln_aim_casts() * 2 * { 100 / { 100 + MeleeHaste() } } + GCD() } < 1 } and Spell(arcane_shot) or Enemies() > 1 and { target.DebuffRemaining(vulnerability_debuff) < 2 * { 100 / { 100 + MeleeHaste() } } or target.DebuffRemaining(vulnerability_debuff) > vuln_aim_casts() * 2 * { 100 / { 100 + MeleeHaste() } } + GCD() and target.DebuffRemaining(vulnerability_debuff) - { vuln_aim_casts() * 2 * { 100 / { 100 + MeleeHaste() } } + GCD() } < 1 } and Spell(multishot)
}

AddFunction MarksmanshipPatientSniperCdActions
{
}

AddFunction MarksmanshipPatientSniperCdPostConditions
{
	BuffPresent(trueshot_buff) and { target.DebuffRemaining(vulnerability_debuff) < 2 * { 100 / { 100 + MeleeHaste() } } or Focus() < 35 } and { Enemies() < 2 or target.DebuffExpires(hunters_mark_debuff) } and Spell(sidewinders) or BuffExpires(trueshot_buff) and target.DebuffRemaining(vulnerability_debuff) < 2 * { 100 / { 100 + MeleeHaste() } } and Focus() < 60 and { target.DebuffExpires(hunters_mark_debuff) or Charges(sidewinders count=0) > 1.3 and Enemies() < 2 } and Spell(sidewinders) or target.DebuffRemaining(vulnerability_debuff) < 2 * { 100 / { 100 + MeleeHaste() } } and { Talent(sidewinders_talent) or Focus() > 60 } and not pooling_for_piercing() and Spell(windburst) or Spell(black_arrow) or { target.TimeToDie() >= SpellCooldown(a_murder_of_crows) + BaseDuration(a_murder_of_crows_debuff) or target.HealthPercent() < 20 or target.TimeToDie() < 16 } and { target.DebuffRemaining(vulnerability_debuff) < 1 or target.DebuffRemaining(vulnerability_debuff) > 4 * { 100 / { 100 + MeleeHaste() } } + GCD() } and Spell(a_murder_of_crows) or { Enemies() > 1 or target.HealthPercent() < 20 and BuffStacks(bullseye_buff) < 25 } and Spell(barrage) or target.DebuffPresent(vulnerability_debuff) and target.DebuffRemaining(vulnerability_debuff) < 4 and Focus() > 80 and Spell(piercing_shot) or not Talent(sidewinders_talent) and Enemies() > 1 and { not pooling_for_piercing() or target.DebuffPresent(vulnerability_debuff) } and Spell(marked_shot) or Talent(sidewinders_talent) and { target.DebuffRemaining(vulnerability_debuff) < 2 * { 100 / { 100 + MeleeHaste() } } and Focus() > 50 or Enemies() > 1 } and Spell(marked_shot) or not Talent(sidewinders_talent) and Enemies() < 2 and target.DebuffRemaining(vulnerability_debuff) < 2 * { 100 / { 100 + MeleeHaste() } } and { target.DebuffRemaining(hunters_mark_debuff) < GCD() or Focus() > 90 } and Spell(marked_shot) or target.DebuffRemaining(vulnerability_debuff) > ExecuteTime(aimed_shot) and { BuffPresent(trueshot_buff) or BuffPresent(lock_and_load_buff) } and { Enemies() < 2 or Talent(sidewinders_talent) } and not pooling_for_piercing() and Spell(aimed_shot) or Talent(sidewinders_talent) and focus_after_vuln() > 60 and not target.DebuffPresent(hunters_mark_debuff) and Spell(aimed_shot) or target.DebuffRemaining(vulnerability_debuff) > ExecuteTime(aimed_shot) and target.DebuffRemaining(vulnerability_debuff) - ExecuteTime(aimed_shot) < 1 and not pooling_for_piercing() and Spell(aimed_shot) or target.DebuffRemaining(vulnerability_debuff) > ExecuteTime(aimed_shot) * 2 and target.DebuffRemaining(vulnerability_debuff) - ExecuteTime(aimed_shot) * 2 < 1 and Focus() + FocusRegenRate() * { target.DebuffRemaining(vulnerability_debuff) - ExecuteTime(aimed_shot) } > 100 and not pooling_for_piercing() and Spell(aimed_shot) or FocusCastingRegen(aimed_shot) + Focus() > MaxFocus() and { target.DebuffRemaining(vulnerability_debuff) > ExecuteTime(aimed_shot) or SpellCooldown(windburst) > 3 } and not pooling_for_piercing() and Spell(aimed_shot) or BuffPresent(trueshot_buff) and Enemies() < 2 and Spell(arcane_shot) or BuffPresent(trueshot_buff) and Enemies() > 1 and Spell(multishot) or Enemies() < 2 and { target.DebuffRemaining(vulnerability_debuff) < 2 * { 100 / { 100 + MeleeHaste() } } or target.DebuffRemaining(vulnerability_debuff) > vuln_aim_casts() * 2 * { 100 / { 100 + MeleeHaste() } } + GCD() and target.DebuffRemaining(vulnerability_debuff) - { vuln_aim_casts() * 2 * { 100 / { 100 + MeleeHaste() } } + GCD() } < 1 } and Spell(arcane_shot) or Enemies() > 1 and { target.DebuffRemaining(vulnerability_debuff) < 2 * { 100 / { 100 + MeleeHaste() } } or target.DebuffRemaining(vulnerability_debuff) > vuln_aim_casts() * 2 * { 100 / { 100 + MeleeHaste() } } + GCD() and target.DebuffRemaining(vulnerability_debuff) - { vuln_aim_casts() * 2 * { 100 / { 100 + MeleeHaste() } } + GCD() } < 1 } and Spell(multishot)
}

### actions.precombat

AddFunction MarksmanshipPrecombatMainActions
{
	#snapshot_stats
	#potion,name=prolonged_power,if=spell_targets.multishot>2
	#potion,name=deadly_grace
	#augmentation,type=defiled
	Spell(augmentation)
	#windburst
	Spell(windburst)
}

AddFunction MarksmanshipPrecombatMainPostConditions
{
}

AddFunction MarksmanshipPrecombatShortCdActions
{
	#flask,type=flask_of_the_seventh_demon
	#food,type=nightborne_delicacy_platter
	#summon_pet
	MarksmanshipSummonPet()
}

AddFunction MarksmanshipPrecombatShortCdPostConditions
{
	Spell(augmentation) or Spell(windburst)
}

AddFunction MarksmanshipPrecombatCdActions
{
}

AddFunction MarksmanshipPrecombatCdPostConditions
{
	Spell(augmentation) or Spell(windburst)
}

### actions.targetdie

AddFunction MarksmanshipTargetdieMainActions
{
	#windburst
	Spell(windburst)
	#aimed_shot,if=debuff.vulnerability.remains>execute_time&target.time_to_die>execute_time
	if target.DebuffRemaining(vulnerability_debuff) > ExecuteTime(aimed_shot) and target.TimeToDie() > ExecuteTime(aimed_shot) Spell(aimed_shot)
	#sidewinders
	Spell(sidewinders)
	#marked_shot
	Spell(marked_shot)
	#aimed_shot
	Spell(aimed_shot)
	#arcane_shot
	Spell(arcane_shot)
}

AddFunction MarksmanshipTargetdieMainPostConditions
{
}

AddFunction MarksmanshipTargetdieShortCdActions
{
}

AddFunction MarksmanshipTargetdieShortCdPostConditions
{
	Spell(windburst) or target.DebuffRemaining(vulnerability_debuff) > ExecuteTime(aimed_shot) and target.TimeToDie() > ExecuteTime(aimed_shot) and Spell(aimed_shot) or Spell(sidewinders) or Spell(marked_shot) or Spell(aimed_shot) or Spell(arcane_shot)
}

AddFunction MarksmanshipTargetdieCdActions
{
}

AddFunction MarksmanshipTargetdieCdPostConditions
{
	Spell(windburst) or target.DebuffRemaining(vulnerability_debuff) > ExecuteTime(aimed_shot) and target.TimeToDie() > ExecuteTime(aimed_shot) and Spell(aimed_shot) or Spell(sidewinders) or Spell(marked_shot) or Spell(aimed_shot) or Spell(arcane_shot)
}

### Marksmanship icons.

AddCheckBox(opt_hunter_marksmanship_aoe L(AOE) default specialization=marksmanship)

AddIcon checkbox=!opt_hunter_marksmanship_aoe enemies=1 help=shortcd specialization=marksmanship
{
	if not InCombat() MarksmanshipPrecombatShortCdActions()
	unless not InCombat() and MarksmanshipPrecombatShortCdPostConditions()
	{
		MarksmanshipDefaultShortCdActions()
	}
}

AddIcon checkbox=opt_hunter_marksmanship_aoe help=shortcd specialization=marksmanship
{
	if not InCombat() MarksmanshipPrecombatShortCdActions()
	unless not InCombat() and MarksmanshipPrecombatShortCdPostConditions()
	{
		MarksmanshipDefaultShortCdActions()
	}
}

AddIcon enemies=1 help=main specialization=marksmanship
{
	if not InCombat() MarksmanshipPrecombatMainActions()
	unless not InCombat() and MarksmanshipPrecombatMainPostConditions()
	{
		MarksmanshipDefaultMainActions()
	}
}

AddIcon checkbox=opt_hunter_marksmanship_aoe help=aoe specialization=marksmanship
{
	if not InCombat() MarksmanshipPrecombatMainActions()
	unless not InCombat() and MarksmanshipPrecombatMainPostConditions()
	{
		MarksmanshipDefaultMainActions()
	}
}

AddIcon checkbox=!opt_hunter_marksmanship_aoe enemies=1 help=cd specialization=marksmanship
{
	if not InCombat() MarksmanshipPrecombatCdActions()
	unless not InCombat() and MarksmanshipPrecombatCdPostConditions()
	{
		MarksmanshipDefaultCdActions()
	}
}

AddIcon checkbox=opt_hunter_marksmanship_aoe help=cd specialization=marksmanship
{
	if not InCombat() MarksmanshipPrecombatCdActions()
	unless not InCombat() and MarksmanshipPrecombatCdPostConditions()
	{
		MarksmanshipDefaultCdActions()
	}
}

### Required symbols
# a_murder_of_crows
# a_murder_of_crows_debuff
# aimed_shot
# arcane_shot
# arcane_torrent_focus
# augmentation
# barrage
# berserking
# black_arrow
# blood_fury_ap
# bullseye_buff
# counter_shot
# explosive_shot
# hunters_mark_debuff
# lock_and_load_buff
# lone_wolf_talent
# marked_shot
# marking_targets_buff
# multishot
# patient_sniper_talent
# piercing_shot
# piercing_shot_talent
# quaking_palm
# revive_pet
# sentinel
# sentinel_talent
# sidewinders
# sidewinders_talent
# trueshot
# trueshot_buff
# volley
# vulnerability_debuff
# war_stomp
# windburst
]]
	OvaleScripts:RegisterScript("HUNTER", "marksmanship", name, desc, code, "script")
end

do
	local name = "simulationcraft_hunter_sv_t19p"
	local desc = "[7.0] SimulationCraft: Hunter_SV_T19P"
	local code = [[
# Based on SimulationCraft profile "Hunter_SV_T19P".
#	class=hunter
#	spec=survival
#	talents=3101032

Include(ovale_common)
Include(ovale_trinkets_mop)
Include(ovale_trinkets_wod)
Include(ovale_hunter_spells)

AddCheckBox(opt_interrupt L(interrupt) default specialization=survival)
AddCheckBox(opt_trap_launcher SpellName(trap_launcher) default specialization=survival)

AddFunction SurvivalUseItemActions
{
	Item(Trinket0Slot usable=1)
	Item(Trinket1Slot usable=1)
}

AddFunction SurvivalInterruptActions
{
	if CheckBoxOn(opt_interrupt) and not target.IsFriend() and target.IsInterruptible()
	{
		Spell(muzzle)
		if not target.Classification(worldboss)
		{
			Spell(arcane_torrent_focus)
			if target.InRange(quaking_palm) Spell(quaking_palm)
			Spell(war_stomp)
		}
	}
}

AddFunction SurvivalSummonPet
{
	if not Talent(lone_wolf_talent)
	{
		if pet.IsDead()
		{
			if not DebuffPresent(heart_of_the_phoenix_debuff) Spell(heart_of_the_phoenix)
			Spell(revive_pet)
		}
		if not pet.Present() and not pet.IsDead() and not PreviousSpell(revive_pet) Texture(ability_hunter_beastcall help=L(summon_pet))
	}
}

### actions.default

AddFunction SurvivalDefaultMainActions
{
	#potion,name=old_war,if=buff.aspect_of_the_eagle.remains
	#call_action_list,name=moknathal,if=talent.way_of_the_moknathal.enabled
	if Talent(way_of_the_moknathal_talent) SurvivalMoknathalMainActions()

	unless Talent(way_of_the_moknathal_talent) and SurvivalMoknathalMainPostConditions()
	{
		#call_action_list,name=nomok,if=!talent.way_of_the_moknathal.enabled
		if not Talent(way_of_the_moknathal_talent) SurvivalNomokMainActions()
	}
}

AddFunction SurvivalDefaultMainPostConditions
{
	Talent(way_of_the_moknathal_talent) and SurvivalMoknathalMainPostConditions() or not Talent(way_of_the_moknathal_talent) and SurvivalNomokMainPostConditions()
}

AddFunction SurvivalDefaultShortCdActions
{
	#potion,name=old_war,if=buff.aspect_of_the_eagle.remains
	#call_action_list,name=moknathal,if=talent.way_of_the_moknathal.enabled
	if Talent(way_of_the_moknathal_talent) SurvivalMoknathalShortCdActions()

	unless Talent(way_of_the_moknathal_talent) and SurvivalMoknathalShortCdPostConditions()
	{
		#call_action_list,name=nomok,if=!talent.way_of_the_moknathal.enabled
		if not Talent(way_of_the_moknathal_talent) SurvivalNomokShortCdActions()
	}
}

AddFunction SurvivalDefaultShortCdPostConditions
{
	Talent(way_of_the_moknathal_talent) and SurvivalMoknathalShortCdPostConditions() or not Talent(way_of_the_moknathal_talent) and SurvivalNomokShortCdPostConditions()
}

AddFunction SurvivalDefaultCdActions
{
	#auto_attack
	#muzzle
	SurvivalInterruptActions()
	#arcane_torrent,if=focus.deficit>=30
	if FocusDeficit() >= 30 Spell(arcane_torrent_focus)
	#berserking
	Spell(berserking)
	#blood_fury
	Spell(blood_fury_ap)
	#use_item,name=tirathons_betrayal
	SurvivalUseItemActions()
	#potion,name=old_war,if=buff.aspect_of_the_eagle.remains
	#call_action_list,name=moknathal,if=talent.way_of_the_moknathal.enabled
	if Talent(way_of_the_moknathal_talent) SurvivalMoknathalCdActions()

	unless Talent(way_of_the_moknathal_talent) and SurvivalMoknathalCdPostConditions()
	{
		#call_action_list,name=nomok,if=!talent.way_of_the_moknathal.enabled
		if not Talent(way_of_the_moknathal_talent) SurvivalNomokCdActions()
	}
}

AddFunction SurvivalDefaultCdPostConditions
{
	Talent(way_of_the_moknathal_talent) and SurvivalMoknathalCdPostConditions() or not Talent(way_of_the_moknathal_talent) and SurvivalNomokCdPostConditions()
}

### actions.moknathal

AddFunction SurvivalMoknathalMainActions
{
	#raptor_strike,if=buff.moknathal_tactics.stack<=1
	if BuffStacks(moknathal_tactics_buff) <= 1 Spell(raptor_strike)
	#raptor_strike,if=buff.moknathal_tactics.remains<gcd
	if BuffRemaining(moknathal_tactics_buff) < GCD() Spell(raptor_strike)
	#caltrops,if=(buff.mongoose_fury.duration>=gcd&buff.mongoose_fury.stack<4&!dot.caltrops.ticking)
	if BaseDuration(mongoose_fury_buff) >= GCD() and BuffStacks(mongoose_fury_buff) < 4 and not target.DebuffPresent(caltrops_debuff) Spell(caltrops)
	#flanking_strike,if=cooldown.mongoose_bite.charges<=0&buff.aspect_of_the_eagle.remains>=gcd&focus>75
	if SpellChargeCooldown(mongoose_bite) <= 0 and BuffRemaining(aspect_of_the_eagle_buff) >= GCD() and Focus() > 75 Spell(flanking_strike)
	#lacerate,if=focus>60&buff.mongoose_fury.duration>=gcd&dot.lacerate.remains<=3&cooldown.mongoose_bite.charges>=0&buff.mongoose_fury.stack<4
	if Focus() > 60 and BaseDuration(mongoose_fury_buff) >= GCD() and target.DebuffRemaining(lacerate_debuff) <= 3 and SpellChargeCooldown(mongoose_bite) >= 0 and BuffStacks(mongoose_fury_buff) < 4 Spell(lacerate)
	#raptor_strike,if=talent.serpent_sting.enabled&dot.serpent_sting.remains<gcd
	if Talent(serpent_sting_talent) and target.DebuffRemaining(serpent_sting_debuff) < GCD() Spell(raptor_strike)
	#raptor_strike,if=buff.moknathal_tactics.remains<4&buff.mongoose_fury.stack=6&buff.mongoose_fury.remains>=gcd
	if BuffRemaining(moknathal_tactics_buff) < 4 and BuffStacks(mongoose_fury_buff) == 6 and BuffRemaining(mongoose_fury_buff) >= GCD() Spell(raptor_strike)
	#mongoose_bite,if=buff.aspect_of_the_eagle.up&buff.mongoose_fury.up&buff.moknathal_tactics.stack>=4
	if BuffPresent(aspect_of_the_eagle_buff) and BuffPresent(mongoose_fury_buff) and BuffStacks(moknathal_tactics_buff) >= 4 Spell(mongoose_bite)
	#raptor_strike,if=buff.moknathal_tactics.stack<=3
	if BuffStacks(moknathal_tactics_buff) <= 3 Spell(raptor_strike)
	#flanking_strike,if=cooldown.mongoose_bite.charges<=2&buff.mongoose_fury.remains>(1+action.mongoose_bite.charges*gcd)&focus>75
	if SpellChargeCooldown(mongoose_bite) <= 2 and BuffRemaining(mongoose_fury_buff) > 1 + Charges(mongoose_bite) * GCD() and Focus() > 75 Spell(flanking_strike)
	#mongoose_bite,if=buff.mongoose_fury.up&buff.mongoose_fury.remains<cooldown.aspect_of_the_eagle.remains
	if BuffPresent(mongoose_fury_buff) and BuffRemaining(mongoose_fury_buff) < SpellCooldown(aspect_of_the_eagle) Spell(mongoose_bite)
	#caltrops,if=(!dot.caltrops.ticking)
	if not target.DebuffPresent(caltrops_debuff) Spell(caltrops)
	#lacerate,if=(!dot.lacerate.ticking|dot.lacerate.remains<3)
	if not target.DebuffPresent(lacerate_debuff) or target.DebuffRemaining(lacerate_debuff) < 3 Spell(lacerate)
	#butchery,if=(charges=3&focus>65)
	if Charges(butchery) == 3 and Focus() > 65 Spell(butchery)
	#mongoose_bite,if=(charges>=2&cooldown.mongoose_bite.remains<=gcd|charges=3)
	if Charges(mongoose_bite) >= 2 and SpellCooldown(mongoose_bite) <= GCD() or Charges(mongoose_bite) == 3 Spell(mongoose_bite)
	#butchery,if=focus>65
	if Focus() > 65 Spell(butchery)
	#flanking_strike,if=focus>75
	if Focus() > 75 Spell(flanking_strike)
	#raptor_strike,if=focus>75-cooldown.flanking_strike.remains*focus.regen
	if Focus() > 75 - SpellCooldown(flanking_strike) * FocusRegenRate() Spell(raptor_strike)
}

AddFunction SurvivalMoknathalMainPostConditions
{
}

AddFunction SurvivalMoknathalShortCdActions
{
	unless BuffStacks(moknathal_tactics_buff) <= 1 and Spell(raptor_strike) or BuffRemaining(moknathal_tactics_buff) < GCD() and Spell(raptor_strike)
	{
		#snake_hunter,if=cooldown.mongoose_bite.charges<=0&buff.mongoose_fury.remains>3*gcd
		if SpellChargeCooldown(mongoose_bite) <= 0 and BuffRemaining(mongoose_fury_buff) > 3 * GCD() Spell(snake_hunter)
		#a_murder_of_crows,if=focus>55&buff.mongoose_fury.stack<4&buff.mongoose_fury.duration>=gcd
		if Focus() > 55 and BuffStacks(mongoose_fury_buff) < 4 and BaseDuration(mongoose_fury_buff) >= GCD() Spell(a_murder_of_crows)
		#steel_trap,if=buff.mongoose_fury.duration>=gcd&buff.mongoose_fury.stack<4
		if BaseDuration(mongoose_fury_buff) >= GCD() and BuffStacks(mongoose_fury_buff) < 4 and CheckBoxOn(opt_trap_launcher) Spell(steel_trap)

		unless BaseDuration(mongoose_fury_buff) >= GCD() and BuffStacks(mongoose_fury_buff) < 4 and not target.DebuffPresent(caltrops_debuff) and Spell(caltrops) or SpellChargeCooldown(mongoose_bite) <= 0 and BuffRemaining(aspect_of_the_eagle_buff) >= GCD() and Focus() > 75 and Spell(flanking_strike) or Focus() > 60 and BaseDuration(mongoose_fury_buff) >= GCD() and target.DebuffRemaining(lacerate_debuff) <= 3 and SpellChargeCooldown(mongoose_bite) >= 0 and BuffStacks(mongoose_fury_buff) < 4 and Spell(lacerate)
		{
			#spitting_cobra,if=buff.mongoose_fury.duration>=gcd&cooldown.mongoose_bite.charges>=0&buff.mongoose_fury.stack<4
			if BaseDuration(mongoose_fury_buff) >= GCD() and SpellChargeCooldown(mongoose_bite) >= 0 and BuffStacks(mongoose_fury_buff) < 4 Spell(spitting_cobra)
			#steel_trap,if=buff.mongoose_fury.duration>=gcd&buff.mongoose_fury.stack<4
			if BaseDuration(mongoose_fury_buff) >= GCD() and BuffStacks(mongoose_fury_buff) < 4 and CheckBoxOn(opt_trap_launcher) Spell(steel_trap)
			#explosive_trap,if=buff.mongoose_fury.duration>=gcd&cooldown.mongoose_bite.charges>=0&buff.mongoose_fury.stack<4
			if BaseDuration(mongoose_fury_buff) >= GCD() and SpellChargeCooldown(mongoose_bite) >= 0 and BuffStacks(mongoose_fury_buff) < 4 and CheckBoxOn(opt_trap_launcher) Spell(explosive_trap)
			#dragonsfire_grenade,if=buff.mongoose_fury.duration>=gcd&cooldown.mongoose_bite.charges>=0&buff.mongoose_fury.stack<4
			if BaseDuration(mongoose_fury_buff) >= GCD() and SpellChargeCooldown(mongoose_bite) >= 0 and BuffStacks(mongoose_fury_buff) < 4 Spell(dragonsfire_grenade)

			unless Talent(serpent_sting_talent) and target.DebuffRemaining(serpent_sting_debuff) < GCD() and Spell(raptor_strike) or BuffRemaining(moknathal_tactics_buff) < 4 and BuffStacks(mongoose_fury_buff) == 6 and BuffRemaining(mongoose_fury_buff) >= GCD() and Spell(raptor_strike)
			{
				#fury_of_the_eagle,if=buff.moknathal_tactics.remains>4&buff.mongoose_fury.stack=6&cooldown.mongoose_bite.charges<=2
				if BuffRemaining(moknathal_tactics_buff) > 4 and BuffStacks(mongoose_fury_buff) == 6 and SpellChargeCooldown(mongoose_bite) <= 2 Spell(fury_of_the_eagle)

				unless BuffPresent(aspect_of_the_eagle_buff) and BuffPresent(mongoose_fury_buff) and BuffStacks(moknathal_tactics_buff) >= 4 and Spell(mongoose_bite)
				{
					#fury_of_the_eagle,if=(buff.moknathal_tactics.remains>4&(buff.mongoose_fury.stack=6&cooldown.mongoose_bite.charges<=0|buff.mongoose_fury.up&buff.mongoose_fury.remains<=2*gcd))
					if BuffRemaining(moknathal_tactics_buff) > 4 and { BuffStacks(mongoose_fury_buff) == 6 and SpellChargeCooldown(mongoose_bite) <= 0 or BuffPresent(mongoose_fury_buff) and BuffRemaining(mongoose_fury_buff) <= 2 * GCD() } Spell(fury_of_the_eagle)

					unless BuffStacks(moknathal_tactics_buff) <= 3 and Spell(raptor_strike) or SpellChargeCooldown(mongoose_bite) <= 2 and BuffRemaining(mongoose_fury_buff) > 1 + Charges(mongoose_bite) * GCD() and Focus() > 75 and Spell(flanking_strike) or BuffPresent(mongoose_fury_buff) and BuffRemaining(mongoose_fury_buff) < SpellCooldown(aspect_of_the_eagle) and Spell(mongoose_bite)
					{
						#a_murder_of_crows,if=focus>55
						if Focus() > 55 Spell(a_murder_of_crows)
						#spitting_cobra
						Spell(spitting_cobra)
						#steel_trap
						if CheckBoxOn(opt_trap_launcher) Spell(steel_trap)
						#explosive_trap
						if CheckBoxOn(opt_trap_launcher) Spell(explosive_trap)

						unless not target.DebuffPresent(caltrops_debuff) and Spell(caltrops) or { not target.DebuffPresent(lacerate_debuff) or target.DebuffRemaining(lacerate_debuff) < 3 } and Spell(lacerate)
						{
							#dragonsfire_grenade
							Spell(dragonsfire_grenade)
						}
					}
				}
			}
		}
	}
}

AddFunction SurvivalMoknathalShortCdPostConditions
{
	BuffStacks(moknathal_tactics_buff) <= 1 and Spell(raptor_strike) or BuffRemaining(moknathal_tactics_buff) < GCD() and Spell(raptor_strike) or BaseDuration(mongoose_fury_buff) >= GCD() and BuffStacks(mongoose_fury_buff) < 4 and not target.DebuffPresent(caltrops_debuff) and Spell(caltrops) or SpellChargeCooldown(mongoose_bite) <= 0 and BuffRemaining(aspect_of_the_eagle_buff) >= GCD() and Focus() > 75 and Spell(flanking_strike) or Focus() > 60 and BaseDuration(mongoose_fury_buff) >= GCD() and target.DebuffRemaining(lacerate_debuff) <= 3 and SpellChargeCooldown(mongoose_bite) >= 0 and BuffStacks(mongoose_fury_buff) < 4 and Spell(lacerate) or Talent(serpent_sting_talent) and target.DebuffRemaining(serpent_sting_debuff) < GCD() and Spell(raptor_strike) or BuffRemaining(moknathal_tactics_buff) < 4 and BuffStacks(mongoose_fury_buff) == 6 and BuffRemaining(mongoose_fury_buff) >= GCD() and Spell(raptor_strike) or BuffPresent(aspect_of_the_eagle_buff) and BuffPresent(mongoose_fury_buff) and BuffStacks(moknathal_tactics_buff) >= 4 and Spell(mongoose_bite) or BuffStacks(moknathal_tactics_buff) <= 3 and Spell(raptor_strike) or SpellChargeCooldown(mongoose_bite) <= 2 and BuffRemaining(mongoose_fury_buff) > 1 + Charges(mongoose_bite) * GCD() and Focus() > 75 and Spell(flanking_strike) or BuffPresent(mongoose_fury_buff) and BuffRemaining(mongoose_fury_buff) < SpellCooldown(aspect_of_the_eagle) and Spell(mongoose_bite) or not target.DebuffPresent(caltrops_debuff) and Spell(caltrops) or { not target.DebuffPresent(lacerate_debuff) or target.DebuffRemaining(lacerate_debuff) < 3 } and Spell(lacerate) or Charges(butchery) == 3 and Focus() > 65 and Spell(butchery) or { Charges(mongoose_bite) >= 2 and SpellCooldown(mongoose_bite) <= GCD() or Charges(mongoose_bite) == 3 } and Spell(mongoose_bite) or Focus() > 65 and Spell(butchery) or Focus() > 75 and Spell(flanking_strike) or Focus() > 75 - SpellCooldown(flanking_strike) * FocusRegenRate() and Spell(raptor_strike)
}

AddFunction SurvivalMoknathalCdActions
{
	unless BuffStacks(moknathal_tactics_buff) <= 1 and Spell(raptor_strike) or BuffRemaining(moknathal_tactics_buff) < GCD() and Spell(raptor_strike) or SpellChargeCooldown(mongoose_bite) <= 0 and BuffRemaining(mongoose_fury_buff) > 3 * GCD() and Spell(snake_hunter) or Focus() > 55 and BuffStacks(mongoose_fury_buff) < 4 and BaseDuration(mongoose_fury_buff) >= GCD() and Spell(a_murder_of_crows) or BaseDuration(mongoose_fury_buff) >= GCD() and BuffStacks(mongoose_fury_buff) < 4 and CheckBoxOn(opt_trap_launcher) and Spell(steel_trap) or BaseDuration(mongoose_fury_buff) >= GCD() and BuffStacks(mongoose_fury_buff) < 4 and not target.DebuffPresent(caltrops_debuff) and Spell(caltrops) or SpellChargeCooldown(mongoose_bite) <= 0 and BuffRemaining(aspect_of_the_eagle_buff) >= GCD() and Focus() > 75 and Spell(flanking_strike) or Focus() > 60 and BaseDuration(mongoose_fury_buff) >= GCD() and target.DebuffRemaining(lacerate_debuff) <= 3 and SpellChargeCooldown(mongoose_bite) >= 0 and BuffStacks(mongoose_fury_buff) < 4 and Spell(lacerate) or BaseDuration(mongoose_fury_buff) >= GCD() and SpellChargeCooldown(mongoose_bite) >= 0 and BuffStacks(mongoose_fury_buff) < 4 and Spell(spitting_cobra) or BaseDuration(mongoose_fury_buff) >= GCD() and BuffStacks(mongoose_fury_buff) < 4 and CheckBoxOn(opt_trap_launcher) and Spell(steel_trap) or BaseDuration(mongoose_fury_buff) >= GCD() and SpellChargeCooldown(mongoose_bite) >= 0 and BuffStacks(mongoose_fury_buff) < 4 and CheckBoxOn(opt_trap_launcher) and Spell(explosive_trap) or BaseDuration(mongoose_fury_buff) >= GCD() and SpellChargeCooldown(mongoose_bite) >= 0 and BuffStacks(mongoose_fury_buff) < 4 and Spell(dragonsfire_grenade) or Talent(serpent_sting_talent) and target.DebuffRemaining(serpent_sting_debuff) < GCD() and Spell(raptor_strike) or BuffRemaining(moknathal_tactics_buff) < 4 and BuffStacks(mongoose_fury_buff) == 6 and BuffRemaining(mongoose_fury_buff) >= GCD() and Spell(raptor_strike) or BuffRemaining(moknathal_tactics_buff) > 4 and BuffStacks(mongoose_fury_buff) == 6 and SpellChargeCooldown(mongoose_bite) <= 2 and Spell(fury_of_the_eagle) or BuffPresent(aspect_of_the_eagle_buff) and BuffPresent(mongoose_fury_buff) and BuffStacks(moknathal_tactics_buff) >= 4 and Spell(mongoose_bite) or BuffRemaining(moknathal_tactics_buff) > 4 and { BuffStacks(mongoose_fury_buff) == 6 and SpellChargeCooldown(mongoose_bite) <= 0 or BuffPresent(mongoose_fury_buff) and BuffRemaining(mongoose_fury_buff) <= 2 * GCD() } and Spell(fury_of_the_eagle) or BuffStacks(moknathal_tactics_buff) <= 3 and Spell(raptor_strike)
	{
		#aspect_of_the_eagle,if=buff.mongoose_fury.up&buff.mongoose_fury.remains>6&cooldown.mongoose_bite.charges>=2
		if BuffPresent(mongoose_fury_buff) and BuffRemaining(mongoose_fury_buff) > 6 and SpellChargeCooldown(mongoose_bite) >= 2 Spell(aspect_of_the_eagle)
	}
}

AddFunction SurvivalMoknathalCdPostConditions
{
	BuffStacks(moknathal_tactics_buff) <= 1 and Spell(raptor_strike) or BuffRemaining(moknathal_tactics_buff) < GCD() and Spell(raptor_strike) or SpellChargeCooldown(mongoose_bite) <= 0 and BuffRemaining(mongoose_fury_buff) > 3 * GCD() and Spell(snake_hunter) or Focus() > 55 and BuffStacks(mongoose_fury_buff) < 4 and BaseDuration(mongoose_fury_buff) >= GCD() and Spell(a_murder_of_crows) or BaseDuration(mongoose_fury_buff) >= GCD() and BuffStacks(mongoose_fury_buff) < 4 and CheckBoxOn(opt_trap_launcher) and Spell(steel_trap) or BaseDuration(mongoose_fury_buff) >= GCD() and BuffStacks(mongoose_fury_buff) < 4 and not target.DebuffPresent(caltrops_debuff) and Spell(caltrops) or SpellChargeCooldown(mongoose_bite) <= 0 and BuffRemaining(aspect_of_the_eagle_buff) >= GCD() and Focus() > 75 and Spell(flanking_strike) or Focus() > 60 and BaseDuration(mongoose_fury_buff) >= GCD() and target.DebuffRemaining(lacerate_debuff) <= 3 and SpellChargeCooldown(mongoose_bite) >= 0 and BuffStacks(mongoose_fury_buff) < 4 and Spell(lacerate) or BaseDuration(mongoose_fury_buff) >= GCD() and SpellChargeCooldown(mongoose_bite) >= 0 and BuffStacks(mongoose_fury_buff) < 4 and Spell(spitting_cobra) or BaseDuration(mongoose_fury_buff) >= GCD() and BuffStacks(mongoose_fury_buff) < 4 and CheckBoxOn(opt_trap_launcher) and Spell(steel_trap) or BaseDuration(mongoose_fury_buff) >= GCD() and SpellChargeCooldown(mongoose_bite) >= 0 and BuffStacks(mongoose_fury_buff) < 4 and CheckBoxOn(opt_trap_launcher) and Spell(explosive_trap) or BaseDuration(mongoose_fury_buff) >= GCD() and SpellChargeCooldown(mongoose_bite) >= 0 and BuffStacks(mongoose_fury_buff) < 4 and Spell(dragonsfire_grenade) or Talent(serpent_sting_talent) and target.DebuffRemaining(serpent_sting_debuff) < GCD() and Spell(raptor_strike) or BuffRemaining(moknathal_tactics_buff) < 4 and BuffStacks(mongoose_fury_buff) == 6 and BuffRemaining(mongoose_fury_buff) >= GCD() and Spell(raptor_strike) or BuffRemaining(moknathal_tactics_buff) > 4 and BuffStacks(mongoose_fury_buff) == 6 and SpellChargeCooldown(mongoose_bite) <= 2 and Spell(fury_of_the_eagle) or BuffPresent(aspect_of_the_eagle_buff) and BuffPresent(mongoose_fury_buff) and BuffStacks(moknathal_tactics_buff) >= 4 and Spell(mongoose_bite) or BuffRemaining(moknathal_tactics_buff) > 4 and { BuffStacks(mongoose_fury_buff) == 6 and SpellChargeCooldown(mongoose_bite) <= 0 or BuffPresent(mongoose_fury_buff) and BuffRemaining(mongoose_fury_buff) <= 2 * GCD() } and Spell(fury_of_the_eagle) or BuffStacks(moknathal_tactics_buff) <= 3 and Spell(raptor_strike) or SpellChargeCooldown(mongoose_bite) <= 2 and BuffRemaining(mongoose_fury_buff) > 1 + Charges(mongoose_bite) * GCD() and Focus() > 75 and Spell(flanking_strike) or BuffPresent(mongoose_fury_buff) and BuffRemaining(mongoose_fury_buff) < SpellCooldown(aspect_of_the_eagle) and Spell(mongoose_bite) or Focus() > 55 and Spell(a_murder_of_crows) or Spell(spitting_cobra) or CheckBoxOn(opt_trap_launcher) and Spell(steel_trap) or CheckBoxOn(opt_trap_launcher) and Spell(explosive_trap) or not target.DebuffPresent(caltrops_debuff) and Spell(caltrops) or { not target.DebuffPresent(lacerate_debuff) or target.DebuffRemaining(lacerate_debuff) < 3 } and Spell(lacerate) or Spell(dragonsfire_grenade) or Charges(butchery) == 3 and Focus() > 65 and Spell(butchery) or { Charges(mongoose_bite) >= 2 and SpellCooldown(mongoose_bite) <= GCD() or Charges(mongoose_bite) == 3 } and Spell(mongoose_bite) or Focus() > 65 and Spell(butchery) or Focus() > 75 and Spell(flanking_strike) or Focus() > 75 - SpellCooldown(flanking_strike) * FocusRegenRate() and Spell(raptor_strike)
}

### actions.nomok

AddFunction SurvivalNomokMainActions
{
	#caltrops,if=(buff.mongoose_fury.duration>=gcd&buff.mongoose_fury.stack<4&!dot.caltrops.ticking)
	if BaseDuration(mongoose_fury_buff) >= GCD() and BuffStacks(mongoose_fury_buff) < 4 and not target.DebuffPresent(caltrops_debuff) Spell(caltrops)
	#flanking_strike,if=cooldown.mongoose_bite.charges<=0&buff.aspect_of_the_eagle.remains>=gcd
	if SpellChargeCooldown(mongoose_bite) <= 0 and BuffRemaining(aspect_of_the_eagle_buff) >= GCD() Spell(flanking_strike)
	#lacerate,if=buff.mongoose_fury.duration>=gcd&dot.lacerate.remains<=1&&cooldown.mongoose_bite.charges>=0&buff.mongoose_fury.stack<4
	if BaseDuration(mongoose_fury_buff) >= GCD() and target.DebuffRemaining(lacerate_debuff) <= 1 and SpellChargeCooldown(mongoose_bite) >= 0 and BuffStacks(mongoose_fury_buff) < 4 Spell(lacerate)
	#raptor_strike,if=talent.serpent_sting.enabled&dot.serpent_sting.remains<gcd
	if Talent(serpent_sting_talent) and target.DebuffRemaining(serpent_sting_debuff) < GCD() Spell(raptor_strike)
	#mongoose_bite,if=buff.aspect_of_the_eagle.up&buff.mongoose_fury.up
	if BuffPresent(aspect_of_the_eagle_buff) and BuffPresent(mongoose_fury_buff) Spell(mongoose_bite)
	#flanking_strike,if=cooldown.mongoose_bite.charges<2&buff.mongoose_fury.remains>(1+action.mongoose_bite.charges*gcd)
	if SpellChargeCooldown(mongoose_bite) < 2 and BuffRemaining(mongoose_fury_buff) > 1 + Charges(mongoose_bite) * GCD() Spell(flanking_strike)
	#mongoose_bite,if=buff.mongoose_fury.up&buff.mongoose_fury.remains<cooldown.aspect_of_the_eagle.remains
	if BuffPresent(mongoose_fury_buff) and BuffRemaining(mongoose_fury_buff) < SpellCooldown(aspect_of_the_eagle) Spell(mongoose_bite)
	#flanking_strike,if=talent.animal_instincts.enabled&cooldown.mongoose_bite.charges<3
	if Talent(animal_instincts_talent) and SpellChargeCooldown(mongoose_bite) < 3 Spell(flanking_strike)
	#caltrops,if=(!dot.caltrops.ticking)
	if not target.DebuffPresent(caltrops_debuff) Spell(caltrops)
	#lacerate,if=(!dot.lacerate.ticking|dot.lacerate.remains<3)
	if not target.DebuffPresent(lacerate_debuff) or target.DebuffRemaining(lacerate_debuff) < 3 Spell(lacerate)
	#butchery,if=(charges=3)
	if Charges(butchery) == 3 Spell(butchery)
	#throwing_axes,if=cooldown.throwing_axes.charges=2
	if SpellChargeCooldown(throwing_axes) == 2 Spell(throwing_axes)
	#mongoose_bite,if=(charges>=2&cooldown.mongoose_bite.remains<=gcd|charges=3)
	if Charges(mongoose_bite) >= 2 and SpellCooldown(mongoose_bite) <= GCD() or Charges(mongoose_bite) == 3 Spell(mongoose_bite)
	#butchery
	Spell(butchery)
	#throwing_axes
	Spell(throwing_axes)
	#flanking_strike
	Spell(flanking_strike)
	#raptor_strike,if=focus>75-cooldown.flanking_strike.remains*focus.regen
	if Focus() > 75 - SpellCooldown(flanking_strike) * FocusRegenRate() Spell(raptor_strike)
}

AddFunction SurvivalNomokMainPostConditions
{
}

AddFunction SurvivalNomokShortCdActions
{
	#a_murder_of_crows,if=cooldown.mongoose_bite.charges>=0&buff.mongoose_fury.stack<4
	if SpellChargeCooldown(mongoose_bite) >= 0 and BuffStacks(mongoose_fury_buff) < 4 Spell(a_murder_of_crows)
	#snake_hunter,if=action.mongoose_bite.charges<=0&buff.mongoose_fury.remains>3*gcd
	if Charges(mongoose_bite) <= 0 and BuffRemaining(mongoose_fury_buff) > 3 * GCD() Spell(snake_hunter)
	#steel_trap,if=buff.mongoose_fury.duration>=gcd&buff.mongoose_fury.stack<4
	if BaseDuration(mongoose_fury_buff) >= GCD() and BuffStacks(mongoose_fury_buff) < 4 and CheckBoxOn(opt_trap_launcher) Spell(steel_trap)

	unless BaseDuration(mongoose_fury_buff) >= GCD() and BuffStacks(mongoose_fury_buff) < 4 and not target.DebuffPresent(caltrops_debuff) and Spell(caltrops) or SpellChargeCooldown(mongoose_bite) <= 0 and BuffRemaining(aspect_of_the_eagle_buff) >= GCD() and Spell(flanking_strike) or BaseDuration(mongoose_fury_buff) >= GCD() and target.DebuffRemaining(lacerate_debuff) <= 1 and SpellChargeCooldown(mongoose_bite) >= 0 and BuffStacks(mongoose_fury_buff) < 4 and Spell(lacerate)
	{
		#spitting_cobra,if=buff.mongoose_fury.duration>=gcd&cooldown.mongoose_bite.charges>=0&buff.mongoose_fury.stack<4
		if BaseDuration(mongoose_fury_buff) >= GCD() and SpellChargeCooldown(mongoose_bite) >= 0 and BuffStacks(mongoose_fury_buff) < 4 Spell(spitting_cobra)
		#steel_trap,if=buff.mongoose_fury.duration>=gcd&buff.mongoose_fury.stack<4
		if BaseDuration(mongoose_fury_buff) >= GCD() and BuffStacks(mongoose_fury_buff) < 4 and CheckBoxOn(opt_trap_launcher) Spell(steel_trap)
		#explosive_trap,if=buff.mongoose_fury.duration>=gcd&cooldown.mongoose_bite.charges>=0&buff.mongoose_fury.stack<4
		if BaseDuration(mongoose_fury_buff) >= GCD() and SpellChargeCooldown(mongoose_bite) >= 0 and BuffStacks(mongoose_fury_buff) < 4 and CheckBoxOn(opt_trap_launcher) Spell(explosive_trap)
		#dragonsfire_grenade,if=buff.mongoose_fury.duration>=gcd&cooldown.mongoose_bite.charges>=0&buff.mongoose_fury.stack<4
		if BaseDuration(mongoose_fury_buff) >= GCD() and SpellChargeCooldown(mongoose_bite) >= 0 and BuffStacks(mongoose_fury_buff) < 4 Spell(dragonsfire_grenade)

		unless Talent(serpent_sting_talent) and target.DebuffRemaining(serpent_sting_debuff) < GCD() and Spell(raptor_strike)
		{
			#fury_of_the_eagle,if=buff.mongoose_fury.stack=6&cooldown.mongoose_bite.charges<=2
			if BuffStacks(mongoose_fury_buff) == 6 and SpellChargeCooldown(mongoose_bite) <= 2 Spell(fury_of_the_eagle)

			unless BuffPresent(aspect_of_the_eagle_buff) and BuffPresent(mongoose_fury_buff) and Spell(mongoose_bite)
			{
				#fury_of_the_eagle,if=cooldown.mongoose_bite.charges<=0&buff.mongoose_fury.duration>6
				if SpellChargeCooldown(mongoose_bite) <= 0 and BaseDuration(mongoose_fury_buff) > 6 Spell(fury_of_the_eagle)

				unless SpellChargeCooldown(mongoose_bite) < 2 and BuffRemaining(mongoose_fury_buff) > 1 + Charges(mongoose_bite) * GCD() and Spell(flanking_strike) or BuffPresent(mongoose_fury_buff) and BuffRemaining(mongoose_fury_buff) < SpellCooldown(aspect_of_the_eagle) and Spell(mongoose_bite) or Talent(animal_instincts_talent) and SpellChargeCooldown(mongoose_bite) < 3 and Spell(flanking_strike)
				{
					#a_murder_of_crows
					Spell(a_murder_of_crows)
					#spitting_cobra
					Spell(spitting_cobra)
					#steel_trap
					if CheckBoxOn(opt_trap_launcher) Spell(steel_trap)
					#explosive_trap
					if CheckBoxOn(opt_trap_launcher) Spell(explosive_trap)

					unless not target.DebuffPresent(caltrops_debuff) and Spell(caltrops) or { not target.DebuffPresent(lacerate_debuff) or target.DebuffRemaining(lacerate_debuff) < 3 } and Spell(lacerate)
					{
						#dragonsfire_grenade
						Spell(dragonsfire_grenade)
					}
				}
			}
		}
	}
}

AddFunction SurvivalNomokShortCdPostConditions
{
	BaseDuration(mongoose_fury_buff) >= GCD() and BuffStacks(mongoose_fury_buff) < 4 and not target.DebuffPresent(caltrops_debuff) and Spell(caltrops) or SpellChargeCooldown(mongoose_bite) <= 0 and BuffRemaining(aspect_of_the_eagle_buff) >= GCD() and Spell(flanking_strike) or BaseDuration(mongoose_fury_buff) >= GCD() and target.DebuffRemaining(lacerate_debuff) <= 1 and SpellChargeCooldown(mongoose_bite) >= 0 and BuffStacks(mongoose_fury_buff) < 4 and Spell(lacerate) or Talent(serpent_sting_talent) and target.DebuffRemaining(serpent_sting_debuff) < GCD() and Spell(raptor_strike) or BuffPresent(aspect_of_the_eagle_buff) and BuffPresent(mongoose_fury_buff) and Spell(mongoose_bite) or SpellChargeCooldown(mongoose_bite) < 2 and BuffRemaining(mongoose_fury_buff) > 1 + Charges(mongoose_bite) * GCD() and Spell(flanking_strike) or BuffPresent(mongoose_fury_buff) and BuffRemaining(mongoose_fury_buff) < SpellCooldown(aspect_of_the_eagle) and Spell(mongoose_bite) or Talent(animal_instincts_talent) and SpellChargeCooldown(mongoose_bite) < 3 and Spell(flanking_strike) or not target.DebuffPresent(caltrops_debuff) and Spell(caltrops) or { not target.DebuffPresent(lacerate_debuff) or target.DebuffRemaining(lacerate_debuff) < 3 } and Spell(lacerate) or Charges(butchery) == 3 and Spell(butchery) or SpellChargeCooldown(throwing_axes) == 2 and Spell(throwing_axes) or { Charges(mongoose_bite) >= 2 and SpellCooldown(mongoose_bite) <= GCD() or Charges(mongoose_bite) == 3 } and Spell(mongoose_bite) or Spell(butchery) or Spell(throwing_axes) or Spell(flanking_strike) or Focus() > 75 - SpellCooldown(flanking_strike) * FocusRegenRate() and Spell(raptor_strike)
}

AddFunction SurvivalNomokCdActions
{
	unless SpellChargeCooldown(mongoose_bite) >= 0 and BuffStacks(mongoose_fury_buff) < 4 and Spell(a_murder_of_crows) or Charges(mongoose_bite) <= 0 and BuffRemaining(mongoose_fury_buff) > 3 * GCD() and Spell(snake_hunter) or BaseDuration(mongoose_fury_buff) >= GCD() and BuffStacks(mongoose_fury_buff) < 4 and CheckBoxOn(opt_trap_launcher) and Spell(steel_trap) or BaseDuration(mongoose_fury_buff) >= GCD() and BuffStacks(mongoose_fury_buff) < 4 and not target.DebuffPresent(caltrops_debuff) and Spell(caltrops) or SpellChargeCooldown(mongoose_bite) <= 0 and BuffRemaining(aspect_of_the_eagle_buff) >= GCD() and Spell(flanking_strike) or BaseDuration(mongoose_fury_buff) >= GCD() and target.DebuffRemaining(lacerate_debuff) <= 1 and SpellChargeCooldown(mongoose_bite) >= 0 and BuffStacks(mongoose_fury_buff) < 4 and Spell(lacerate) or BaseDuration(mongoose_fury_buff) >= GCD() and SpellChargeCooldown(mongoose_bite) >= 0 and BuffStacks(mongoose_fury_buff) < 4 and Spell(spitting_cobra) or BaseDuration(mongoose_fury_buff) >= GCD() and BuffStacks(mongoose_fury_buff) < 4 and CheckBoxOn(opt_trap_launcher) and Spell(steel_trap) or BaseDuration(mongoose_fury_buff) >= GCD() and SpellChargeCooldown(mongoose_bite) >= 0 and BuffStacks(mongoose_fury_buff) < 4 and CheckBoxOn(opt_trap_launcher) and Spell(explosive_trap) or BaseDuration(mongoose_fury_buff) >= GCD() and SpellChargeCooldown(mongoose_bite) >= 0 and BuffStacks(mongoose_fury_buff) < 4 and Spell(dragonsfire_grenade) or Talent(serpent_sting_talent) and target.DebuffRemaining(serpent_sting_debuff) < GCD() and Spell(raptor_strike) or BuffStacks(mongoose_fury_buff) == 6 and SpellChargeCooldown(mongoose_bite) <= 2 and Spell(fury_of_the_eagle) or BuffPresent(aspect_of_the_eagle_buff) and BuffPresent(mongoose_fury_buff) and Spell(mongoose_bite)
	{
		#aspect_of_the_eagle,if=buff.mongoose_fury.up&buff.mongoose_fury.duration>6&cooldown.mongoose_bite.charges>=2
		if BuffPresent(mongoose_fury_buff) and BaseDuration(mongoose_fury_buff) > 6 and SpellChargeCooldown(mongoose_bite) >= 2 Spell(aspect_of_the_eagle)
	}
}

AddFunction SurvivalNomokCdPostConditions
{
	SpellChargeCooldown(mongoose_bite) >= 0 and BuffStacks(mongoose_fury_buff) < 4 and Spell(a_murder_of_crows) or Charges(mongoose_bite) <= 0 and BuffRemaining(mongoose_fury_buff) > 3 * GCD() and Spell(snake_hunter) or BaseDuration(mongoose_fury_buff) >= GCD() and BuffStacks(mongoose_fury_buff) < 4 and CheckBoxOn(opt_trap_launcher) and Spell(steel_trap) or BaseDuration(mongoose_fury_buff) >= GCD() and BuffStacks(mongoose_fury_buff) < 4 and not target.DebuffPresent(caltrops_debuff) and Spell(caltrops) or SpellChargeCooldown(mongoose_bite) <= 0 and BuffRemaining(aspect_of_the_eagle_buff) >= GCD() and Spell(flanking_strike) or BaseDuration(mongoose_fury_buff) >= GCD() and target.DebuffRemaining(lacerate_debuff) <= 1 and SpellChargeCooldown(mongoose_bite) >= 0 and BuffStacks(mongoose_fury_buff) < 4 and Spell(lacerate) or BaseDuration(mongoose_fury_buff) >= GCD() and SpellChargeCooldown(mongoose_bite) >= 0 and BuffStacks(mongoose_fury_buff) < 4 and Spell(spitting_cobra) or BaseDuration(mongoose_fury_buff) >= GCD() and BuffStacks(mongoose_fury_buff) < 4 and CheckBoxOn(opt_trap_launcher) and Spell(steel_trap) or BaseDuration(mongoose_fury_buff) >= GCD() and SpellChargeCooldown(mongoose_bite) >= 0 and BuffStacks(mongoose_fury_buff) < 4 and CheckBoxOn(opt_trap_launcher) and Spell(explosive_trap) or BaseDuration(mongoose_fury_buff) >= GCD() and SpellChargeCooldown(mongoose_bite) >= 0 and BuffStacks(mongoose_fury_buff) < 4 and Spell(dragonsfire_grenade) or Talent(serpent_sting_talent) and target.DebuffRemaining(serpent_sting_debuff) < GCD() and Spell(raptor_strike) or BuffStacks(mongoose_fury_buff) == 6 and SpellChargeCooldown(mongoose_bite) <= 2 and Spell(fury_of_the_eagle) or BuffPresent(aspect_of_the_eagle_buff) and BuffPresent(mongoose_fury_buff) and Spell(mongoose_bite) or SpellChargeCooldown(mongoose_bite) <= 0 and BaseDuration(mongoose_fury_buff) > 6 and Spell(fury_of_the_eagle) or SpellChargeCooldown(mongoose_bite) < 2 and BuffRemaining(mongoose_fury_buff) > 1 + Charges(mongoose_bite) * GCD() and Spell(flanking_strike) or BuffPresent(mongoose_fury_buff) and BuffRemaining(mongoose_fury_buff) < SpellCooldown(aspect_of_the_eagle) and Spell(mongoose_bite) or Talent(animal_instincts_talent) and SpellChargeCooldown(mongoose_bite) < 3 and Spell(flanking_strike) or Spell(a_murder_of_crows) or Spell(spitting_cobra) or CheckBoxOn(opt_trap_launcher) and Spell(steel_trap) or CheckBoxOn(opt_trap_launcher) and Spell(explosive_trap) or not target.DebuffPresent(caltrops_debuff) and Spell(caltrops) or { not target.DebuffPresent(lacerate_debuff) or target.DebuffRemaining(lacerate_debuff) < 3 } and Spell(lacerate) or Spell(dragonsfire_grenade) or Charges(butchery) == 3 and Spell(butchery) or SpellChargeCooldown(throwing_axes) == 2 and Spell(throwing_axes) or { Charges(mongoose_bite) >= 2 and SpellCooldown(mongoose_bite) <= GCD() or Charges(mongoose_bite) == 3 } and Spell(mongoose_bite) or Spell(butchery) or Spell(throwing_axes) or Spell(flanking_strike) or Focus() > 75 - SpellCooldown(flanking_strike) * FocusRegenRate() and Spell(raptor_strike)
}

### actions.precombat

AddFunction SurvivalPrecombatMainActions
{
	#snapshot_stats
	#potion,name=old_war
	#augmentation,type=defiled
	Spell(augmentation)
	#harpoon
	Spell(harpoon)
}

AddFunction SurvivalPrecombatMainPostConditions
{
}

AddFunction SurvivalPrecombatShortCdActions
{
	#flask,type=flask_of_the_seventh_demon
	#food,type=fishbrul_special
	#summon_pet
	SurvivalSummonPet()

	unless Spell(augmentation)
	{
		#dragonsfire_grenade
		Spell(dragonsfire_grenade)
	}
}

AddFunction SurvivalPrecombatShortCdPostConditions
{
	Spell(augmentation) or Spell(harpoon)
}

AddFunction SurvivalPrecombatCdActions
{
}

AddFunction SurvivalPrecombatCdPostConditions
{
	Spell(augmentation) or Spell(dragonsfire_grenade) or Spell(harpoon)
}

### Survival icons.

AddCheckBox(opt_hunter_survival_aoe L(AOE) default specialization=survival)

AddIcon checkbox=!opt_hunter_survival_aoe enemies=1 help=shortcd specialization=survival
{
	if not InCombat() SurvivalPrecombatShortCdActions()
	unless not InCombat() and SurvivalPrecombatShortCdPostConditions()
	{
		SurvivalDefaultShortCdActions()
	}
}

AddIcon checkbox=opt_hunter_survival_aoe help=shortcd specialization=survival
{
	if not InCombat() SurvivalPrecombatShortCdActions()
	unless not InCombat() and SurvivalPrecombatShortCdPostConditions()
	{
		SurvivalDefaultShortCdActions()
	}
}

AddIcon enemies=1 help=main specialization=survival
{
	if not InCombat() SurvivalPrecombatMainActions()
	unless not InCombat() and SurvivalPrecombatMainPostConditions()
	{
		SurvivalDefaultMainActions()
	}
}

AddIcon checkbox=opt_hunter_survival_aoe help=aoe specialization=survival
{
	if not InCombat() SurvivalPrecombatMainActions()
	unless not InCombat() and SurvivalPrecombatMainPostConditions()
	{
		SurvivalDefaultMainActions()
	}
}

AddIcon checkbox=!opt_hunter_survival_aoe enemies=1 help=cd specialization=survival
{
	if not InCombat() SurvivalPrecombatCdActions()
	unless not InCombat() and SurvivalPrecombatCdPostConditions()
	{
		SurvivalDefaultCdActions()
	}
}

AddIcon checkbox=opt_hunter_survival_aoe help=cd specialization=survival
{
	if not InCombat() SurvivalPrecombatCdActions()
	unless not InCombat() and SurvivalPrecombatCdPostConditions()
	{
		SurvivalDefaultCdActions()
	}
}

### Required symbols
# a_murder_of_crows
# animal_instincts_talent
# arcane_torrent_focus
# aspect_of_the_eagle
# aspect_of_the_eagle_buff
# augmentation
# berserking
# blood_fury_ap
# butchery
# caltrops
# caltrops_debuff
# dragonsfire_grenade
# explosive_trap
# flanking_strike
# fury_of_the_eagle
# harpoon
# lacerate
# lacerate_debuff
# lone_wolf_talent
# moknathal_tactics_buff
# mongoose_bite
# mongoose_fury_buff
# muzzle
# quaking_palm
# raptor_strike
# revive_pet
# serpent_sting_debuff
# serpent_sting_talent
# snake_hunter
# spitting_cobra
# steel_trap
# throwing_axes
# trap_launcher
# war_stomp
# way_of_the_moknathal_talent
]]
	OvaleScripts:RegisterScript("HUNTER", "survival", name, desc, code, "script")
end
