local OVALE, Ovale = ...
local OvaleScripts = Ovale.OvaleScripts

do
	local name = "ovale_priest_spells"
	local desc = "[7.0] Ovale: Priest spells"
	local code = [[
# Priest spells and functions.

# Learned spells
Define(borrowed_time 52798)
	SpellInfo(borrowed_time learn=1 level=10 specialization=discipline)
Define(rapture 47536)
	SpellInfo(rapture learn=1 level=10 specialization=discipline)
Define(surge_of_light 109186)
	SpellInfo(surge_of_light learn=1 level=45 specialization=discipline)
	SpellInfo(surge_of_light learn=1 level=45 specialization=holy)

# Dummy spells
Define(mindbender_tier18_2pc 999123040)
	SpellInfo(mindbender_tier18_2pc dummy_replace=123040 replace=mindbender)
	SpellInfo(mindbender_tier18_2pc cd=20)
Define(shadowfiend_tier18_2pc 999034433)
	SpellInfo(shadowfiend_tier18_2pc dummy_replace=34433 replace=shadowfiend)
	SpellInfo(shadowfiend_tier18_2pc cd=20)

Define(archangel 81700)
	SpellInfo(archangel cd=30 gcd=0 offgcd=1)
	SpellRequire(archangel unusable 1=buff,!evangelism_buff)
	SpellAddBuff(archangel archangel_buff=1)
	SpellAddBuff(archangel clear_thoughts_buff=1 itemset=T17 itemcount=4 specialization=discipline)
	SpellAddBuff(archangel evangelism_buff=0 if_spell=evangelism)
Define(archangel_buff 81700)
	SpellInfo(archangel_buff duration=18)
Define(auspicious_spirits_talent 21)
Define(binding_heal 32546)
	SpellAddBuff(binding_heal serendipity_buff=1 if_spell=serendipity)
Define(body_and_soul_talent 4)
Define(borrowed_time_buff 59889)
	SpellInfo(borrowed_time_buff duration=6)
Define(cascade_caster 121135)
	SpellInfo(cascade_caster cd=25 travel_time=1)
Define(cascade_heal 121135)
	SpellInfo(cascade_heal cd=25 travel_time=1)
Define(cascade_talent 16)
Define(chakra_chastise 81209)
	SpellInfo(chakra_chastise cd=30 sharedcd=chakra)
	SpellInfo(chakra_chastise addcd=-20 if_spell=enhanced_chakras)
	SpellInfo(chakra_chastise unusable=1)
	SpellAddBuff(chakra_chastise chakra_chastise_buff=1)
Define(chakra_chastise_buff 81209)
Define(chakra_sanctuary 81206)
	SpellInfo(chakra_sanctuary cd=30 sharedcd=chakra)
	SpellInfo(chakra_sanctuary addcd=-20 if_spell=enhanced_chakras)
	SpellInfo(chakra_sanctuary unusable=1)
	SpellAddBuff(chakra_sanctuary chakra_sanctuary_buff=1)
Define(chakra_sanctuary_buff 81206)
Define(chakra_serenity 81208)
	SpellInfo(chakra_serenity cd=30 sharedcd=chakra)
	SpellInfo(chakra_serenity addcd=-20 if_spell=enhanced_chakras)
	SpellInfo(chakra_serenity unusable=1)
	SpellAddBuff(chakra_serenity chakra_serenity_buff=1)
Define(chakra_serenity_buff 81208)
Define(circle_of_healing 34861)
	SpellInfo(circle_of_healing cd=12)
	SpellInfo(circle_of_healing addcd=-4 itemset=T14_heal itemcount=4)
Define(clarity_of_power 155246)
Define(clarity_of_power_talent 19)
Define(clarity_of_purpose 155245)
	SpellAddBuff(clarity_of_purpose serendipity_buff=0 if_spell=serendipity)
Define(clarity_of_purpose_talent 19)
Define(clarity_of_will 152118)
	SpellAddTargetBuff(clarity_of_will clarity_of_will_buff=1)
Define(clarity_of_will_buff 152118)
	SpellInfo(clarity_of_will_buff duration=20)
Define(clarity_of_will_talent 19)
Define(clear_thoughts_buff 167695)
	SpellInfo(clear_thoughts_buff duration=6)
Define(devouring_plague 2944)
	SpellInfo(devouring_plague shadoworbs=finisher min_shadoworbs=3)
	SpellAddTargetDebuff(devouring_plague devouring_plague_debuff=1)
	SpellAddTargetDebuff(devouring_plague void_entropy_debuff=refresh if_spell=void_entropy)
Define(devouring_plague_debuff 158831)
	SpellInfo(devouring_plague_debuff duration=6 haste=spell tick=1)
Define(devouring_plague_dot_debuff 158831)
Define(dispersion 47585)
	SpellInfo(dispersion cd=120)
Define(divine_hymn 64843)
	SpellInfo(divine_hymn cd=180 channel=4 haste=spell)
Define(divine_insight 109175)
Define(divine_insight_buff 123267)
	SpellInfo(divine_insight_buff duration=10)
Define(divine_star_caster 110744)
	SpellInfo(divine_star_caster cd=15 travel_time=1)
Define(divine_star_heal 110744)
	SpellInfo(divine_star_heal cd=15 travel_time=1)
Define(divine_star_talent 17)
Define(empowered_archangel 157197)
Define(empowered_archangel_buff 172359)
	SpellInfo(empowered_archangel_buff duration=30)
Define(enhanced_chakras 157206)
Define(enhanced_mind_flay 157223)
Define(enhanced_power_word_shield 157129)
Define(enhanced_renew 157207)
Define(enhanced_shadow_word_death 157218)
Define(evangelism 81662)
Define(evangelism_buff 81661)
	SpellInfo(evangelism_buff duration=20 max_stacks=5)
Define(flash_heal 2061)
	SpellAddBuff(flash_heal empowered_archangel_buff=0 if_spell=empowered_archangel)
	SpellAddBuff(flash_heal serendipity_buff=1 if_spell=serendipity)
	SpellAddBuff(flash_heal surge_of_light_buff=0 if_spell=surge_of_light)
	SpellAddTargetBuff(flash_heal renew_buff=refresh if_spell=chakra_serenity)
Define(fortress_of_the_mind_talent 2)
Define(from_the_shadows 193642)
Define(halo_caster 120644)
	SpellInfo(halo_caster cd=40 travel_time=2)
Define(halo_heal 120517)
	SpellInfo(halo_heal cd=40 travel_time=2)
Define(halo_talent 18)
Define(heal 2060)
	SpellAddBuff(heal serendipity_buff=0 if_spell=serendipity)
	SpellAddTargetBuff(heal renew_buff=refresh if_spell=chakra_serenity)
Define(holy_fire 14914)
	SpellInfo(holy_fire cd=10)
	SpellInfo(holy_fire replace=power_word_solace talent=power_word_solace_talent)
	SpellAddBuff(holy_fire evangelism_buff=1 if_spell=evangelism)
	SpellAddTargetDebuff(holy_fire holy_fire_debuff=1)
Define(holy_fire_debuff 14914)
	SpellInfo(holy_fire_debuff duration=9 haste=spell tick=1)
Define(holy_word 88625)
Define(holy_word_chastise 88625)
	SpellInfo(holy_word_chastise cd=30)
	SpellInfo(holy_word_chastise replace=holy_word_sanctuary if_spell=chakra_sanctuary)
	SpellInfo(holy_word_chastise replace=holy_word_serenity if_spell=chakra_serenity)
Define(holy_word_sanctuary 88685)
	SpellInfo(holy_word_sanctuary cd=40)
Define(holy_word_serenity 88684)
	SpellInfo(holy_word_serenity cd=10)
	SpellAddTargetBuff(holy_word_serenity holy_word_serenity_buff=1)
	SpellAddTargetBuff(holy_word_serenity renew_buff=refresh,buff,chakra_serenity_buff if_spell=chakra_serenity)
Define(holy_word_serenity_buff 88684)
	SpellInfo(holy_word_serenity_buff duration=6)
Define(insanity_drain_stacks_buff 194249)
Define(legacy_of_the_void_talent 19)
Define(lightwell 126135)
	SpellInfo(lightwell cd=180)
Define(mass_hysteria 194378)
Define(mental_fatigue_debuff 185104)
	SpellInfo(mental_fatigue_debuff duration=10 max_stacks=5)
Define(mental_instinct_buff 167254)
	SpellInfo(mental_instinct_buff duration=4 max_stacks=12)
Define(mind_blast 8092)
	SpellInfo(mind_blast cd=9 cd_haste=spell shadoworbs=-1)
	SpellInfo(mind_blast addcd=-3 if_spell=clarity_of_power)
	SpellAddBuff(mind_blast shadowy_insight_buff=0 if_spell=shadowy_insight)
Define(mind_flay 15407)
	SpellInfo(mind_flay channel=3 haste=spell)
	SpellInfo(mind_flay channel=2 if_spell=enhanced_mind_flay)
Define(mind_spike 73510)
	SpellAddBuff(mind_spike surge_of_darkness_buff=-1 if_spell=surge_of_darkness)
	SpellAddTargetDebuff(mind_spike devouring_plague_debuff=0,buff,!surge_of_darkness_buff)
	SpellAddTargetDebuff(mind_spike shadow_word_pain_debuff=0,buff,!surge_of_darkness_buff)
	SpellAddTargetDebuff(mind_spike vampiric_touch_debuff=0,buff,!surge_of_darkness_buff)
	SpellAddTargetDebuff(mind_spike void_entropy_debuff=0,buff,!surge_of_darkness_buff if_spell=void_entropy)
Define(mind_spike_talent 20)
Define(mindbender 123040)
	SpellInfo(mindbender cd=60)
	SpellInfo(mindbender addcd=-40 itemset=T18 itemcount=2 specialization=shadow)
Define(mindbender_talent 8)
Define(misery_talent 17)
Define(penance 47540)
	SpellInfo(penance cd=9)
	SpellInfo(penance addcd=-3 itemset=T14_heal itemcount=4)
	SpellAddBuff(penance evangelism_buff=1 if_spell=evangelism itemset=T17 itemset=2 specialization=discipline)
	SpellAddBuff(penance reparation_buff=1 itemset=T18 itemcount=2 specialization=discipline)
Define(penance_heal 47540)
	SpellAddBuff(penance_heal reparation_buff=1 itemset=T18 itemcount=2 specialization=discipline)
Define(power_infusion 10060)
	SpellInfo(power_infusion cd=120 gcd=0)
	SpellAddBuff(power_infusion power_infusion_buff=1)
Define(power_infusion_buff 10060)
	SpellInfo(power_infusion_buff duration=20)
Define(power_infusion_talent 14)
Define(power_word_fortitude 21562)
	SpellAddBuff(power_word_fortitude power_word_fortitude_buff=1)
Define(power_word_fortitude_buff 21562)
	SpellInfo(power_word_fortitude_buff duration=3600)
Define(power_word_shield 17)
	SpellInfo(power_word_shield cd=6)
	SpellInfo(power_word_shield cd=0 if_spell=rapture)
	SpellRequire(power_word_shield unusable 1=target_debuff,weakened_soul_debuff)
	SpellAddBuff(power_word_shield borrowed_time_buff=1 if_spell=borrowed_time)
	SpellAddDebuff(power_word_shield weakened_soul_debuff=1)
Define(power_word_solace 129250)
	SpellInfo(power_word_solace cd=10)
	SpellAddBuff(power_word_solace evangelism_buff=1 if_spell=evangelism)
	SpellAddTargetDebuff(power_word_solace power_word_solace_debuff=1)
Define(power_word_solace_debuff 129250)
	SpellInfo(power_word_solace_debuff duration=9 haste=spell tick=1)
Define(power_word_solace_talent 9)
Define(prayer_of_healing 596)
	SpellInfo(prayer_of_healing replace=clarity_of_purpose talent=clarity_of_purpose_talent specialization=holy)
	SpellAddBuff(prayer_of_healing empowered_archangel_buff=0 if_spell=empowered_archangel)
	SpellAddBuff(prayer_of_healing serendipity_buff=0 if_spell=serendipity)
Define(prayer_of_mending 33076)
	SpellInfo(prayer_of_mending cd=10)
	SpellRequire(prayer_of_mending replace prayer_of_mending_divine_insight=buff,divine_insight_buff if_spell=divine_insight)
Define(prayer_of_mending_buff 41635)
	SpellInfo(prayer_of_mending_buff duration=30 max_stacks=5)
Define(prayer_of_mending_divine_insight 123259)
	SpellAddBuff(prayer_of_mending_divine_insight divine_insight_buff=0)
Define(prayers_reprise_buff 186367)
	SpellInfo(prayers_reprise_buff duration=15 max_stacks=3)
Define(premonition_buff 188779)
	SpellInfo(premonition_buff duration=15)
Define(psychic_scream 8122)
	SpellInfo(psychic_scream cd=30)
Define(psychic_scream_talent 11)
Define(reaper_of_souls_talent 11)
Define(reparation_buff 186478)
	SpellInfo(reparation_buff duration=15 max_stacks=6)
Define(renew 139)
Define(renew_buff 139)
	SpellInfo(renew_buff duration=12 haste=spell tick=3)
Define(sanlayn_talent 13)
Define(serendipity 63733)
Define(serendipity_buff 63735)
	SpellInfo(serendipity_buff duration=20 max_stacks=2)
Define(shadow_crash 205385)
	SpellInfo(shadow_crash cd=30 insanity=-15)
Define(shadow_crash_talent 17)
Define(shadow_word_void 205351)
	SpellInfo(shadow_word_void cd=30 charges=3 insanity=-25)
Define(shadow_word_death 32379)
	SpellInfo(shadow_word_death cd=8 shadoworbs=-1 target_health_pct=20)
	SpellRequire(shadow_word_death shadoworbs 0=buff,shadow_word_death_reset_cooldown_buff if_spell=!enhanced_shadow_word_death)
Define(shadow_word_death_reset_cooldown_buff 125927)	# OvaleShadowWordDeath
	SpellInfo(shadow_word_death_reset_cooldown_buff duration=9)
Define(shadow_word_pain 589)
	SpellAddTargetDebuff(shadow_word_pain shadow_word_pain_debuff=1)
Define(shadow_word_pain_debuff 589)
	SpellInfo(shadow_word_pain_debuff duration=18 haste=spell tick=3)
	SpellInfo(shadow_word_pain_debuff addduration=3 itemset=T14_caster itemcount=4)
Define(shadow_word_void_talent 3)
Define(shadowfiend 34433)
	SpellInfo(shadowfiend cd=180)
	SpellInfo(shadowfiend addcd=-160 itemset=T18 itemcount=2 specialization=shadow)
	SpellInfo(shadowfiend replace=mindbender if_spell=mindbender)
Define(shadowform 232698)
Define(shadowform_buff 232698)
Define(shadowy_insight 162452)
Define(shadowy_insight_buff 124430)
	SpellInfo(shadowy_insight_buff duration=12)
Define(shadowy_insight_talent 15)
Define(silence 15487)
	SpellInfo(silence cd=45 gcd=0 interrupt=1)
Define(smite 585)
	SpellAddBuff(smite evangelism_buff=1 if_spell=evangelism)
Define(sphere_of_insanity 194179)
Define(surge_of_darkness 87160)
Define(surge_of_darkness_buff 87160)
	SpellInfo(surge_of_darkness_buff duration=10 max_stacks=3)
Define(surge_of_darkness_talent 7)
Define(surge_of_light_buff 114255)
	SpellInfo(surge_of_light_buff duration=20)
Define(surrender_to_madness 193223)
	SpellInfo(surrender_to_madness cd=600)
	SpellAddBuff(surrender_to_madness surrender_to_madness_buff=1)
Define(surrender_to_madness_buff 193223)
	SpellInfo(surrender_to_madness_buff duration=180)
Define(surrender_to_madness_talent 21)
Define(t18_class_trinket 124519)
Define(unleash_the_shadows 194093)
Define(vampiric_touch 34914)
	SpellAddTargetDebuff(vampiric_touch vampiric_touch_debuff=1)
Define(vampiric_touch_debuff 34914)
	SpellInfo(vampiric_touch_debuff duration=15 haste=spell tick=3)
	SpellInfo(vampiric_touch_debuff addduration=3 itemset=T14_caster itemcount=4)
Define(void_bolt 205448)
	SpellInfo(void_bolt cd=4.5 insanity=-16)
	SpellAddTargetDebuff(void_bolt shadow_word_pain_debuff=refresh)
	SpellAddTargetDebuff(void_bolt vampiric_touch_debuff=refresh)
Define(void_entropy 155361)
	SpellInfo(void_entropy shadoworbs=finisher min_shadoworbs=3)
	SpellAddTargetDebuff(void_entropy void_entropy_debuff=1)
Define(void_entropy_debuff 155361)
	SpellInfo(void_entropy_debuff duration=60 haste=spell tick=3)
Define(void_entropy_talent 20)
Define(void_eruption 228260)
	SpellInfo(void_eruption cd=180 insanity=100)
	SpellAddBuff(void_eruption voidform_buff=1)
	SpellRequire(void_eruption unusable 1=buff,voidform_buff)
	SpellRequire(void_eruption replace void_bolt=buff,voidform_buff)
Define(void_torrent 205065)
	SpellInfo(void_torrent cd=60)
	SpellRequire(void_torrent unusable 0=buff,voidform_buff)
Define(void_torrent_buff 205065)
# TODO Insanity does not drain during this buff
Define(voidform_buff 194249)
Define(weakened_soul_debuff 6788)
	SpellInfo(weakened_soul_debuff duration=15)

# Non-default tags for OvaleSimulationCraft.
	SpellInfo(cascade_caster tag=shortcd)
	SpellInfo(divine_star_caster tag=shortcd)

AddFunction CurrentInsanityDrain {
	if BuffPresent(void_torrent_buff) 0
	if BuffPresent(voidform_buff) BuffStacks(voidform_buff)/2 + 9
	0
}
]]

	OvaleScripts:RegisterScript("PRIEST", nil, name, desc, code, "include")
end
