local OVALE, Ovale = ...
local OvaleScripts = Ovale.OvaleScripts

-- THE REST OF THIS FILE IS AUTOMATICALLY GENERATED.
-- ANY CHANGES MADE BELOW THIS POINT WILL BE LOST.

do
	local name = "simulationcraft_rogue_assassination_t19p"
	local desc = "[7.0] SimulationCraft: Rogue_Assassination_T19P"
	local code = [[
# Based on SimulationCraft profile "Rogue_Assassination_T19P".
#	class=rogue
#	spec=assassination
#	talents=1130111

Include(ovale_common)
Include(ovale_trinkets_mop)
Include(ovale_trinkets_wod)
Include(ovale_rogue_spells)

AddCheckBox(opt_melee_range L(not_in_melee_range) specialization=assassination)
AddCheckBox(opt_vanish SpellName(vanish) default specialization=assassination)

AddFunction AssassinationUseItemActions
{
	Item(Trinket0Slot usable=1)
	Item(Trinket1Slot usable=1)
}

AddFunction AssassinationGetInMeleeRange
{
	if CheckBoxOn(opt_melee_range) and not target.InRange(kick)
	{
		Spell(shadowstep)
		Texture(misc_arrowlup help=L(not_in_melee_range))
	}
}

### actions.default

AddFunction AssassinationDefaultMainActions
{
	#call_action_list,name=cds
	AssassinationCdsMainActions()

	unless AssassinationCdsMainPostConditions()
	{
		#call_action_list,name=maintain
		AssassinationMaintainMainActions()

		unless AssassinationMaintainMainPostConditions()
		{
			#call_action_list,name=finish,if=(!talent.exsanguinate.enabled|cooldown.exsanguinate.remains>2)&(!dot.rupture.refreshable|(dot.rupture.exsanguinated&dot.rupture.remains>=3.5)|target.time_to_die-dot.rupture.remains<=4)&active_dot.rupture>=spell_targets.rupture
			if { not Talent(exsanguinate_talent) or SpellCooldown(exsanguinate) > 2 } and { not target.DebuffRefreshable(rupture_debuff) or target.DebuffRemaining(rupture_debuff_exsanguinated) and target.DebuffRemaining(rupture_debuff) >= 3.5 or target.TimeToDie() - target.DebuffRemaining(rupture_debuff) <= 4 } and DebuffCountOnAny(rupture_debuff) >= Enemies() AssassinationFinishMainActions()

			unless { not Talent(exsanguinate_talent) or SpellCooldown(exsanguinate) > 2 } and { not target.DebuffRefreshable(rupture_debuff) or target.DebuffRemaining(rupture_debuff_exsanguinated) and target.DebuffRemaining(rupture_debuff) >= 3.5 or target.TimeToDie() - target.DebuffRemaining(rupture_debuff) <= 4 } and DebuffCountOnAny(rupture_debuff) >= Enemies() and AssassinationFinishMainPostConditions()
			{
				#call_action_list,name=build,if=(combo_points.deficit>0|energy.time_to_max<1)
				if ComboPointsDeficit() > 0 or TimeToMaxEnergy() < 1 AssassinationBuildMainActions()
			}
		}
	}
}

AddFunction AssassinationDefaultMainPostConditions
{
	AssassinationCdsMainPostConditions() or AssassinationMaintainMainPostConditions() or { not Talent(exsanguinate_talent) or SpellCooldown(exsanguinate) > 2 } and { not target.DebuffRefreshable(rupture_debuff) or target.DebuffRemaining(rupture_debuff_exsanguinated) and target.DebuffRemaining(rupture_debuff) >= 3.5 or target.TimeToDie() - target.DebuffRemaining(rupture_debuff) <= 4 } and DebuffCountOnAny(rupture_debuff) >= Enemies() and AssassinationFinishMainPostConditions() or { ComboPointsDeficit() > 0 or TimeToMaxEnergy() < 1 } and AssassinationBuildMainPostConditions()
}

AddFunction AssassinationDefaultShortCdActions
{
	#call_action_list,name=cds
	AssassinationCdsShortCdActions()

	unless AssassinationCdsShortCdPostConditions()
	{
		#call_action_list,name=maintain
		AssassinationMaintainShortCdActions()

		unless AssassinationMaintainShortCdPostConditions()
		{
			#call_action_list,name=finish,if=(!talent.exsanguinate.enabled|cooldown.exsanguinate.remains>2)&(!dot.rupture.refreshable|(dot.rupture.exsanguinated&dot.rupture.remains>=3.5)|target.time_to_die-dot.rupture.remains<=4)&active_dot.rupture>=spell_targets.rupture
			if { not Talent(exsanguinate_talent) or SpellCooldown(exsanguinate) > 2 } and { not target.DebuffRefreshable(rupture_debuff) or target.DebuffRemaining(rupture_debuff_exsanguinated) and target.DebuffRemaining(rupture_debuff) >= 3.5 or target.TimeToDie() - target.DebuffRemaining(rupture_debuff) <= 4 } and DebuffCountOnAny(rupture_debuff) >= Enemies() AssassinationFinishShortCdActions()

			unless { not Talent(exsanguinate_talent) or SpellCooldown(exsanguinate) > 2 } and { not target.DebuffRefreshable(rupture_debuff) or target.DebuffRemaining(rupture_debuff_exsanguinated) and target.DebuffRemaining(rupture_debuff) >= 3.5 or target.TimeToDie() - target.DebuffRemaining(rupture_debuff) <= 4 } and DebuffCountOnAny(rupture_debuff) >= Enemies() and AssassinationFinishShortCdPostConditions()
			{
				#call_action_list,name=build,if=(combo_points.deficit>0|energy.time_to_max<1)
				if ComboPointsDeficit() > 0 or TimeToMaxEnergy() < 1 AssassinationBuildShortCdActions()
			}
		}
	}
}

AddFunction AssassinationDefaultShortCdPostConditions
{
	AssassinationCdsShortCdPostConditions() or AssassinationMaintainShortCdPostConditions() or { not Talent(exsanguinate_talent) or SpellCooldown(exsanguinate) > 2 } and { not target.DebuffRefreshable(rupture_debuff) or target.DebuffRemaining(rupture_debuff_exsanguinated) and target.DebuffRemaining(rupture_debuff) >= 3.5 or target.TimeToDie() - target.DebuffRemaining(rupture_debuff) <= 4 } and DebuffCountOnAny(rupture_debuff) >= Enemies() and AssassinationFinishShortCdPostConditions() or { ComboPointsDeficit() > 0 or TimeToMaxEnergy() < 1 } and AssassinationBuildShortCdPostConditions()
}

AddFunction AssassinationDefaultCdActions
{
	#call_action_list,name=cds
	AssassinationCdsCdActions()

	unless AssassinationCdsCdPostConditions()
	{
		#call_action_list,name=maintain
		AssassinationMaintainCdActions()

		unless AssassinationMaintainCdPostConditions()
		{
			#call_action_list,name=finish,if=(!talent.exsanguinate.enabled|cooldown.exsanguinate.remains>2)&(!dot.rupture.refreshable|(dot.rupture.exsanguinated&dot.rupture.remains>=3.5)|target.time_to_die-dot.rupture.remains<=4)&active_dot.rupture>=spell_targets.rupture
			if { not Talent(exsanguinate_talent) or SpellCooldown(exsanguinate) > 2 } and { not target.DebuffRefreshable(rupture_debuff) or target.DebuffRemaining(rupture_debuff_exsanguinated) and target.DebuffRemaining(rupture_debuff) >= 3.5 or target.TimeToDie() - target.DebuffRemaining(rupture_debuff) <= 4 } and DebuffCountOnAny(rupture_debuff) >= Enemies() AssassinationFinishCdActions()

			unless { not Talent(exsanguinate_talent) or SpellCooldown(exsanguinate) > 2 } and { not target.DebuffRefreshable(rupture_debuff) or target.DebuffRemaining(rupture_debuff_exsanguinated) and target.DebuffRemaining(rupture_debuff) >= 3.5 or target.TimeToDie() - target.DebuffRemaining(rupture_debuff) <= 4 } and DebuffCountOnAny(rupture_debuff) >= Enemies() and AssassinationFinishCdPostConditions()
			{
				#call_action_list,name=build,if=(combo_points.deficit>0|energy.time_to_max<1)
				if ComboPointsDeficit() > 0 or TimeToMaxEnergy() < 1 AssassinationBuildCdActions()
			}
		}
	}
}

AddFunction AssassinationDefaultCdPostConditions
{
	AssassinationCdsCdPostConditions() or AssassinationMaintainCdPostConditions() or { not Talent(exsanguinate_talent) or SpellCooldown(exsanguinate) > 2 } and { not target.DebuffRefreshable(rupture_debuff) or target.DebuffRemaining(rupture_debuff_exsanguinated) and target.DebuffRemaining(rupture_debuff) >= 3.5 or target.TimeToDie() - target.DebuffRemaining(rupture_debuff) <= 4 } and DebuffCountOnAny(rupture_debuff) >= Enemies() and AssassinationFinishCdPostConditions() or { ComboPointsDeficit() > 0 or TimeToMaxEnergy() < 1 } and AssassinationBuildCdPostConditions()
}

### actions.build

AddFunction AssassinationBuildMainActions
{
	#hemorrhage,if=refreshable
	if target.Refreshable(hemorrhage_debuff) Spell(hemorrhage)
	#hemorrhage,cycle_targets=1,if=refreshable&dot.rupture.ticking&spell_targets.fan_of_knives<=3
	if target.Refreshable(hemorrhage_debuff) and target.DebuffPresent(rupture_debuff) and Enemies() <= 3 Spell(hemorrhage)
	#fan_of_knives,if=spell_targets>=3|buff.the_dreadlords_deceit.stack>=29
	if Enemies() >= 3 or BuffStacks(the_dreadlords_deceit_buff) >= 29 Spell(fan_of_knives)
	#mutilate,cycle_targets=1,if=(!talent.agonizing_poison.enabled&dot.deadly_poison_dot.refreshable)|(talent.agonizing_poison.enabled&debuff.agonizing_poison.remains<debuff.agonizing_poison.duration*0.3)|(set_bonus.tier19_2pc=1&dot.mutilated_flesh.refreshable)
	if not Talent(agonizing_poison_talent) and target.DebuffRefreshable(deadly_poison_dot_debuff) or Talent(agonizing_poison_talent) and target.DebuffRemaining(agonizing_poison_debuff) < BaseDuration(agonizing_poison_debuff) * 0.3 or ArmorSetBonus(T19 2) == 1 and target.DebuffRefreshable(mutilated_flesh_debuff) Spell(mutilate)
	#mutilate
	Spell(mutilate)
}

AddFunction AssassinationBuildMainPostConditions
{
}

AddFunction AssassinationBuildShortCdActions
{
}

AddFunction AssassinationBuildShortCdPostConditions
{
	target.Refreshable(hemorrhage_debuff) and Spell(hemorrhage) or target.Refreshable(hemorrhage_debuff) and target.DebuffPresent(rupture_debuff) and Enemies() <= 3 and Spell(hemorrhage) or { Enemies() >= 3 or BuffStacks(the_dreadlords_deceit_buff) >= 29 } and Spell(fan_of_knives) or { not Talent(agonizing_poison_talent) and target.DebuffRefreshable(deadly_poison_dot_debuff) or Talent(agonizing_poison_talent) and target.DebuffRemaining(agonizing_poison_debuff) < BaseDuration(agonizing_poison_debuff) * 0.3 or ArmorSetBonus(T19 2) == 1 and target.DebuffRefreshable(mutilated_flesh_debuff) } and Spell(mutilate) or Spell(mutilate)
}

AddFunction AssassinationBuildCdActions
{
}

AddFunction AssassinationBuildCdPostConditions
{
	target.Refreshable(hemorrhage_debuff) and Spell(hemorrhage) or target.Refreshable(hemorrhage_debuff) and target.DebuffPresent(rupture_debuff) and Enemies() <= 3 and Spell(hemorrhage) or { Enemies() >= 3 or BuffStacks(the_dreadlords_deceit_buff) >= 29 } and Spell(fan_of_knives) or { not Talent(agonizing_poison_talent) and target.DebuffRefreshable(deadly_poison_dot_debuff) or Talent(agonizing_poison_talent) and target.DebuffRemaining(agonizing_poison_debuff) < BaseDuration(agonizing_poison_debuff) * 0.3 or ArmorSetBonus(T19 2) == 1 and target.DebuffRefreshable(mutilated_flesh_debuff) } and Spell(mutilate) or Spell(mutilate)
}

### actions.cds

AddFunction AssassinationCdsMainActions
{
}

AddFunction AssassinationCdsMainPostConditions
{
}

AddFunction AssassinationCdsShortCdActions
{
	#marked_for_death,target_if=min:target.time_to_die,if=target.time_to_die<combo_points.deficit|combo_points.deficit>=5
	if target.TimeToDie() < ComboPointsDeficit() or ComboPointsDeficit() >= 5 Spell(marked_for_death)
	#vanish,if=talent.nightstalker.enabled&combo_points>=cp_max_spend&((talent.exsanguinate.enabled&cooldown.exsanguinate.remains<1&(dot.rupture.ticking|time>10))|(!talent.exsanguinate.enabled&dot.rupture.refreshable))
	if Talent(nightstalker_talent) and ComboPoints() >= MaxComboPoints() and { Talent(exsanguinate_talent) and SpellCooldown(exsanguinate) < 1 and { target.DebuffPresent(rupture_debuff) or TimeInCombat() > 10 } or not Talent(exsanguinate_talent) and target.DebuffRefreshable(rupture_debuff) } and CheckBoxOn(opt_vanish) Spell(vanish)
	#vanish,if=talent.subterfuge.enabled&dot.garrote.refreshable&((spell_targets.fan_of_knives<=3&combo_points.deficit>=1+spell_targets.fan_of_knives)|(spell_targets.fan_of_knives>=4&combo_points.deficit>=4))
	if Talent(subterfuge_talent) and target.DebuffRefreshable(garrote_debuff) and { Enemies() <= 3 and ComboPointsDeficit() >= 1 + Enemies() or Enemies() >= 4 and ComboPointsDeficit() >= 4 } and CheckBoxOn(opt_vanish) Spell(vanish)
	#vanish,if=talent.shadow_focus.enabled&energy.time_to_max>=2&combo_points.deficit>=4
	if Talent(shadow_focus_talent) and TimeToMaxEnergy() >= 2 and ComboPointsDeficit() >= 4 and CheckBoxOn(opt_vanish) Spell(vanish)
	#exsanguinate,if=prev_gcd.1.rupture&dot.rupture.remains>4+4*cp_max_spend
	if PreviousGCDSpell(rupture) and target.DebuffRemaining(rupture_debuff) > 4 + 4 * MaxComboPoints() Spell(exsanguinate)
}

AddFunction AssassinationCdsShortCdPostConditions
{
}

AddFunction AssassinationCdsCdActions
{
	#potion,name=old_war,if=buff.bloodlust.react|target.time_to_die<=25|debuff.vendetta.up
	#use_item,slot=trinket1,if=buff.bloodlust.react|target.time_to_die<=20|debuff.vendetta.up
	if BuffPresent(burst_haste_buff any=1) or target.TimeToDie() <= 20 or target.DebuffPresent(vendetta_debuff) AssassinationUseItemActions()
	#use_item,slot=trinket2,if=buff.bloodlust.react|target.time_to_die<=20|debuff.vendetta.up
	if BuffPresent(burst_haste_buff any=1) or target.TimeToDie() <= 20 or target.DebuffPresent(vendetta_debuff) AssassinationUseItemActions()
	#blood_fury,if=debuff.vendetta.up
	if target.DebuffPresent(vendetta_debuff) Spell(blood_fury_ap)
	#berserking,if=debuff.vendetta.up
	if target.DebuffPresent(vendetta_debuff) Spell(berserking)
	#arcane_torrent,if=debuff.vendetta.up&energy.deficit>50
	if target.DebuffPresent(vendetta_debuff) and EnergyDeficit() > 50 Spell(arcane_torrent_energy)
	#vendetta,if=talent.exsanguinate.enabled&cooldown.exsanguinate.remains<5&dot.rupture.ticking
	if Talent(exsanguinate_talent) and SpellCooldown(exsanguinate) < 5 and target.DebuffPresent(rupture_debuff) Spell(vendetta)
	#vendetta,if=talent.exsanguinate.enabled&(artifact.master_assassin.rank>=4-equipped.convergence_of_fates|equipped.duskwalkers_footpads)&energy.deficit>=75&!(artifact.master_assassin.rank=5-equipped.convergence_of_fates&equipped.duskwalkers_footpads)
	if Talent(exsanguinate_talent) and { ArtifactTraitRank(master_assassin) >= 4 - HasEquippedItem(convergence_of_fates) or HasEquippedItem(duskwalkers_footpads) } and EnergyDeficit() >= 75 and not { ArtifactTraitRank(master_assassin) == 5 - HasEquippedItem(convergence_of_fates) and HasEquippedItem(duskwalkers_footpads) } Spell(vendetta)
	#vendetta,if=!talent.exsanguinate.enabled&energy.deficit>=88-!talent.venom_rush.enabled*10
	if not Talent(exsanguinate_talent) and EnergyDeficit() >= 88 - Talent(venom_rush_talent no) * 10 Spell(vendetta)
}

AddFunction AssassinationCdsCdPostConditions
{
	PreviousGCDSpell(rupture) and target.DebuffRemaining(rupture_debuff) > 4 + 4 * MaxComboPoints() and Spell(exsanguinate)
}

### actions.finish

AddFunction AssassinationFinishMainActions
{
	#death_from_above,if=combo_points>=cp_max_spend
	if ComboPoints() >= MaxComboPoints() Spell(death_from_above)
	#envenom,if=combo_points>=4|(talent.elaborate_planning.enabled&combo_points>=3+!talent.exsanguinate.enabled&buff.elaborate_planning.remains<0.1)
	if ComboPoints() >= 4 or Talent(elaborate_planning_talent) and ComboPoints() >= 3 + Talent(exsanguinate_talent no) and BuffRemaining(elaborate_planning_buff) < 0.1 Spell(envenom)
}

AddFunction AssassinationFinishMainPostConditions
{
}

AddFunction AssassinationFinishShortCdActions
{
}

AddFunction AssassinationFinishShortCdPostConditions
{
	ComboPoints() >= MaxComboPoints() and Spell(death_from_above) or { ComboPoints() >= 4 or Talent(elaborate_planning_talent) and ComboPoints() >= 3 + Talent(exsanguinate_talent no) and BuffRemaining(elaborate_planning_buff) < 0.1 } and Spell(envenom)
}

AddFunction AssassinationFinishCdActions
{
}

AddFunction AssassinationFinishCdPostConditions
{
	ComboPoints() >= MaxComboPoints() and Spell(death_from_above) or { ComboPoints() >= 4 or Talent(elaborate_planning_talent) and ComboPoints() >= 3 + Talent(exsanguinate_talent no) and BuffRemaining(elaborate_planning_buff) < 0.1 } and Spell(envenom)
}

### actions.maintain

AddFunction AssassinationMaintainMainActions
{
	#rupture,if=(talent.nightstalker.enabled&stealthed.rogue)|(talent.exsanguinate.enabled&((combo_points>=cp_max_spend&cooldown.exsanguinate.remains<1)|(!ticking&(time>10|combo_points>=2+artifact.urge_to_kill.enabled))))
	if Talent(nightstalker_talent) and Stealthed() or Talent(exsanguinate_talent) and { ComboPoints() >= MaxComboPoints() and SpellCooldown(exsanguinate) < 1 or not target.DebuffPresent(rupture_debuff) and { TimeInCombat() > 10 or ComboPoints() >= 2 + HasArtifactTrait(urge_to_kill) } } Spell(rupture)
	#rupture,cycle_targets=1,if=combo_points>=cp_max_spend-talent.exsanguinate.enabled&refreshable&(!exsanguinated|remains<=1.5)&target.time_to_die-remains>4
	if ComboPoints() >= MaxComboPoints() - TalentPoints(exsanguinate_talent) and target.Refreshable(rupture_debuff) and { not target.DebuffPresent(exsanguinated) or target.DebuffRemaining(rupture_debuff) <= 1.5 } and target.TimeToDie() - target.DebuffRemaining(rupture_debuff) > 4 Spell(rupture)
	#kingsbane,if=(talent.exsanguinate.enabled&dot.rupture.exsanguinated)|(!talent.exsanguinate.enabled&(debuff.vendetta.up|cooldown.vendetta.remains>10))
	if Talent(exsanguinate_talent) and target.DebuffRemaining(rupture_debuff_exsanguinated) or not Talent(exsanguinate_talent) and { target.DebuffPresent(vendetta_debuff) or SpellCooldown(vendetta) > 10 } Spell(kingsbane)
	#pool_resource,for_next=1
	#garrote,cycle_targets=1,if=refreshable&(!exsanguinated|remains<=1.5)&target.time_to_die-remains>4
	if target.Refreshable(garrote_debuff) and { not target.DebuffPresent(exsanguinated) or target.DebuffRemaining(garrote_debuff) <= 1.5 } and target.TimeToDie() - target.DebuffRemaining(garrote_debuff) > 4 Spell(garrote)
}

AddFunction AssassinationMaintainMainPostConditions
{
}

AddFunction AssassinationMaintainShortCdActions
{
}

AddFunction AssassinationMaintainShortCdPostConditions
{
	{ Talent(nightstalker_talent) and Stealthed() or Talent(exsanguinate_talent) and { ComboPoints() >= MaxComboPoints() and SpellCooldown(exsanguinate) < 1 or not target.DebuffPresent(rupture_debuff) and { TimeInCombat() > 10 or ComboPoints() >= 2 + HasArtifactTrait(urge_to_kill) } } } and Spell(rupture) or ComboPoints() >= MaxComboPoints() - TalentPoints(exsanguinate_talent) and target.Refreshable(rupture_debuff) and { not target.DebuffPresent(exsanguinated) or target.DebuffRemaining(rupture_debuff) <= 1.5 } and target.TimeToDie() - target.DebuffRemaining(rupture_debuff) > 4 and Spell(rupture) or { Talent(exsanguinate_talent) and target.DebuffRemaining(rupture_debuff_exsanguinated) or not Talent(exsanguinate_talent) and { target.DebuffPresent(vendetta_debuff) or SpellCooldown(vendetta) > 10 } } and Spell(kingsbane) or target.Refreshable(garrote_debuff) and { not target.DebuffPresent(exsanguinated) or target.DebuffRemaining(garrote_debuff) <= 1.5 } and target.TimeToDie() - target.DebuffRemaining(garrote_debuff) > 4 and Spell(garrote)
}

AddFunction AssassinationMaintainCdActions
{
}

AddFunction AssassinationMaintainCdPostConditions
{
	{ Talent(nightstalker_talent) and Stealthed() or Talent(exsanguinate_talent) and { ComboPoints() >= MaxComboPoints() and SpellCooldown(exsanguinate) < 1 or not target.DebuffPresent(rupture_debuff) and { TimeInCombat() > 10 or ComboPoints() >= 2 + HasArtifactTrait(urge_to_kill) } } } and Spell(rupture) or ComboPoints() >= MaxComboPoints() - TalentPoints(exsanguinate_talent) and target.Refreshable(rupture_debuff) and { not target.DebuffPresent(exsanguinated) or target.DebuffRemaining(rupture_debuff) <= 1.5 } and target.TimeToDie() - target.DebuffRemaining(rupture_debuff) > 4 and Spell(rupture) or { Talent(exsanguinate_talent) and target.DebuffRemaining(rupture_debuff_exsanguinated) or not Talent(exsanguinate_talent) and { target.DebuffPresent(vendetta_debuff) or SpellCooldown(vendetta) > 10 } } and Spell(kingsbane) or target.Refreshable(garrote_debuff) and { not target.DebuffPresent(exsanguinated) or target.DebuffRemaining(garrote_debuff) <= 1.5 } and target.TimeToDie() - target.DebuffRemaining(garrote_debuff) > 4 and Spell(garrote)
}

### actions.precombat

AddFunction AssassinationPrecombatMainActions
{
	#flask,name=flask_of_the_seventh_demon
	#augmentation,name=defiled
	Spell(augmentation)
	#food,name=seedbattered_fish_plate
	#snapshot_stats
	#apply_poison
	#stealth
	Spell(stealth)
}

AddFunction AssassinationPrecombatMainPostConditions
{
}

AddFunction AssassinationPrecombatShortCdActions
{
	unless Spell(augmentation) or Spell(stealth)
	{
		#potion,name=old_war
		#marked_for_death,if=raid_event.adds.in>40
		if 600 > 40 Spell(marked_for_death)
	}
}

AddFunction AssassinationPrecombatShortCdPostConditions
{
	Spell(augmentation) or Spell(stealth)
}

AddFunction AssassinationPrecombatCdActions
{
}

AddFunction AssassinationPrecombatCdPostConditions
{
	Spell(augmentation) or Spell(stealth)
}

### Assassination icons.

AddCheckBox(opt_rogue_assassination_aoe L(AOE) default specialization=assassination)

AddIcon checkbox=!opt_rogue_assassination_aoe enemies=1 help=shortcd specialization=assassination
{
	if not InCombat() AssassinationPrecombatShortCdActions()
	unless not InCombat() and AssassinationPrecombatShortCdPostConditions()
	{
		AssassinationDefaultShortCdActions()
	}
}

AddIcon checkbox=opt_rogue_assassination_aoe help=shortcd specialization=assassination
{
	if not InCombat() AssassinationPrecombatShortCdActions()
	unless not InCombat() and AssassinationPrecombatShortCdPostConditions()
	{
		AssassinationDefaultShortCdActions()
	}
}

AddIcon enemies=1 help=main specialization=assassination
{
	if not InCombat() AssassinationPrecombatMainActions()
	unless not InCombat() and AssassinationPrecombatMainPostConditions()
	{
		AssassinationDefaultMainActions()
	}
}

AddIcon checkbox=opt_rogue_assassination_aoe help=aoe specialization=assassination
{
	if not InCombat() AssassinationPrecombatMainActions()
	unless not InCombat() and AssassinationPrecombatMainPostConditions()
	{
		AssassinationDefaultMainActions()
	}
}

AddIcon checkbox=!opt_rogue_assassination_aoe enemies=1 help=cd specialization=assassination
{
	if not InCombat() AssassinationPrecombatCdActions()
	unless not InCombat() and AssassinationPrecombatCdPostConditions()
	{
		AssassinationDefaultCdActions()
	}
}

AddIcon checkbox=opt_rogue_assassination_aoe help=cd specialization=assassination
{
	if not InCombat() AssassinationPrecombatCdActions()
	unless not InCombat() and AssassinationPrecombatCdPostConditions()
	{
		AssassinationDefaultCdActions()
	}
}

### Required symbols
# agonizing_poison_debuff
# agonizing_poison_talent
# arcane_torrent_energy
# augmentation
# berserking
# blood_fury_ap
# convergence_of_fates
# deadly_poison_dot_debuff
# death_from_above
# duskwalkers_footpads
# elaborate_planning_buff
# elaborate_planning_talent
# envenom
# exsanguinate
# exsanguinate_talent
# fan_of_knives
# garrote
# garrote_debuff
# hemorrhage
# hemorrhage_debuff
# kick
# kingsbane
# marked_for_death
# master_assassin
# mutilate
# mutilated_flesh_debuff
# nightstalker_talent
# rupture
# rupture_debuff
# shadow_focus_talent
# shadowstep
# stealth
# subterfuge_talent
# the_dreadlords_deceit_buff
# urge_to_kill
# vanish
# vendetta
# vendetta_debuff
# venom_rush_talent
]]
	OvaleScripts:RegisterScript("ROGUE", "assassination", name, desc, code, "script")
end

do
	local name = "simulationcraft_rogue_outlaw_t19p"
	local desc = "[7.0] SimulationCraft: Rogue_Outlaw_T19P"
	local code = [[
# Based on SimulationCraft profile "Rogue_Outlaw_T19P".
#	class=rogue
#	spec=outlaw
#	talents=1310022

Include(ovale_common)
Include(ovale_trinkets_mop)
Include(ovale_trinkets_wod)
Include(ovale_rogue_spells)


AddFunction stealth_condition
{
	ComboPointsDeficit() >= 2 + 2 * { Talent(ghostly_strike_talent) and not target.DebuffPresent(ghostly_strike_debuff) } + BuffPresent(broadsides_buff) and Energy() > 60 and not BuffPresent(jolly_roger_buff) and not BuffPresent(hidden_blade_buff) and not BuffPresent(curse_of_the_dreadblades_buff)
}

AddFunction ss_useable
{
	Talent(anticipation_talent) and ComboPoints() < 4 or not Talent(anticipation_talent) and { rtb_reroll() and ComboPoints() < 4 + TalentPoints(deeper_stratagem_talent) or not rtb_reroll() and ss_useable_noreroll() }
}

AddFunction ss_useable_noreroll
{
	ComboPoints() < 5 + TalentPoints(deeper_stratagem_talent) - { BuffPresent(broadsides_buff) or BuffPresent(jolly_roger_buff) } - { Talent(alacrity_talent) and BuffStacks(alacrity_buff) <= 4 }
}

AddFunction rtb_reroll
{
	not Talent(slice_and_dice_talent) and BuffCount(roll_the_bones_buff) <= 2 and not BuffCount(roll_the_bones_buff more 5)
}

AddCheckBox(opt_interrupt L(interrupt) default specialization=outlaw)
AddCheckBox(opt_melee_range L(not_in_melee_range) specialization=outlaw)

AddFunction OutlawUseItemActions
{
	Item(Trinket0Slot usable=1)
	Item(Trinket1Slot usable=1)
}

AddFunction OutlawGetInMeleeRange
{
	if CheckBoxOn(opt_melee_range) and not target.InRange(kick)
	{
		Spell(shadowstep)
		Texture(misc_arrowlup help=L(not_in_melee_range))
	}
}

AddFunction OutlawInterruptActions
{
	if CheckBoxOn(opt_interrupt) and not target.IsFriend() and target.IsInterruptible()
	{
		if target.InRange(kick) Spell(kick)
		if not target.Classification(worldboss)
		{
			if target.InRange(cheap_shot) Spell(cheap_shot)
			if target.InRange(deadly_throw) and ComboPoints() == 5 Spell(deadly_throw)
			if target.InRange(between_the_eyes) Spell(between_the_eyes)
			if target.InRange(kidney_shot) Spell(kidney_shot)
			Spell(arcane_torrent_energy)
			if target.InRange(gouge) Spell(gouge)
			if target.InRange(quaking_palm) Spell(quaking_palm)
		}
	}
}

### actions.default

AddFunction OutlawDefaultMainActions
{
	#call_action_list,name=bf
	OutlawBfMainActions()

	unless OutlawBfMainPostConditions()
	{
		#call_action_list,name=cds
		OutlawCdsMainActions()

		unless OutlawCdsMainPostConditions()
		{
			#call_action_list,name=stealth,if=stealthed.rogue|cooldown.vanish.up|cooldown.shadowmeld.up
			if Stealthed() or not SpellCooldown(vanish) > 0 or not SpellCooldown(shadowmeld) > 0 OutlawStealthMainActions()

			unless { Stealthed() or not SpellCooldown(vanish) > 0 or not SpellCooldown(shadowmeld) > 0 } and OutlawStealthMainPostConditions()
			{
				#death_from_above,if=energy.time_to_max>2&!variable.ss_useable_noreroll
				if TimeToMaxEnergy() > 2 and not ss_useable_noreroll() Spell(death_from_above)
				#slice_and_dice,if=!variable.ss_useable&buff.slice_and_dice.remains<target.time_to_die&buff.slice_and_dice.remains<(1+combo_points)*1.8
				if not ss_useable() and BuffRemaining(slice_and_dice_buff) < target.TimeToDie() and BuffRemaining(slice_and_dice_buff) < { 1 + ComboPoints() } * 1.8 Spell(slice_and_dice)
				#roll_the_bones,if=!variable.ss_useable&buff.roll_the_bones.remains<target.time_to_die&(buff.roll_the_bones.remains<=3|variable.rtb_reroll)
				if not ss_useable() and BuffRemaining(roll_the_bones_buff) < target.TimeToDie() and { BuffRemaining(roll_the_bones_buff) <= 3 or rtb_reroll() } Spell(roll_the_bones)
				#call_action_list,name=build
				OutlawBuildMainActions()

				unless OutlawBuildMainPostConditions()
				{
					#call_action_list,name=finish,if=!variable.ss_useable
					if not ss_useable() OutlawFinishMainActions()

					unless not ss_useable() and OutlawFinishMainPostConditions()
					{
						#gouge,if=talent.dirty_tricks.enabled&combo_points.deficit>=1
						if Talent(dirty_tricks_talent) and ComboPointsDeficit() >= 1 Spell(gouge)
					}
				}
			}
		}
	}
}

AddFunction OutlawDefaultMainPostConditions
{
	OutlawBfMainPostConditions() or OutlawCdsMainPostConditions() or { Stealthed() or not SpellCooldown(vanish) > 0 or not SpellCooldown(shadowmeld) > 0 } and OutlawStealthMainPostConditions() or OutlawBuildMainPostConditions() or not ss_useable() and OutlawFinishMainPostConditions()
}

AddFunction OutlawDefaultShortCdActions
{
	#call_action_list,name=bf
	OutlawBfShortCdActions()

	unless OutlawBfShortCdPostConditions()
	{
		#call_action_list,name=cds
		OutlawCdsShortCdActions()

		unless OutlawCdsShortCdPostConditions()
		{
			#call_action_list,name=stealth,if=stealthed.rogue|cooldown.vanish.up|cooldown.shadowmeld.up
			if Stealthed() or not SpellCooldown(vanish) > 0 or not SpellCooldown(shadowmeld) > 0 OutlawStealthShortCdActions()

			unless { Stealthed() or not SpellCooldown(vanish) > 0 or not SpellCooldown(shadowmeld) > 0 } and OutlawStealthShortCdPostConditions() or TimeToMaxEnergy() > 2 and not ss_useable_noreroll() and Spell(death_from_above) or not ss_useable() and BuffRemaining(slice_and_dice_buff) < target.TimeToDie() and BuffRemaining(slice_and_dice_buff) < { 1 + ComboPoints() } * 1.8 and Spell(slice_and_dice) or not ss_useable() and BuffRemaining(roll_the_bones_buff) < target.TimeToDie() and { BuffRemaining(roll_the_bones_buff) <= 3 or rtb_reroll() } and Spell(roll_the_bones)
			{
				#call_action_list,name=build
				OutlawBuildShortCdActions()

				unless OutlawBuildShortCdPostConditions()
				{
					#call_action_list,name=finish,if=!variable.ss_useable
					if not ss_useable() OutlawFinishShortCdActions()
				}
			}
		}
	}
}

AddFunction OutlawDefaultShortCdPostConditions
{
	OutlawBfShortCdPostConditions() or OutlawCdsShortCdPostConditions() or { Stealthed() or not SpellCooldown(vanish) > 0 or not SpellCooldown(shadowmeld) > 0 } and OutlawStealthShortCdPostConditions() or TimeToMaxEnergy() > 2 and not ss_useable_noreroll() and Spell(death_from_above) or not ss_useable() and BuffRemaining(slice_and_dice_buff) < target.TimeToDie() and BuffRemaining(slice_and_dice_buff) < { 1 + ComboPoints() } * 1.8 and Spell(slice_and_dice) or not ss_useable() and BuffRemaining(roll_the_bones_buff) < target.TimeToDie() and { BuffRemaining(roll_the_bones_buff) <= 3 or rtb_reroll() } and Spell(roll_the_bones) or OutlawBuildShortCdPostConditions() or not ss_useable() and OutlawFinishShortCdPostConditions() or Talent(dirty_tricks_talent) and ComboPointsDeficit() >= 1 and Spell(gouge)
}

AddFunction OutlawDefaultCdActions
{
	#variable,name=rtb_reroll,value=!talent.slice_and_dice.enabled&(rtb_buffs<=2&!rtb_list.any.6)
	#variable,name=ss_useable_noreroll,value=(combo_points<5+talent.deeper_stratagem.enabled-(buff.broadsides.up|buff.jolly_roger.up)-(talent.alacrity.enabled&buff.alacrity.stack<=4))
	#variable,name=ss_useable,value=(talent.anticipation.enabled&combo_points<4)|(!talent.anticipation.enabled&((variable.rtb_reroll&combo_points<4+talent.deeper_stratagem.enabled)|(!variable.rtb_reroll&variable.ss_useable_noreroll)))
	#kick
	OutlawInterruptActions()
	#call_action_list,name=bf
	OutlawBfCdActions()

	unless OutlawBfCdPostConditions()
	{
		#call_action_list,name=cds
		OutlawCdsCdActions()

		unless OutlawCdsCdPostConditions()
		{
			#call_action_list,name=stealth,if=stealthed.rogue|cooldown.vanish.up|cooldown.shadowmeld.up
			if Stealthed() or not SpellCooldown(vanish) > 0 or not SpellCooldown(shadowmeld) > 0 OutlawStealthCdActions()

			unless { Stealthed() or not SpellCooldown(vanish) > 0 or not SpellCooldown(shadowmeld) > 0 } and OutlawStealthCdPostConditions() or TimeToMaxEnergy() > 2 and not ss_useable_noreroll() and Spell(death_from_above) or not ss_useable() and BuffRemaining(slice_and_dice_buff) < target.TimeToDie() and BuffRemaining(slice_and_dice_buff) < { 1 + ComboPoints() } * 1.8 and Spell(slice_and_dice) or not ss_useable() and BuffRemaining(roll_the_bones_buff) < target.TimeToDie() and { BuffRemaining(roll_the_bones_buff) <= 3 or rtb_reroll() } and Spell(roll_the_bones)
			{
				#killing_spree,if=energy.time_to_max>5|energy<15
				if TimeToMaxEnergy() > 5 or Energy() < 15 Spell(killing_spree)
				#call_action_list,name=build
				OutlawBuildCdActions()

				unless OutlawBuildCdPostConditions()
				{
					#call_action_list,name=finish,if=!variable.ss_useable
					if not ss_useable() OutlawFinishCdActions()
				}
			}
		}
	}
}

AddFunction OutlawDefaultCdPostConditions
{
	OutlawBfCdPostConditions() or OutlawCdsCdPostConditions() or { Stealthed() or not SpellCooldown(vanish) > 0 or not SpellCooldown(shadowmeld) > 0 } and OutlawStealthCdPostConditions() or TimeToMaxEnergy() > 2 and not ss_useable_noreroll() and Spell(death_from_above) or not ss_useable() and BuffRemaining(slice_and_dice_buff) < target.TimeToDie() and BuffRemaining(slice_and_dice_buff) < { 1 + ComboPoints() } * 1.8 and Spell(slice_and_dice) or not ss_useable() and BuffRemaining(roll_the_bones_buff) < target.TimeToDie() and { BuffRemaining(roll_the_bones_buff) <= 3 or rtb_reroll() } and Spell(roll_the_bones) or OutlawBuildCdPostConditions() or not ss_useable() and OutlawFinishCdPostConditions() or Talent(dirty_tricks_talent) and ComboPointsDeficit() >= 1 and Spell(gouge)
}

### actions.bf

AddFunction OutlawBfMainActions
{
	#cancel_buff,name=blade_flurry,if=equipped.shivarran_symmetry&cooldown.blade_flurry.up&buff.blade_flurry.up&spell_targets.blade_flurry>=2|spell_targets.blade_flurry<2&buff.blade_flurry.up
	if { HasEquippedItem(shivarran_symmetry) and not SpellCooldown(blade_flurry) > 0 and BuffPresent(blade_flurry_buff) and Enemies() >= 2 or Enemies() < 2 and BuffPresent(blade_flurry_buff) } and BuffPresent(blade_flurry_buff) Texture(blade_flurry text=cancel)
}

AddFunction OutlawBfMainPostConditions
{
}

AddFunction OutlawBfShortCdActions
{
	unless { HasEquippedItem(shivarran_symmetry) and not SpellCooldown(blade_flurry) > 0 and BuffPresent(blade_flurry_buff) and Enemies() >= 2 or Enemies() < 2 and BuffPresent(blade_flurry_buff) } and BuffPresent(blade_flurry_buff) and Texture(blade_flurry text=cancel)
	{
		#blade_flurry,if=spell_targets.blade_flurry>=2&!buff.blade_flurry.up
		if Enemies() >= 2 and not BuffPresent(blade_flurry_buff) Spell(blade_flurry)
	}
}

AddFunction OutlawBfShortCdPostConditions
{
	{ HasEquippedItem(shivarran_symmetry) and not SpellCooldown(blade_flurry) > 0 and BuffPresent(blade_flurry_buff) and Enemies() >= 2 or Enemies() < 2 and BuffPresent(blade_flurry_buff) } and BuffPresent(blade_flurry_buff) and Texture(blade_flurry text=cancel)
}

AddFunction OutlawBfCdActions
{
}

AddFunction OutlawBfCdPostConditions
{
	{ HasEquippedItem(shivarran_symmetry) and not SpellCooldown(blade_flurry) > 0 and BuffPresent(blade_flurry_buff) and Enemies() >= 2 or Enemies() < 2 and BuffPresent(blade_flurry_buff) } and BuffPresent(blade_flurry_buff) and Texture(blade_flurry text=cancel)
}

### actions.build

AddFunction OutlawBuildMainActions
{
	#ghostly_strike,if=combo_points.deficit>=1+buff.broadsides.up&!buff.curse_of_the_dreadblades.up&(debuff.ghostly_strike.remains<debuff.ghostly_strike.duration*0.3|(cooldown.curse_of_the_dreadblades.remains<3&debuff.ghostly_strike.remains<14))&(combo_points>=3|(variable.rtb_reroll&time>=10))
	if ComboPointsDeficit() >= 1 + BuffPresent(broadsides_buff) and not BuffPresent(curse_of_the_dreadblades_buff) and { target.DebuffRemaining(ghostly_strike_debuff) < BaseDuration(ghostly_strike_debuff) * 0.3 or SpellCooldown(curse_of_the_dreadblades) < 3 and target.DebuffRemaining(ghostly_strike_debuff) < 14 } and { ComboPoints() >= 3 or rtb_reroll() and TimeInCombat() >= 10 } Spell(ghostly_strike)
	#pistol_shot,if=combo_points.deficit>=1+buff.broadsides.up&buff.opportunity.up&(energy.time_to_max>2-talent.quick_draw.enabled|(buff.blunderbuss.up&buff.greenskins_waterlogged_wristcuffs.up))
	if ComboPointsDeficit() >= 1 + BuffPresent(broadsides_buff) and BuffPresent(opportunity_buff) and { TimeToMaxEnergy() > 2 - TalentPoints(quick_draw_talent) or BuffPresent(blunderbuss_buff) and BuffPresent(greenskins_waterlogged_wristcuffs_buff) } Spell(pistol_shot)
	#saber_slash,if=variable.ss_useable
	if ss_useable() Spell(saber_slash)
}

AddFunction OutlawBuildMainPostConditions
{
}

AddFunction OutlawBuildShortCdActions
{
}

AddFunction OutlawBuildShortCdPostConditions
{
	ComboPointsDeficit() >= 1 + BuffPresent(broadsides_buff) and not BuffPresent(curse_of_the_dreadblades_buff) and { target.DebuffRemaining(ghostly_strike_debuff) < BaseDuration(ghostly_strike_debuff) * 0.3 or SpellCooldown(curse_of_the_dreadblades) < 3 and target.DebuffRemaining(ghostly_strike_debuff) < 14 } and { ComboPoints() >= 3 or rtb_reroll() and TimeInCombat() >= 10 } and Spell(ghostly_strike) or ComboPointsDeficit() >= 1 + BuffPresent(broadsides_buff) and BuffPresent(opportunity_buff) and { TimeToMaxEnergy() > 2 - TalentPoints(quick_draw_talent) or BuffPresent(blunderbuss_buff) and BuffPresent(greenskins_waterlogged_wristcuffs_buff) } and Spell(pistol_shot) or ss_useable() and Spell(saber_slash)
}

AddFunction OutlawBuildCdActions
{
}

AddFunction OutlawBuildCdPostConditions
{
	ComboPointsDeficit() >= 1 + BuffPresent(broadsides_buff) and not BuffPresent(curse_of_the_dreadblades_buff) and { target.DebuffRemaining(ghostly_strike_debuff) < BaseDuration(ghostly_strike_debuff) * 0.3 or SpellCooldown(curse_of_the_dreadblades) < 3 and target.DebuffRemaining(ghostly_strike_debuff) < 14 } and { ComboPoints() >= 3 or rtb_reroll() and TimeInCombat() >= 10 } and Spell(ghostly_strike) or ComboPointsDeficit() >= 1 + BuffPresent(broadsides_buff) and BuffPresent(opportunity_buff) and { TimeToMaxEnergy() > 2 - TalentPoints(quick_draw_talent) or BuffPresent(blunderbuss_buff) and BuffPresent(greenskins_waterlogged_wristcuffs_buff) } and Spell(pistol_shot) or ss_useable() and Spell(saber_slash)
}

### actions.cds

AddFunction OutlawCdsMainActions
{
}

AddFunction OutlawCdsMainPostConditions
{
}

AddFunction OutlawCdsShortCdActions
{
	#cannonball_barrage,if=spell_targets.cannonball_barrage>=1
	if Enemies() >= 1 Spell(cannonball_barrage)
	#marked_for_death,target_if=min:target.time_to_die,if=target.time_to_die<combo_points.deficit|((raid_event.adds.in>40|buff.true_bearing.remains>15)&combo_points.deficit>=4+talent.deeper_stratagem.enabled+talent.anticipation.enabled)
	if target.TimeToDie() < ComboPointsDeficit() or { 600 > 40 or BuffRemaining(true_bearing_buff) > 15 } and ComboPointsDeficit() >= 4 + TalentPoints(deeper_stratagem_talent) + TalentPoints(anticipation_talent) Spell(marked_for_death)
	#sprint,if=equipped.thraxis_tricksy_treads&!variable.ss_useable
	if HasEquippedItem(thraxis_tricksy_treads) and not ss_useable() Spell(sprint)
	#curse_of_the_dreadblades,if=combo_points.deficit>=4&(!talent.ghostly_strike.enabled|debuff.ghostly_strike.up)
	if ComboPointsDeficit() >= 4 and { not Talent(ghostly_strike_talent) or target.DebuffPresent(ghostly_strike_debuff) } Spell(curse_of_the_dreadblades)
}

AddFunction OutlawCdsShortCdPostConditions
{
}

AddFunction OutlawCdsCdActions
{
	#potion,name=old_war,if=buff.bloodlust.react|target.time_to_die<=25|buff.adrenaline_rush.up
	#use_item,slot=trinket2,if=buff.bloodlust.react|target.time_to_die<=20|combo_points.deficit<=2
	if BuffPresent(burst_haste_buff any=1) or target.TimeToDie() <= 20 or ComboPointsDeficit() <= 2 OutlawUseItemActions()
	#blood_fury
	Spell(blood_fury_ap)
	#berserking
	Spell(berserking)
	#arcane_torrent,if=energy.deficit>40
	if EnergyDeficit() > 40 Spell(arcane_torrent_energy)

	unless Enemies() >= 1 and Spell(cannonball_barrage)
	{
		#adrenaline_rush,if=!buff.adrenaline_rush.up&energy.deficit>0
		if not BuffPresent(adrenaline_rush_buff) and EnergyDeficit() > 0 Spell(adrenaline_rush)
	}
}

AddFunction OutlawCdsCdPostConditions
{
	Enemies() >= 1 and Spell(cannonball_barrage) or HasEquippedItem(thraxis_tricksy_treads) and not ss_useable() and Spell(sprint) or ComboPointsDeficit() >= 4 and { not Talent(ghostly_strike_talent) or target.DebuffPresent(ghostly_strike_debuff) } and Spell(curse_of_the_dreadblades)
}

### actions.finish

AddFunction OutlawFinishMainActions
{
	#between_the_eyes,if=equipped.greenskins_waterlogged_wristcuffs&!buff.greenskins_waterlogged_wristcuffs.up
	if HasEquippedItem(greenskins_waterlogged_wristcuffs) and not BuffPresent(greenskins_waterlogged_wristcuffs_buff) Spell(between_the_eyes)
	#run_through,if=!talent.death_from_above.enabled|energy.time_to_max<cooldown.death_from_above.remains+3.5
	if not Talent(death_from_above_talent) or TimeToMaxEnergy() < SpellCooldown(death_from_above) + 3.5 Spell(run_through)
}

AddFunction OutlawFinishMainPostConditions
{
}

AddFunction OutlawFinishShortCdActions
{
}

AddFunction OutlawFinishShortCdPostConditions
{
	HasEquippedItem(greenskins_waterlogged_wristcuffs) and not BuffPresent(greenskins_waterlogged_wristcuffs_buff) and Spell(between_the_eyes) or { not Talent(death_from_above_talent) or TimeToMaxEnergy() < SpellCooldown(death_from_above) + 3.5 } and Spell(run_through)
}

AddFunction OutlawFinishCdActions
{
}

AddFunction OutlawFinishCdPostConditions
{
	HasEquippedItem(greenskins_waterlogged_wristcuffs) and not BuffPresent(greenskins_waterlogged_wristcuffs_buff) and Spell(between_the_eyes) or { not Talent(death_from_above_talent) or TimeToMaxEnergy() < SpellCooldown(death_from_above) + 3.5 } and Spell(run_through)
}

### actions.precombat

AddFunction OutlawPrecombatMainActions
{
	#flask,name=flask_of_the_seventh_demon
	#augmentation,name=defiled
	Spell(augmentation)
	#food,name=seedbattered_fish_plate
	#snapshot_stats
	#stealth
	Spell(stealth)
	#roll_the_bones,if=!talent.slice_and_dice.enabled
	if not Talent(slice_and_dice_talent) Spell(roll_the_bones)
}

AddFunction OutlawPrecombatMainPostConditions
{
}

AddFunction OutlawPrecombatShortCdActions
{
	unless Spell(augmentation) or Spell(stealth)
	{
		#potion,name=old_war
		#marked_for_death,if=raid_event.adds.in>40
		if 600 > 40 Spell(marked_for_death)
	}
}

AddFunction OutlawPrecombatShortCdPostConditions
{
	Spell(augmentation) or Spell(stealth) or not Talent(slice_and_dice_talent) and Spell(roll_the_bones)
}

AddFunction OutlawPrecombatCdActions
{
}

AddFunction OutlawPrecombatCdPostConditions
{
	Spell(augmentation) or Spell(stealth) or not Talent(slice_and_dice_talent) and Spell(roll_the_bones)
}

### actions.stealth

AddFunction OutlawStealthMainActions
{
	#variable,name=stealth_condition,value=(combo_points.deficit>=2+2*(talent.ghostly_strike.enabled&!debuff.ghostly_strike.up)+buff.broadsides.up&energy>60&!buff.jolly_roger.up&!buff.hidden_blade.up&!buff.curse_of_the_dreadblades.up)
	#ambush
	Spell(ambush)
}

AddFunction OutlawStealthMainPostConditions
{
}

AddFunction OutlawStealthShortCdActions
{
	unless Spell(ambush)
	{
		#vanish,if=variable.stealth_condition
		if stealth_condition() Spell(vanish)
	}
}

AddFunction OutlawStealthShortCdPostConditions
{
	Spell(ambush)
}

AddFunction OutlawStealthCdActions
{
	unless Spell(ambush)
	{
		#shadowmeld,if=variable.stealth_condition
		if stealth_condition() Spell(shadowmeld)
	}
}

AddFunction OutlawStealthCdPostConditions
{
	Spell(ambush)
}

### Outlaw icons.

AddCheckBox(opt_rogue_outlaw_aoe L(AOE) default specialization=outlaw)

AddIcon checkbox=!opt_rogue_outlaw_aoe enemies=1 help=shortcd specialization=outlaw
{
	if not InCombat() OutlawPrecombatShortCdActions()
	unless not InCombat() and OutlawPrecombatShortCdPostConditions()
	{
		OutlawDefaultShortCdActions()
	}
}

AddIcon checkbox=opt_rogue_outlaw_aoe help=shortcd specialization=outlaw
{
	if not InCombat() OutlawPrecombatShortCdActions()
	unless not InCombat() and OutlawPrecombatShortCdPostConditions()
	{
		OutlawDefaultShortCdActions()
	}
}

AddIcon enemies=1 help=main specialization=outlaw
{
	if not InCombat() OutlawPrecombatMainActions()
	unless not InCombat() and OutlawPrecombatMainPostConditions()
	{
		OutlawDefaultMainActions()
	}
}

AddIcon checkbox=opt_rogue_outlaw_aoe help=aoe specialization=outlaw
{
	if not InCombat() OutlawPrecombatMainActions()
	unless not InCombat() and OutlawPrecombatMainPostConditions()
	{
		OutlawDefaultMainActions()
	}
}

AddIcon checkbox=!opt_rogue_outlaw_aoe enemies=1 help=cd specialization=outlaw
{
	if not InCombat() OutlawPrecombatCdActions()
	unless not InCombat() and OutlawPrecombatCdPostConditions()
	{
		OutlawDefaultCdActions()
	}
}

AddIcon checkbox=opt_rogue_outlaw_aoe help=cd specialization=outlaw
{
	if not InCombat() OutlawPrecombatCdActions()
	unless not InCombat() and OutlawPrecombatCdPostConditions()
	{
		OutlawDefaultCdActions()
	}
}

### Required symbols
# adrenaline_rush
# adrenaline_rush_buff
# alacrity_buff
# alacrity_talent
# ambush
# anticipation_talent
# arcane_torrent_energy
# augmentation
# berserking
# between_the_eyes
# blade_flurry
# blade_flurry_buff
# blood_fury_ap
# blunderbuss_buff
# broadsides_buff
# cannonball_barrage
# cheap_shot
# curse_of_the_dreadblades
# curse_of_the_dreadblades_buff
# deadly_throw
# death_from_above
# death_from_above_talent
# deeper_stratagem_talent
# dirty_tricks_talent
# ghostly_strike
# ghostly_strike_debuff
# ghostly_strike_talent
# gouge
# greenskins_waterlogged_wristcuffs
# greenskins_waterlogged_wristcuffs_buff
# hidden_blade_buff
# jolly_roger_buff
# kick
# kidney_shot
# killing_spree
# marked_for_death
# opportunity_buff
# pistol_shot
# quaking_palm
# quick_draw_talent
# roll_the_bones
# roll_the_bones_buff
# run_through
# saber_slash
# shadowmeld
# shadowstep
# shivarran_symmetry
# slice_and_dice
# slice_and_dice_buff
# slice_and_dice_talent
# sprint
# stealth
# thraxis_tricksy_treads
# true_bearing_buff
# vanish
]]
	OvaleScripts:RegisterScript("ROGUE", "outlaw", name, desc, code, "script")
end

do
	local name = "simulationcraft_rogue_subtlety_t19p"
	local desc = "[7.0] SimulationCraft: Rogue_Subtlety_T19P"
	local code = [[
# Based on SimulationCraft profile "Rogue_Subtlety_T19P".
#	class=rogue
#	spec=subtlety
#	talents=1210011

Include(ovale_common)
Include(ovale_trinkets_mop)
Include(ovale_trinkets_wod)
Include(ovale_rogue_spells)


AddFunction stealth_threshold
{
	15 + TalentPoints(vigor_talent) * 35 + TalentPoints(master_of_shadows_talent) * 30 + ssw_refund()
}

AddFunction ssw_refund
{
	HasEquippedItem(shadow_satyrs_walk) * { 4 + { target.Distance() % 3 - 1 } }
}

AddCheckBox(opt_melee_range L(not_in_melee_range) specialization=subtlety)

AddFunction SubtletyGetInMeleeRange
{
	if CheckBoxOn(opt_melee_range) and not target.InRange(kick)
	{
		Spell(shadowstep)
		Texture(misc_arrowlup help=L(not_in_melee_range))
	}
}

### actions.default

AddFunction SubtletyDefaultMainActions
{
	#call_action_list,name=cds
	SubtletyCdsMainActions()

	unless SubtletyCdsMainPostConditions()
	{
		#run_action_list,name=stealthed,if=stealthed.all
		if Stealthed() SubtletyStealthedMainActions()

		unless Stealthed() and SubtletyStealthedMainPostConditions()
		{
			#call_action_list,name=finish,if=combo_points>=5|(combo_points>=4&spell_targets.shuriken_storm>=3&spell_targets.shuriken_storm<=4)
			if ComboPoints() >= 5 or ComboPoints() >= 4 and Enemies() >= 3 and Enemies() <= 4 SubtletyFinishMainActions()

			unless { ComboPoints() >= 5 or ComboPoints() >= 4 and Enemies() >= 3 and Enemies() <= 4 } and SubtletyFinishMainPostConditions()
			{
				#call_action_list,name=stealth_als,if=combo_points.deficit>=2+talent.premeditation.enabled
				if ComboPointsDeficit() >= 2 + TalentPoints(premeditation_talent) SubtletyStealthAlsMainActions()

				unless ComboPointsDeficit() >= 2 + TalentPoints(premeditation_talent) and SubtletyStealthAlsMainPostConditions()
				{
					#call_action_list,name=build,if=energy.deficit<=variable.stealth_threshold
					if EnergyDeficit() <= stealth_threshold() SubtletyBuildMainActions()
				}
			}
		}
	}
}

AddFunction SubtletyDefaultMainPostConditions
{
	SubtletyCdsMainPostConditions() or Stealthed() and SubtletyStealthedMainPostConditions() or { ComboPoints() >= 5 or ComboPoints() >= 4 and Enemies() >= 3 and Enemies() <= 4 } and SubtletyFinishMainPostConditions() or ComboPointsDeficit() >= 2 + TalentPoints(premeditation_talent) and SubtletyStealthAlsMainPostConditions() or EnergyDeficit() <= stealth_threshold() and SubtletyBuildMainPostConditions()
}

AddFunction SubtletyDefaultShortCdActions
{
	#call_action_list,name=cds
	SubtletyCdsShortCdActions()

	unless SubtletyCdsShortCdPostConditions()
	{
		#run_action_list,name=stealthed,if=stealthed.all
		if Stealthed() SubtletyStealthedShortCdActions()

		unless Stealthed() and SubtletyStealthedShortCdPostConditions()
		{
			#call_action_list,name=finish,if=combo_points>=5|(combo_points>=4&spell_targets.shuriken_storm>=3&spell_targets.shuriken_storm<=4)
			if ComboPoints() >= 5 or ComboPoints() >= 4 and Enemies() >= 3 and Enemies() <= 4 SubtletyFinishShortCdActions()

			unless { ComboPoints() >= 5 or ComboPoints() >= 4 and Enemies() >= 3 and Enemies() <= 4 } and SubtletyFinishShortCdPostConditions()
			{
				#call_action_list,name=stealth_als,if=combo_points.deficit>=2+talent.premeditation.enabled
				if ComboPointsDeficit() >= 2 + TalentPoints(premeditation_talent) SubtletyStealthAlsShortCdActions()

				unless ComboPointsDeficit() >= 2 + TalentPoints(premeditation_talent) and SubtletyStealthAlsShortCdPostConditions()
				{
					#call_action_list,name=build,if=energy.deficit<=variable.stealth_threshold
					if EnergyDeficit() <= stealth_threshold() SubtletyBuildShortCdActions()
				}
			}
		}
	}
}

AddFunction SubtletyDefaultShortCdPostConditions
{
	SubtletyCdsShortCdPostConditions() or Stealthed() and SubtletyStealthedShortCdPostConditions() or { ComboPoints() >= 5 or ComboPoints() >= 4 and Enemies() >= 3 and Enemies() <= 4 } and SubtletyFinishShortCdPostConditions() or ComboPointsDeficit() >= 2 + TalentPoints(premeditation_talent) and SubtletyStealthAlsShortCdPostConditions() or EnergyDeficit() <= stealth_threshold() and SubtletyBuildShortCdPostConditions()
}

AddFunction SubtletyDefaultCdActions
{
	#call_action_list,name=cds
	SubtletyCdsCdActions()

	unless SubtletyCdsCdPostConditions()
	{
		#run_action_list,name=stealthed,if=stealthed.all
		if Stealthed() SubtletyStealthedCdActions()

		unless Stealthed() and SubtletyStealthedCdPostConditions()
		{
			#call_action_list,name=finish,if=combo_points>=5|(combo_points>=4&spell_targets.shuriken_storm>=3&spell_targets.shuriken_storm<=4)
			if ComboPoints() >= 5 or ComboPoints() >= 4 and Enemies() >= 3 and Enemies() <= 4 SubtletyFinishCdActions()

			unless { ComboPoints() >= 5 or ComboPoints() >= 4 and Enemies() >= 3 and Enemies() <= 4 } and SubtletyFinishCdPostConditions()
			{
				#call_action_list,name=stealth_als,if=combo_points.deficit>=2+talent.premeditation.enabled
				if ComboPointsDeficit() >= 2 + TalentPoints(premeditation_talent) SubtletyStealthAlsCdActions()

				unless ComboPointsDeficit() >= 2 + TalentPoints(premeditation_talent) and SubtletyStealthAlsCdPostConditions()
				{
					#call_action_list,name=build,if=energy.deficit<=variable.stealth_threshold
					if EnergyDeficit() <= stealth_threshold() SubtletyBuildCdActions()
				}
			}
		}
	}
}

AddFunction SubtletyDefaultCdPostConditions
{
	SubtletyCdsCdPostConditions() or Stealthed() and SubtletyStealthedCdPostConditions() or { ComboPoints() >= 5 or ComboPoints() >= 4 and Enemies() >= 3 and Enemies() <= 4 } and SubtletyFinishCdPostConditions() or ComboPointsDeficit() >= 2 + TalentPoints(premeditation_talent) and SubtletyStealthAlsCdPostConditions() or EnergyDeficit() <= stealth_threshold() and SubtletyBuildCdPostConditions()
}

### actions.build

AddFunction SubtletyBuildMainActions
{
	#shuriken_storm,if=spell_targets.shuriken_storm>=2
	if Enemies() >= 2 Spell(shuriken_storm)
	#gloomblade
	Spell(gloomblade)
	#backstab
	Spell(backstab)
}

AddFunction SubtletyBuildMainPostConditions
{
}

AddFunction SubtletyBuildShortCdActions
{
}

AddFunction SubtletyBuildShortCdPostConditions
{
	Enemies() >= 2 and Spell(shuriken_storm) or Spell(gloomblade) or Spell(backstab)
}

AddFunction SubtletyBuildCdActions
{
}

AddFunction SubtletyBuildCdPostConditions
{
	Enemies() >= 2 and Spell(shuriken_storm) or Spell(gloomblade) or Spell(backstab)
}

### actions.cds

AddFunction SubtletyCdsMainActions
{
}

AddFunction SubtletyCdsMainPostConditions
{
}

AddFunction SubtletyCdsShortCdActions
{
	#goremaws_bite,if=!stealthed.all&cooldown.shadow_dance.charges_fractional<=2.45&((combo_points.deficit>=4-(time<10)*2&energy.deficit>50+talent.vigor.enabled*25-(time>=10)*15)|target.time_to_die<8)
	if not Stealthed() and SpellCharges(shadow_dance count=0) <= 2.45 and { ComboPointsDeficit() >= 4 - { TimeInCombat() < 10 } * 2 and EnergyDeficit() > 50 + TalentPoints(vigor_talent) * 25 - { TimeInCombat() >= 10 } * 15 or target.TimeToDie() < 8 } Spell(goremaws_bite)
	#marked_for_death,target_if=min:target.time_to_die,if=target.time_to_die<combo_points.deficit|(raid_event.adds.in>40&combo_points.deficit>=4+talent.deeper_stratagem.enabled+talent.anticipation.enabled)
	if target.TimeToDie() < ComboPointsDeficit() or 600 > 40 and ComboPointsDeficit() >= 4 + TalentPoints(deeper_stratagem_talent) + TalentPoints(anticipation_talent) Spell(marked_for_death)
}

AddFunction SubtletyCdsShortCdPostConditions
{
}

AddFunction SubtletyCdsCdActions
{
	#potion,name=old_war,if=buff.bloodlust.react|target.time_to_die<=25|buff.shadow_blades.up
	#blood_fury,if=stealthed.rogue
	if Stealthed() Spell(blood_fury_ap)
	#berserking,if=stealthed.rogue
	if Stealthed() Spell(berserking)
	#arcane_torrent,if=stealthed.rogue&energy.deficit>70
	if Stealthed() and EnergyDeficit() > 70 Spell(arcane_torrent_energy)
	#shadow_blades,if=combo_points<=2|(equipped.denial_of_the_halfgiants&combo_points>=1)
	if ComboPoints() <= 2 or HasEquippedItem(denial_of_the_halfgiants) and ComboPoints() >= 1 Spell(shadow_blades)
}

AddFunction SubtletyCdsCdPostConditions
{
	not Stealthed() and SpellCharges(shadow_dance count=0) <= 2.45 and { ComboPointsDeficit() >= 4 - { TimeInCombat() < 10 } * 2 and EnergyDeficit() > 50 + TalentPoints(vigor_talent) * 25 - { TimeInCombat() >= 10 } * 15 or target.TimeToDie() < 8 } and Spell(goremaws_bite)
}

### actions.finish

AddFunction SubtletyFinishMainActions
{
	#enveloping_shadows,if=buff.enveloping_shadows.remains<target.time_to_die&buff.enveloping_shadows.remains<=combo_points*1.8
	if BuffRemaining(enveloping_shadows_buff) < target.TimeToDie() and BuffRemaining(enveloping_shadows_buff) <= ComboPoints() * 1.8 Spell(enveloping_shadows)
	#death_from_above,if=spell_targets.death_from_above>=6
	if Enemies() >= 6 Spell(death_from_above)
	#nightblade,cycle_targets=1,if=target.time_to_die>8&((refreshable&(!finality|buff.finality_nightblade.up))|remains<tick_time)
	if target.TimeToDie() > 8 and { target.Refreshable(nightblade_debuff) and { not HasArtifactTrait(finality) or DebuffPresent(finality_nightblade_debuff) } or target.DebuffRemaining(nightblade_debuff) < target.TickTime(nightblade_debuff) } Spell(nightblade)
	#death_from_above
	Spell(death_from_above)
	#eviscerate
	Spell(eviscerate)
}

AddFunction SubtletyFinishMainPostConditions
{
}

AddFunction SubtletyFinishShortCdActions
{
}

AddFunction SubtletyFinishShortCdPostConditions
{
	BuffRemaining(enveloping_shadows_buff) < target.TimeToDie() and BuffRemaining(enveloping_shadows_buff) <= ComboPoints() * 1.8 and Spell(enveloping_shadows) or Enemies() >= 6 and Spell(death_from_above) or target.TimeToDie() > 8 and { target.Refreshable(nightblade_debuff) and { not HasArtifactTrait(finality) or DebuffPresent(finality_nightblade_debuff) } or target.DebuffRemaining(nightblade_debuff) < target.TickTime(nightblade_debuff) } and Spell(nightblade) or Spell(death_from_above) or Spell(eviscerate)
}

AddFunction SubtletyFinishCdActions
{
}

AddFunction SubtletyFinishCdPostConditions
{
	BuffRemaining(enveloping_shadows_buff) < target.TimeToDie() and BuffRemaining(enveloping_shadows_buff) <= ComboPoints() * 1.8 and Spell(enveloping_shadows) or Enemies() >= 6 and Spell(death_from_above) or target.TimeToDie() > 8 and { target.Refreshable(nightblade_debuff) and { not HasArtifactTrait(finality) or DebuffPresent(finality_nightblade_debuff) } or target.DebuffRemaining(nightblade_debuff) < target.TickTime(nightblade_debuff) } and Spell(nightblade) or Spell(death_from_above) or Spell(eviscerate)
}

### actions.precombat

AddFunction SubtletyPrecombatMainActions
{
	#flask,name=flask_of_the_seventh_demon
	#augmentation,name=defiled
	Spell(augmentation)
	#food,name=seedbattered_fish_plate
	#snapshot_stats
	#stealth
	Spell(stealth)
	#variable,name=ssw_refund,value=equipped.shadow_satyrs_walk*(4+ssw_refund_offset)
	#variable,name=stealth_threshold,value=(15+talent.vigor.enabled*35+talent.master_of_shadows.enabled*30+variable.ssw_refund)
	#enveloping_shadows,if=combo_points>=5
	if ComboPoints() >= 5 Spell(enveloping_shadows)
	#symbols_of_death
	Spell(symbols_of_death)
}

AddFunction SubtletyPrecombatMainPostConditions
{
}

AddFunction SubtletyPrecombatShortCdActions
{
	unless Spell(augmentation) or Spell(stealth)
	{
		#potion,name=old_war
		#marked_for_death,if=raid_event.adds.in>40
		if 600 > 40 Spell(marked_for_death)
	}
}

AddFunction SubtletyPrecombatShortCdPostConditions
{
	Spell(augmentation) or Spell(stealth) or ComboPoints() >= 5 and Spell(enveloping_shadows) or Spell(symbols_of_death)
}

AddFunction SubtletyPrecombatCdActions
{
}

AddFunction SubtletyPrecombatCdPostConditions
{
	Spell(augmentation) or Spell(stealth) or ComboPoints() >= 5 and Spell(enveloping_shadows) or Spell(symbols_of_death)
}

### actions.stealth_als

AddFunction SubtletyStealthAlsMainActions
{
	#call_action_list,name=stealth_cds,if=energy.deficit<=variable.stealth_threshold&(!equipped.shadow_satyrs_walk|cooldown.shadow_dance.charges_fractional>=2.45|energy.deficit>=10)
	if EnergyDeficit() <= stealth_threshold() and { not HasEquippedItem(shadow_satyrs_walk) or SpellCharges(shadow_dance count=0) >= 2.45 or EnergyDeficit() >= 10 } SubtletyStealthCdsMainActions()

	unless EnergyDeficit() <= stealth_threshold() and { not HasEquippedItem(shadow_satyrs_walk) or SpellCharges(shadow_dance count=0) >= 2.45 or EnergyDeficit() >= 10 } and SubtletyStealthCdsMainPostConditions()
	{
		#call_action_list,name=stealth_cds,if=spell_targets.shuriken_storm>=5
		if Enemies() >= 5 SubtletyStealthCdsMainActions()

		unless Enemies() >= 5 and SubtletyStealthCdsMainPostConditions()
		{
			#call_action_list,name=stealth_cds,if=(cooldown.shadowmeld.up&!cooldown.vanish.up&cooldown.shadow_dance.charges<=1)
			if not SpellCooldown(shadowmeld) > 0 and not { not SpellCooldown(vanish) > 0 } and SpellChargeCooldown(shadow_dance) <= 1 SubtletyStealthCdsMainActions()

			unless not SpellCooldown(shadowmeld) > 0 and not { not SpellCooldown(vanish) > 0 } and SpellChargeCooldown(shadow_dance) <= 1 and SubtletyStealthCdsMainPostConditions()
			{
				#call_action_list,name=stealth_cds,if=target.time_to_die<12*cooldown.shadow_dance.charges_fractional*(1+equipped.shadow_satyrs_walk*0.5)
				if target.TimeToDie() < 12 * SpellCharges(shadow_dance count=0) * { 1 + HasEquippedItem(shadow_satyrs_walk) * 0.5 } SubtletyStealthCdsMainActions()
			}
		}
	}
}

AddFunction SubtletyStealthAlsMainPostConditions
{
	EnergyDeficit() <= stealth_threshold() and { not HasEquippedItem(shadow_satyrs_walk) or SpellCharges(shadow_dance count=0) >= 2.45 or EnergyDeficit() >= 10 } and SubtletyStealthCdsMainPostConditions() or Enemies() >= 5 and SubtletyStealthCdsMainPostConditions() or not SpellCooldown(shadowmeld) > 0 and not { not SpellCooldown(vanish) > 0 } and SpellChargeCooldown(shadow_dance) <= 1 and SubtletyStealthCdsMainPostConditions() or target.TimeToDie() < 12 * SpellCharges(shadow_dance count=0) * { 1 + HasEquippedItem(shadow_satyrs_walk) * 0.5 } and SubtletyStealthCdsMainPostConditions()
}

AddFunction SubtletyStealthAlsShortCdActions
{
	#call_action_list,name=stealth_cds,if=energy.deficit<=variable.stealth_threshold&(!equipped.shadow_satyrs_walk|cooldown.shadow_dance.charges_fractional>=2.45|energy.deficit>=10)
	if EnergyDeficit() <= stealth_threshold() and { not HasEquippedItem(shadow_satyrs_walk) or SpellCharges(shadow_dance count=0) >= 2.45 or EnergyDeficit() >= 10 } SubtletyStealthCdsShortCdActions()

	unless EnergyDeficit() <= stealth_threshold() and { not HasEquippedItem(shadow_satyrs_walk) or SpellCharges(shadow_dance count=0) >= 2.45 or EnergyDeficit() >= 10 } and SubtletyStealthCdsShortCdPostConditions()
	{
		#call_action_list,name=stealth_cds,if=spell_targets.shuriken_storm>=5
		if Enemies() >= 5 SubtletyStealthCdsShortCdActions()

		unless Enemies() >= 5 and SubtletyStealthCdsShortCdPostConditions()
		{
			#call_action_list,name=stealth_cds,if=(cooldown.shadowmeld.up&!cooldown.vanish.up&cooldown.shadow_dance.charges<=1)
			if not SpellCooldown(shadowmeld) > 0 and not { not SpellCooldown(vanish) > 0 } and SpellChargeCooldown(shadow_dance) <= 1 SubtletyStealthCdsShortCdActions()

			unless not SpellCooldown(shadowmeld) > 0 and not { not SpellCooldown(vanish) > 0 } and SpellChargeCooldown(shadow_dance) <= 1 and SubtletyStealthCdsShortCdPostConditions()
			{
				#call_action_list,name=stealth_cds,if=target.time_to_die<12*cooldown.shadow_dance.charges_fractional*(1+equipped.shadow_satyrs_walk*0.5)
				if target.TimeToDie() < 12 * SpellCharges(shadow_dance count=0) * { 1 + HasEquippedItem(shadow_satyrs_walk) * 0.5 } SubtletyStealthCdsShortCdActions()
			}
		}
	}
}

AddFunction SubtletyStealthAlsShortCdPostConditions
{
	EnergyDeficit() <= stealth_threshold() and { not HasEquippedItem(shadow_satyrs_walk) or SpellCharges(shadow_dance count=0) >= 2.45 or EnergyDeficit() >= 10 } and SubtletyStealthCdsShortCdPostConditions() or Enemies() >= 5 and SubtletyStealthCdsShortCdPostConditions() or not SpellCooldown(shadowmeld) > 0 and not { not SpellCooldown(vanish) > 0 } and SpellChargeCooldown(shadow_dance) <= 1 and SubtletyStealthCdsShortCdPostConditions() or target.TimeToDie() < 12 * SpellCharges(shadow_dance count=0) * { 1 + HasEquippedItem(shadow_satyrs_walk) * 0.5 } and SubtletyStealthCdsShortCdPostConditions()
}

AddFunction SubtletyStealthAlsCdActions
{
	#call_action_list,name=stealth_cds,if=energy.deficit<=variable.stealth_threshold&(!equipped.shadow_satyrs_walk|cooldown.shadow_dance.charges_fractional>=2.45|energy.deficit>=10)
	if EnergyDeficit() <= stealth_threshold() and { not HasEquippedItem(shadow_satyrs_walk) or SpellCharges(shadow_dance count=0) >= 2.45 or EnergyDeficit() >= 10 } SubtletyStealthCdsCdActions()

	unless EnergyDeficit() <= stealth_threshold() and { not HasEquippedItem(shadow_satyrs_walk) or SpellCharges(shadow_dance count=0) >= 2.45 or EnergyDeficit() >= 10 } and SubtletyStealthCdsCdPostConditions()
	{
		#call_action_list,name=stealth_cds,if=spell_targets.shuriken_storm>=5
		if Enemies() >= 5 SubtletyStealthCdsCdActions()

		unless Enemies() >= 5 and SubtletyStealthCdsCdPostConditions()
		{
			#call_action_list,name=stealth_cds,if=(cooldown.shadowmeld.up&!cooldown.vanish.up&cooldown.shadow_dance.charges<=1)
			if not SpellCooldown(shadowmeld) > 0 and not { not SpellCooldown(vanish) > 0 } and SpellChargeCooldown(shadow_dance) <= 1 SubtletyStealthCdsCdActions()

			unless not SpellCooldown(shadowmeld) > 0 and not { not SpellCooldown(vanish) > 0 } and SpellChargeCooldown(shadow_dance) <= 1 and SubtletyStealthCdsCdPostConditions()
			{
				#call_action_list,name=stealth_cds,if=target.time_to_die<12*cooldown.shadow_dance.charges_fractional*(1+equipped.shadow_satyrs_walk*0.5)
				if target.TimeToDie() < 12 * SpellCharges(shadow_dance count=0) * { 1 + HasEquippedItem(shadow_satyrs_walk) * 0.5 } SubtletyStealthCdsCdActions()
			}
		}
	}
}

AddFunction SubtletyStealthAlsCdPostConditions
{
	EnergyDeficit() <= stealth_threshold() and { not HasEquippedItem(shadow_satyrs_walk) or SpellCharges(shadow_dance count=0) >= 2.45 or EnergyDeficit() >= 10 } and SubtletyStealthCdsCdPostConditions() or Enemies() >= 5 and SubtletyStealthCdsCdPostConditions() or not SpellCooldown(shadowmeld) > 0 and not { not SpellCooldown(vanish) > 0 } and SpellChargeCooldown(shadow_dance) <= 1 and SubtletyStealthCdsCdPostConditions() or target.TimeToDie() < 12 * SpellCharges(shadow_dance count=0) * { 1 + HasEquippedItem(shadow_satyrs_walk) * 0.5 } and SubtletyStealthCdsCdPostConditions()
}

### actions.stealth_cds

AddFunction SubtletyStealthCdsMainActions
{
}

AddFunction SubtletyStealthCdsMainPostConditions
{
}

AddFunction SubtletyStealthCdsShortCdActions
{
	#shadow_dance,if=charges_fractional>=2.45
	if Charges(shadow_dance count=0) >= 2.45 Spell(shadow_dance)
	#vanish
	Spell(vanish)
	#shadow_dance,if=charges>=2&combo_points<=1
	if Charges(shadow_dance) >= 2 and ComboPoints() <= 1 Spell(shadow_dance)
	#pool_resource,for_next=1,extra_amount=40
	#shadowmeld,if=energy>=40&energy.deficit>=10+variable.ssw_refund
	unless True(pool_energy 40) and EnergyDeficit() >= 10 + ssw_refund() and SpellUsable(shadowmeld) and SpellCooldown(shadowmeld) < TimeToEnergy(40)
	{
		#shadow_dance,if=combo_points<=1
		if ComboPoints() <= 1 Spell(shadow_dance)
	}
}

AddFunction SubtletyStealthCdsShortCdPostConditions
{
}

AddFunction SubtletyStealthCdsCdActions
{
	#pool_resource,for_next=1,extra_amount=40
	#shadowmeld,if=energy>=40&energy.deficit>=10+variable.ssw_refund
	if Energy() >= 40 and EnergyDeficit() >= 10 + ssw_refund() Spell(shadowmeld)
}

AddFunction SubtletyStealthCdsCdPostConditions
{
}

### actions.stealthed

AddFunction SubtletyStealthedMainActions
{
	#symbols_of_death,if=(buff.symbols_of_death.remains<target.time_to_die-4&buff.symbols_of_death.remains<=buff.symbols_of_death.duration*0.3)|equipped.shadow_satyrs_walk&energy.time_to_max<0.25
	if BuffRemaining(symbols_of_death_buff) < target.TimeToDie() - 4 and BuffRemaining(symbols_of_death_buff) <= BaseDuration(symbols_of_death_buff) * 0.3 or HasEquippedItem(shadow_satyrs_walk) and TimeToMaxEnergy() < 0.25 Spell(symbols_of_death)
	#call_action_list,name=finish,if=combo_points>=5
	if ComboPoints() >= 5 SubtletyFinishMainActions()

	unless ComboPoints() >= 5 and SubtletyFinishMainPostConditions()
	{
		#shuriken_storm,if=buff.shadowmeld.down&((combo_points.deficit>=3&spell_targets.shuriken_storm>=2+talent.premeditation.enabled+equipped.shadow_satyrs_walk)|buff.the_dreadlords_deceit.stack>=29)
		if BuffExpires(shadowmeld_buff) and { ComboPointsDeficit() >= 3 and Enemies() >= 2 + TalentPoints(premeditation_talent) + HasEquippedItem(shadow_satyrs_walk) or BuffStacks(the_dreadlords_deceit_buff) >= 29 } Spell(shuriken_storm)
		#shadowstrike
		Spell(shadowstrike)
	}
}

AddFunction SubtletyStealthedMainPostConditions
{
	ComboPoints() >= 5 and SubtletyFinishMainPostConditions()
}

AddFunction SubtletyStealthedShortCdActions
{
	unless { BuffRemaining(symbols_of_death_buff) < target.TimeToDie() - 4 and BuffRemaining(symbols_of_death_buff) <= BaseDuration(symbols_of_death_buff) * 0.3 or HasEquippedItem(shadow_satyrs_walk) and TimeToMaxEnergy() < 0.25 } and Spell(symbols_of_death)
	{
		#call_action_list,name=finish,if=combo_points>=5
		if ComboPoints() >= 5 SubtletyFinishShortCdActions()
	}
}

AddFunction SubtletyStealthedShortCdPostConditions
{
	{ BuffRemaining(symbols_of_death_buff) < target.TimeToDie() - 4 and BuffRemaining(symbols_of_death_buff) <= BaseDuration(symbols_of_death_buff) * 0.3 or HasEquippedItem(shadow_satyrs_walk) and TimeToMaxEnergy() < 0.25 } and Spell(symbols_of_death) or ComboPoints() >= 5 and SubtletyFinishShortCdPostConditions() or BuffExpires(shadowmeld_buff) and { ComboPointsDeficit() >= 3 and Enemies() >= 2 + TalentPoints(premeditation_talent) + HasEquippedItem(shadow_satyrs_walk) or BuffStacks(the_dreadlords_deceit_buff) >= 29 } and Spell(shuriken_storm) or Spell(shadowstrike)
}

AddFunction SubtletyStealthedCdActions
{
	unless { BuffRemaining(symbols_of_death_buff) < target.TimeToDie() - 4 and BuffRemaining(symbols_of_death_buff) <= BaseDuration(symbols_of_death_buff) * 0.3 or HasEquippedItem(shadow_satyrs_walk) and TimeToMaxEnergy() < 0.25 } and Spell(symbols_of_death)
	{
		#call_action_list,name=finish,if=combo_points>=5
		if ComboPoints() >= 5 SubtletyFinishCdActions()
	}
}

AddFunction SubtletyStealthedCdPostConditions
{
	{ BuffRemaining(symbols_of_death_buff) < target.TimeToDie() - 4 and BuffRemaining(symbols_of_death_buff) <= BaseDuration(symbols_of_death_buff) * 0.3 or HasEquippedItem(shadow_satyrs_walk) and TimeToMaxEnergy() < 0.25 } and Spell(symbols_of_death) or ComboPoints() >= 5 and SubtletyFinishCdPostConditions() or BuffExpires(shadowmeld_buff) and { ComboPointsDeficit() >= 3 and Enemies() >= 2 + TalentPoints(premeditation_talent) + HasEquippedItem(shadow_satyrs_walk) or BuffStacks(the_dreadlords_deceit_buff) >= 29 } and Spell(shuriken_storm) or Spell(shadowstrike)
}

### Subtlety icons.

AddCheckBox(opt_rogue_subtlety_aoe L(AOE) default specialization=subtlety)

AddIcon checkbox=!opt_rogue_subtlety_aoe enemies=1 help=shortcd specialization=subtlety
{
	if not InCombat() SubtletyPrecombatShortCdActions()
	unless not InCombat() and SubtletyPrecombatShortCdPostConditions()
	{
		SubtletyDefaultShortCdActions()
	}
}

AddIcon checkbox=opt_rogue_subtlety_aoe help=shortcd specialization=subtlety
{
	if not InCombat() SubtletyPrecombatShortCdActions()
	unless not InCombat() and SubtletyPrecombatShortCdPostConditions()
	{
		SubtletyDefaultShortCdActions()
	}
}

AddIcon enemies=1 help=main specialization=subtlety
{
	if not InCombat() SubtletyPrecombatMainActions()
	unless not InCombat() and SubtletyPrecombatMainPostConditions()
	{
		SubtletyDefaultMainActions()
	}
}

AddIcon checkbox=opt_rogue_subtlety_aoe help=aoe specialization=subtlety
{
	if not InCombat() SubtletyPrecombatMainActions()
	unless not InCombat() and SubtletyPrecombatMainPostConditions()
	{
		SubtletyDefaultMainActions()
	}
}

AddIcon checkbox=!opt_rogue_subtlety_aoe enemies=1 help=cd specialization=subtlety
{
	if not InCombat() SubtletyPrecombatCdActions()
	unless not InCombat() and SubtletyPrecombatCdPostConditions()
	{
		SubtletyDefaultCdActions()
	}
}

AddIcon checkbox=opt_rogue_subtlety_aoe help=cd specialization=subtlety
{
	if not InCombat() SubtletyPrecombatCdActions()
	unless not InCombat() and SubtletyPrecombatCdPostConditions()
	{
		SubtletyDefaultCdActions()
	}
}

### Required symbols
# anticipation_talent
# arcane_torrent_energy
# augmentation
# backstab
# berserking
# blood_fury_ap
# death_from_above
# deeper_stratagem_talent
# denial_of_the_halfgiants
# enveloping_shadows
# enveloping_shadows_buff
# eviscerate
# finality_nightblade_debuff
# gloomblade
# goremaws_bite
# kick
# marked_for_death
# master_of_shadows_talent
# nightblade
# nightblade_debuff
# premeditation_talent
# shadow_blades
# shadow_dance
# shadow_satyrs_walk
# shadowmeld
# shadowmeld_buff
# shadowstep
# shadowstrike
# shuriken_storm
# stealth
# symbols_of_death
# symbols_of_death_buff
# the_dreadlords_deceit_buff
# vanish
# vigor_talent
]]
	OvaleScripts:RegisterScript("ROGUE", "subtlety", name, desc, code, "script")
end
