local OVALE, Ovale = ...
local OvaleScripts = Ovale.OvaleScripts

-- THE REST OF THIS FILE IS AUTOMATICALLY GENERATED.
-- ANY CHANGES MADE BELOW THIS POINT WILL BE LOST.

do
	local name = "simulationcraft_shaman_elemental_t19p"
	local desc = "[7.0] SimulationCraft: Shaman_Elemental_T19P"
	local code = [[
# Based on SimulationCraft profile "Shaman_Elemental_T19P".
#	class=shaman
#	spec=elemental
#	talents=2112333

Include(ovale_common)
Include(ovale_trinkets_mop)
Include(ovale_trinkets_wod)
Include(ovale_shaman_spells)

AddCheckBox(opt_bloodlust SpellName(bloodlust) specialization=elemental)

AddFunction ElementalBloodlust
{
	if CheckBoxOn(opt_bloodlust) and DebuffExpires(burst_haste_debuff any=1)
	{
		Spell(bloodlust)
		Spell(heroism)
	}
}

### actions.default

AddFunction ElementalDefaultMainActions
{
	#storm_elemental
	Spell(storm_elemental)
	#run_action_list,name=aoe,if=active_enemies>2&(spell_targets.chain_lightning>2|spell_targets.lava_beam>2)
	if Enemies() > 2 and { Enemies() > 2 or Enemies() > 2 } ElementalAoeMainActions()

	unless Enemies() > 2 and { Enemies() > 2 or Enemies() > 2 } and ElementalAoeMainPostConditions()
	{
		#run_action_list,name=single_asc,if=talent.ascendance.enabled
		if Talent(ascendance_talent) ElementalSingleAscMainActions()

		unless Talent(ascendance_talent) and ElementalSingleAscMainPostConditions()
		{
			#run_action_list,name=single_if,if=talent.icefury.enabled
			if Talent(icefury_talent) ElementalSingleIfMainActions()

			unless Talent(icefury_talent) and ElementalSingleIfMainPostConditions()
			{
				#run_action_list,name=single_lr,if=talent.lightning_rod.enabled
				if Talent(lightning_rod_talent) ElementalSingleLrMainActions()
			}
		}
	}
}

AddFunction ElementalDefaultMainPostConditions
{
	Enemies() > 2 and { Enemies() > 2 or Enemies() > 2 } and ElementalAoeMainPostConditions() or Talent(ascendance_talent) and ElementalSingleAscMainPostConditions() or Talent(icefury_talent) and ElementalSingleIfMainPostConditions() or Talent(lightning_rod_talent) and ElementalSingleLrMainPostConditions()
}

AddFunction ElementalDefaultShortCdActions
{
	unless Spell(storm_elemental)
	{
		#elemental_mastery
		Spell(elemental_mastery)
		#run_action_list,name=aoe,if=active_enemies>2&(spell_targets.chain_lightning>2|spell_targets.lava_beam>2)
		if Enemies() > 2 and { Enemies() > 2 or Enemies() > 2 } ElementalAoeShortCdActions()

		unless Enemies() > 2 and { Enemies() > 2 or Enemies() > 2 } and ElementalAoeShortCdPostConditions()
		{
			#run_action_list,name=single_asc,if=talent.ascendance.enabled
			if Talent(ascendance_talent) ElementalSingleAscShortCdActions()

			unless Talent(ascendance_talent) and ElementalSingleAscShortCdPostConditions()
			{
				#run_action_list,name=single_if,if=talent.icefury.enabled
				if Talent(icefury_talent) ElementalSingleIfShortCdActions()

				unless Talent(icefury_talent) and ElementalSingleIfShortCdPostConditions()
				{
					#run_action_list,name=single_lr,if=talent.lightning_rod.enabled
					if Talent(lightning_rod_talent) ElementalSingleLrShortCdActions()
				}
			}
		}
	}
}

AddFunction ElementalDefaultShortCdPostConditions
{
	Spell(storm_elemental) or Enemies() > 2 and { Enemies() > 2 or Enemies() > 2 } and ElementalAoeShortCdPostConditions() or Talent(ascendance_talent) and ElementalSingleAscShortCdPostConditions() or Talent(icefury_talent) and ElementalSingleIfShortCdPostConditions() or Talent(lightning_rod_talent) and ElementalSingleLrShortCdPostConditions()
}

AddFunction ElementalDefaultCdActions
{
	#bloodlust,if=target.health.pct<25|time>0.500
	if target.HealthPercent() < 25 or TimeInCombat() > 0.5 ElementalBloodlust()
	#potion,name=prolonged_power,if=cooldown.fire_elemental.remains>280|target.time_to_die<=60
	#totem_mastery,if=buff.resonance_totem.remains<2
	if BuffRemaining(resonance_totem_buff) < 2 Spell(totem_mastery)
	#fire_elemental
	Spell(fire_elemental)

	unless Spell(storm_elemental)
	{
		#blood_fury,if=!talent.ascendance.enabled|buff.ascendance.up|cooldown.ascendance.remains>50
		if not Talent(ascendance_talent) or BuffPresent(ascendance_caster_buff) or SpellCooldown(ascendance_caster) > 50 Spell(blood_fury_apsp)
		#berserking,if=!talent.ascendance.enabled|buff.ascendance.up
		if not Talent(ascendance_talent) or BuffPresent(ascendance_caster_buff) Spell(berserking)
		#run_action_list,name=aoe,if=active_enemies>2&(spell_targets.chain_lightning>2|spell_targets.lava_beam>2)
		if Enemies() > 2 and { Enemies() > 2 or Enemies() > 2 } ElementalAoeCdActions()

		unless Enemies() > 2 and { Enemies() > 2 or Enemies() > 2 } and ElementalAoeCdPostConditions()
		{
			#run_action_list,name=single_asc,if=talent.ascendance.enabled
			if Talent(ascendance_talent) ElementalSingleAscCdActions()

			unless Talent(ascendance_talent) and ElementalSingleAscCdPostConditions()
			{
				#run_action_list,name=single_if,if=talent.icefury.enabled
				if Talent(icefury_talent) ElementalSingleIfCdActions()

				unless Talent(icefury_talent) and ElementalSingleIfCdPostConditions()
				{
					#run_action_list,name=single_lr,if=talent.lightning_rod.enabled
					if Talent(lightning_rod_talent) ElementalSingleLrCdActions()
				}
			}
		}
	}
}

AddFunction ElementalDefaultCdPostConditions
{
	Spell(storm_elemental) or Enemies() > 2 and { Enemies() > 2 or Enemies() > 2 } and ElementalAoeCdPostConditions() or Talent(ascendance_talent) and ElementalSingleAscCdPostConditions() or Talent(icefury_talent) and ElementalSingleIfCdPostConditions() or Talent(lightning_rod_talent) and ElementalSingleLrCdPostConditions()
}

### actions.aoe

AddFunction ElementalAoeMainActions
{
	#flame_shock,if=spell_targets.chain_lightning<4&maelstrom>=20&!talent.lightning_rod.enabled,target_if=refreshable
	if Enemies() < 4 and Maelstrom() >= 20 and not Talent(lightning_rod_talent) and target.Refreshable(flame_shock_debuff) Spell(flame_shock)
	#earthquake
	Spell(earthquake)
	#lava_burst,if=dot.flame_shock.remains>cast_time&buff.lava_surge.up&!talent.lightning_rod.enabled&spell_targets.chain_lightning<4
	if target.DebuffRemaining(flame_shock_debuff) > CastTime(lava_burst) and BuffPresent(lava_surge_buff) and not Talent(lightning_rod_talent) and Enemies() < 4 Spell(lava_burst)
	#elemental_blast,if=!talent.lightning_rod.enabled&spell_targets.chain_lightning<5
	if not Talent(lightning_rod_talent) and Enemies() < 5 Spell(elemental_blast)
	#lava_beam
	Spell(lava_beam)
	#chain_lightning,target_if=debuff.lightning_rod.down
	if target.DebuffExpires(lightning_rod_debuff) Spell(chain_lightning)
	#chain_lightning
	Spell(chain_lightning)
	#lava_burst,moving=1
	if Speed() > 0 Spell(lava_burst)
	#flame_shock,moving=1,target_if=refreshable
	if Speed() > 0 and target.Refreshable(flame_shock_debuff) Spell(flame_shock)
}

AddFunction ElementalAoeMainPostConditions
{
}

AddFunction ElementalAoeShortCdActions
{
	#stormkeeper
	Spell(stormkeeper)
	#liquid_magma_totem
	Spell(liquid_magma_totem)
}

AddFunction ElementalAoeShortCdPostConditions
{
	Enemies() < 4 and Maelstrom() >= 20 and not Talent(lightning_rod_talent) and target.Refreshable(flame_shock_debuff) and Spell(flame_shock) or Spell(earthquake) or target.DebuffRemaining(flame_shock_debuff) > CastTime(lava_burst) and BuffPresent(lava_surge_buff) and not Talent(lightning_rod_talent) and Enemies() < 4 and Spell(lava_burst) or not Talent(lightning_rod_talent) and Enemies() < 5 and Spell(elemental_blast) or Spell(lava_beam) or target.DebuffExpires(lightning_rod_debuff) and Spell(chain_lightning) or Spell(chain_lightning) or Speed() > 0 and Spell(lava_burst) or Speed() > 0 and target.Refreshable(flame_shock_debuff) and Spell(flame_shock)
}

AddFunction ElementalAoeCdActions
{
	unless Spell(stormkeeper)
	{
		#ascendance
		if BuffExpires(ascendance_caster_buff) Spell(ascendance_caster)
	}
}

AddFunction ElementalAoeCdPostConditions
{
	Spell(stormkeeper) or Spell(liquid_magma_totem) or Enemies() < 4 and Maelstrom() >= 20 and not Talent(lightning_rod_talent) and target.Refreshable(flame_shock_debuff) and Spell(flame_shock) or Spell(earthquake) or target.DebuffRemaining(flame_shock_debuff) > CastTime(lava_burst) and BuffPresent(lava_surge_buff) and not Talent(lightning_rod_talent) and Enemies() < 4 and Spell(lava_burst) or not Talent(lightning_rod_talent) and Enemies() < 5 and Spell(elemental_blast) or Spell(lava_beam) or target.DebuffExpires(lightning_rod_debuff) and Spell(chain_lightning) or Spell(chain_lightning) or Speed() > 0 and Spell(lava_burst) or Speed() > 0 and target.Refreshable(flame_shock_debuff) and Spell(flame_shock)
}

### actions.precombat

AddFunction ElementalPrecombatMainActions
{
	#flask,type=whispered_pact
	#food,name=fishbrul_special
	#augmentation,type=defiled
	Spell(augmentation)
}

AddFunction ElementalPrecombatMainPostConditions
{
}

AddFunction ElementalPrecombatShortCdActions
{
	unless Spell(augmentation)
	{
		#stormkeeper
		Spell(stormkeeper)
	}
}

AddFunction ElementalPrecombatShortCdPostConditions
{
	Spell(augmentation)
}

AddFunction ElementalPrecombatCdActions
{
	unless Spell(augmentation)
	{
		#snapshot_stats
		#potion,name=prolonged_power
		#totem_mastery
		Spell(totem_mastery)
	}
}

AddFunction ElementalPrecombatCdPostConditions
{
	Spell(augmentation) or Spell(stormkeeper)
}

### actions.single_asc

AddFunction ElementalSingleAscMainActions
{
	#flame_shock,if=!ticking
	if not target.DebuffPresent(flame_shock_debuff) Spell(flame_shock)
	#flame_shock,if=maelstrom>=20&remains<=buff.ascendance.duration&cooldown.ascendance.remains+buff.ascendance.duration<=duration
	if Maelstrom() >= 20 and target.DebuffRemaining(flame_shock_debuff) <= BaseDuration(ascendance_caster_buff) and SpellCooldown(ascendance_caster) + BaseDuration(ascendance_caster_buff) <= BaseDuration(flame_shock_debuff) Spell(flame_shock)
	#earthquake,if=buff.echoes_of_the_great_sundering.up&!buff.ascendance.up&maelstrom>=86
	if BuffPresent(echoes_of_the_great_sundering_buff) and not BuffPresent(ascendance_caster_buff) and Maelstrom() >= 86 Spell(earthquake)
	#earth_shock,if=maelstrom>=92&!buff.ascendance.up
	if Maelstrom() >= 92 and not BuffPresent(ascendance_caster_buff) Spell(earth_shock)
	#elemental_blast
	Spell(elemental_blast)
	#lightning_bolt,if=buff.power_of_the_maelstrom.up&buff.stormkeeper.up&spell_targets.chain_lightning<3
	if BuffPresent(power_of_the_maelstrom_buff) and BuffPresent(stormkeeper_buff) and Enemies() < 3 Spell(lightning_bolt)
	#lava_burst,if=dot.flame_shock.remains>cast_time&(cooldown_react|buff.ascendance.up)
	if target.DebuffRemaining(flame_shock_debuff) > CastTime(lava_burst) and { not SpellCooldown(lava_burst) > 0 or BuffPresent(ascendance_caster_buff) } Spell(lava_burst)
	#flame_shock,if=maelstrom>=20&buff.elemental_focus.up,target_if=refreshable
	if Maelstrom() >= 20 and BuffPresent(elemental_focus_buff) and target.Refreshable(flame_shock_debuff) Spell(flame_shock)
	#earth_shock,if=maelstrom>=86
	if Maelstrom() >= 86 Spell(earth_shock)
	#earthquake,if=buff.echoes_of_the_great_sundering.up
	if BuffPresent(echoes_of_the_great_sundering_buff) Spell(earthquake)
	#lava_beam,if=active_enemies>1&spell_targets.lava_beam>1
	if Enemies() > 1 and Enemies() > 1 Spell(lava_beam)
	#lightning_bolt,if=buff.power_of_the_maelstrom.up&spell_targets.chain_lightning<3
	if BuffPresent(power_of_the_maelstrom_buff) and Enemies() < 3 Spell(lightning_bolt)
	#chain_lightning,if=active_enemies>1&spell_targets.chain_lightning>1
	if Enemies() > 1 and Enemies() > 1 Spell(chain_lightning)
	#lightning_bolt
	Spell(lightning_bolt)
	#flame_shock,moving=1,target_if=refreshable
	if Speed() > 0 and target.Refreshable(flame_shock_debuff) Spell(flame_shock)
	#earth_shock,moving=1
	if Speed() > 0 Spell(earth_shock)
	#flame_shock,moving=1,if=movement.distance>6
	if Speed() > 0 and target.Distance() > 6 Spell(flame_shock)
}

AddFunction ElementalSingleAscMainPostConditions
{
}

AddFunction ElementalSingleAscShortCdActions
{
	unless not target.DebuffPresent(flame_shock_debuff) and Spell(flame_shock) or Maelstrom() >= 20 and target.DebuffRemaining(flame_shock_debuff) <= BaseDuration(ascendance_caster_buff) and SpellCooldown(ascendance_caster) + BaseDuration(ascendance_caster_buff) <= BaseDuration(flame_shock_debuff) and Spell(flame_shock) or BuffPresent(echoes_of_the_great_sundering_buff) and not BuffPresent(ascendance_caster_buff) and Maelstrom() >= 86 and Spell(earthquake) or Maelstrom() >= 92 and not BuffPresent(ascendance_caster_buff) and Spell(earth_shock)
	{
		#stormkeeper,if=raid_event.adds.count<3|raid_event.adds.in>50
		if 0 < 3 or 600 > 50 Spell(stormkeeper)

		unless Spell(elemental_blast)
		{
			#liquid_magma_totem,if=raid_event.adds.count<3|raid_event.adds.in>50
			if 0 < 3 or 600 > 50 Spell(liquid_magma_totem)
		}
	}
}

AddFunction ElementalSingleAscShortCdPostConditions
{
	not target.DebuffPresent(flame_shock_debuff) and Spell(flame_shock) or Maelstrom() >= 20 and target.DebuffRemaining(flame_shock_debuff) <= BaseDuration(ascendance_caster_buff) and SpellCooldown(ascendance_caster) + BaseDuration(ascendance_caster_buff) <= BaseDuration(flame_shock_debuff) and Spell(flame_shock) or BuffPresent(echoes_of_the_great_sundering_buff) and not BuffPresent(ascendance_caster_buff) and Maelstrom() >= 86 and Spell(earthquake) or Maelstrom() >= 92 and not BuffPresent(ascendance_caster_buff) and Spell(earth_shock) or Spell(elemental_blast) or BuffPresent(power_of_the_maelstrom_buff) and BuffPresent(stormkeeper_buff) and Enemies() < 3 and Spell(lightning_bolt) or target.DebuffRemaining(flame_shock_debuff) > CastTime(lava_burst) and { not SpellCooldown(lava_burst) > 0 or BuffPresent(ascendance_caster_buff) } and Spell(lava_burst) or Maelstrom() >= 20 and BuffPresent(elemental_focus_buff) and target.Refreshable(flame_shock_debuff) and Spell(flame_shock) or Maelstrom() >= 86 and Spell(earth_shock) or BuffPresent(echoes_of_the_great_sundering_buff) and Spell(earthquake) or Enemies() > 1 and Enemies() > 1 and Spell(lava_beam) or BuffPresent(power_of_the_maelstrom_buff) and Enemies() < 3 and Spell(lightning_bolt) or Enemies() > 1 and Enemies() > 1 and Spell(chain_lightning) or Spell(lightning_bolt) or Speed() > 0 and target.Refreshable(flame_shock_debuff) and Spell(flame_shock) or Speed() > 0 and Spell(earth_shock) or Speed() > 0 and target.Distance() > 6 and Spell(flame_shock)
}

AddFunction ElementalSingleAscCdActions
{
	#ascendance,if=dot.flame_shock.remains>buff.ascendance.duration&(time>=60|buff.bloodlust.up)&cooldown.lava_burst.remains>0&!buff.stormkeeper.up
	if target.DebuffRemaining(flame_shock_debuff) > BaseDuration(ascendance_caster_buff) and { TimeInCombat() >= 60 or BuffPresent(burst_haste_buff any=1) } and SpellCooldown(lava_burst) > 0 and not BuffPresent(stormkeeper_buff) and BuffExpires(ascendance_caster_buff) Spell(ascendance_caster)

	unless not target.DebuffPresent(flame_shock_debuff) and Spell(flame_shock) or Maelstrom() >= 20 and target.DebuffRemaining(flame_shock_debuff) <= BaseDuration(ascendance_caster_buff) and SpellCooldown(ascendance_caster) + BaseDuration(ascendance_caster_buff) <= BaseDuration(flame_shock_debuff) and Spell(flame_shock) or BuffPresent(echoes_of_the_great_sundering_buff) and not BuffPresent(ascendance_caster_buff) and Maelstrom() >= 86 and Spell(earthquake) or Maelstrom() >= 92 and not BuffPresent(ascendance_caster_buff) and Spell(earth_shock) or { 0 < 3 or 600 > 50 } and Spell(stormkeeper) or Spell(elemental_blast) or { 0 < 3 or 600 > 50 } and Spell(liquid_magma_totem) or BuffPresent(power_of_the_maelstrom_buff) and BuffPresent(stormkeeper_buff) and Enemies() < 3 and Spell(lightning_bolt) or target.DebuffRemaining(flame_shock_debuff) > CastTime(lava_burst) and { not SpellCooldown(lava_burst) > 0 or BuffPresent(ascendance_caster_buff) } and Spell(lava_burst) or Maelstrom() >= 20 and BuffPresent(elemental_focus_buff) and target.Refreshable(flame_shock_debuff) and Spell(flame_shock) or Maelstrom() >= 86 and Spell(earth_shock)
	{
		#totem_mastery,if=buff.resonance_totem.remains<10|(buff.resonance_totem.remains<(buff.ascendance.duration+cooldown.ascendance.remains)&cooldown.ascendance.remains<15)
		if BuffRemaining(resonance_totem_buff) < 10 or BuffRemaining(resonance_totem_buff) < BaseDuration(ascendance_caster_buff) + SpellCooldown(ascendance_caster) and SpellCooldown(ascendance_caster) < 15 Spell(totem_mastery)
	}
}

AddFunction ElementalSingleAscCdPostConditions
{
	not target.DebuffPresent(flame_shock_debuff) and Spell(flame_shock) or Maelstrom() >= 20 and target.DebuffRemaining(flame_shock_debuff) <= BaseDuration(ascendance_caster_buff) and SpellCooldown(ascendance_caster) + BaseDuration(ascendance_caster_buff) <= BaseDuration(flame_shock_debuff) and Spell(flame_shock) or BuffPresent(echoes_of_the_great_sundering_buff) and not BuffPresent(ascendance_caster_buff) and Maelstrom() >= 86 and Spell(earthquake) or Maelstrom() >= 92 and not BuffPresent(ascendance_caster_buff) and Spell(earth_shock) or { 0 < 3 or 600 > 50 } and Spell(stormkeeper) or Spell(elemental_blast) or { 0 < 3 or 600 > 50 } and Spell(liquid_magma_totem) or BuffPresent(power_of_the_maelstrom_buff) and BuffPresent(stormkeeper_buff) and Enemies() < 3 and Spell(lightning_bolt) or target.DebuffRemaining(flame_shock_debuff) > CastTime(lava_burst) and { not SpellCooldown(lava_burst) > 0 or BuffPresent(ascendance_caster_buff) } and Spell(lava_burst) or Maelstrom() >= 20 and BuffPresent(elemental_focus_buff) and target.Refreshable(flame_shock_debuff) and Spell(flame_shock) or Maelstrom() >= 86 and Spell(earth_shock) or BuffPresent(echoes_of_the_great_sundering_buff) and Spell(earthquake) or Enemies() > 1 and Enemies() > 1 and Spell(lava_beam) or BuffPresent(power_of_the_maelstrom_buff) and Enemies() < 3 and Spell(lightning_bolt) or Enemies() > 1 and Enemies() > 1 and Spell(chain_lightning) or Spell(lightning_bolt) or Speed() > 0 and target.Refreshable(flame_shock_debuff) and Spell(flame_shock) or Speed() > 0 and Spell(earth_shock) or Speed() > 0 and target.Distance() > 6 and Spell(flame_shock)
}

### actions.single_if

AddFunction ElementalSingleIfMainActions
{
	#flame_shock,if=!ticking
	if not target.DebuffPresent(flame_shock_debuff) Spell(flame_shock)
	#earthquake,if=buff.echoes_of_the_great_sundering.up&maelstrom>=86
	if BuffPresent(echoes_of_the_great_sundering_buff) and Maelstrom() >= 86 Spell(earthquake)
	#frost_shock,if=buff.icefury.up&maelstrom>=86
	if BuffPresent(icefury_buff) and Maelstrom() >= 86 Spell(frost_shock)
	#earth_shock,if=maelstrom>=92
	if Maelstrom() >= 92 Spell(earth_shock)
	#elemental_blast
	Spell(elemental_blast)
	#icefury,if=raid_event.movement.in<5|maelstrom<=76
	if 600 < 5 or Maelstrom() <= 76 Spell(icefury)
	#lightning_bolt,if=buff.power_of_the_maelstrom.up&buff.stormkeeper.up&spell_targets.chain_lightning<3
	if BuffPresent(power_of_the_maelstrom_buff) and BuffPresent(stormkeeper_buff) and Enemies() < 3 Spell(lightning_bolt)
	#lava_burst,if=dot.flame_shock.remains>cast_time&cooldown_react
	if target.DebuffRemaining(flame_shock_debuff) > CastTime(lava_burst) and not SpellCooldown(lava_burst) > 0 Spell(lava_burst)
	#frost_shock,if=buff.icefury.up&((maelstrom>=20&raid_event.movement.in>buff.icefury.remains)|buff.icefury.remains<(1.5*spell_haste*buff.icefury.stack+1))
	if BuffPresent(icefury_buff) and { Maelstrom() >= 20 and 600 > BuffRemaining(icefury_buff) or BuffRemaining(icefury_buff) < 1.5 * { 100 / { 100 + SpellHaste() } } * BuffStacks(icefury_buff) + 1 } Spell(frost_shock)
	#flame_shock,if=maelstrom>=20&buff.elemental_focus.up,target_if=refreshable
	if Maelstrom() >= 20 and BuffPresent(elemental_focus_buff) and target.Refreshable(flame_shock_debuff) Spell(flame_shock)
	#frost_shock,moving=1,if=buff.icefury.up
	if Speed() > 0 and BuffPresent(icefury_buff) Spell(frost_shock)
	#earth_shock,if=maelstrom>=86
	if Maelstrom() >= 86 Spell(earth_shock)
	#earthquake,if=buff.echoes_of_the_great_sundering.up
	if BuffPresent(echoes_of_the_great_sundering_buff) Spell(earthquake)
	#lightning_bolt,if=buff.power_of_the_maelstrom.up&spell_targets.chain_lightning<3
	if BuffPresent(power_of_the_maelstrom_buff) and Enemies() < 3 Spell(lightning_bolt)
	#chain_lightning,if=active_enemies>1&spell_targets.chain_lightning>1
	if Enemies() > 1 and Enemies() > 1 Spell(chain_lightning)
	#lightning_bolt
	Spell(lightning_bolt)
	#flame_shock,moving=1,target_if=refreshable
	if Speed() > 0 and target.Refreshable(flame_shock_debuff) Spell(flame_shock)
	#earth_shock,moving=1
	if Speed() > 0 Spell(earth_shock)
	#flame_shock,moving=1,if=movement.distance>6
	if Speed() > 0 and target.Distance() > 6 Spell(flame_shock)
}

AddFunction ElementalSingleIfMainPostConditions
{
}

AddFunction ElementalSingleIfShortCdActions
{
	unless not target.DebuffPresent(flame_shock_debuff) and Spell(flame_shock) or BuffPresent(echoes_of_the_great_sundering_buff) and Maelstrom() >= 86 and Spell(earthquake) or BuffPresent(icefury_buff) and Maelstrom() >= 86 and Spell(frost_shock) or Maelstrom() >= 92 and Spell(earth_shock)
	{
		#stormkeeper,if=raid_event.adds.count<3|raid_event.adds.in>50
		if 0 < 3 or 600 > 50 Spell(stormkeeper)

		unless Spell(elemental_blast) or { 600 < 5 or Maelstrom() <= 76 } and Spell(icefury)
		{
			#liquid_magma_totem,if=raid_event.adds.count<3|raid_event.adds.in>50
			if 0 < 3 or 600 > 50 Spell(liquid_magma_totem)
		}
	}
}

AddFunction ElementalSingleIfShortCdPostConditions
{
	not target.DebuffPresent(flame_shock_debuff) and Spell(flame_shock) or BuffPresent(echoes_of_the_great_sundering_buff) and Maelstrom() >= 86 and Spell(earthquake) or BuffPresent(icefury_buff) and Maelstrom() >= 86 and Spell(frost_shock) or Maelstrom() >= 92 and Spell(earth_shock) or Spell(elemental_blast) or { 600 < 5 or Maelstrom() <= 76 } and Spell(icefury) or BuffPresent(power_of_the_maelstrom_buff) and BuffPresent(stormkeeper_buff) and Enemies() < 3 and Spell(lightning_bolt) or target.DebuffRemaining(flame_shock_debuff) > CastTime(lava_burst) and not SpellCooldown(lava_burst) > 0 and Spell(lava_burst) or BuffPresent(icefury_buff) and { Maelstrom() >= 20 and 600 > BuffRemaining(icefury_buff) or BuffRemaining(icefury_buff) < 1.5 * { 100 / { 100 + SpellHaste() } } * BuffStacks(icefury_buff) + 1 } and Spell(frost_shock) or Maelstrom() >= 20 and BuffPresent(elemental_focus_buff) and target.Refreshable(flame_shock_debuff) and Spell(flame_shock) or Speed() > 0 and BuffPresent(icefury_buff) and Spell(frost_shock) or Maelstrom() >= 86 and Spell(earth_shock) or BuffPresent(echoes_of_the_great_sundering_buff) and Spell(earthquake) or BuffPresent(power_of_the_maelstrom_buff) and Enemies() < 3 and Spell(lightning_bolt) or Enemies() > 1 and Enemies() > 1 and Spell(chain_lightning) or Spell(lightning_bolt) or Speed() > 0 and target.Refreshable(flame_shock_debuff) and Spell(flame_shock) or Speed() > 0 and Spell(earth_shock) or Speed() > 0 and target.Distance() > 6 and Spell(flame_shock)
}

AddFunction ElementalSingleIfCdActions
{
	unless not target.DebuffPresent(flame_shock_debuff) and Spell(flame_shock) or BuffPresent(echoes_of_the_great_sundering_buff) and Maelstrom() >= 86 and Spell(earthquake) or BuffPresent(icefury_buff) and Maelstrom() >= 86 and Spell(frost_shock) or Maelstrom() >= 92 and Spell(earth_shock) or { 0 < 3 or 600 > 50 } and Spell(stormkeeper) or Spell(elemental_blast) or { 600 < 5 or Maelstrom() <= 76 } and Spell(icefury) or { 0 < 3 or 600 > 50 } and Spell(liquid_magma_totem) or BuffPresent(power_of_the_maelstrom_buff) and BuffPresent(stormkeeper_buff) and Enemies() < 3 and Spell(lightning_bolt) or target.DebuffRemaining(flame_shock_debuff) > CastTime(lava_burst) and not SpellCooldown(lava_burst) > 0 and Spell(lava_burst) or BuffPresent(icefury_buff) and { Maelstrom() >= 20 and 600 > BuffRemaining(icefury_buff) or BuffRemaining(icefury_buff) < 1.5 * { 100 / { 100 + SpellHaste() } } * BuffStacks(icefury_buff) + 1 } and Spell(frost_shock) or Maelstrom() >= 20 and BuffPresent(elemental_focus_buff) and target.Refreshable(flame_shock_debuff) and Spell(flame_shock) or Speed() > 0 and BuffPresent(icefury_buff) and Spell(frost_shock) or Maelstrom() >= 86 and Spell(earth_shock)
	{
		#totem_mastery,if=buff.resonance_totem.remains<10
		if BuffRemaining(resonance_totem_buff) < 10 Spell(totem_mastery)
	}
}

AddFunction ElementalSingleIfCdPostConditions
{
	not target.DebuffPresent(flame_shock_debuff) and Spell(flame_shock) or BuffPresent(echoes_of_the_great_sundering_buff) and Maelstrom() >= 86 and Spell(earthquake) or BuffPresent(icefury_buff) and Maelstrom() >= 86 and Spell(frost_shock) or Maelstrom() >= 92 and Spell(earth_shock) or { 0 < 3 or 600 > 50 } and Spell(stormkeeper) or Spell(elemental_blast) or { 600 < 5 or Maelstrom() <= 76 } and Spell(icefury) or { 0 < 3 or 600 > 50 } and Spell(liquid_magma_totem) or BuffPresent(power_of_the_maelstrom_buff) and BuffPresent(stormkeeper_buff) and Enemies() < 3 and Spell(lightning_bolt) or target.DebuffRemaining(flame_shock_debuff) > CastTime(lava_burst) and not SpellCooldown(lava_burst) > 0 and Spell(lava_burst) or BuffPresent(icefury_buff) and { Maelstrom() >= 20 and 600 > BuffRemaining(icefury_buff) or BuffRemaining(icefury_buff) < 1.5 * { 100 / { 100 + SpellHaste() } } * BuffStacks(icefury_buff) + 1 } and Spell(frost_shock) or Maelstrom() >= 20 and BuffPresent(elemental_focus_buff) and target.Refreshable(flame_shock_debuff) and Spell(flame_shock) or Speed() > 0 and BuffPresent(icefury_buff) and Spell(frost_shock) or Maelstrom() >= 86 and Spell(earth_shock) or BuffPresent(echoes_of_the_great_sundering_buff) and Spell(earthquake) or BuffPresent(power_of_the_maelstrom_buff) and Enemies() < 3 and Spell(lightning_bolt) or Enemies() > 1 and Enemies() > 1 and Spell(chain_lightning) or Spell(lightning_bolt) or Speed() > 0 and target.Refreshable(flame_shock_debuff) and Spell(flame_shock) or Speed() > 0 and Spell(earth_shock) or Speed() > 0 and target.Distance() > 6 and Spell(flame_shock)
}

### actions.single_lr

AddFunction ElementalSingleLrMainActions
{
	#flame_shock,if=!ticking
	if not target.DebuffPresent(flame_shock_debuff) Spell(flame_shock)
	#earthquake,if=buff.echoes_of_the_great_sundering.up&maelstrom>=86
	if BuffPresent(echoes_of_the_great_sundering_buff) and Maelstrom() >= 86 Spell(earthquake)
	#earth_shock,if=maelstrom>=92
	if Maelstrom() >= 92 Spell(earth_shock)
	#elemental_blast
	Spell(elemental_blast)
	#lava_burst,if=dot.flame_shock.remains>cast_time&cooldown_react
	if target.DebuffRemaining(flame_shock_debuff) > CastTime(lava_burst) and not SpellCooldown(lava_burst) > 0 Spell(lava_burst)
	#flame_shock,if=maelstrom>=20&buff.elemental_focus.up,target_if=refreshable
	if Maelstrom() >= 20 and BuffPresent(elemental_focus_buff) and target.Refreshable(flame_shock_debuff) Spell(flame_shock)
	#earth_shock,if=maelstrom>=86
	if Maelstrom() >= 86 Spell(earth_shock)
	#earthquake,if=buff.echoes_of_the_great_sundering.up
	if BuffPresent(echoes_of_the_great_sundering_buff) Spell(earthquake)
	#lightning_bolt,if=buff.power_of_the_maelstrom.up&spell_targets.chain_lightning<3,target_if=debuff.lightning_rod.down
	if BuffPresent(power_of_the_maelstrom_buff) and Enemies() < 3 and target.DebuffExpires(lightning_rod_debuff) Spell(lightning_bolt)
	#lightning_bolt,if=buff.power_of_the_maelstrom.up&spell_targets.chain_lightning<3
	if BuffPresent(power_of_the_maelstrom_buff) and Enemies() < 3 Spell(lightning_bolt)
	#chain_lightning,if=active_enemies>1&spell_targets.chain_lightning>1,target_if=debuff.lightning_rod.down
	if Enemies() > 1 and Enemies() > 1 and target.DebuffExpires(lightning_rod_debuff) Spell(chain_lightning)
	#chain_lightning,if=active_enemies>1&spell_targets.chain_lightning>1
	if Enemies() > 1 and Enemies() > 1 Spell(chain_lightning)
	#lightning_bolt,target_if=debuff.lightning_rod.down
	if target.DebuffExpires(lightning_rod_debuff) Spell(lightning_bolt)
	#lightning_bolt
	Spell(lightning_bolt)
	#flame_shock,moving=1,target_if=refreshable
	if Speed() > 0 and target.Refreshable(flame_shock_debuff) Spell(flame_shock)
	#earth_shock,moving=1
	if Speed() > 0 Spell(earth_shock)
	#flame_shock,moving=1,if=movement.distance>6
	if Speed() > 0 and target.Distance() > 6 Spell(flame_shock)
}

AddFunction ElementalSingleLrMainPostConditions
{
}

AddFunction ElementalSingleLrShortCdActions
{
	unless not target.DebuffPresent(flame_shock_debuff) and Spell(flame_shock) or BuffPresent(echoes_of_the_great_sundering_buff) and Maelstrom() >= 86 and Spell(earthquake) or Maelstrom() >= 92 and Spell(earth_shock)
	{
		#stormkeeper,if=raid_event.adds.count<3|raid_event.adds.in>50
		if 0 < 3 or 600 > 50 Spell(stormkeeper)

		unless Spell(elemental_blast)
		{
			#liquid_magma_totem,if=raid_event.adds.count<3|raid_event.adds.in>50
			if 0 < 3 or 600 > 50 Spell(liquid_magma_totem)
		}
	}
}

AddFunction ElementalSingleLrShortCdPostConditions
{
	not target.DebuffPresent(flame_shock_debuff) and Spell(flame_shock) or BuffPresent(echoes_of_the_great_sundering_buff) and Maelstrom() >= 86 and Spell(earthquake) or Maelstrom() >= 92 and Spell(earth_shock) or Spell(elemental_blast) or target.DebuffRemaining(flame_shock_debuff) > CastTime(lava_burst) and not SpellCooldown(lava_burst) > 0 and Spell(lava_burst) or Maelstrom() >= 20 and BuffPresent(elemental_focus_buff) and target.Refreshable(flame_shock_debuff) and Spell(flame_shock) or Maelstrom() >= 86 and Spell(earth_shock) or BuffPresent(echoes_of_the_great_sundering_buff) and Spell(earthquake) or BuffPresent(power_of_the_maelstrom_buff) and Enemies() < 3 and target.DebuffExpires(lightning_rod_debuff) and Spell(lightning_bolt) or BuffPresent(power_of_the_maelstrom_buff) and Enemies() < 3 and Spell(lightning_bolt) or Enemies() > 1 and Enemies() > 1 and target.DebuffExpires(lightning_rod_debuff) and Spell(chain_lightning) or Enemies() > 1 and Enemies() > 1 and Spell(chain_lightning) or target.DebuffExpires(lightning_rod_debuff) and Spell(lightning_bolt) or Spell(lightning_bolt) or Speed() > 0 and target.Refreshable(flame_shock_debuff) and Spell(flame_shock) or Speed() > 0 and Spell(earth_shock) or Speed() > 0 and target.Distance() > 6 and Spell(flame_shock)
}

AddFunction ElementalSingleLrCdActions
{
	unless not target.DebuffPresent(flame_shock_debuff) and Spell(flame_shock) or BuffPresent(echoes_of_the_great_sundering_buff) and Maelstrom() >= 86 and Spell(earthquake) or Maelstrom() >= 92 and Spell(earth_shock) or { 0 < 3 or 600 > 50 } and Spell(stormkeeper) or Spell(elemental_blast) or { 0 < 3 or 600 > 50 } and Spell(liquid_magma_totem) or target.DebuffRemaining(flame_shock_debuff) > CastTime(lava_burst) and not SpellCooldown(lava_burst) > 0 and Spell(lava_burst) or Maelstrom() >= 20 and BuffPresent(elemental_focus_buff) and target.Refreshable(flame_shock_debuff) and Spell(flame_shock) or Maelstrom() >= 86 and Spell(earth_shock)
	{
		#totem_mastery,if=buff.resonance_totem.remains<10|(buff.resonance_totem.remains<(buff.ascendance.duration+cooldown.ascendance.remains)&cooldown.ascendance.remains<15)
		if BuffRemaining(resonance_totem_buff) < 10 or BuffRemaining(resonance_totem_buff) < BaseDuration(ascendance_caster_buff) + SpellCooldown(ascendance_caster) and SpellCooldown(ascendance_caster) < 15 Spell(totem_mastery)
	}
}

AddFunction ElementalSingleLrCdPostConditions
{
	not target.DebuffPresent(flame_shock_debuff) and Spell(flame_shock) or BuffPresent(echoes_of_the_great_sundering_buff) and Maelstrom() >= 86 and Spell(earthquake) or Maelstrom() >= 92 and Spell(earth_shock) or { 0 < 3 or 600 > 50 } and Spell(stormkeeper) or Spell(elemental_blast) or { 0 < 3 or 600 > 50 } and Spell(liquid_magma_totem) or target.DebuffRemaining(flame_shock_debuff) > CastTime(lava_burst) and not SpellCooldown(lava_burst) > 0 and Spell(lava_burst) or Maelstrom() >= 20 and BuffPresent(elemental_focus_buff) and target.Refreshable(flame_shock_debuff) and Spell(flame_shock) or Maelstrom() >= 86 and Spell(earth_shock) or BuffPresent(echoes_of_the_great_sundering_buff) and Spell(earthquake) or BuffPresent(power_of_the_maelstrom_buff) and Enemies() < 3 and target.DebuffExpires(lightning_rod_debuff) and Spell(lightning_bolt) or BuffPresent(power_of_the_maelstrom_buff) and Enemies() < 3 and Spell(lightning_bolt) or Enemies() > 1 and Enemies() > 1 and target.DebuffExpires(lightning_rod_debuff) and Spell(chain_lightning) or Enemies() > 1 and Enemies() > 1 and Spell(chain_lightning) or target.DebuffExpires(lightning_rod_debuff) and Spell(lightning_bolt) or Spell(lightning_bolt) or Speed() > 0 and target.Refreshable(flame_shock_debuff) and Spell(flame_shock) or Speed() > 0 and Spell(earth_shock) or Speed() > 0 and target.Distance() > 6 and Spell(flame_shock)
}

### Elemental icons.

AddCheckBox(opt_shaman_elemental_aoe L(AOE) default specialization=elemental)

AddIcon checkbox=!opt_shaman_elemental_aoe enemies=1 help=shortcd specialization=elemental
{
	if not InCombat() ElementalPrecombatShortCdActions()
	unless not InCombat() and ElementalPrecombatShortCdPostConditions()
	{
		ElementalDefaultShortCdActions()
	}
}

AddIcon checkbox=opt_shaman_elemental_aoe help=shortcd specialization=elemental
{
	if not InCombat() ElementalPrecombatShortCdActions()
	unless not InCombat() and ElementalPrecombatShortCdPostConditions()
	{
		ElementalDefaultShortCdActions()
	}
}

AddIcon enemies=1 help=main specialization=elemental
{
	if not InCombat() ElementalPrecombatMainActions()
	unless not InCombat() and ElementalPrecombatMainPostConditions()
	{
		ElementalDefaultMainActions()
	}
}

AddIcon checkbox=opt_shaman_elemental_aoe help=aoe specialization=elemental
{
	if not InCombat() ElementalPrecombatMainActions()
	unless not InCombat() and ElementalPrecombatMainPostConditions()
	{
		ElementalDefaultMainActions()
	}
}

AddIcon checkbox=!opt_shaman_elemental_aoe enemies=1 help=cd specialization=elemental
{
	if not InCombat() ElementalPrecombatCdActions()
	unless not InCombat() and ElementalPrecombatCdPostConditions()
	{
		ElementalDefaultCdActions()
	}
}

AddIcon checkbox=opt_shaman_elemental_aoe help=cd specialization=elemental
{
	if not InCombat() ElementalPrecombatCdActions()
	unless not InCombat() and ElementalPrecombatCdPostConditions()
	{
		ElementalDefaultCdActions()
	}
}

### Required symbols
# ascendance_caster
# ascendance_caster_buff
# ascendance_talent
# augmentation
# berserking
# blood_fury_apsp
# bloodlust
# chain_lightning
# earth_shock
# earthquake
# echoes_of_the_great_sundering_buff
# elemental_blast
# elemental_focus_buff
# elemental_mastery
# fire_elemental
# flame_shock
# flame_shock_debuff
# frost_shock
# heroism
# icefury
# icefury_buff
# icefury_talent
# lava_beam
# lava_burst
# lava_surge_buff
# lightning_bolt
# lightning_rod_debuff
# lightning_rod_talent
# liquid_magma_totem
# power_of_the_maelstrom_buff
# resonance_totem_buff
# storm_elemental
# stormkeeper
# stormkeeper_buff
# totem_mastery
]]
	OvaleScripts:RegisterScript("SHAMAN", "elemental", name, desc, code, "script")
end

do
	local name = "simulationcraft_shaman_enhancement_t19p"
	local desc = "[7.0] SimulationCraft: Shaman_Enhancement_T19P"
	local code = [[
# Based on SimulationCraft profile "Shaman_Enhancement_T19P".
#	class=shaman
#	spec=enhancement
#	talents=2002222

Include(ovale_common)
Include(ovale_trinkets_mop)
Include(ovale_trinkets_wod)
Include(ovale_shaman_spells)

AddCheckBox(opt_interrupt L(interrupt) default specialization=enhancement)
AddCheckBox(opt_melee_range L(not_in_melee_range) specialization=enhancement)
AddCheckBox(opt_bloodlust SpellName(bloodlust) specialization=enhancement)

AddFunction EnhancementBloodlust
{
	if CheckBoxOn(opt_bloodlust) and DebuffExpires(burst_haste_debuff any=1)
	{
		Spell(bloodlust)
		Spell(heroism)
	}
}

AddFunction EnhancementGetInMeleeRange
{
	if CheckBoxOn(opt_melee_range) and not target.InRange(stormstrike) Texture(misc_arrowlup help=L(not_in_melee_range))
}

AddFunction EnhancementInterruptActions
{
	if CheckBoxOn(opt_interrupt) and not target.IsFriend() and target.IsInterruptible()
	{
		Spell(wind_shear)
		if not target.Classification(worldboss)
		{
			Spell(arcane_torrent_mana)
			if target.InRange(quaking_palm) Spell(quaking_palm)
			Spell(war_stomp)
		}
	}
}

### actions.default

AddFunction EnhancementDefaultMainActions
{
	#crash_lightning,if=artifact.alpha_wolf.rank&prev_gcd.1.feral_spirit
	if ArtifactTraitRank(alpha_wolf) and PreviousGCDSpell(feral_spirit) Spell(crash_lightning)
	#potion,name=prolonged_power,if=feral_spirit.remains>5|target.time_to_die<=60
	#boulderfist,if=buff.boulderfist.remains<gcd|(maelstrom<=50&active_enemies>=3)
	if BuffRemaining(boulderfist_buff) < GCD() or Maelstrom() <= 50 and Enemies() >= 3 Spell(boulderfist)
	#boulderfist,if=buff.boulderfist.remains<gcd|(charges_fractional>1.75&maelstrom<=100&active_enemies<=2)
	if BuffRemaining(boulderfist_buff) < GCD() or Charges(boulderfist count=0) > 1.75 and Maelstrom() <= 100 and Enemies() <= 2 Spell(boulderfist)
	#rockbiter,if=talent.landslide.enabled&buff.landslide.remains<gcd
	if Talent(landslide_talent) and BuffRemaining(landslide_buff) < GCD() Spell(rockbiter)
	#fury_of_air,if=!ticking&maelstrom>22
	if not target.DebuffPresent(fury_of_air_debuff) and Maelstrom() > 22 Spell(fury_of_air)
	#frostbrand,if=talent.hailstorm.enabled&buff.frostbrand.remains<gcd
	if Talent(hailstorm_talent) and BuffRemaining(frostbrand_buff) < GCD() Spell(frostbrand)
	#flametongue,if=buff.flametongue.remains<gcd|(cooldown.doom_winds.remains<6&buff.flametongue.remains<4)
	if BuffRemaining(flametongue_buff) < GCD() or SpellCooldown(doom_winds) < 6 and BuffRemaining(flametongue_buff) < 4 Spell(flametongue)
	#crash_lightning,if=talent.crashing_storm.enabled&active_enemies>=3&(!talent.hailstorm.enabled|buff.frostbrand.remains>gcd)
	if Talent(crashing_storm_talent) and Enemies() >= 3 and { not Talent(hailstorm_talent) or BuffRemaining(frostbrand_buff) > GCD() } Spell(crash_lightning)
	#earthen_spike
	Spell(earthen_spike)
	#lightning_bolt,if=(talent.overcharge.enabled&maelstrom>=40&!talent.fury_of_air.enabled)|(talent.overcharge.enabled&talent.fury_of_air.enabled&maelstrom>46)
	if Talent(overcharge_talent) and Maelstrom() >= 40 and not Talent(fury_of_air_talent) or Talent(overcharge_talent) and Talent(fury_of_air_talent) and Maelstrom() > 46 Spell(lightning_bolt)
	#crash_lightning,if=buff.crash_lightning.remains<gcd&active_enemies>=2
	if BuffRemaining(crash_lightning_buff) < GCD() and Enemies() >= 2 Spell(crash_lightning)
	#windstrike,if=buff.stormbringer.react&((talent.fury_of_air.enabled&maelstrom>=26)|(!talent.fury_of_air.enabled))
	if BuffPresent(stormbringer_buff) and { Talent(fury_of_air_talent) and Maelstrom() >= 26 or not Talent(fury_of_air_talent) } Spell(windstrike)
	#stormstrike,if=buff.stormbringer.react&((talent.fury_of_air.enabled&maelstrom>=26)|(!talent.fury_of_air.enabled))
	if BuffPresent(stormbringer_buff) and { Talent(fury_of_air_talent) and Maelstrom() >= 26 or not Talent(fury_of_air_talent) } Spell(stormstrike)
	#lava_lash,if=talent.hot_hand.enabled&buff.hot_hand.react
	if Talent(hot_hand_talent) and BuffPresent(hot_hand_buff) Spell(lava_lash)
	#crash_lightning,if=active_enemies>=4
	if Enemies() >= 4 Spell(crash_lightning)
	#windstrike
	Spell(windstrike)
	#stormstrike,if=talent.overcharge.enabled&cooldown.lightning_bolt.remains<gcd&maelstrom>80
	if Talent(overcharge_talent) and SpellCooldown(lightning_bolt) < GCD() and Maelstrom() > 80 Spell(stormstrike)
	#stormstrike,if=talent.fury_of_air.enabled&maelstrom>46&(cooldown.lightning_bolt.remains>gcd|!talent.overcharge.enabled)
	if Talent(fury_of_air_talent) and Maelstrom() > 46 and { SpellCooldown(lightning_bolt) > GCD() or not Talent(overcharge_talent) } Spell(stormstrike)
	#stormstrike,if=!talent.overcharge.enabled&!talent.fury_of_air.enabled
	if not Talent(overcharge_talent) and not Talent(fury_of_air_talent) Spell(stormstrike)
	#crash_lightning,if=((active_enemies>1|talent.crashing_storm.enabled|talent.boulderfist.enabled)&!set_bonus.tier19_4pc)|feral_spirit.remains>5
	if { Enemies() > 1 or Talent(crashing_storm_talent) or Talent(boulderfist_talent) } and not ArmorSetBonus(T19 4) or TotemRemaining(sprit_wolf) > 5 Spell(crash_lightning)
	#frostbrand,if=talent.hailstorm.enabled&buff.frostbrand.remains<4.8
	if Talent(hailstorm_talent) and BuffRemaining(frostbrand_buff) < 4.8 Spell(frostbrand)
	#lava_lash,if=talent.fury_of_air.enabled&talent.overcharge.enabled&(set_bonus.tier19_4pc&maelstrom>=80)
	if Talent(fury_of_air_talent) and Talent(overcharge_talent) and ArmorSetBonus(T19 4) and Maelstrom() >= 80 Spell(lava_lash)
	#lava_lash,if=talent.fury_of_air.enabled&!talent.overcharge.enabled&(set_bonus.tier19_4pc&maelstrom>=53)
	if Talent(fury_of_air_talent) and not Talent(overcharge_talent) and ArmorSetBonus(T19 4) and Maelstrom() >= 53 Spell(lava_lash)
	#lava_lash,if=(!set_bonus.tier19_4pc&maelstrom>=120)|(!talent.fury_of_air.enabled&set_bonus.tier19_4pc&maelstrom>=40)
	if not ArmorSetBonus(T19 4) and Maelstrom() >= 120 or not Talent(fury_of_air_talent) and ArmorSetBonus(T19 4) and Maelstrom() >= 40 Spell(lava_lash)
	#flametongue,if=buff.flametongue.remains<4.8
	if BuffRemaining(flametongue_buff) < 4.8 Spell(flametongue)
	#rockbiter
	Spell(rockbiter)
	#flametongue
	Spell(flametongue)
	#boulderfist
	Spell(boulderfist)
}

AddFunction EnhancementDefaultMainPostConditions
{
}

AddFunction EnhancementDefaultShortCdActions
{
	#auto_attack
	EnhancementGetInMeleeRange()

	unless ArtifactTraitRank(alpha_wolf) and PreviousGCDSpell(feral_spirit) and Spell(crash_lightning) or { BuffRemaining(boulderfist_buff) < GCD() or Maelstrom() <= 50 and Enemies() >= 3 } and Spell(boulderfist) or { BuffRemaining(boulderfist_buff) < GCD() or Charges(boulderfist count=0) > 1.75 and Maelstrom() <= 100 and Enemies() <= 2 } and Spell(boulderfist) or Talent(landslide_talent) and BuffRemaining(landslide_buff) < GCD() and Spell(rockbiter) or not target.DebuffPresent(fury_of_air_debuff) and Maelstrom() > 22 and Spell(fury_of_air) or Talent(hailstorm_talent) and BuffRemaining(frostbrand_buff) < GCD() and Spell(frostbrand) or { BuffRemaining(flametongue_buff) < GCD() or SpellCooldown(doom_winds) < 6 and BuffRemaining(flametongue_buff) < 4 } and Spell(flametongue)
	{
		#doom_winds
		Spell(doom_winds)

		unless Talent(crashing_storm_talent) and Enemies() >= 3 and { not Talent(hailstorm_talent) or BuffRemaining(frostbrand_buff) > GCD() } and Spell(crash_lightning) or Spell(earthen_spike) or { Talent(overcharge_talent) and Maelstrom() >= 40 and not Talent(fury_of_air_talent) or Talent(overcharge_talent) and Talent(fury_of_air_talent) and Maelstrom() > 46 } and Spell(lightning_bolt) or BuffRemaining(crash_lightning_buff) < GCD() and Enemies() >= 2 and Spell(crash_lightning)
		{
			#windsong
			Spell(windsong)

			unless BuffPresent(stormbringer_buff) and { Talent(fury_of_air_talent) and Maelstrom() >= 26 or not Talent(fury_of_air_talent) } and Spell(windstrike) or BuffPresent(stormbringer_buff) and { Talent(fury_of_air_talent) and Maelstrom() >= 26 or not Talent(fury_of_air_talent) } and Spell(stormstrike) or Talent(hot_hand_talent) and BuffPresent(hot_hand_buff) and Spell(lava_lash) or Enemies() >= 4 and Spell(crash_lightning) or Spell(windstrike) or Talent(overcharge_talent) and SpellCooldown(lightning_bolt) < GCD() and Maelstrom() > 80 and Spell(stormstrike) or Talent(fury_of_air_talent) and Maelstrom() > 46 and { SpellCooldown(lightning_bolt) > GCD() or not Talent(overcharge_talent) } and Spell(stormstrike) or not Talent(overcharge_talent) and not Talent(fury_of_air_talent) and Spell(stormstrike) or { { Enemies() > 1 or Talent(crashing_storm_talent) or Talent(boulderfist_talent) } and not ArmorSetBonus(T19 4) or TotemRemaining(sprit_wolf) > 5 } and Spell(crash_lightning) or Talent(hailstorm_talent) and BuffRemaining(frostbrand_buff) < 4.8 and Spell(frostbrand) or Talent(fury_of_air_talent) and Talent(overcharge_talent) and ArmorSetBonus(T19 4) and Maelstrom() >= 80 and Spell(lava_lash) or Talent(fury_of_air_talent) and not Talent(overcharge_talent) and ArmorSetBonus(T19 4) and Maelstrom() >= 53 and Spell(lava_lash) or { not ArmorSetBonus(T19 4) and Maelstrom() >= 120 or not Talent(fury_of_air_talent) and ArmorSetBonus(T19 4) and Maelstrom() >= 40 } and Spell(lava_lash) or BuffRemaining(flametongue_buff) < 4.8 and Spell(flametongue)
			{
				#sundering
				Spell(sundering)
			}
		}
	}
}

AddFunction EnhancementDefaultShortCdPostConditions
{
	ArtifactTraitRank(alpha_wolf) and PreviousGCDSpell(feral_spirit) and Spell(crash_lightning) or { BuffRemaining(boulderfist_buff) < GCD() or Maelstrom() <= 50 and Enemies() >= 3 } and Spell(boulderfist) or { BuffRemaining(boulderfist_buff) < GCD() or Charges(boulderfist count=0) > 1.75 and Maelstrom() <= 100 and Enemies() <= 2 } and Spell(boulderfist) or Talent(landslide_talent) and BuffRemaining(landslide_buff) < GCD() and Spell(rockbiter) or not target.DebuffPresent(fury_of_air_debuff) and Maelstrom() > 22 and Spell(fury_of_air) or Talent(hailstorm_talent) and BuffRemaining(frostbrand_buff) < GCD() and Spell(frostbrand) or { BuffRemaining(flametongue_buff) < GCD() or SpellCooldown(doom_winds) < 6 and BuffRemaining(flametongue_buff) < 4 } and Spell(flametongue) or Talent(crashing_storm_talent) and Enemies() >= 3 and { not Talent(hailstorm_talent) or BuffRemaining(frostbrand_buff) > GCD() } and Spell(crash_lightning) or Spell(earthen_spike) or { Talent(overcharge_talent) and Maelstrom() >= 40 and not Talent(fury_of_air_talent) or Talent(overcharge_talent) and Talent(fury_of_air_talent) and Maelstrom() > 46 } and Spell(lightning_bolt) or BuffRemaining(crash_lightning_buff) < GCD() and Enemies() >= 2 and Spell(crash_lightning) or BuffPresent(stormbringer_buff) and { Talent(fury_of_air_talent) and Maelstrom() >= 26 or not Talent(fury_of_air_talent) } and Spell(windstrike) or BuffPresent(stormbringer_buff) and { Talent(fury_of_air_talent) and Maelstrom() >= 26 or not Talent(fury_of_air_talent) } and Spell(stormstrike) or Talent(hot_hand_talent) and BuffPresent(hot_hand_buff) and Spell(lava_lash) or Enemies() >= 4 and Spell(crash_lightning) or Spell(windstrike) or Talent(overcharge_talent) and SpellCooldown(lightning_bolt) < GCD() and Maelstrom() > 80 and Spell(stormstrike) or Talent(fury_of_air_talent) and Maelstrom() > 46 and { SpellCooldown(lightning_bolt) > GCD() or not Talent(overcharge_talent) } and Spell(stormstrike) or not Talent(overcharge_talent) and not Talent(fury_of_air_talent) and Spell(stormstrike) or { { Enemies() > 1 or Talent(crashing_storm_talent) or Talent(boulderfist_talent) } and not ArmorSetBonus(T19 4) or TotemRemaining(sprit_wolf) > 5 } and Spell(crash_lightning) or Talent(hailstorm_talent) and BuffRemaining(frostbrand_buff) < 4.8 and Spell(frostbrand) or Talent(fury_of_air_talent) and Talent(overcharge_talent) and ArmorSetBonus(T19 4) and Maelstrom() >= 80 and Spell(lava_lash) or Talent(fury_of_air_talent) and not Talent(overcharge_talent) and ArmorSetBonus(T19 4) and Maelstrom() >= 53 and Spell(lava_lash) or { not ArmorSetBonus(T19 4) and Maelstrom() >= 120 or not Talent(fury_of_air_talent) and ArmorSetBonus(T19 4) and Maelstrom() >= 40 } and Spell(lava_lash) or BuffRemaining(flametongue_buff) < 4.8 and Spell(flametongue) or Spell(rockbiter) or Spell(flametongue) or Spell(boulderfist)
}

AddFunction EnhancementDefaultCdActions
{
	#wind_shear
	EnhancementInterruptActions()
	#bloodlust,if=target.health.pct<25|time>0.500
	if target.HealthPercent() < 25 or TimeInCombat() > 0.5 EnhancementBloodlust()
	#feral_spirit,if=!artifact.alpha_wolf.rank|(maelstrom>=20&cooldown.crash_lightning.remains<=gcd)
	if not ArtifactTraitRank(alpha_wolf) or Maelstrom() >= 20 and SpellCooldown(crash_lightning) <= GCD() Spell(feral_spirit)

	unless ArtifactTraitRank(alpha_wolf) and PreviousGCDSpell(feral_spirit) and Spell(crash_lightning)
	{
		#berserking,if=buff.ascendance.up|!talent.ascendance.enabled|level<100
		if BuffPresent(ascendance_melee_buff) or not Talent(ascendance_talent) or Level() < 100 Spell(berserking)
		#blood_fury
		Spell(blood_fury_apsp)

		unless { BuffRemaining(boulderfist_buff) < GCD() or Maelstrom() <= 50 and Enemies() >= 3 } and Spell(boulderfist) or { BuffRemaining(boulderfist_buff) < GCD() or Charges(boulderfist count=0) > 1.75 and Maelstrom() <= 100 and Enemies() <= 2 } and Spell(boulderfist) or Talent(landslide_talent) and BuffRemaining(landslide_buff) < GCD() and Spell(rockbiter) or not target.DebuffPresent(fury_of_air_debuff) and Maelstrom() > 22 and Spell(fury_of_air) or Talent(hailstorm_talent) and BuffRemaining(frostbrand_buff) < GCD() and Spell(frostbrand) or { BuffRemaining(flametongue_buff) < GCD() or SpellCooldown(doom_winds) < 6 and BuffRemaining(flametongue_buff) < 4 } and Spell(flametongue) or Talent(crashing_storm_talent) and Enemies() >= 3 and { not Talent(hailstorm_talent) or BuffRemaining(frostbrand_buff) > GCD() } and Spell(crash_lightning) or Spell(earthen_spike) or { Talent(overcharge_talent) and Maelstrom() >= 40 and not Talent(fury_of_air_talent) or Talent(overcharge_talent) and Talent(fury_of_air_talent) and Maelstrom() > 46 } and Spell(lightning_bolt) or BuffRemaining(crash_lightning_buff) < GCD() and Enemies() >= 2 and Spell(crash_lightning) or Spell(windsong)
		{
			#ascendance,if=buff.stormbringer.react
			if BuffPresent(stormbringer_buff) and BuffExpires(ascendance_melee_buff) Spell(ascendance_melee)
		}
	}
}

AddFunction EnhancementDefaultCdPostConditions
{
	ArtifactTraitRank(alpha_wolf) and PreviousGCDSpell(feral_spirit) and Spell(crash_lightning) or { BuffRemaining(boulderfist_buff) < GCD() or Maelstrom() <= 50 and Enemies() >= 3 } and Spell(boulderfist) or { BuffRemaining(boulderfist_buff) < GCD() or Charges(boulderfist count=0) > 1.75 and Maelstrom() <= 100 and Enemies() <= 2 } and Spell(boulderfist) or Talent(landslide_talent) and BuffRemaining(landslide_buff) < GCD() and Spell(rockbiter) or not target.DebuffPresent(fury_of_air_debuff) and Maelstrom() > 22 and Spell(fury_of_air) or Talent(hailstorm_talent) and BuffRemaining(frostbrand_buff) < GCD() and Spell(frostbrand) or { BuffRemaining(flametongue_buff) < GCD() or SpellCooldown(doom_winds) < 6 and BuffRemaining(flametongue_buff) < 4 } and Spell(flametongue) or Talent(crashing_storm_talent) and Enemies() >= 3 and { not Talent(hailstorm_talent) or BuffRemaining(frostbrand_buff) > GCD() } and Spell(crash_lightning) or Spell(earthen_spike) or { Talent(overcharge_talent) and Maelstrom() >= 40 and not Talent(fury_of_air_talent) or Talent(overcharge_talent) and Talent(fury_of_air_talent) and Maelstrom() > 46 } and Spell(lightning_bolt) or BuffRemaining(crash_lightning_buff) < GCD() and Enemies() >= 2 and Spell(crash_lightning) or Spell(windsong) or BuffPresent(stormbringer_buff) and { Talent(fury_of_air_talent) and Maelstrom() >= 26 or not Talent(fury_of_air_talent) } and Spell(windstrike) or BuffPresent(stormbringer_buff) and { Talent(fury_of_air_talent) and Maelstrom() >= 26 or not Talent(fury_of_air_talent) } and Spell(stormstrike) or Talent(hot_hand_talent) and BuffPresent(hot_hand_buff) and Spell(lava_lash) or Enemies() >= 4 and Spell(crash_lightning) or Spell(windstrike) or Talent(overcharge_talent) and SpellCooldown(lightning_bolt) < GCD() and Maelstrom() > 80 and Spell(stormstrike) or Talent(fury_of_air_talent) and Maelstrom() > 46 and { SpellCooldown(lightning_bolt) > GCD() or not Talent(overcharge_talent) } and Spell(stormstrike) or not Talent(overcharge_talent) and not Talent(fury_of_air_talent) and Spell(stormstrike) or { { Enemies() > 1 or Talent(crashing_storm_talent) or Talent(boulderfist_talent) } and not ArmorSetBonus(T19 4) or TotemRemaining(sprit_wolf) > 5 } and Spell(crash_lightning) or Talent(hailstorm_talent) and BuffRemaining(frostbrand_buff) < 4.8 and Spell(frostbrand) or Talent(fury_of_air_talent) and Talent(overcharge_talent) and ArmorSetBonus(T19 4) and Maelstrom() >= 80 and Spell(lava_lash) or Talent(fury_of_air_talent) and not Talent(overcharge_talent) and ArmorSetBonus(T19 4) and Maelstrom() >= 53 and Spell(lava_lash) or { not ArmorSetBonus(T19 4) and Maelstrom() >= 120 or not Talent(fury_of_air_talent) and ArmorSetBonus(T19 4) and Maelstrom() >= 40 } and Spell(lava_lash) or BuffRemaining(flametongue_buff) < 4.8 and Spell(flametongue) or Spell(sundering) or Spell(rockbiter) or Spell(flametongue) or Spell(boulderfist)
}

### actions.precombat

AddFunction EnhancementPrecombatMainActions
{
	#flask,type=seventh_demon
	#augmentation,type=defiled
	Spell(augmentation)
	#food,name=nightborne_delicacy_platter
	#snapshot_stats
	#potion,name=prolonged_power
	#lightning_shield
	Spell(lightning_shield)
}

AddFunction EnhancementPrecombatMainPostConditions
{
}

AddFunction EnhancementPrecombatShortCdActions
{
}

AddFunction EnhancementPrecombatShortCdPostConditions
{
	Spell(augmentation) or Spell(lightning_shield)
}

AddFunction EnhancementPrecombatCdActions
{
}

AddFunction EnhancementPrecombatCdPostConditions
{
	Spell(augmentation) or Spell(lightning_shield)
}

### Enhancement icons.

AddCheckBox(opt_shaman_enhancement_aoe L(AOE) default specialization=enhancement)

AddIcon checkbox=!opt_shaman_enhancement_aoe enemies=1 help=shortcd specialization=enhancement
{
	if not InCombat() EnhancementPrecombatShortCdActions()
	unless not InCombat() and EnhancementPrecombatShortCdPostConditions()
	{
		EnhancementDefaultShortCdActions()
	}
}

AddIcon checkbox=opt_shaman_enhancement_aoe help=shortcd specialization=enhancement
{
	if not InCombat() EnhancementPrecombatShortCdActions()
	unless not InCombat() and EnhancementPrecombatShortCdPostConditions()
	{
		EnhancementDefaultShortCdActions()
	}
}

AddIcon enemies=1 help=main specialization=enhancement
{
	if not InCombat() EnhancementPrecombatMainActions()
	unless not InCombat() and EnhancementPrecombatMainPostConditions()
	{
		EnhancementDefaultMainActions()
	}
}

AddIcon checkbox=opt_shaman_enhancement_aoe help=aoe specialization=enhancement
{
	if not InCombat() EnhancementPrecombatMainActions()
	unless not InCombat() and EnhancementPrecombatMainPostConditions()
	{
		EnhancementDefaultMainActions()
	}
}

AddIcon checkbox=!opt_shaman_enhancement_aoe enemies=1 help=cd specialization=enhancement
{
	if not InCombat() EnhancementPrecombatCdActions()
	unless not InCombat() and EnhancementPrecombatCdPostConditions()
	{
		EnhancementDefaultCdActions()
	}
}

AddIcon checkbox=opt_shaman_enhancement_aoe help=cd specialization=enhancement
{
	if not InCombat() EnhancementPrecombatCdActions()
	unless not InCombat() and EnhancementPrecombatCdPostConditions()
	{
		EnhancementDefaultCdActions()
	}
}

### Required symbols
# alpha_wolf
# arcane_torrent_mana
# ascendance_melee
# ascendance_melee_buff
# ascendance_talent
# augmentation
# berserking
# blood_fury_apsp
# bloodlust
# boulderfist
# boulderfist_buff
# boulderfist_talent
# crash_lightning
# crash_lightning_buff
# crashing_storm_talent
# doom_winds
# earthen_spike
# feral_spirit
# flametongue
# flametongue_buff
# frostbrand
# frostbrand_buff
# fury_of_air
# fury_of_air_debuff
# fury_of_air_talent
# hailstorm_talent
# heroism
# hot_hand_buff
# hot_hand_talent
# landslide_buff
# landslide_talent
# lava_lash
# lightning_bolt
# lightning_shield
# overcharge_talent
# quaking_palm
# rockbiter
# stormbringer_buff
# stormstrike
# sundering
# war_stomp
# wind_shear
# windsong
# windstrike
]]
	OvaleScripts:RegisterScript("SHAMAN", "enhancement", name, desc, code, "script")
end
