local OVALE, Ovale = ...
local OvaleScripts = Ovale.OvaleScripts

-- THE REST OF THIS FILE IS AUTOMATICALLY GENERATED.
-- ANY CHANGES MADE BELOW THIS POINT WILL BE LOST.

do
	local name = "simulationcraft_warrior_arms_t19p"
	local desc = "[7.0] SimulationCraft: Warrior_Arms_T19P"
	local code = [[
# Based on SimulationCraft profile "Warrior_Arms_T19P".
#	class=warrior
#	spec=arms
#	talents=1332311

Include(ovale_common)
Include(ovale_trinkets_mop)
Include(ovale_trinkets_wod)
Include(ovale_warrior_spells)

AddCheckBox(opt_interrupt L(interrupt) default specialization=arms)
AddCheckBox(opt_melee_range L(not_in_melee_range) specialization=arms)

AddFunction ArmsUseItemActions
{
	Item(Trinket0Slot usable=1)
	Item(Trinket1Slot usable=1)
}

AddFunction ArmsGetInMeleeRange
{
	if CheckBoxOn(opt_melee_range)
	{
		if target.InRange(charge) Spell(charge)
		if target.InRange(charge) Spell(heroic_leap)
		if not target.InRange(pummel) Texture(misc_arrowlup help=L(not_in_melee_range))
	}
}

AddFunction ArmsInterruptActions
{
	if CheckBoxOn(opt_interrupt) and not target.IsFriend() and target.IsInterruptible()
	{
		if target.InRange(pummel) Spell(pummel)
		if not target.Classification(worldboss)
		{
			Spell(arcane_torrent_rage)
			if target.InRange(quaking_palm) Spell(quaking_palm)
			Spell(war_stomp)
		}
	}
}

### actions.default

AddFunction ArmsDefaultMainActions
{
	#battle_cry,if=gcd.remains<0.25&(buff.shattered_defenses.up|cooldown.warbreaker.remains>7&cooldown.colossus_smash.remains>7|cooldown.colossus_smash.remains&debuff.colossus_smash.remains>gcd)|target.time_to_die<=5
	if GCDRemaining() < 0.25 and { BuffPresent(shattered_defenses_buff) or SpellCooldown(warbreaker) > 7 and SpellCooldown(colossus_smash) > 7 or SpellCooldown(colossus_smash) > 0 and target.DebuffRemaining(colossus_smash_debuff) > GCD() } or target.TimeToDie() <= 5 Spell(battle_cry)
	#rend,if=remains<gcd
	if target.DebuffRemaining(rend_debuff) < GCD() Spell(rend)
	#colossus_smash,if=cooldown_react&debuff.colossus_smash.remains<gcd
	if not SpellCooldown(colossus_smash) > 0 and target.DebuffRemaining(colossus_smash_debuff) < GCD() Spell(colossus_smash)
	#overpower,if=buff.overpower.react
	if BuffPresent(overpower_buff) Spell(overpower)
	#run_action_list,name=cleave,if=spell_targets.whirlwind>=2&talent.sweeping_strikes.enabled
	if Enemies() >= 2 and Talent(sweeping_strikes_talent) ArmsCleaveMainActions()

	unless Enemies() >= 2 and Talent(sweeping_strikes_talent) and ArmsCleaveMainPostConditions()
	{
		#run_action_list,name=aoe,if=spell_targets.whirlwind>=5&!talent.sweeping_strikes.enabled
		if Enemies() >= 5 and not Talent(sweeping_strikes_talent) ArmsAoeMainActions()

		unless Enemies() >= 5 and not Talent(sweeping_strikes_talent) and ArmsAoeMainPostConditions()
		{
			#run_action_list,name=execute,target_if=target.health.pct<=20&spell_targets.whirlwind<5
			if target.HealthPercent() <= 20 and Enemies() < 5 ArmsExecuteMainActions()

			unless target.HealthPercent() <= 20 and Enemies() < 5 and ArmsExecuteMainPostConditions()
			{
				#run_action_list,name=single,if=target.health.pct>20
				if target.HealthPercent() > 20 ArmsSingleMainActions()
			}
		}
	}
}

AddFunction ArmsDefaultMainPostConditions
{
	Enemies() >= 2 and Talent(sweeping_strikes_talent) and ArmsCleaveMainPostConditions() or Enemies() >= 5 and not Talent(sweeping_strikes_talent) and ArmsAoeMainPostConditions() or target.HealthPercent() <= 20 and Enemies() < 5 and ArmsExecuteMainPostConditions() or target.HealthPercent() > 20 and ArmsSingleMainPostConditions()
}

AddFunction ArmsDefaultShortCdActions
{
	#charge
	if CheckBoxOn(opt_melee_range) and target.InRange(charge) Spell(charge)
	#auto_attack
	ArmsGetInMeleeRange()

	unless { GCDRemaining() < 0.25 and { BuffPresent(shattered_defenses_buff) or SpellCooldown(warbreaker) > 7 and SpellCooldown(colossus_smash) > 7 or SpellCooldown(colossus_smash) > 0 and target.DebuffRemaining(colossus_smash_debuff) > GCD() } or target.TimeToDie() <= 5 } and Spell(battle_cry)
	{
		#heroic_leap
		if CheckBoxOn(opt_melee_range) and target.InRange(charge) Spell(heroic_leap)

		unless target.DebuffRemaining(rend_debuff) < GCD() and Spell(rend)
		{
			#focused_rage,if=buff.battle_cry_deadly_calm.remains>cooldown.focused_rage.remains&(buff.focused_rage.stack<3|cooldown.mortal_strike.remains)
			if BuffRemaining(battle_cry_deadly_calm_buff) > SpellCooldown(focused_rage) and { BuffStacks(focused_rage_buff) < 3 or SpellCooldown(mortal_strike) > 0 } Spell(focused_rage)

			unless not SpellCooldown(colossus_smash) > 0 and target.DebuffRemaining(colossus_smash_debuff) < GCD() and Spell(colossus_smash)
			{
				#warbreaker,if=debuff.colossus_smash.remains<gcd
				if target.DebuffRemaining(colossus_smash_debuff) < GCD() Spell(warbreaker)
				#ravager
				Spell(ravager)

				unless BuffPresent(overpower_buff) and Spell(overpower)
				{
					#run_action_list,name=cleave,if=spell_targets.whirlwind>=2&talent.sweeping_strikes.enabled
					if Enemies() >= 2 and Talent(sweeping_strikes_talent) ArmsCleaveShortCdActions()

					unless Enemies() >= 2 and Talent(sweeping_strikes_talent) and ArmsCleaveShortCdPostConditions()
					{
						#run_action_list,name=aoe,if=spell_targets.whirlwind>=5&!talent.sweeping_strikes.enabled
						if Enemies() >= 5 and not Talent(sweeping_strikes_talent) ArmsAoeShortCdActions()

						unless Enemies() >= 5 and not Talent(sweeping_strikes_talent) and ArmsAoeShortCdPostConditions()
						{
							#run_action_list,name=execute,target_if=target.health.pct<=20&spell_targets.whirlwind<5
							if target.HealthPercent() <= 20 and Enemies() < 5 ArmsExecuteShortCdActions()

							unless target.HealthPercent() <= 20 and Enemies() < 5 and ArmsExecuteShortCdPostConditions()
							{
								#run_action_list,name=single,if=target.health.pct>20
								if target.HealthPercent() > 20 ArmsSingleShortCdActions()
							}
						}
					}
				}
			}
		}
	}
}

AddFunction ArmsDefaultShortCdPostConditions
{
	{ GCDRemaining() < 0.25 and { BuffPresent(shattered_defenses_buff) or SpellCooldown(warbreaker) > 7 and SpellCooldown(colossus_smash) > 7 or SpellCooldown(colossus_smash) > 0 and target.DebuffRemaining(colossus_smash_debuff) > GCD() } or target.TimeToDie() <= 5 } and Spell(battle_cry) or target.DebuffRemaining(rend_debuff) < GCD() and Spell(rend) or not SpellCooldown(colossus_smash) > 0 and target.DebuffRemaining(colossus_smash_debuff) < GCD() and Spell(colossus_smash) or BuffPresent(overpower_buff) and Spell(overpower) or Enemies() >= 2 and Talent(sweeping_strikes_talent) and ArmsCleaveShortCdPostConditions() or Enemies() >= 5 and not Talent(sweeping_strikes_talent) and ArmsAoeShortCdPostConditions() or target.HealthPercent() <= 20 and Enemies() < 5 and ArmsExecuteShortCdPostConditions() or target.HealthPercent() > 20 and ArmsSingleShortCdPostConditions()
}

AddFunction ArmsDefaultCdActions
{
	#pummel
	ArmsInterruptActions()
	#potion,name=old_war,if=buff.avatar.up&buff.battle_cry.up&debuff.colossus_smash.up|target.time_to_die<=26
	#blood_fury,if=buff.battle_cry.up|target.time_to_die<=16
	if BuffPresent(battle_cry_buff) or target.TimeToDie() <= 16 Spell(blood_fury_ap)
	#berserking,if=buff.battle_cry.up|target.time_to_die<=11
	if BuffPresent(battle_cry_buff) or target.TimeToDie() <= 11 Spell(berserking)
	#arcane_torrent,if=buff.battle_cry_deadly_calm.down&rage.deficit>40
	if BuffExpires(battle_cry_deadly_calm_buff) and RageDeficit() > 40 Spell(arcane_torrent_rage)

	unless { GCDRemaining() < 0.25 and { BuffPresent(shattered_defenses_buff) or SpellCooldown(warbreaker) > 7 and SpellCooldown(colossus_smash) > 7 or SpellCooldown(colossus_smash) > 0 and target.DebuffRemaining(colossus_smash_debuff) > GCD() } or target.TimeToDie() <= 5 } and Spell(battle_cry)
	{
		#avatar,if=gcd.remains<0.25&(buff.battle_cry.up|cooldown.battle_cry.remains<15)|target.time_to_die<=20
		if GCDRemaining() < 0.25 and { BuffPresent(battle_cry_buff) or SpellCooldown(battle_cry) < 15 } or target.TimeToDie() <= 20 Spell(avatar)
		#use_item,name=gift_of_radiance
		ArmsUseItemActions()

		unless target.DebuffRemaining(rend_debuff) < GCD() and Spell(rend) or not SpellCooldown(colossus_smash) > 0 and target.DebuffRemaining(colossus_smash_debuff) < GCD() and Spell(colossus_smash) or target.DebuffRemaining(colossus_smash_debuff) < GCD() and Spell(warbreaker) or Spell(ravager) or BuffPresent(overpower_buff) and Spell(overpower)
		{
			#run_action_list,name=cleave,if=spell_targets.whirlwind>=2&talent.sweeping_strikes.enabled
			if Enemies() >= 2 and Talent(sweeping_strikes_talent) ArmsCleaveCdActions()

			unless Enemies() >= 2 and Talent(sweeping_strikes_talent) and ArmsCleaveCdPostConditions()
			{
				#run_action_list,name=aoe,if=spell_targets.whirlwind>=5&!talent.sweeping_strikes.enabled
				if Enemies() >= 5 and not Talent(sweeping_strikes_talent) ArmsAoeCdActions()

				unless Enemies() >= 5 and not Talent(sweeping_strikes_talent) and ArmsAoeCdPostConditions()
				{
					#run_action_list,name=execute,target_if=target.health.pct<=20&spell_targets.whirlwind<5
					if target.HealthPercent() <= 20 and Enemies() < 5 ArmsExecuteCdActions()

					unless target.HealthPercent() <= 20 and Enemies() < 5 and ArmsExecuteCdPostConditions()
					{
						#run_action_list,name=single,if=target.health.pct>20
						if target.HealthPercent() > 20 ArmsSingleCdActions()
					}
				}
			}
		}
	}
}

AddFunction ArmsDefaultCdPostConditions
{
	{ GCDRemaining() < 0.25 and { BuffPresent(shattered_defenses_buff) or SpellCooldown(warbreaker) > 7 and SpellCooldown(colossus_smash) > 7 or SpellCooldown(colossus_smash) > 0 and target.DebuffRemaining(colossus_smash_debuff) > GCD() } or target.TimeToDie() <= 5 } and Spell(battle_cry) or target.DebuffRemaining(rend_debuff) < GCD() and Spell(rend) or not SpellCooldown(colossus_smash) > 0 and target.DebuffRemaining(colossus_smash_debuff) < GCD() and Spell(colossus_smash) or target.DebuffRemaining(colossus_smash_debuff) < GCD() and Spell(warbreaker) or Spell(ravager) or BuffPresent(overpower_buff) and Spell(overpower) or Enemies() >= 2 and Talent(sweeping_strikes_talent) and ArmsCleaveCdPostConditions() or Enemies() >= 5 and not Talent(sweeping_strikes_talent) and ArmsAoeCdPostConditions() or target.HealthPercent() <= 20 and Enemies() < 5 and ArmsExecuteCdPostConditions() or target.HealthPercent() > 20 and ArmsSingleCdPostConditions()
}

### actions.aoe

AddFunction ArmsAoeMainActions
{
	#mortal_strike,if=cooldown_react
	if not SpellCooldown(mortal_strike) > 0 Spell(mortal_strike)
	#execute,if=buff.stone_heart.react
	if BuffPresent(stone_heart_buff) Spell(execute_arms)
	#colossus_smash,if=cooldown_react&buff.shattered_defenses.down&buff.precise_strikes.down
	if not SpellCooldown(colossus_smash) > 0 and BuffExpires(shattered_defenses_buff) and BuffExpires(precise_strikes_buff) Spell(colossus_smash)
	#whirlwind,if=talent.fervor_of_battle.enabled&(debuff.colossus_smash.up|rage.deficit<50)&(!talent.focused_rage.enabled|buff.battle_cry_deadly_calm.up|buff.cleave.up)
	if Talent(fervor_of_battle_talent) and { target.DebuffPresent(colossus_smash_debuff) or RageDeficit() < 50 } and { not Talent(focused_rage_talent) or BuffPresent(battle_cry_deadly_calm_buff) or BuffPresent(cleave_buff) } Spell(whirlwind)
	#rend,if=remains<=duration*0.3
	if target.DebuffRemaining(rend_debuff) <= BaseDuration(rend_debuff) * 0.3 Spell(rend)
	#cleave
	Spell(cleave)
	#execute,if=rage>90
	if Rage() > 90 Spell(execute_arms)
	#whirlwind,if=rage>=40
	if Rage() >= 40 Spell(whirlwind)
}

AddFunction ArmsAoeMainPostConditions
{
}

AddFunction ArmsAoeShortCdActions
{
	unless not SpellCooldown(mortal_strike) > 0 and Spell(mortal_strike) or BuffPresent(stone_heart_buff) and Spell(execute_arms) or not SpellCooldown(colossus_smash) > 0 and BuffExpires(shattered_defenses_buff) and BuffExpires(precise_strikes_buff) and Spell(colossus_smash)
	{
		#warbreaker,if=buff.shattered_defenses.down
		if BuffExpires(shattered_defenses_buff) Spell(warbreaker)

		unless Talent(fervor_of_battle_talent) and { target.DebuffPresent(colossus_smash_debuff) or RageDeficit() < 50 } and { not Talent(focused_rage_talent) or BuffPresent(battle_cry_deadly_calm_buff) or BuffPresent(cleave_buff) } and Spell(whirlwind) or target.DebuffRemaining(rend_debuff) <= BaseDuration(rend_debuff) * 0.3 and Spell(rend)
		{
			#bladestorm
			Spell(bladestorm)

			unless Spell(cleave) or Rage() > 90 and Spell(execute_arms) or Rage() >= 40 and Spell(whirlwind)
			{
				#shockwave
				Spell(shockwave)
				#storm_bolt
				Spell(storm_bolt)
			}
		}
	}
}

AddFunction ArmsAoeShortCdPostConditions
{
	not SpellCooldown(mortal_strike) > 0 and Spell(mortal_strike) or BuffPresent(stone_heart_buff) and Spell(execute_arms) or not SpellCooldown(colossus_smash) > 0 and BuffExpires(shattered_defenses_buff) and BuffExpires(precise_strikes_buff) and Spell(colossus_smash) or Talent(fervor_of_battle_talent) and { target.DebuffPresent(colossus_smash_debuff) or RageDeficit() < 50 } and { not Talent(focused_rage_talent) or BuffPresent(battle_cry_deadly_calm_buff) or BuffPresent(cleave_buff) } and Spell(whirlwind) or target.DebuffRemaining(rend_debuff) <= BaseDuration(rend_debuff) * 0.3 and Spell(rend) or Spell(cleave) or Rage() > 90 and Spell(execute_arms) or Rage() >= 40 and Spell(whirlwind)
}

AddFunction ArmsAoeCdActions
{
}

AddFunction ArmsAoeCdPostConditions
{
	not SpellCooldown(mortal_strike) > 0 and Spell(mortal_strike) or BuffPresent(stone_heart_buff) and Spell(execute_arms) or not SpellCooldown(colossus_smash) > 0 and BuffExpires(shattered_defenses_buff) and BuffExpires(precise_strikes_buff) and Spell(colossus_smash) or BuffExpires(shattered_defenses_buff) and Spell(warbreaker) or Talent(fervor_of_battle_talent) and { target.DebuffPresent(colossus_smash_debuff) or RageDeficit() < 50 } and { not Talent(focused_rage_talent) or BuffPresent(battle_cry_deadly_calm_buff) or BuffPresent(cleave_buff) } and Spell(whirlwind) or target.DebuffRemaining(rend_debuff) <= BaseDuration(rend_debuff) * 0.3 and Spell(rend) or Spell(bladestorm) or Spell(cleave) or Rage() > 90 and Spell(execute_arms) or Rage() >= 40 and Spell(whirlwind) or Spell(shockwave) or Spell(storm_bolt)
}

### actions.cleave

AddFunction ArmsCleaveMainActions
{
	#mortal_strike
	Spell(mortal_strike)
	#execute,if=buff.stone_heart.react
	if BuffPresent(stone_heart_buff) Spell(execute_arms)
	#colossus_smash,if=buff.shattered_defenses.down&buff.precise_strikes.down
	if BuffExpires(shattered_defenses_buff) and BuffExpires(precise_strikes_buff) Spell(colossus_smash)
	#whirlwind,if=talent.fervor_of_battle.enabled&(debuff.colossus_smash.up|rage.deficit<50)&(!talent.focused_rage.enabled|buff.battle_cry_deadly_calm.up|buff.cleave.up)
	if Talent(fervor_of_battle_talent) and { target.DebuffPresent(colossus_smash_debuff) or RageDeficit() < 50 } and { not Talent(focused_rage_talent) or BuffPresent(battle_cry_deadly_calm_buff) or BuffPresent(cleave_buff) } Spell(whirlwind)
	#rend,if=remains<=duration*0.3
	if target.DebuffRemaining(rend_debuff) <= BaseDuration(rend_debuff) * 0.3 Spell(rend)
	#cleave
	Spell(cleave)
	#whirlwind,if=rage>40|buff.cleave.up
	if Rage() > 40 or BuffPresent(cleave_buff) Spell(whirlwind)
}

AddFunction ArmsCleaveMainPostConditions
{
}

AddFunction ArmsCleaveShortCdActions
{
	unless Spell(mortal_strike) or BuffPresent(stone_heart_buff) and Spell(execute_arms) or BuffExpires(shattered_defenses_buff) and BuffExpires(precise_strikes_buff) and Spell(colossus_smash)
	{
		#warbreaker,if=buff.shattered_defenses.down
		if BuffExpires(shattered_defenses_buff) Spell(warbreaker)
		#focused_rage,if=rage>100|buff.battle_cry_deadly_calm.up
		if Rage() > 100 or BuffPresent(battle_cry_deadly_calm_buff) Spell(focused_rage)

		unless Talent(fervor_of_battle_talent) and { target.DebuffPresent(colossus_smash_debuff) or RageDeficit() < 50 } and { not Talent(focused_rage_talent) or BuffPresent(battle_cry_deadly_calm_buff) or BuffPresent(cleave_buff) } and Spell(whirlwind) or target.DebuffRemaining(rend_debuff) <= BaseDuration(rend_debuff) * 0.3 and Spell(rend)
		{
			#bladestorm
			Spell(bladestorm)

			unless Spell(cleave) or { Rage() > 40 or BuffPresent(cleave_buff) } and Spell(whirlwind)
			{
				#shockwave
				Spell(shockwave)
				#storm_bolt
				Spell(storm_bolt)
			}
		}
	}
}

AddFunction ArmsCleaveShortCdPostConditions
{
	Spell(mortal_strike) or BuffPresent(stone_heart_buff) and Spell(execute_arms) or BuffExpires(shattered_defenses_buff) and BuffExpires(precise_strikes_buff) and Spell(colossus_smash) or Talent(fervor_of_battle_talent) and { target.DebuffPresent(colossus_smash_debuff) or RageDeficit() < 50 } and { not Talent(focused_rage_talent) or BuffPresent(battle_cry_deadly_calm_buff) or BuffPresent(cleave_buff) } and Spell(whirlwind) or target.DebuffRemaining(rend_debuff) <= BaseDuration(rend_debuff) * 0.3 and Spell(rend) or Spell(cleave) or { Rage() > 40 or BuffPresent(cleave_buff) } and Spell(whirlwind)
}

AddFunction ArmsCleaveCdActions
{
}

AddFunction ArmsCleaveCdPostConditions
{
	Spell(mortal_strike) or BuffPresent(stone_heart_buff) and Spell(execute_arms) or BuffExpires(shattered_defenses_buff) and BuffExpires(precise_strikes_buff) and Spell(colossus_smash) or BuffExpires(shattered_defenses_buff) and Spell(warbreaker) or Talent(fervor_of_battle_talent) and { target.DebuffPresent(colossus_smash_debuff) or RageDeficit() < 50 } and { not Talent(focused_rage_talent) or BuffPresent(battle_cry_deadly_calm_buff) or BuffPresent(cleave_buff) } and Spell(whirlwind) or target.DebuffRemaining(rend_debuff) <= BaseDuration(rend_debuff) * 0.3 and Spell(rend) or Spell(bladestorm) or Spell(cleave) or { Rage() > 40 or BuffPresent(cleave_buff) } and Spell(whirlwind) or Spell(shockwave) or Spell(storm_bolt)
}

### actions.execute

AddFunction ArmsExecuteMainActions
{
	#mortal_strike,if=cooldown_react&buff.battle_cry.up&buff.focused_rage.stack=3
	if not SpellCooldown(mortal_strike) > 0 and BuffPresent(battle_cry_buff) and BuffStacks(focused_rage_buff) == 3 Spell(mortal_strike)
	#execute,if=buff.battle_cry_deadly_calm.up
	if BuffPresent(battle_cry_deadly_calm_buff) Spell(execute_arms)
	#colossus_smash,if=cooldown_react&buff.shattered_defenses.down
	if not SpellCooldown(colossus_smash) > 0 and BuffExpires(shattered_defenses_buff) Spell(colossus_smash)
	#execute,if=buff.shattered_defenses.up&(rage>=17.6|buff.stone_heart.react)
	if BuffPresent(shattered_defenses_buff) and { Rage() >= 17.6 or BuffPresent(stone_heart_buff) } Spell(execute_arms)
	#mortal_strike,if=cooldown_react&equipped.archavons_heavy_hand&rage<60
	if not SpellCooldown(mortal_strike) > 0 and HasEquippedItem(archavons_heavy_hand) and Rage() < 60 Spell(mortal_strike)
	#execute,if=buff.shattered_defenses.down
	if BuffExpires(shattered_defenses_buff) Spell(execute_arms)
}

AddFunction ArmsExecuteMainPostConditions
{
}

AddFunction ArmsExecuteShortCdActions
{
	unless not SpellCooldown(mortal_strike) > 0 and BuffPresent(battle_cry_buff) and BuffStacks(focused_rage_buff) == 3 and Spell(mortal_strike) or BuffPresent(battle_cry_deadly_calm_buff) and Spell(execute_arms) or not SpellCooldown(colossus_smash) > 0 and BuffExpires(shattered_defenses_buff) and Spell(colossus_smash) or BuffPresent(shattered_defenses_buff) and { Rage() >= 17.6 or BuffPresent(stone_heart_buff) } and Spell(execute_arms) or not SpellCooldown(mortal_strike) > 0 and HasEquippedItem(archavons_heavy_hand) and Rage() < 60 and Spell(mortal_strike) or BuffExpires(shattered_defenses_buff) and Spell(execute_arms)
	{
		#bladestorm,interrupt=1,if=raid_event.adds.in>90|!raid_event.adds.exists|spell_targets.bladestorm_mh>desired_targets
		if 600 > 90 or not False(raid_event_adds_exists) or Enemies() > Enemies(tagged=1) Spell(bladestorm)
	}
}

AddFunction ArmsExecuteShortCdPostConditions
{
	not SpellCooldown(mortal_strike) > 0 and BuffPresent(battle_cry_buff) and BuffStacks(focused_rage_buff) == 3 and Spell(mortal_strike) or BuffPresent(battle_cry_deadly_calm_buff) and Spell(execute_arms) or not SpellCooldown(colossus_smash) > 0 and BuffExpires(shattered_defenses_buff) and Spell(colossus_smash) or BuffPresent(shattered_defenses_buff) and { Rage() >= 17.6 or BuffPresent(stone_heart_buff) } and Spell(execute_arms) or not SpellCooldown(mortal_strike) > 0 and HasEquippedItem(archavons_heavy_hand) and Rage() < 60 and Spell(mortal_strike) or BuffExpires(shattered_defenses_buff) and Spell(execute_arms)
}

AddFunction ArmsExecuteCdActions
{
}

AddFunction ArmsExecuteCdPostConditions
{
	not SpellCooldown(mortal_strike) > 0 and BuffPresent(battle_cry_buff) and BuffStacks(focused_rage_buff) == 3 and Spell(mortal_strike) or BuffPresent(battle_cry_deadly_calm_buff) and Spell(execute_arms) or not SpellCooldown(colossus_smash) > 0 and BuffExpires(shattered_defenses_buff) and Spell(colossus_smash) or BuffPresent(shattered_defenses_buff) and { Rage() >= 17.6 or BuffPresent(stone_heart_buff) } and Spell(execute_arms) or not SpellCooldown(mortal_strike) > 0 and HasEquippedItem(archavons_heavy_hand) and Rage() < 60 and Spell(mortal_strike) or BuffExpires(shattered_defenses_buff) and Spell(execute_arms) or { 600 > 90 or not False(raid_event_adds_exists) or Enemies() > Enemies(tagged=1) } and Spell(bladestorm)
}

### actions.precombat

AddFunction ArmsPrecombatMainActions
{
	#flask,type=countless_armies
	#food,type=fishbrul_special
	#augmentation,type=defiled
	Spell(augmentation)
}

AddFunction ArmsPrecombatMainPostConditions
{
}

AddFunction ArmsPrecombatShortCdActions
{
}

AddFunction ArmsPrecombatShortCdPostConditions
{
	Spell(augmentation)
}

AddFunction ArmsPrecombatCdActions
{
}

AddFunction ArmsPrecombatCdPostConditions
{
	Spell(augmentation)
}

### actions.single

AddFunction ArmsSingleMainActions
{
	#colossus_smash,if=cooldown_react&buff.shattered_defenses.down&(buff.battle_cry.down|buff.battle_cry.up&buff.battle_cry.remains>=gcd)
	if not SpellCooldown(colossus_smash) > 0 and BuffExpires(shattered_defenses_buff) and { BuffExpires(battle_cry_buff) or BuffPresent(battle_cry_buff) and BuffRemaining(battle_cry_buff) >= GCD() } Spell(colossus_smash)
	#mortal_strike,if=cooldown_react&cooldown.battle_cry.remains>8
	if not SpellCooldown(mortal_strike) > 0 and SpellCooldown(battle_cry) > 8 Spell(mortal_strike)
	#execute,if=buff.stone_heart.react
	if BuffPresent(stone_heart_buff) Spell(execute_arms)
	#whirlwind,if=spell_targets.whirlwind>1
	if Enemies() > 1 Spell(whirlwind)
	#slam,if=spell_targets.whirlwind=1
	if Enemies() == 1 Spell(slam)
}

AddFunction ArmsSingleMainPostConditions
{
}

AddFunction ArmsSingleShortCdActions
{
	unless not SpellCooldown(colossus_smash) > 0 and BuffExpires(shattered_defenses_buff) and { BuffExpires(battle_cry_buff) or BuffPresent(battle_cry_buff) and BuffRemaining(battle_cry_buff) >= GCD() } and Spell(colossus_smash)
	{
		#focused_rage,if=!buff.battle_cry_deadly_calm.up&buff.focused_rage.stack<3&!cooldown.colossus_smash.up&(rage>=50|debuff.colossus_smash.down|cooldown.battle_cry.remains<=8)
		if not BuffPresent(battle_cry_deadly_calm_buff) and BuffStacks(focused_rage_buff) < 3 and not { not SpellCooldown(colossus_smash) > 0 } and { Rage() >= 50 or target.DebuffExpires(colossus_smash_debuff) or SpellCooldown(battle_cry) <= 8 } Spell(focused_rage)

		unless not SpellCooldown(mortal_strike) > 0 and SpellCooldown(battle_cry) > 8 and Spell(mortal_strike) or BuffPresent(stone_heart_buff) and Spell(execute_arms) or Enemies() > 1 and Spell(whirlwind) or Enemies() == 1 and Spell(slam)
		{
			#focused_rage,if=equipped.archavons_heavy_hand&buff.focused_rage.stack<3
			if HasEquippedItem(archavons_heavy_hand) and BuffStacks(focused_rage_buff) < 3 Spell(focused_rage)
			#bladestorm,interrupt=1,if=raid_event.adds.in>90|!raid_event.adds.exists|spell_targets.bladestorm_mh>desired_targets
			if 600 > 90 or not False(raid_event_adds_exists) or Enemies() > Enemies(tagged=1) Spell(bladestorm)
		}
	}
}

AddFunction ArmsSingleShortCdPostConditions
{
	not SpellCooldown(colossus_smash) > 0 and BuffExpires(shattered_defenses_buff) and { BuffExpires(battle_cry_buff) or BuffPresent(battle_cry_buff) and BuffRemaining(battle_cry_buff) >= GCD() } and Spell(colossus_smash) or not SpellCooldown(mortal_strike) > 0 and SpellCooldown(battle_cry) > 8 and Spell(mortal_strike) or BuffPresent(stone_heart_buff) and Spell(execute_arms) or Enemies() > 1 and Spell(whirlwind) or Enemies() == 1 and Spell(slam)
}

AddFunction ArmsSingleCdActions
{
}

AddFunction ArmsSingleCdPostConditions
{
	not SpellCooldown(colossus_smash) > 0 and BuffExpires(shattered_defenses_buff) and { BuffExpires(battle_cry_buff) or BuffPresent(battle_cry_buff) and BuffRemaining(battle_cry_buff) >= GCD() } and Spell(colossus_smash) or not SpellCooldown(mortal_strike) > 0 and SpellCooldown(battle_cry) > 8 and Spell(mortal_strike) or BuffPresent(stone_heart_buff) and Spell(execute_arms) or Enemies() > 1 and Spell(whirlwind) or Enemies() == 1 and Spell(slam) or { 600 > 90 or not False(raid_event_adds_exists) or Enemies() > Enemies(tagged=1) } and Spell(bladestorm)
}

### Arms icons.

AddCheckBox(opt_warrior_arms_aoe L(AOE) default specialization=arms)

AddIcon checkbox=!opt_warrior_arms_aoe enemies=1 help=shortcd specialization=arms
{
	if not InCombat() ArmsPrecombatShortCdActions()
	unless not InCombat() and ArmsPrecombatShortCdPostConditions()
	{
		ArmsDefaultShortCdActions()
	}
}

AddIcon checkbox=opt_warrior_arms_aoe help=shortcd specialization=arms
{
	if not InCombat() ArmsPrecombatShortCdActions()
	unless not InCombat() and ArmsPrecombatShortCdPostConditions()
	{
		ArmsDefaultShortCdActions()
	}
}

AddIcon enemies=1 help=main specialization=arms
{
	if not InCombat() ArmsPrecombatMainActions()
	unless not InCombat() and ArmsPrecombatMainPostConditions()
	{
		ArmsDefaultMainActions()
	}
}

AddIcon checkbox=opt_warrior_arms_aoe help=aoe specialization=arms
{
	if not InCombat() ArmsPrecombatMainActions()
	unless not InCombat() and ArmsPrecombatMainPostConditions()
	{
		ArmsDefaultMainActions()
	}
}

AddIcon checkbox=!opt_warrior_arms_aoe enemies=1 help=cd specialization=arms
{
	if not InCombat() ArmsPrecombatCdActions()
	unless not InCombat() and ArmsPrecombatCdPostConditions()
	{
		ArmsDefaultCdActions()
	}
}

AddIcon checkbox=opt_warrior_arms_aoe help=cd specialization=arms
{
	if not InCombat() ArmsPrecombatCdActions()
	unless not InCombat() and ArmsPrecombatCdPostConditions()
	{
		ArmsDefaultCdActions()
	}
}

### Required symbols
# arcane_torrent_rage
# archavons_heavy_hand
# augmentation
# avatar
# battle_cry
# battle_cry_buff
# battle_cry_deadly_calm_buff
# berserking
# bladestorm
# blood_fury_ap
# charge
# cleave
# cleave_buff
# colossus_smash
# colossus_smash_debuff
# execute_arms
# fervor_of_battle_talent
# focused_rage
# focused_rage_buff
# focused_rage_talent
# heroic_leap
# heroic_throw
# mortal_strike
# overpower
# overpower_buff
# precise_strikes_buff
# pummel
# quaking_palm
# ravager
# rend
# rend_debuff
# shattered_defenses_buff
# shockwave
# slam
# stone_heart_buff
# storm_bolt
# sweeping_strikes_talent
# war_stomp
# warbreaker
# whirlwind
]]
	OvaleScripts:RegisterScript("WARRIOR", "arms", name, desc, code, "script")
end

do
	local name = "simulationcraft_warrior_fury_t19p"
	local desc = "[7.0] SimulationCraft: Warrior_Fury_T19P"
	local code = [[
# Based on SimulationCraft profile "Warrior_Fury_T19P".
#	class=warrior
#	spec=fury
#	talents=2232133

Include(ovale_common)
Include(ovale_trinkets_mop)
Include(ovale_trinkets_wod)
Include(ovale_warrior_spells)

AddCheckBox(opt_interrupt L(interrupt) default specialization=fury)
AddCheckBox(opt_melee_range L(not_in_melee_range) specialization=fury)

AddFunction FuryUseItemActions
{
	Item(Trinket0Slot usable=1)
	Item(Trinket1Slot usable=1)
}

AddFunction FuryGetInMeleeRange
{
	if CheckBoxOn(opt_melee_range)
	{
		if target.InRange(charge) Spell(charge)
		if target.InRange(charge) Spell(heroic_leap)
		if not target.InRange(pummel) Texture(misc_arrowlup help=L(not_in_melee_range))
	}
}

AddFunction FuryInterruptActions
{
	if CheckBoxOn(opt_interrupt) and not target.IsFriend() and target.IsInterruptible()
	{
		if target.InRange(pummel) Spell(pummel)
		if not target.Classification(worldboss)
		{
			Spell(arcane_torrent_rage)
			if target.InRange(quaking_palm) Spell(quaking_palm)
			Spell(war_stomp)
		}
	}
}

### actions.default

AddFunction FuryDefaultMainActions
{
	#run_action_list,name=movement,if=movement.distance>5
	if target.Distance() > 5 FuryMovementMainActions()

	unless target.Distance() > 5 and FuryMovementMainPostConditions()
	{
		#potion,name=old_war,if=(target.health.pct<20&buff.battle_cry.up)|target.time_to_die<30
		#battle_cry,if=(cooldown.odyns_fury.remains=0&(cooldown.bloodthirst.remains=0|(buff.enrage.remains>cooldown.bloodthirst.remains)))
		if not SpellCooldown(odyns_fury) > 0 and { not SpellCooldown(bloodthirst) > 0 or EnrageRemaining() > SpellCooldown(bloodthirst) } Spell(battle_cry)
		#call_action_list,name=two_targets,if=spell_targets.whirlwind=2|spell_targets.whirlwind=3
		if Enemies() == 2 or Enemies() == 3 FuryTwoTargetsMainActions()

		unless { Enemies() == 2 or Enemies() == 3 } and FuryTwoTargetsMainPostConditions()
		{
			#call_action_list,name=aoe,if=spell_targets.whirlwind>3
			if Enemies() > 3 FuryAoeMainActions()

			unless Enemies() > 3 and FuryAoeMainPostConditions()
			{
				#call_action_list,name=single_target
				FurySingleTargetMainActions()
			}
		}
	}
}

AddFunction FuryDefaultMainPostConditions
{
	target.Distance() > 5 and FuryMovementMainPostConditions() or { Enemies() == 2 or Enemies() == 3 } and FuryTwoTargetsMainPostConditions() or Enemies() > 3 and FuryAoeMainPostConditions() or FurySingleTargetMainPostConditions()
}

AddFunction FuryDefaultShortCdActions
{
	#auto_attack
	FuryGetInMeleeRange()
	#charge
	if CheckBoxOn(opt_melee_range) and target.InRange(charge) Spell(charge)
	#run_action_list,name=movement,if=movement.distance>5
	if target.Distance() > 5 FuryMovementShortCdActions()

	unless target.Distance() > 5 and FuryMovementShortCdPostConditions()
	{
		#heroic_leap,if=(raid_event.movement.distance>25&raid_event.movement.in>45)|!raid_event.movement.exists
		if { target.Distance() > 25 and 600 > 45 or not False(raid_event_movement_exists) } and CheckBoxOn(opt_melee_range) and target.InRange(charge) Spell(heroic_leap)

		unless not SpellCooldown(odyns_fury) > 0 and { not SpellCooldown(bloodthirst) > 0 or EnrageRemaining() > SpellCooldown(bloodthirst) } and Spell(battle_cry)
		{
			#bloodbath,if=buff.dragon_roar.up|(!talent.dragon_roar.enabled&(buff.battle_cry.up|cooldown.battle_cry.remains>10))
			if BuffPresent(dragon_roar_buff) or not Talent(dragon_roar_talent) and { BuffPresent(battle_cry_buff) or SpellCooldown(battle_cry) > 10 } Spell(bloodbath)
			#call_action_list,name=two_targets,if=spell_targets.whirlwind=2|spell_targets.whirlwind=3
			if Enemies() == 2 or Enemies() == 3 FuryTwoTargetsShortCdActions()

			unless { Enemies() == 2 or Enemies() == 3 } and FuryTwoTargetsShortCdPostConditions()
			{
				#call_action_list,name=aoe,if=spell_targets.whirlwind>3
				if Enemies() > 3 FuryAoeShortCdActions()

				unless Enemies() > 3 and FuryAoeShortCdPostConditions()
				{
					#call_action_list,name=single_target
					FurySingleTargetShortCdActions()
				}
			}
		}
	}
}

AddFunction FuryDefaultShortCdPostConditions
{
	target.Distance() > 5 and FuryMovementShortCdPostConditions() or not SpellCooldown(odyns_fury) > 0 and { not SpellCooldown(bloodthirst) > 0 or EnrageRemaining() > SpellCooldown(bloodthirst) } and Spell(battle_cry) or { Enemies() == 2 or Enemies() == 3 } and FuryTwoTargetsShortCdPostConditions() or Enemies() > 3 and FuryAoeShortCdPostConditions() or FurySingleTargetShortCdPostConditions()
}

AddFunction FuryDefaultCdActions
{
	#pummel
	FuryInterruptActions()
	#run_action_list,name=movement,if=movement.distance>5
	if target.Distance() > 5 FuryMovementCdActions()

	unless target.Distance() > 5 and FuryMovementCdPostConditions()
	{
		#use_item,name=faulty_countermeasure,if=(spell_targets.whirlwind>1|!raid_event.adds.exists)&((talent.bladestorm.enabled&cooldown.bladestorm.remains=0)|buff.battle_cry.up|target.time_to_die<25)
		if { Enemies() > 1 or not False(raid_event_adds_exists) } and { Talent(bladestorm_talent) and not SpellCooldown(bladestorm) > 0 or BuffPresent(battle_cry_buff) or target.TimeToDie() < 25 } FuryUseItemActions()

		unless not SpellCooldown(odyns_fury) > 0 and { not SpellCooldown(bloodthirst) > 0 or EnrageRemaining() > SpellCooldown(bloodthirst) } and Spell(battle_cry)
		{
			#avatar,if=buff.battle_cry.up|(target.time_to_die<(cooldown.battle_cry.remains+10))
			if BuffPresent(battle_cry_buff) or target.TimeToDie() < SpellCooldown(battle_cry) + 10 Spell(avatar)
			#blood_fury,if=buff.battle_cry.up
			if BuffPresent(battle_cry_buff) Spell(blood_fury_ap)
			#berserking,if=buff.battle_cry.up
			if BuffPresent(battle_cry_buff) Spell(berserking)
			#arcane_torrent,if=rage<rage.max-40
			if Rage() < MaxRage() - 40 Spell(arcane_torrent_rage)
			#call_action_list,name=two_targets,if=spell_targets.whirlwind=2|spell_targets.whirlwind=3
			if Enemies() == 2 or Enemies() == 3 FuryTwoTargetsCdActions()

			unless { Enemies() == 2 or Enemies() == 3 } and FuryTwoTargetsCdPostConditions()
			{
				#call_action_list,name=aoe,if=spell_targets.whirlwind>3
				if Enemies() > 3 FuryAoeCdActions()

				unless Enemies() > 3 and FuryAoeCdPostConditions()
				{
					#call_action_list,name=single_target
					FurySingleTargetCdActions()
				}
			}
		}
	}
}

AddFunction FuryDefaultCdPostConditions
{
	target.Distance() > 5 and FuryMovementCdPostConditions() or not SpellCooldown(odyns_fury) > 0 and { not SpellCooldown(bloodthirst) > 0 or EnrageRemaining() > SpellCooldown(bloodthirst) } and Spell(battle_cry) or { Enemies() == 2 or Enemies() == 3 } and FuryTwoTargetsCdPostConditions() or Enemies() > 3 and FuryAoeCdPostConditions() or FurySingleTargetCdPostConditions()
}

### actions.aoe

AddFunction FuryAoeMainActions
{
	#bloodthirst,if=buff.enrage.down|rage<50
	if not IsEnraged() or Rage() < 50 Spell(bloodthirst)
	#call_action_list,name=bladestorm
	FuryBladestormMainActions()

	unless FuryBladestormMainPostConditions()
	{
		#whirlwind,if=buff.enrage.up
		if IsEnraged() Spell(whirlwind)
		#dragon_roar
		Spell(dragon_roar)
		#rampage,if=buff.meat_cleaver.up
		if BuffPresent(meat_cleaver_buff) Spell(rampage)
		#bloodthirst
		Spell(bloodthirst)
		#whirlwind
		Spell(whirlwind)
	}
}

AddFunction FuryAoeMainPostConditions
{
	FuryBladestormMainPostConditions()
}

AddFunction FuryAoeShortCdActions
{
	unless { not IsEnraged() or Rage() < 50 } and Spell(bloodthirst)
	{
		#call_action_list,name=bladestorm
		FuryBladestormShortCdActions()

		unless FuryBladestormShortCdPostConditions()
		{
			#odyns_fury,if=buff.battle_cry.up&buff.enrage.up
			if BuffPresent(battle_cry_buff) and IsEnraged() Spell(odyns_fury)
		}
	}
}

AddFunction FuryAoeShortCdPostConditions
{
	{ not IsEnraged() or Rage() < 50 } and Spell(bloodthirst) or FuryBladestormShortCdPostConditions() or IsEnraged() and Spell(whirlwind) or Spell(dragon_roar) or BuffPresent(meat_cleaver_buff) and Spell(rampage) or Spell(bloodthirst) or Spell(whirlwind)
}

AddFunction FuryAoeCdActions
{
	unless { not IsEnraged() or Rage() < 50 } and Spell(bloodthirst)
	{
		#call_action_list,name=bladestorm
		FuryBladestormCdActions()
	}
}

AddFunction FuryAoeCdPostConditions
{
	{ not IsEnraged() or Rage() < 50 } and Spell(bloodthirst) or FuryBladestormCdPostConditions() or BuffPresent(battle_cry_buff) and IsEnraged() and Spell(odyns_fury) or IsEnraged() and Spell(whirlwind) or Spell(dragon_roar) or BuffPresent(meat_cleaver_buff) and Spell(rampage) or Spell(bloodthirst) or Spell(whirlwind)
}

### actions.bladestorm

AddFunction FuryBladestormMainActions
{
}

AddFunction FuryBladestormMainPostConditions
{
}

AddFunction FuryBladestormShortCdActions
{
	#bladestorm,if=buff.enrage.remains>2&(raid_event.adds.in>90|!raid_event.adds.exists|spell_targets.bladestorm_mh>desired_targets)
	if EnrageRemaining() > 2 and { 600 > 90 or not False(raid_event_adds_exists) or Enemies() > Enemies(tagged=1) } Spell(bladestorm)
}

AddFunction FuryBladestormShortCdPostConditions
{
}

AddFunction FuryBladestormCdActions
{
}

AddFunction FuryBladestormCdPostConditions
{
	EnrageRemaining() > 2 and { 600 > 90 or not False(raid_event_adds_exists) or Enemies() > Enemies(tagged=1) } and Spell(bladestorm)
}

### actions.movement

AddFunction FuryMovementMainActions
{
}

AddFunction FuryMovementMainPostConditions
{
}

AddFunction FuryMovementShortCdActions
{
	#heroic_leap
	if CheckBoxOn(opt_melee_range) and target.InRange(charge) Spell(heroic_leap)
}

AddFunction FuryMovementShortCdPostConditions
{
}

AddFunction FuryMovementCdActions
{
}

AddFunction FuryMovementCdPostConditions
{
}

### actions.precombat

AddFunction FuryPrecombatMainActions
{
	#flask,type=countless_armies
	#food,type=nightborne_delicacy_platter
	#augmentation,type=defiled
	Spell(augmentation)
}

AddFunction FuryPrecombatMainPostConditions
{
}

AddFunction FuryPrecombatShortCdActions
{
}

AddFunction FuryPrecombatShortCdPostConditions
{
	Spell(augmentation)
}

AddFunction FuryPrecombatCdActions
{
}

AddFunction FuryPrecombatCdPostConditions
{
	Spell(augmentation)
}

### actions.single_target

AddFunction FurySingleTargetMainActions
{
	#bloodthirst,if=buff.fujiedas_fury.up&buff.fujiedas_fury.remains<2
	if BuffPresent(fujiedas_fury_buff) and BuffRemaining(fujiedas_fury_buff) < 2 Spell(bloodthirst)
	#execute,if=(artifact.juggernaut.enabled&(!buff.juggernaut.up|buff.juggernaut.remains<2|(buff.sense_death.react&buff.enrage.up)))|buff.stone_heart.react
	if HasArtifactTrait(juggernaut) and { not BuffPresent(juggernaut_buff) or BuffRemaining(juggernaut_buff) < 2 or BuffPresent(sense_death_buff) and IsEnraged() } or BuffPresent(stone_heart_buff) Spell(execute)
	#rampage,if=(rage=100&(target.health.pct>=20|(target.health.pct<20&!talent.massacre.enabled&!talent.frothing_berserker.enabled)))|(buff.massacre.react&buff.enrage.remains<1)
	if Rage() == 100 and { target.HealthPercent() >= 20 or target.HealthPercent() < 20 and not Talent(massacre_talent) and not Talent(frothing_berserker_talent) } or BuffPresent(massacre_buff) and EnrageRemaining() < 1 Spell(rampage)
	#dragon_roar,if=cooldown.odyns_fury.remains>=10|cooldown.odyns_fury.remains<=3
	if SpellCooldown(odyns_fury) >= 10 or SpellCooldown(odyns_fury) <= 3 Spell(dragon_roar)
	#rampage,if=buff.juggernaut.down&((!talent.frothing_berserker.enabled&buff.enrage.down)|(talent.frothing_berserker.enabled&rage=100)|(talent.reckless_abandon.enabled&cooldown.battle_cry.remains<=gcd.max))
	if BuffExpires(juggernaut_buff) and { not Talent(frothing_berserker_talent) and not IsEnraged() or Talent(frothing_berserker_talent) and Rage() == 100 or Talent(reckless_abandon_talent) and SpellCooldown(battle_cry) <= GCD() } Spell(rampage)
	#furious_slash,if=talent.frenzy.enabled&(buff.frenzy.down|buff.frenzy.remains<=3)
	if Talent(frenzy_talent) and { BuffExpires(frenzy_buff) or BuffRemaining(frenzy_buff) <= 3 } Spell(furious_slash)
	#raging_blow,if=buff.juggernaut.down&buff.enrage.up
	if BuffExpires(juggernaut_buff) and IsEnraged() Spell(raging_blow)
	#whirlwind,if=buff.wrecking_ball.react&buff.enrage.up
	if BuffPresent(wrecking_ball_buff) and IsEnraged() Spell(whirlwind)
	#bloodthirst,if=(talent.frothing_berserker.enabled&buff.enrage.down)|(buff.enrage.remains<2&buff.battle_cry.up&buff.battle_cry.remains<=gcd.max)
	if Talent(frothing_berserker_talent) and not IsEnraged() or EnrageRemaining() < 2 and BuffPresent(battle_cry_buff) and BuffRemaining(battle_cry_buff) <= GCD() Spell(bloodthirst)
	#execute,if=((talent.inner_rage.enabled|!talent.inner_rage.enabled&rage>50)&(!talent.frothing_berserker.enabled|buff.frothing_berserker.up|(cooldown.battle_cry.remains<5&talent.reckless_abandon.enabled)))
	if { Talent(inner_rage_talent) or not Talent(inner_rage_talent) and Rage() > 50 } and { not Talent(frothing_berserker_talent) or BuffPresent(frothing_berserker_buff) or SpellCooldown(battle_cry) < 5 and Talent(reckless_abandon_talent) } Spell(execute)
	#bloodthirst,if=buff.enrage.down
	if not IsEnraged() Spell(bloodthirst)
	#raging_blow,if=buff.enrage.down
	if not IsEnraged() Spell(raging_blow)
	#execute,if=artifact.juggernaut.enabled&(!talent.frothing_berserker.enabled|rage=100)
	if HasArtifactTrait(juggernaut) and { not Talent(frothing_berserker_talent) or Rage() == 100 } Spell(execute)
	#raging_blow
	Spell(raging_blow)
	#bloodthirst
	Spell(bloodthirst)
	#furious_slash
	Spell(furious_slash)
	#call_action_list,name=bladestorm
	FuryBladestormMainActions()
}

AddFunction FurySingleTargetMainPostConditions
{
	FuryBladestormMainPostConditions()
}

AddFunction FurySingleTargetShortCdActions
{
	unless BuffPresent(fujiedas_fury_buff) and BuffRemaining(fujiedas_fury_buff) < 2 and Spell(bloodthirst) or { HasArtifactTrait(juggernaut) and { not BuffPresent(juggernaut_buff) or BuffRemaining(juggernaut_buff) < 2 or BuffPresent(sense_death_buff) and IsEnraged() } or BuffPresent(stone_heart_buff) } and Spell(execute) or { Rage() == 100 and { target.HealthPercent() >= 20 or target.HealthPercent() < 20 and not Talent(massacre_talent) and not Talent(frothing_berserker_talent) } or BuffPresent(massacre_buff) and EnrageRemaining() < 1 } and Spell(rampage)
	{
		#berserker_rage,if=talent.outburst.enabled&cooldown.odyns_fury.remains=0&buff.enrage.down
		if Talent(outburst_talent) and not SpellCooldown(odyns_fury) > 0 and not IsEnraged() Spell(berserker_rage)

		unless { SpellCooldown(odyns_fury) >= 10 or SpellCooldown(odyns_fury) <= 3 } and Spell(dragon_roar)
		{
			#odyns_fury,if=buff.battle_cry.up&buff.enrage.up
			if BuffPresent(battle_cry_buff) and IsEnraged() Spell(odyns_fury)

			unless BuffExpires(juggernaut_buff) and { not Talent(frothing_berserker_talent) and not IsEnraged() or Talent(frothing_berserker_talent) and Rage() == 100 or Talent(reckless_abandon_talent) and SpellCooldown(battle_cry) <= GCD() } and Spell(rampage) or Talent(frenzy_talent) and { BuffExpires(frenzy_buff) or BuffRemaining(frenzy_buff) <= 3 } and Spell(furious_slash) or BuffExpires(juggernaut_buff) and IsEnraged() and Spell(raging_blow) or BuffPresent(wrecking_ball_buff) and IsEnraged() and Spell(whirlwind) or { Talent(frothing_berserker_talent) and not IsEnraged() or EnrageRemaining() < 2 and BuffPresent(battle_cry_buff) and BuffRemaining(battle_cry_buff) <= GCD() } and Spell(bloodthirst) or { Talent(inner_rage_talent) or not Talent(inner_rage_talent) and Rage() > 50 } and { not Talent(frothing_berserker_talent) or BuffPresent(frothing_berserker_buff) or SpellCooldown(battle_cry) < 5 and Talent(reckless_abandon_talent) } and Spell(execute) or not IsEnraged() and Spell(bloodthirst) or not IsEnraged() and Spell(raging_blow) or HasArtifactTrait(juggernaut) and { not Talent(frothing_berserker_talent) or Rage() == 100 } and Spell(execute) or Spell(raging_blow) or Spell(bloodthirst) or Spell(furious_slash)
			{
				#call_action_list,name=bladestorm
				FuryBladestormShortCdActions()

				unless FuryBladestormShortCdPostConditions()
				{
					#bloodbath,if=buff.frothing_berserker.up|(rage>80&!talent.frothing_berserker.enabled)
					if BuffPresent(frothing_berserker_buff) or Rage() > 80 and not Talent(frothing_berserker_talent) Spell(bloodbath)
				}
			}
		}
	}
}

AddFunction FurySingleTargetShortCdPostConditions
{
	BuffPresent(fujiedas_fury_buff) and BuffRemaining(fujiedas_fury_buff) < 2 and Spell(bloodthirst) or { HasArtifactTrait(juggernaut) and { not BuffPresent(juggernaut_buff) or BuffRemaining(juggernaut_buff) < 2 or BuffPresent(sense_death_buff) and IsEnraged() } or BuffPresent(stone_heart_buff) } and Spell(execute) or { Rage() == 100 and { target.HealthPercent() >= 20 or target.HealthPercent() < 20 and not Talent(massacre_talent) and not Talent(frothing_berserker_talent) } or BuffPresent(massacre_buff) and EnrageRemaining() < 1 } and Spell(rampage) or { SpellCooldown(odyns_fury) >= 10 or SpellCooldown(odyns_fury) <= 3 } and Spell(dragon_roar) or BuffExpires(juggernaut_buff) and { not Talent(frothing_berserker_talent) and not IsEnraged() or Talent(frothing_berserker_talent) and Rage() == 100 or Talent(reckless_abandon_talent) and SpellCooldown(battle_cry) <= GCD() } and Spell(rampage) or Talent(frenzy_talent) and { BuffExpires(frenzy_buff) or BuffRemaining(frenzy_buff) <= 3 } and Spell(furious_slash) or BuffExpires(juggernaut_buff) and IsEnraged() and Spell(raging_blow) or BuffPresent(wrecking_ball_buff) and IsEnraged() and Spell(whirlwind) or { Talent(frothing_berserker_talent) and not IsEnraged() or EnrageRemaining() < 2 and BuffPresent(battle_cry_buff) and BuffRemaining(battle_cry_buff) <= GCD() } and Spell(bloodthirst) or { Talent(inner_rage_talent) or not Talent(inner_rage_talent) and Rage() > 50 } and { not Talent(frothing_berserker_talent) or BuffPresent(frothing_berserker_buff) or SpellCooldown(battle_cry) < 5 and Talent(reckless_abandon_talent) } and Spell(execute) or not IsEnraged() and Spell(bloodthirst) or not IsEnraged() and Spell(raging_blow) or HasArtifactTrait(juggernaut) and { not Talent(frothing_berserker_talent) or Rage() == 100 } and Spell(execute) or Spell(raging_blow) or Spell(bloodthirst) or Spell(furious_slash) or FuryBladestormShortCdPostConditions()
}

AddFunction FurySingleTargetCdActions
{
	unless BuffPresent(fujiedas_fury_buff) and BuffRemaining(fujiedas_fury_buff) < 2 and Spell(bloodthirst) or { HasArtifactTrait(juggernaut) and { not BuffPresent(juggernaut_buff) or BuffRemaining(juggernaut_buff) < 2 or BuffPresent(sense_death_buff) and IsEnraged() } or BuffPresent(stone_heart_buff) } and Spell(execute) or { Rage() == 100 and { target.HealthPercent() >= 20 or target.HealthPercent() < 20 and not Talent(massacre_talent) and not Talent(frothing_berserker_talent) } or BuffPresent(massacre_buff) and EnrageRemaining() < 1 } and Spell(rampage) or { SpellCooldown(odyns_fury) >= 10 or SpellCooldown(odyns_fury) <= 3 } and Spell(dragon_roar) or BuffPresent(battle_cry_buff) and IsEnraged() and Spell(odyns_fury) or BuffExpires(juggernaut_buff) and { not Talent(frothing_berserker_talent) and not IsEnraged() or Talent(frothing_berserker_talent) and Rage() == 100 or Talent(reckless_abandon_talent) and SpellCooldown(battle_cry) <= GCD() } and Spell(rampage) or Talent(frenzy_talent) and { BuffExpires(frenzy_buff) or BuffRemaining(frenzy_buff) <= 3 } and Spell(furious_slash) or BuffExpires(juggernaut_buff) and IsEnraged() and Spell(raging_blow) or BuffPresent(wrecking_ball_buff) and IsEnraged() and Spell(whirlwind) or { Talent(frothing_berserker_talent) and not IsEnraged() or EnrageRemaining() < 2 and BuffPresent(battle_cry_buff) and BuffRemaining(battle_cry_buff) <= GCD() } and Spell(bloodthirst) or { Talent(inner_rage_talent) or not Talent(inner_rage_talent) and Rage() > 50 } and { not Talent(frothing_berserker_talent) or BuffPresent(frothing_berserker_buff) or SpellCooldown(battle_cry) < 5 and Talent(reckless_abandon_talent) } and Spell(execute) or not IsEnraged() and Spell(bloodthirst) or not IsEnraged() and Spell(raging_blow) or HasArtifactTrait(juggernaut) and { not Talent(frothing_berserker_talent) or Rage() == 100 } and Spell(execute) or Spell(raging_blow) or Spell(bloodthirst) or Spell(furious_slash)
	{
		#call_action_list,name=bladestorm
		FuryBladestormCdActions()
	}
}

AddFunction FurySingleTargetCdPostConditions
{
	BuffPresent(fujiedas_fury_buff) and BuffRemaining(fujiedas_fury_buff) < 2 and Spell(bloodthirst) or { HasArtifactTrait(juggernaut) and { not BuffPresent(juggernaut_buff) or BuffRemaining(juggernaut_buff) < 2 or BuffPresent(sense_death_buff) and IsEnraged() } or BuffPresent(stone_heart_buff) } and Spell(execute) or { Rage() == 100 and { target.HealthPercent() >= 20 or target.HealthPercent() < 20 and not Talent(massacre_talent) and not Talent(frothing_berserker_talent) } or BuffPresent(massacre_buff) and EnrageRemaining() < 1 } and Spell(rampage) or { SpellCooldown(odyns_fury) >= 10 or SpellCooldown(odyns_fury) <= 3 } and Spell(dragon_roar) or BuffPresent(battle_cry_buff) and IsEnraged() and Spell(odyns_fury) or BuffExpires(juggernaut_buff) and { not Talent(frothing_berserker_talent) and not IsEnraged() or Talent(frothing_berserker_talent) and Rage() == 100 or Talent(reckless_abandon_talent) and SpellCooldown(battle_cry) <= GCD() } and Spell(rampage) or Talent(frenzy_talent) and { BuffExpires(frenzy_buff) or BuffRemaining(frenzy_buff) <= 3 } and Spell(furious_slash) or BuffExpires(juggernaut_buff) and IsEnraged() and Spell(raging_blow) or BuffPresent(wrecking_ball_buff) and IsEnraged() and Spell(whirlwind) or { Talent(frothing_berserker_talent) and not IsEnraged() or EnrageRemaining() < 2 and BuffPresent(battle_cry_buff) and BuffRemaining(battle_cry_buff) <= GCD() } and Spell(bloodthirst) or { Talent(inner_rage_talent) or not Talent(inner_rage_talent) and Rage() > 50 } and { not Talent(frothing_berserker_talent) or BuffPresent(frothing_berserker_buff) or SpellCooldown(battle_cry) < 5 and Talent(reckless_abandon_talent) } and Spell(execute) or not IsEnraged() and Spell(bloodthirst) or not IsEnraged() and Spell(raging_blow) or HasArtifactTrait(juggernaut) and { not Talent(frothing_berserker_talent) or Rage() == 100 } and Spell(execute) or Spell(raging_blow) or Spell(bloodthirst) or Spell(furious_slash) or FuryBladestormCdPostConditions()
}

### actions.two_targets

AddFunction FuryTwoTargetsMainActions
{
	#whirlwind,if=buff.meat_cleaver.down
	if BuffExpires(meat_cleaver_buff) Spell(whirlwind)
	#call_action_list,name=bladestorm
	FuryBladestormMainActions()

	unless FuryBladestormMainPostConditions()
	{
		#rampage,if=buff.enrage.down|(rage=100&buff.juggernaut.down)|buff.massacre.up
		if not IsEnraged() or Rage() == 100 and BuffExpires(juggernaut_buff) or BuffPresent(massacre_buff) Spell(rampage)
		#bloodthirst,if=buff.enrage.down
		if not IsEnraged() Spell(bloodthirst)
		#raging_blow,if=talent.inner_rage.enabled&spell_targets.whirlwind=2
		if Talent(inner_rage_talent) and Enemies() == 2 Spell(raging_blow)
		#whirlwind,if=spell_targets.whirlwind>2
		if Enemies() > 2 Spell(whirlwind)
		#dragon_roar
		Spell(dragon_roar)
		#bloodthirst
		Spell(bloodthirst)
		#whirlwind
		Spell(whirlwind)
	}
}

AddFunction FuryTwoTargetsMainPostConditions
{
	FuryBladestormMainPostConditions()
}

AddFunction FuryTwoTargetsShortCdActions
{
	unless BuffExpires(meat_cleaver_buff) and Spell(whirlwind)
	{
		#call_action_list,name=bladestorm
		FuryBladestormShortCdActions()

		unless FuryBladestormShortCdPostConditions() or { not IsEnraged() or Rage() == 100 and BuffExpires(juggernaut_buff) or BuffPresent(massacre_buff) } and Spell(rampage) or not IsEnraged() and Spell(bloodthirst)
		{
			#odyns_fury,if=buff.battle_cry.up&buff.enrage.up
			if BuffPresent(battle_cry_buff) and IsEnraged() Spell(odyns_fury)
		}
	}
}

AddFunction FuryTwoTargetsShortCdPostConditions
{
	BuffExpires(meat_cleaver_buff) and Spell(whirlwind) or FuryBladestormShortCdPostConditions() or { not IsEnraged() or Rage() == 100 and BuffExpires(juggernaut_buff) or BuffPresent(massacre_buff) } and Spell(rampage) or not IsEnraged() and Spell(bloodthirst) or Talent(inner_rage_talent) and Enemies() == 2 and Spell(raging_blow) or Enemies() > 2 and Spell(whirlwind) or Spell(dragon_roar) or Spell(bloodthirst) or Spell(whirlwind)
}

AddFunction FuryTwoTargetsCdActions
{
	unless BuffExpires(meat_cleaver_buff) and Spell(whirlwind)
	{
		#call_action_list,name=bladestorm
		FuryBladestormCdActions()
	}
}

AddFunction FuryTwoTargetsCdPostConditions
{
	BuffExpires(meat_cleaver_buff) and Spell(whirlwind) or FuryBladestormCdPostConditions() or { not IsEnraged() or Rage() == 100 and BuffExpires(juggernaut_buff) or BuffPresent(massacre_buff) } and Spell(rampage) or not IsEnraged() and Spell(bloodthirst) or BuffPresent(battle_cry_buff) and IsEnraged() and Spell(odyns_fury) or Talent(inner_rage_talent) and Enemies() == 2 and Spell(raging_blow) or Enemies() > 2 and Spell(whirlwind) or Spell(dragon_roar) or Spell(bloodthirst) or Spell(whirlwind)
}

### Fury icons.

AddCheckBox(opt_warrior_fury_aoe L(AOE) default specialization=fury)

AddIcon checkbox=!opt_warrior_fury_aoe enemies=1 help=shortcd specialization=fury
{
	if not InCombat() FuryPrecombatShortCdActions()
	unless not InCombat() and FuryPrecombatShortCdPostConditions()
	{
		FuryDefaultShortCdActions()
	}
}

AddIcon checkbox=opt_warrior_fury_aoe help=shortcd specialization=fury
{
	if not InCombat() FuryPrecombatShortCdActions()
	unless not InCombat() and FuryPrecombatShortCdPostConditions()
	{
		FuryDefaultShortCdActions()
	}
}

AddIcon enemies=1 help=main specialization=fury
{
	if not InCombat() FuryPrecombatMainActions()
	unless not InCombat() and FuryPrecombatMainPostConditions()
	{
		FuryDefaultMainActions()
	}
}

AddIcon checkbox=opt_warrior_fury_aoe help=aoe specialization=fury
{
	if not InCombat() FuryPrecombatMainActions()
	unless not InCombat() and FuryPrecombatMainPostConditions()
	{
		FuryDefaultMainActions()
	}
}

AddIcon checkbox=!opt_warrior_fury_aoe enemies=1 help=cd specialization=fury
{
	if not InCombat() FuryPrecombatCdActions()
	unless not InCombat() and FuryPrecombatCdPostConditions()
	{
		FuryDefaultCdActions()
	}
}

AddIcon checkbox=opt_warrior_fury_aoe help=cd specialization=fury
{
	if not InCombat() FuryPrecombatCdActions()
	unless not InCombat() and FuryPrecombatCdPostConditions()
	{
		FuryDefaultCdActions()
	}
}

### Required symbols
# arcane_torrent_rage
# augmentation
# avatar
# battle_cry
# battle_cry_buff
# berserker_rage
# berserking
# bladestorm
# bladestorm_talent
# blood_fury_ap
# bloodbath
# bloodthirst
# charge
# dragon_roar
# dragon_roar_buff
# dragon_roar_talent
# execute
# frenzy_buff
# frenzy_talent
# frothing_berserker_buff
# frothing_berserker_talent
# fujiedas_fury_buff
# furious_slash
# heroic_leap
# heroic_throw
# inner_rage_talent
# juggernaut
# juggernaut_buff
# massacre_buff
# massacre_talent
# meat_cleaver_buff
# odyns_fury
# outburst_talent
# pummel
# quaking_palm
# raging_blow
# rampage
# reckless_abandon_talent
# sense_death_buff
# stone_heart_buff
# war_stomp
# whirlwind
# wrecking_ball_buff
]]
	OvaleScripts:RegisterScript("WARRIOR", "fury", name, desc, code, "script")
end

do
	local name = "simulationcraft_warrior_protection_t19p"
	local desc = "[7.0] SimulationCraft: Warrior_Protection_T19P"
	local code = [[
# Based on SimulationCraft profile "Warrior_Protection_T19P".
#	class=warrior
#	spec=protection
#	talents=1222312

Include(ovale_common)
Include(ovale_trinkets_mop)
Include(ovale_trinkets_wod)
Include(ovale_warrior_spells)

AddCheckBox(opt_interrupt L(interrupt) default specialization=protection)
AddCheckBox(opt_melee_range L(not_in_melee_range) specialization=protection)

AddFunction ProtectionGetInMeleeRange
{
	if CheckBoxOn(opt_melee_range)
	{
		if target.InRange(charge) Spell(charge)
		if target.InRange(charge) Spell(heroic_leap)
		if not target.InRange(pummel) Texture(misc_arrowlup help=L(not_in_melee_range))
	}
}

AddFunction ProtectionInterruptActions
{
	if CheckBoxOn(opt_interrupt) and not target.IsFriend() and target.IsInterruptible()
	{
		if target.InRange(pummel) Spell(pummel)
		if not target.Classification(worldboss)
		{
			Spell(arcane_torrent_rage)
			if target.InRange(quaking_palm) Spell(quaking_palm)
			Spell(war_stomp)
		}
	}
}

### actions.default

AddFunction ProtectionDefaultMainActions
{
	#call_action_list,name=prot
	ProtectionProtMainActions()
}

AddFunction ProtectionDefaultMainPostConditions
{
	ProtectionProtMainPostConditions()
}

AddFunction ProtectionDefaultShortCdActions
{
	#auto_attack
	ProtectionGetInMeleeRange()

	unless Spell(intercept)
	{
		#call_action_list,name=prot
		ProtectionProtShortCdActions()
	}
}

AddFunction ProtectionDefaultShortCdPostConditions
{
	Spell(intercept) or ProtectionProtShortCdPostConditions()
}

AddFunction ProtectionDefaultCdActions
{
	#pummel
	ProtectionInterruptActions()

	unless Spell(intercept)
	{
		#blood_fury
		Spell(blood_fury_ap)
		#berserking
		Spell(berserking)
		#arcane_torrent
		Spell(arcane_torrent_rage)
		#call_action_list,name=prot
		ProtectionProtCdActions()
	}
}

AddFunction ProtectionDefaultCdPostConditions
{
	Spell(intercept) or ProtectionProtCdPostConditions()
}

### actions.precombat

AddFunction ProtectionPrecombatMainActions
{
	#flask,type=countless_armies
	#food,type=azshari_salad
	#augmentation,type=defiled
	Spell(augmentation)
}

AddFunction ProtectionPrecombatMainPostConditions
{
}

AddFunction ProtectionPrecombatShortCdActions
{
}

AddFunction ProtectionPrecombatShortCdPostConditions
{
	Spell(augmentation)
}

AddFunction ProtectionPrecombatCdActions
{
}

AddFunction ProtectionPrecombatCdPostConditions
{
	Spell(augmentation)
}

### actions.prot

AddFunction ProtectionProtMainActions
{
	#spell_reflection,if=incoming_damage_2500ms>health.max*0.20
	if IncomingDamage(2.5) > MaxHealth() * 0.2 Spell(spell_reflection)
	#potion,name=unbending_potion,if=(incoming_damage_2500ms>health.max*0.15&!buff.potion.up)|target.time_to_die<=25
	#battle_cry,if=cooldown.shield_slam.remains=0
	if not SpellCooldown(shield_slam) > 0 Spell(battle_cry)
	#revenge,if=buff.revenge.react
	if RageCost(revenge) == 0 Spell(revenge)
	#shield_slam,if=!(cooldown.shield_block.remains<=gcd.max*2&!buff.shield_block.up&talent.heavy_repercussions.enabled)
	if not { SpellCooldown(shield_block) <= GCD() * 2 and not BuffPresent(shield_block_buff) and Talent(heavy_repercussions_talent) } Spell(shield_slam)
	#revenge,if=cooldown.shield_slam.remains<=gcd.max*1.5|spell_targets.revenge>=2
	if SpellCooldown(shield_slam) <= GCD() * 1.5 or Enemies() >= 2 Spell(revenge)
	#revenge,if=(buff.vengeance_revenge.up&!buff.vengeance_ignore_pain.up&rage>=59)|!buff.vengeance_ignore_pain.up|(talent.vengeance.enabled&!buff.vengeance_ignore_pain.up&!buff.vengeance_revenge.up&rage>=69)|(rage>=100)
	if BuffPresent(vengeance_revenge_buff) and not BuffPresent(vengeance_ignore_pain_buff) and Rage() >= 59 or not BuffPresent(vengeance_ignore_pain_buff) or Talent(vengeance_talent) and not BuffPresent(vengeance_ignore_pain_buff) and not BuffPresent(vengeance_revenge_buff) and Rage() >= 69 or Rage() >= 100 Spell(revenge)
	#thunder_clap,if=spell_targets.thunder_clap>=4
	if Enemies() >= 4 Spell(thunder_clap)
	#devastate
	Spell(devastate)
}

AddFunction ProtectionProtMainPostConditions
{
}

AddFunction ProtectionProtShortCdActions
{
	unless IncomingDamage(2.5) > MaxHealth() * 0.2 and Spell(spell_reflection)
	{
		#demoralizing_shout,if=incoming_damage_2500ms>health.max*0.20
		if IncomingDamage(2.5) > MaxHealth() * 0.2 Spell(demoralizing_shout)

		unless not SpellCooldown(shield_slam) > 0 and Spell(battle_cry) or RageCost(revenge) == 0 and Spell(revenge)
		{
			#demoralizing_shout,if=talent.booming_voice.enabled&buff.battle_cry.up
			if Talent(booming_voice_talent) and BuffPresent(battle_cry_buff) Spell(demoralizing_shout)
			#ravager,if=talent.ravager.enabled&buff.battle_cry.up
			if Talent(ravager_talent) and BuffPresent(battle_cry_buff) Spell(ravager)
			#neltharions_fury,if=!buff.shield_block.up&cooldown.shield_block.remains>3&cooldown.shield_slam.remains>3
			if not BuffPresent(shield_block_buff) and SpellCooldown(shield_block) > 3 and SpellCooldown(shield_slam) > 3 Spell(neltharions_fury)
			#shield_block,if=!buff.neltharions_fury.up&(cooldown.shield_slam.remains=0|action.shield_block.charges=2)
			if not BuffPresent(neltharions_fury_buff) and { not SpellCooldown(shield_slam) > 0 or Charges(shield_block) == 2 } Spell(shield_block)

			unless not { SpellCooldown(shield_block) <= GCD() * 2 and not BuffPresent(shield_block_buff) and Talent(heavy_repercussions_talent) } and Spell(shield_slam) or { SpellCooldown(shield_slam) <= GCD() * 1.5 or Enemies() >= 2 } and Spell(revenge)
			{
				#ignore_pain,if=(rage>=60&!talent.vengeance.enabled)|(buff.vengeance_ignore_pain.up&rage>=39)|(talent.vengeance.enabled&!buff.vengeance_ignore_pain.up&!buff.vengeance_revenge.up&rage<30)
				if Rage() >= 60 and not Talent(vengeance_talent) or BuffPresent(vengeance_ignore_pain_buff) and Rage() >= 39 or Talent(vengeance_talent) and not BuffPresent(vengeance_ignore_pain_buff) and not BuffPresent(vengeance_revenge_buff) and Rage() < 30 Spell(ignore_pain)
			}
		}
	}
}

AddFunction ProtectionProtShortCdPostConditions
{
	IncomingDamage(2.5) > MaxHealth() * 0.2 and Spell(spell_reflection) or not SpellCooldown(shield_slam) > 0 and Spell(battle_cry) or RageCost(revenge) == 0 and Spell(revenge) or not { SpellCooldown(shield_block) <= GCD() * 2 and not BuffPresent(shield_block_buff) and Talent(heavy_repercussions_talent) } and Spell(shield_slam) or { SpellCooldown(shield_slam) <= GCD() * 1.5 or Enemies() >= 2 } and Spell(revenge) or { BuffPresent(vengeance_revenge_buff) and not BuffPresent(vengeance_ignore_pain_buff) and Rage() >= 59 or not BuffPresent(vengeance_ignore_pain_buff) or Talent(vengeance_talent) and not BuffPresent(vengeance_ignore_pain_buff) and not BuffPresent(vengeance_revenge_buff) and Rage() >= 69 or Rage() >= 100 } and Spell(revenge) or Enemies() >= 4 and Spell(thunder_clap) or Spell(devastate)
}

AddFunction ProtectionProtCdActions
{
	unless IncomingDamage(2.5) > MaxHealth() * 0.2 and Spell(spell_reflection)
	{
		#last_stand,if=incoming_damage_2500ms>health.max*0.50
		if IncomingDamage(2.5) > MaxHealth() * 0.5 Spell(last_stand)
		#shield_wall,if=incoming_damage_2500ms>health.max*0.50&!cooldown.last_stand.remains=0
		if IncomingDamage(2.5) > MaxHealth() * 0.5 and not { not SpellCooldown(last_stand) > 0 } Spell(shield_wall)
	}
}

AddFunction ProtectionProtCdPostConditions
{
	IncomingDamage(2.5) > MaxHealth() * 0.2 and Spell(spell_reflection) or not SpellCooldown(shield_slam) > 0 and Spell(battle_cry) or RageCost(revenge) == 0 and Spell(revenge) or Talent(ravager_talent) and BuffPresent(battle_cry_buff) and Spell(ravager) or not BuffPresent(shield_block_buff) and SpellCooldown(shield_block) > 3 and SpellCooldown(shield_slam) > 3 and Spell(neltharions_fury) or not { SpellCooldown(shield_block) <= GCD() * 2 and not BuffPresent(shield_block_buff) and Talent(heavy_repercussions_talent) } and Spell(shield_slam) or { SpellCooldown(shield_slam) <= GCD() * 1.5 or Enemies() >= 2 } and Spell(revenge) or { BuffPresent(vengeance_revenge_buff) and not BuffPresent(vengeance_ignore_pain_buff) and Rage() >= 59 or not BuffPresent(vengeance_ignore_pain_buff) or Talent(vengeance_talent) and not BuffPresent(vengeance_ignore_pain_buff) and not BuffPresent(vengeance_revenge_buff) and Rage() >= 69 or Rage() >= 100 } and Spell(revenge) or Enemies() >= 4 and Spell(thunder_clap) or Spell(devastate)
}

### Protection icons.

AddCheckBox(opt_warrior_protection_aoe L(AOE) default specialization=protection)

AddIcon checkbox=!opt_warrior_protection_aoe enemies=1 help=shortcd specialization=protection
{
	if not InCombat() ProtectionPrecombatShortCdActions()
	unless not InCombat() and ProtectionPrecombatShortCdPostConditions()
	{
		ProtectionDefaultShortCdActions()
	}
}

AddIcon checkbox=opt_warrior_protection_aoe help=shortcd specialization=protection
{
	if not InCombat() ProtectionPrecombatShortCdActions()
	unless not InCombat() and ProtectionPrecombatShortCdPostConditions()
	{
		ProtectionDefaultShortCdActions()
	}
}

AddIcon enemies=1 help=main specialization=protection
{
	if not InCombat() ProtectionPrecombatMainActions()
	unless not InCombat() and ProtectionPrecombatMainPostConditions()
	{
		ProtectionDefaultMainActions()
	}
}

AddIcon checkbox=opt_warrior_protection_aoe help=aoe specialization=protection
{
	if not InCombat() ProtectionPrecombatMainActions()
	unless not InCombat() and ProtectionPrecombatMainPostConditions()
	{
		ProtectionDefaultMainActions()
	}
}

AddIcon checkbox=!opt_warrior_protection_aoe enemies=1 help=cd specialization=protection
{
	if not InCombat() ProtectionPrecombatCdActions()
	unless not InCombat() and ProtectionPrecombatCdPostConditions()
	{
		ProtectionDefaultCdActions()
	}
}

AddIcon checkbox=opt_warrior_protection_aoe help=cd specialization=protection
{
	if not InCombat() ProtectionPrecombatCdActions()
	unless not InCombat() and ProtectionPrecombatCdPostConditions()
	{
		ProtectionDefaultCdActions()
	}
}

### Required symbols
# arcane_torrent_rage
# augmentation
# battle_cry
# battle_cry_buff
# berserking
# blood_fury_ap
# booming_voice_talent
# charge
# demoralizing_shout
# devastate
# heavy_repercussions_talent
# heroic_leap
# heroic_throw
# ignore_pain
# intercept
# last_stand
# neltharions_fury
# neltharions_fury_buff
# pummel
# quaking_palm
# ravager
# ravager_talent
# revenge
# shield_block
# shield_block_buff
# shield_slam
# shield_wall
# spell_reflection
# thunder_clap
# vengeance_ignore_pain_buff
# vengeance_revenge_buff
# vengeance_talent
# war_stomp
]]
	OvaleScripts:RegisterScript("WARRIOR", "protection", name, desc, code, "script")
end
